package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbmonolDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbmonol;

/**
 * ArbmonolServiceImpl  
 * 
 *  
 */

@Service(value = "arbmonolService")
public class ArbmonolServiceImpl implements ArbmonolService {

	@Autowired
	private ArbmonolDao arbmonolDao;

	/**
	 * Inserts a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbmonol add(Arbmonol arbmonol) {
		return this.arbmonolDao.add(arbmonol);
	}

	/**
	 * Updates a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbmonol update(Arbmonol arbmonol) {
		return this.arbmonolDao.update(arbmonol);
	}

	/**
	 * Finds a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	public Arbmonol find(Arbmonol arbmonol) {
		return (Arbmonol) this.arbmonolDao.find(arbmonol);
	}

	/**
	 * Finds a List of rows in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbmonol> findAll(Arbmonol arbmonol, Pagination pagination) {
		return (List<Arbmonol>) this.arbmonolDao.findAll(arbmonol, pagination);
	}

	/**
	 * Counts rows in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Long
	 */
	public Long findAllCount(Arbmonol arbmonol) {
		return this.arbmonolDao.findAllCount(arbmonol);
	}

	/**
	 * Finds rows in the Arbmonol table using like.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbmonol> findAllLike(Arbmonol arbmonol, Pagination pagination,
			Boolean startsWith) {
		return (List<Arbmonol>) this.arbmonolDao.findAllLike(arbmonol,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbmonol table using like.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbmonol arbmonol, Boolean startsWith) {
		return this.arbmonolDao.findAllLikeCount(arbmonol, startsWith);
	}

	/**
	 * Deletes a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbmonol arbmonol) {
		this.arbmonolDao.remove(arbmonol);
	}

	/**
	 * Deletes multiple rows in the Arbmonol table.
	 * 
	 * @param arbmonolList
	 *            List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbmonol> arbmonolList) {
		for (Arbmonol arbmonolAux : arbmonolList) {
			this.arbmonolDao.remove(arbmonolAux);
		}
	}

}
