package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbmonol;

/**
 * ArbmonolService  
 * 
 *  
 */

public interface ArbmonolService {

	/**
	 * Inserts a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	Arbmonol add(Arbmonol arbmonol);

	/**
	 * Updates a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	Arbmonol update(Arbmonol arbmonol);

	/**
	 * Finds a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	Arbmonol find(Arbmonol arbmonol);

	/**
	 * Finds a List of rows in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbmonol> findAll(Arbmonol arbmonol, Pagination pagination);

	/**
	 * Counts rows in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Long
	 */
	Long findAllCount(Arbmonol arbmonol);

	/**
	 * Finds rows in the Arbmonol table using like.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbmonol> findAllLike(Arbmonol arbmonol, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbmonol table using like.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbmonol arbmonol, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbmonol table.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return
	 */
	void remove(Arbmonol arbmonol);

	/**
	 * Deletes multiple rows in the Arbmonol table.
	 * 
	 * @param arbmonolList
	 *            List
	 */
	void removeMultiple(List<Arbmonol> arbmonolList);

}
