package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbitroDao;
import com.ejie.y41b.dao.ArseDao;
import com.ejie.y41b.dao.Arta1Dao;
import com.ejie.y41b.dao.CcarDao;
import com.ejie.y41b.dao.LocalidaDao;
import com.ejie.y41b.dao.MunicipiDao;
import com.ejie.y41b.dao.OearDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arse;
import com.ejie.y41b.model.Arta1;
import com.ejie.y41b.model.Ccar;
import com.ejie.y41b.model.Localida;
import com.ejie.y41b.model.Municipi;
import com.ejie.y41b.model.Oear;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbitroServiceImpl  
 * 
 *  
 */

@Service(value = "arbitroService")
public class ArbitroServiceImpl implements ArbitroService {

	@Autowired()
	private ArbitroDao arbitroDao;

	@Autowired()
	private Arta1Dao arta1Dao;

	@Autowired()
	private ArseDao arseDao;

	@Autowired()
	private OearDao oearDao;

	@Autowired()
	private CcarDao ccarDao;

	@Autowired()
	private SolarbDao solArbDao;

	@Autowired()
	private LocalidaDao localidaDao;
	@Autowired()
	private MunicipiDao municipiDao;
	@Autowired()
	private T17ProvinciaDao provinciaDao;
	@Autowired()
	private T17CalleDao calleDao;

	@Autowired
	private OrganismoDao organismoDao;

	/**
	 * Inserts a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbitro add(Arbitro arbitro) {
		// tratamos la direccin.
		this.tratarDireccion(arbitro);
		this.arbitroDao.add(arbitro);
		this.tratarMn(arbitro);
		return arbitro;
	}

	/**
	 * Updates a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbitro update(Arbitro arbitro) {

		// tratamos la direccin.
		this.tratarDireccion(arbitro);
		this.arbitroDao.update(arbitro);
		this.tratarMn(arbitro);
		return arbitro;
	}

	/**
	 * 
	 * @param arbitro
	 *            Arbitro
	 */
	private void tratarMn(Arbitro arbitro) {
		// Territorios de actuacin: borramos por arbitro y aadimos la lista
		Arta1 arta1 = new Arta1();
		arta1.setArbitro(arbitro);
		this.arta1Dao.remove(arta1);
		if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArThActAraba())) {
			arta1.setM3cota1(arbitro.getArThActAraba());
			arta1.setArbitro(arbitro);
			// Aadimos los territorios del arbitro
			this.arta1Dao.add(arta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArThActBizkaia())) {
			arta1.setM3cota1(arbitro.getArThActBizkaia());
			arta1.setArbitro(arbitro);
			// Aadimos los territorios del arbitro
			this.arta1Dao.add(arta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArThActGipuzkoa())) {
			arta1.setM3cota1(arbitro.getArThActGipuzkoa());
			arta1.setArbitro(arbitro);
			// Aadimos los territorios del arbitro
			this.arta1Dao.add(arta1);
		}
		// Sectores
		Arse arse = new Arse();
		arse.setArbitro(arbitro);
		// Borramos de arse por arbitro
		this.arseDao.removeArse(arse);
		// Lista de la temporal
		List<Arse> arses = this.arseDao.findAll(arse, null);
		if (arses != null) {
			for (int i = 0; i < arses.size(); i++) {
				arse = arses.get(i);
				// Aadimos los sectores a arse
				this.arseDao.addArse(arse);
				// Eliminamos de la temporal
				this.arseDao.remove(arse);
			}
		}

		// Ooee
		Oear oear = new Oear();
		oear.setArbitro(arbitro);
		// Borramos de oear por ooee
		this.oearDao.removeOearArbitro(oear);
		// Lista de la temporal
		List<Oear> oears = this.oearDao.findAll(oear, null);
		if (oears != null) {
			for (int i = 0; i < oears.size(); i++) {
				oear = oears.get(i);
				// Aadimos los arbitros a oese
				if (oear.getOoee().getOecodigo()
						.equals(arbitro.getArcoentidad())) {
					oear.setM2centroar(Y41bConstantes.VALOR_SI);
				} else {
					oear.setM2centroar(null);
				}
				if (Y41bConstantes.CENSO_ARB_TIPOARBITROE.equals(arbitro
						.getArincoes())) {
					this.oearDao.addOear(oear);
				}
				// Eliminamos de la temporal
				this.oearDao.remove(oear);
			}
		}

		// Aacc
		Ccar ccar = new Ccar();
		ccar.setArbitro(arbitro);
		// Borramos de ccar por aacc
		this.ccarDao.removeCcarArbitro(ccar);
		// Lista de la temporal
		List<Ccar> ccars = this.ccarDao.findAll(ccar, null);
		if (ccars != null) {
			for (int i = 0; i < ccars.size(); i++) {
				ccar = ccars.get(i);
				// Aadimos los arbitros a oese
				if (ccar.getAacc().getCccodigo()
						.equals(arbitro.getArcoentidad())) {
					ccar.setM1centroar(Y41bConstantes.VALOR_SI);
				} else {
					ccar.setM1centroar(null);
				}
				if (Y41bConstantes.CENSO_ARB_TIPOARBITROC.equals(arbitro
						.getArincoes())) {
					this.ccarDao.addCcar(ccar);
				}
				// Eliminamos de la temporal
				this.ccarDao.remove(ccar);
			}
		}
	}

	/**
	 * Finds a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	public Arbitro find(Arbitro arbitro) {
		Arbitro arbitroDetalle = this.arbitroDao.find(arbitro);
		try {
			arbitroDetalle.setArcalle(this.calleDao.findCalleConTipoVia(
					new T17Calle(Long.parseLong(arbitroDetalle.getArcalleId()),
							null)).getDsO());
		} catch (Exception e) {

		}
		try {
			arbitroDetalle.setArcallec(this.calleDao.findCalleConTipoVia(
					new T17Calle(
							Long.parseLong(arbitroDetalle.getArcallecId()),
							null)).getDsO());
		} catch (Exception e) {

		}

		arbitroDetalle.setArdireccionNoCAPV(this
				.componerDireccionNoCAPV(arbitroDetalle));
		arbitroDetalle.setArdireccionNoCAPVc(this
				.componerDireccionNoCAPVc(arbitroDetalle));

		arbitroDetalle.setArdireccionAntigua(this
				.componerDireccionAntigua(arbitroDetalle));
		arbitroDetalle.setArdireccionAntiguac(this
				.componerDireccionAntiguac(arbitroDetalle));

		// Volcar en tablas temporales: sectores, ooee y aacc
		this.arseDao.volcarArbitroSectores(arbitro);

		if (Y41bConstantes.CENSO_ARB_TIPOARBITROE.equals(arbitroDetalle
				.getArincoes())) {
			this.oearDao.volcarArbitroOoees(arbitro);
			Oear oear = new Oear();
			oear.setArbitro(arbitroDetalle);
			arbitroDetalle.setOears(this.oearDao.findAll(oear, null));
		} else if (Y41bConstantes.CENSO_ARB_TIPOARBITROC.equals(arbitroDetalle
				.getArincoes())) {
			this.ccarDao.volcarArbitroAaccs(arbitro);
			Ccar ccar = new Ccar();
			ccar.setArbitro(arbitroDetalle);
			arbitroDetalle.setCcars(this.ccarDao.findAll(ccar, null));
		}

		return arbitroDetalle;
	}

	/**
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return String
	 */
	private String componerDireccionNoCAPV(Arbitro arbitro) {
		StringBuffer ardireccionNoCAPV = new StringBuffer("");
		try {
			if (Y41bUtils.esNullOCadenaVacia(arbitro.getArprovId())) {
				if (arbitro.getArnodir() != null) {
					ardireccionNoCAPV.append(arbitro.getArnodir());
				}
				if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArcolo())) {
					Localida localida = new Localida();
					localida.setLocodigo(arbitro.getArcolo());
					localida = this.localidaDao.find(localida);
					if (localida != null) {
						ardireccionNoCAPV.append(" ").append(
								localida.getLonombre());
						if (!Y41bUtils.esNullOCadenaVacia(localida.getLocomu())) {
							Municipi municipi = new Municipi();
							municipi.setMucodigo(localida.getLocomu());
							municipi = this.municipiDao.find(municipi);
							if (municipi != null) {
								ardireccionNoCAPV.append(" ").append(
										municipi.getMunombre());
							}
						}
						if (!Y41bUtils.esNullOCadenaVacia(localida.getLocopv())) {
							T17Provincia provincia = new T17Provincia();
							provincia.setId(localida.getLocopv());
							provincia = this.provinciaDao.find(provincia);
							if (provincia != null) {
								ardireccionNoCAPV.append(" ").append(
										provincia.getDsO());
							}
						}
					}
				}
			} else {
				if (!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
						&& !Y41bConstantes.BIZKAIA
								.equals(arbitro.getArprovId())
						&& !Y41bConstantes.GIPUZKOA.equals(arbitro
								.getArprovId())) {
					if (arbitro.getArnodir() != null) {
						ardireccionNoCAPV.append(arbitro.getArnodir());
					}
				}
			}
		} catch (Exception e) {

		}
		return ardireccionNoCAPV.toString();

	}

	/**
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return String
	 */
	private String componerDireccionNoCAPVc(Arbitro arbitro) {
		StringBuffer ardireccionNoCAPVc = new StringBuffer("");
		if (Y41bUtils.esNullOCadenaVacia(arbitro.getArprovcId())) {
			if (arbitro.getArnodirc() != null) {
				ardireccionNoCAPVc.append(arbitro.getArnodirc());
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArcoloc())) {
				Localida localida = new Localida();
				localida.setLocodigo(arbitro.getArcoloc());
				localida = this.localidaDao.find(localida);
				if (localida != null) {
					ardireccionNoCAPVc.append(" ").append(
							localida.getLonombre());
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocomu())) {
						Municipi municipi = new Municipi();
						municipi.setMucodigo(localida.getLocomu());
						municipi = this.municipiDao.find(municipi);
						if (municipi != null) {
							ardireccionNoCAPVc.append(" ").append(
									municipi.getMunombre());
						}
					}
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocopv())) {
						T17Provincia provincia = new T17Provincia();
						provincia.setId(localida.getLocopv());
						provincia = this.provinciaDao.find(provincia);
						if (provincia != null) {
							ardireccionNoCAPVc.append(" ").append(
									provincia.getDsO());
						}
					}
				}
			}
		} else {
			if (!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
					&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())
					&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())) {
				if (arbitro.getArnodirc() != null) {
					ardireccionNoCAPVc.append(arbitro.getArnodirc());
				}
			}
		}
		return ardireccionNoCAPVc.toString();

	}

	/**
	 * Finds a List of rows in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbitro> findAll(Arbitro arbitro, Pagination pagination) {
		List<Arbitro> lArbitros = this.arbitroDao.findAll(arbitro, pagination);
		if (lArbitros != null) {
			for (int i = 0; i < lArbitros.size(); i++) {
				arbitro = lArbitros.get(i);
				arbitro = this.solArbDao.obtenerCargaArbitro(arbitro);
			}
		}
		return lArbitros;
	}

	/**
	 * Counts rows in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Long
	 */
	public Long findAllCount(Arbitro arbitro) {
		return this.arbitroDao.findAllCount(arbitro);
	}

	/**
	 * Finds rows in the Arbitro table using like.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbitro> findAllLike(Arbitro arbitro, Pagination pagination,
			Boolean startsWith) {
		return (List<Arbitro>) this.arbitroDao.findAllLike(arbitro, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Arbitro table using like.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbitro arbitro, Boolean startsWith) {
		return this.arbitroDao.findAllLikeCount(arbitro, startsWith);
	}

	/**
	 * Deletes a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbitro arbitro) {
		Solarb solarb = new Solarb();
		solarb.setArbitro(arbitro);
		long numExpedientesAbiertos = this.solArbDao.findAllCount(solarb);
		if (numExpedientesAbiertos > 0) {
			throw new Y41bUDAException(
					"error.ooee.ExpedientesAbiertosException", true,
					new Exception());
		}
		// Borramos de oeta1 por arbitro
		Arta1 arta1 = new Arta1();
		arta1.setArbitro(arbitro);
		this.arta1Dao.remove(arta1);

		// Borramos de arse por arbitro
		Arse arse = new Arse();
		arse.setArbitro(arbitro);
		this.arseDao.removeArse(arse);

		// Borramos de oear por arbitro
		Oear oear = new Oear();
		oear.setArbitro(arbitro);
		this.oearDao.removeOearArbitro(oear);

		// Borramos de ccar por arbitro
		Ccar ccar = new Ccar();
		ccar.setArbitro(arbitro);
		this.ccarDao.removeCcarArbitro(ccar);

		this.borrarTemporales(arbitro);

		this.arbitroDao.remove(arbitro);
	}

	/**
	 * Deletes multiple rows in the Arbitro table.
	 * 
	 * @param arbitroList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbitro> arbitroList) {
		for (Arbitro arbitroAux : arbitroList) {
			this.arbitroDao.remove(arbitroAux);
		}
	}

	/**
	 * Borra los registros temporales
	 * 
	 * @param arbitro
	 *            Arbitro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void borrarTemporales(Arbitro arbitro) {
		// Sectores
		Arse arse = new Arse();
		arse.setArbitro(arbitro);
		// Lista de la temporal
		List<Arse> arses = this.arseDao.findAll(arse, null);
		if (arses != null) {
			for (int i = 0; i < arses.size(); i++) {
				arse = arses.get(i);
				// Eliminamos de la temporal
				this.arseDao.remove(arse);
			}
		}

		// Ooee
		Oear oear = new Oear();
		oear.setArbitro(arbitro);
		// Lista de la temporal
		List<Oear> oears = this.oearDao.findAll(oear, null);
		if (oears != null) {
			for (int i = 0; i < oears.size(); i++) {
				oear = oears.get(i);
				// Eliminamos de la temporal
				this.oearDao.remove(oear);
			}
		}

		// AAcc
		Ccar ccar = new Ccar();
		ccar.setArbitro(arbitro);
		// Lista de la temporal
		List<Ccar> ccars = this.ccarDao.findAll(ccar, null);
		if (ccars != null) {
			for (int i = 0; i < ccars.size(); i++) {
				ccar = ccars.get(i);
				// Eliminamos de la temporal
				this.ccarDao.remove(ccar);
			}
		}

	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		return this.arbitroDao.getNewPK();
	}

	/**
	 * 
	 * @param arbitro
	 *            Arbitro
	 */
	private void tratarDireccion(Arbitro arbitro) {

		if (arbitro != null && arbitro.getArprovId() != null) {

			if (!Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(arbitro
					.getArprovId())
					&& !Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(arbitro
							.getArprovId())
					&& !Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA.equals(arbitro
							.getArprovId())) {

				arbitro.setArnodir(arbitro.getArdireccionNoCAPV());

				// blanqueamos los datos de nora
				arbitro.setArcalleId(null);
				arbitro.setArportalId(null);

			}

		}

		// lo mismo para direccin del centro
		if (arbitro != null && arbitro.getArprovcId() != null) {

			if (!Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(arbitro
					.getArprovcId())
					&& !Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(arbitro
							.getArprovcId())
					&& !Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA.equals(arbitro
							.getArprovcId())) {

				arbitro.setArnodirc(arbitro.getArdireccionNoCAPVc());

				// blanqueamos los datos de nora
				arbitro.setArcallecId(null);
				arbitro.setArportalcId(null);

			}

		}
	}

	/**
	 * trata el objeto arbitro para dejar en los campos de centro los campos de
	 * la direccin de este.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 * @throws Exception
	 */
	public Arbitro tratarDireccionesCentro(Arbitro arbitro) {

		if (arbitro.getArincoes() != null
				&& !Y41bConstantes.CENSO_ARB_TIPOARBITROP.equals(arbitro
						.getArincoes())
				&& (arbitro.getArindico() != null && Y41bConstantes.CENSO_ARB_ARBITRO_DIR_CEN
						.equals(arbitro.getArindico())))

		{

			// es un arbitro que no es presidente y tiene elegido el centro como
			// direccin
			if (Y41bConstantes.CENSO_ARB_TIPOARBITROE.equals(arbitro
					.getArincoes())) {

				// buscamos de su lista de oear cual es la que est seleccionada
				List<Oear> oears = arbitro.getOears();
				if (oears != null && oears.size() > 0) {
					Oear oear;
					for (int i = 0; i < oears.size(); i++) {
						oear = oears.get(i);
						if (oear.getM2centroar() != null
								&& Y41bConstantes.SI.equals(oear
										.getM2centroar())) {
							// encontramos el organismo correspondiente
							Organismo organismo = new Organismo();
							organismo.setCodOrg(oear.getOoee().getOecodigo());
							organismo = this.organismoDao.find(organismo);

							arbitro.setArnrtelc(organismo.getTelefono());
							arbitro.setArnrtel2c("");
							arbitro.setArprovcId(organismo.getNoraProvinciaId());
							arbitro.setArmuncId(organismo.getNoraMunicipioId());
							arbitro.setArloccId(organismo.getNoraLocalidadId());
							arbitro.setArcallecId(organismo.getNoraCalleId());
							arbitro.setArnrcopoc(organismo.getAdressCP());
							arbitro.setArportalcId(organismo.getNoraPortalId());
							if (Y41bUtils.esNullOCadenaVacia(organismo
									.getCompleDirec())) {
								arbitro.setArnodirc(organismo.getNombreCalle());
							} else {
								arbitro.setArnodirc(organismo.getCompleDirec());
							}
							arbitro.setArteemc(organismo.getEmail());
							break;
						}
					}
				}

			} else if (Y41bConstantes.CENSO_ARB_TIPOARBITROC.equals(arbitro
					.getArincoes())) {

				// buscamos de su lista de oear cual es la que est seleccionada
				List<Ccar> ccars = arbitro.getCcars();
				if (ccars != null && ccars.size() > 0) {
					Ccar ccar;
					for (int i = 0; i < ccars.size(); i++) {
						ccar = ccars.get(i);
						if (ccar.getM1centroar() != null
								&& Y41bConstantes.SI.equals(ccar
										.getM1centroar())) {
							// encontramos el organismo correspondiente
							Organismo organismo = new Organismo();
							organismo.setCodOrg(ccar.getAacc().getCccodigo());
							organismo = this.organismoDao.find(organismo);
							arbitro.setArnrtelc(organismo.getTelefono());
							arbitro.setArnrtel2c("");
							arbitro.setArprovcId(organismo.getNoraProvinciaId());
							arbitro.setArmuncId(organismo.getNoraMunicipioId());
							arbitro.setArloccId(organismo.getNoraLocalidadId());
							arbitro.setArcallecId(organismo.getNoraCalleId());
							arbitro.setArnrcopoc(organismo.getAdressCP());
							arbitro.setArportalcId(organismo.getNoraPortalId());
							if (Y41bUtils.esNullOCadenaVacia(organismo
									.getCompleDirec())) {
								arbitro.setArnodirc(organismo.getNombreCalle());
							} else {
								arbitro.setArnodirc(organismo.getCompleDirec());
							}
							arbitro.setArteemc(organismo.getEmail());
							break;
						}
					}
				}

			}

		}

		return arbitro;
	}

	/**
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return String
	 */
	private String componerDireccionAntigua(Arbitro arbitro) {
		StringBuffer ardireccionNoCAPV = new StringBuffer("");
		try {
			// if (Y41bUtils.esNullOCadenaVacia(empper.getPeprovId())) {
			if (arbitro.getArnodir() != null) {
				ardireccionNoCAPV.append(arbitro.getArnodir());
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArcolo())) {
				Localida localida = new Localida();
				localida.setLocodigo(arbitro.getArcolo());
				localida = this.localidaDao.find(localida);
				if (localida != null) {
					ardireccionNoCAPV.append(" ")
							.append(localida.getLonombre());
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocomu())) {
						Municipi municipi = new Municipi();
						municipi.setMucodigo(localida.getLocomu());
						municipi = this.municipiDao.find(municipi);
						if (municipi != null) {
							ardireccionNoCAPV.append(" ").append(
									municipi.getMunombre());
						}
					}
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocopv())) {
						T17Provincia provincia = new T17Provincia();
						provincia.setId(localida.getLocopv());
						provincia = this.provinciaDao.find(provincia);
						if (provincia != null) {
							ardireccionNoCAPV.append(" ").append(
									provincia.getDsO());
						}
					}
				}
			}
			// }
		} catch (Exception e) {

		}
		return ardireccionNoCAPV.toString();

	}

	/**
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return String
	 */
	private String componerDireccionAntiguac(Arbitro arbitro) {
		StringBuffer ardireccionNoCAPV = new StringBuffer("");
		try {
			// if (Y41bUtils.esNullOCadenaVacia(empper.getPeprovId())) {
			if (arbitro.getArnodirc() != null) {
				ardireccionNoCAPV.append(arbitro.getArnodirc());
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbitro.getArcoloc())) {
				Localida localida = new Localida();
				localida.setLocodigo(arbitro.getArcoloc());
				localida = this.localidaDao.find(localida);
				if (localida != null) {
					ardireccionNoCAPV.append(" ")
							.append(localida.getLonombre());
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocomu())) {
						Municipi municipi = new Municipi();
						municipi.setMucodigo(localida.getLocomu());
						municipi = this.municipiDao.find(municipi);
						if (municipi != null) {
							ardireccionNoCAPV.append(" ").append(
									municipi.getMunombre());
						}
					}
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocopv())) {
						T17Provincia provincia = new T17Provincia();
						provincia.setId(localida.getLocopv());
						provincia = this.provinciaDao.find(provincia);
						if (provincia != null) {
							ardireccionNoCAPV.append(" ").append(
									provincia.getDsO());
						}
					}
				}
			}
			// }
		} catch (Exception e) {

		}
		return ardireccionNoCAPV.toString();

	}
}
