package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbitro;

/**
 * ArbitroService  
 * 
 *  
 */

public interface ArbitroService {

	/**
	 * Inserts a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	Arbitro add(Arbitro arbitro);

	/**
	 * Updates a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	Arbitro update(Arbitro arbitro);

	/**
	 * Finds a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	Arbitro find(Arbitro arbitro);

	/**
	 * Finds a List of rows in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbitro> findAll(Arbitro arbitro, Pagination pagination);

	/**
	 * Counts rows in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Long
	 */
	Long findAllCount(Arbitro arbitro);

	/**
	 * Finds rows in the Arbitro table using like.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbitro> findAllLike(Arbitro arbitro, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbitro table using like.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbitro arbitro, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return
	 */
	void remove(Arbitro arbitro);

	/**
	 * Deletes multiple rows in the Arbitro table.
	 * 
	 * @param arbitroList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbitro> arbitroList);

	/**
	 * @param arbitro
	 *            Arbitro
	 */
	void borrarTemporales(Arbitro arbitro);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * trata el objeto arbitro para dejar en los campos de centro los campos de
	 * la direccin de este.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	Arbitro tratarDireccionesCentro(Arbitro arbitro);

}
