package com.ejie.y41b.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.EmpperDao;
import com.ejie.y41b.dao.DtsaDao;
import com.ejie.y41b.dao.EssaDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PaisDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Dtsa;
import com.ejie.y41b.model.Essa;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ArbintervServiceImpl  
 * 
 *  
 */

@Service(value = "arbintervService")
public class ArbintervServiceImpl implements ArbintervService {

	private static final Logger logger = LoggerFactory.getLogger(ArbintervServiceImpl.class);

	@Autowired()
	private ArbintervDao arbintervDao;

	@Autowired()
	private T17CalleDao t17CalleDao;

	@Autowired()
	private T17PortalDao t17PortalDao;

	@Autowired()
	private T17LocalidadDao t17LocalidadDao;

	@Autowired()
	private T17MunicipioDao t17MunicipioDao;

	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;

	@Autowired()
	private T17PortalService t17PortalService;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private EstablecimArbitraDao establecimArbitraDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private SedeDao sedeDao;

	@Autowired()
	private EstablecimSectorDao establecimSectorDao;

	@Autowired()
	private ConsumidorDao consumidorDao;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private ArbtramexpDao arbtramexpDao;

	// @Autowired()
	// private ArbdoctempDao arbdoctempdao;
	//
	// @Autowired()
	// private SolarbDao solarbDao;

	@Autowired()
	private T17PaisDao t17PaisDao;

	@Autowired()
	private EmpperDao empperDao;
	@Autowired()
	private DtsaDao dtsaDao;
	@Autowired()
	private EssaDao essaDao;
	@Autowired()
	private ArbitroService arbitroService;
	@Autowired()
	private SolarbDao solarbDao;
	@Autowired()
	private ArbexpDao arbexpDao;
	@Autowired()
	private EstablecimientoService establecimientoService;

	/**
	 * Inserts a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbinterv add(Arbinterv arbinterv) {
		return this.arbintervDao.add(arbinterv);
	}

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbinterv update(Arbinterv arbinterv) {
		return this.arbintervDao.update(arbinterv);
	}

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbinterv actualizaReclamado(Solarb solarb, CensoMonitor censoMonitor) {

		Arbinterv reclamadoModif = solarb.getReclamado();
		Arbinterv reclamado = null;
		Arbinterv arbintervBD = this.arbintervDao.find(reclamadoModif);

		if (Y41bConstantes.VALOR_SI.equals(reclamadoModif.getReclamadoCambio())) {

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(reclamadoModif.getUaescodigo());
			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimiento = this.tratamientoAnyadirIntervinienteSancionado(establecimiento);

			if (establecimiento != null) {
				Arbinterv sancionado = new Arbinterv();
				sancionado.setSolarb(solarb);
				solarb = this.solarbDao.find(solarb);
				solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));
				sancionado.setUaescodigo(establecimiento.getEscodigo());
				sancionado.setUanombre(establecimiento.getEsnombre());
				sancionado.setUanif(establecimiento.getEsnif());
				sancionado.setUanrtel(establecimiento.getEsnrtel());
				sancionado.setUanrtel2(establecimiento.getEsnrtel2());
				sancionado.setUacoem(establecimiento.getEscoem());
				sancionado.setUaprovId(establecimiento.getEsnoraProvinciaId());
				sancionado.setUamunId(establecimiento.getEsnoraMunicipioId());
				sancionado.setUalocId(establecimiento.getEsnoraLocalidadId());
				sancionado.setUacalleId(establecimiento.getEsnoraCalleId());
				sancionado.setUacpId(establecimiento.getEsnombreCp());
				sancionado.setUaportalId(establecimiento.getEsnoraPortalId());
				sancionado.setUanombrePiso(establecimiento.getEsnombrePiso());
				sancionado.setUadireNocapv(establecimiento.getEsdireccion_nocapv());
				sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				sancionado.setUanodir(establecimiento.getEsnombrePiso());
				sancionado.setUadireAnt(establecimiento.getEsnodir());
				String pais = "";
				if (Y41bConstantes.SI.equals(establecimiento.getEsextranjero())) {
					pais = establecimiento.getEsnoraPaisId();
				} else {
					pais = Y41bConstantes.COD_PAIS_ESTADO;
				}
				sancionado.setUapaisId(pais);

				sancionado.setUanopeco(establecimiento.getEsnopeco());
				sancionado.setUaurl(establecimiento.getEsteurl());
				sancionado.setUanoco(establecimiento.getEsnoco());

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				sancionado.setUasecodigo(establecSector.getSector().getSecodigo());
				sancionado.setUasenombre(establecSector.getSector().getSenombre());
				sancionado.setUasenombree(establecSector.getSector().getSenombree());
				sancionado.setUafecultmod(establecimiento.getEsfemod());
				sancionado.setUausuultmod(establecimiento.getCensoMonitor().getMocodigo());

				if (reclamadoModif.getUaidinterv() == null) { // Anadir el
																// sancionado
					reclamado = this.arbintervDao.add(sancionado);
				} else { // Actualizar el sancionado
					sancionado.setUaidinterv(reclamadoModif.getUaidinterv());
					sancionado.setUaexcodigo(arbintervBD.getUaexcodigo());
					reclamado = this.arbintervDao.update(sancionado);
				}
				// por mantener coherencia con histricos hay que insertar en la
				// tabla
				// ESSA - DTSA
				Essa essa = new Essa();
				essa.setSolarb(solarb);
				this.essaDao.remove(essa);
				essa.setEstablecimiento(establecimiento);
				this.essaDao.add(essa);

				// Actualizar el campo de tipo de Arbitraje si no existe tramite
				// de aceptacion tramitado
				Arbtramexp arbtramexp = new Arbtramexp();
				arbtramexp.setSolarb(solarb);
				arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
				arbtramexp = this.arbtramexpDao.findUltimoTramiteTramitadoExpedientePorTipoTramite(arbtramexp);
				if (arbtramexp == null) {
					// Se actualiza el tipo de arbitraje si el establecimiento
					// esta
					// actualmente adherido o null en caso contrario
					if ("A".equalsIgnoreCase(establecimiento.getEsinadar())
							|| "L".equalsIgnoreCase(establecimiento.getEsinadar())) {
						solarb.setSaintiso(establecimiento.getEsintiar());
					} else {
						solarb.setSaintiso(null);
					}
					this.solarbDao.updateTipoArbitraje(solarb);
				}

			}
		}

		this.arbintervDao.actualizaFormaNotificacion(reclamadoModif);

		if (reclamado == null) {
			reclamado = arbintervBD;
		}
		reclamado.setUaformanotificacion(reclamadoModif.getUaformanotificacion());
		reclamado.setUaidioma(reclamadoModif.getUaidioma());

		if (Y41bUtils.interactuarConDokusi() && solarb != null && solarb.getArbexp() != null) {
			if (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea())) {
				// Si el reclamado ya esta dado de alta en Platea, se puede
				// actualizar
				if (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getExpartrecl())) {
					if ((reclamado != null && reclamado.getUanif() != null
							&& reclamado.getUanif().equals(arbintervBD.getUanif()))
							|| (!Y41bUtils.isValidCIF(arbintervBD.getUanif())
									&& !Y41bUtils.isValidNIF(arbintervBD.getUanif()))) {
						this.actualizarParticipantPlatea(solarb, reclamado, censoMonitor, false);
					} else {
						throw new Y41bUDAException("error.platea.actualizarTitular", true, null);
					}
				}
			}
		}

		return reclamadoModif;
	}

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbinterv actualizaReclamante(Solarb solarb, CensoMonitor censoMonitor) {

		Arbinterv reclamanteModif = solarb.getReclamante();
		Arbinterv reclamante = null;

		Arbinterv arbintervBD = this.arbintervDao.find(reclamanteModif);

		if (Y41bConstantes.VALOR_SI.equals(reclamanteModif.getReclamanteCambio())) {

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(reclamanteModif.getUadtcodigo());
			consumidor = this.consumidorDao.find(consumidor);

			if (consumidor != null) {
				Arbinterv consu = new Arbinterv();
				consu.setSolarb(solarb);
				solarb = this.solarbDao.find(solarb);
				solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));
				consu.setUadtcodigo(consumidor.getDtcodigo());
				consu.setUanombre(consumidor.getDtnombre());
				consu.setUaapellido1(consumidor.getDtapellido1());
				consu.setUaapellido2(consumidor.getDtapellido2());
				consu.setUanif(consumidor.getDtnif());
				consu.setUacoem(consumidor.getDttecoem());
				consu.setUanrtel(consumidor.getDtnrtel());
				consu.setUanrtel2(consumidor.getDtnrtel2());
				consu.setUaprovId(consumidor.getDtnoraProvinciaId());
				consu.setUamunId(consumidor.getDtnoraMunicipioId());
				consu.setUalocId(consumidor.getDtnoraLocalidadId());
				consu.setUacalleId(consumidor.getDtnoraCalleId());
				consu.setUacpId(consumidor.getDtnombreCp());
				consu.setUaportalId(consumidor.getDtnoraPortalId());
				consu.setUanombrePiso(consumidor.getDtnombrePiso());
				consu.setUadireNocapv(consumidor.getDtdireccion_nocapv());
				consu.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
				consu.setUanodir(consumidor.getDtnombrePiso());
				consu.setUadireAnt(consumidor.getDtnodir());
				String pais = "";
				if (Y41bConstantes.SI.equals(consumidor.getDtextranjero())) {
					pais = consumidor.getDtnoraPaisId();
				} else {
					pais = Y41bConstantes.COD_PAIS_ESTADO;
				}
				consu.setUapaisId(pais);

				if (reclamanteModif.getUaidinterv() == null) { // Anadir el
																// sancionado
					reclamante = this.arbintervDao.add(consu);
				} else { // Actualizar el sancionado
					consu.setUaidinterv(reclamanteModif.getUaidinterv());
					consu.setUaexcodigo(arbintervBD.getUaexcodigo());
					reclamante = this.arbintervDao.update(consu);
				}
				Dtsa dtsa = new Dtsa();
				dtsa.setSolarb(solarb);
				this.dtsaDao.remove(dtsa);
				dtsa.setConsumidor(consumidor);
				this.dtsaDao.add(dtsa);
			}

		}

		this.arbintervDao.actualizaFormaNotificacion(reclamanteModif);
		if (reclamante == null) {
			reclamante = arbintervBD;
		}
		reclamante.setUaformanotificacion(reclamanteModif.getUaformanotificacion());
		reclamante.setUaidioma(reclamanteModif.getUaidioma());

		if (Y41bUtils.interactuarConDokusi() && solarb != null && solarb.getArbexp() != null) {
			if (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea())) {
				if ((reclamante != null && reclamante.getUanif() != null
						&& reclamante.getUanif().equals(arbintervBD.getUanif()))
						|| (!Y41bUtils.isValidCIF(arbintervBD.getUanif())
								&& !Y41bUtils.isValidNIF(arbintervBD.getUanif()))) {
					this.actualizarParticipantPlatea(solarb, reclamante, censoMonitor, false);
				} else {
					throw new Y41bUDAException("error.platea.actualizarTitular", true, null);
				}
			}
		}

		return reclamanteModif;
	}

	/**
	 * Actualizar la participacin del reclamado / reclamante en el expediente
	 * 
	 * @param solarb
	 *            solarb
	 * @param arbinterv
	 *            arbinterv
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param eliminarRep
	 *            boolean
	 */
	public void actualizarParticipantPlatea(Solarb solarb, Arbinterv arbinterv, CensoMonitor censoMonitor,
			boolean eliminarRep) {

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());

		arbexp = this.arbexpDao.find(arbexp);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
		actualizarExpediente.setProcedure(procedure);

		// Actualizamos los datos del solicitante (titular)
		actualizarExpediente.setSolicitante(this.cargarDatosPersona(arbinterv));

		// Buscar el representante del reclamado / reclamante validado
		// si existe se aade
		String tipo = null;
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
			tipo = Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO;
			actualizarExpediente.setIdParticipacion(arbexp.getExidparticipacionreclamado());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
			tipo = Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE;
			actualizarExpediente.setIdParticipacion(arbexp.getExidparticipacionreclamante());
		}

		if (tipo != null && !eliminarRep) {
			Arbinterv representante = this.arbintervDao.dameInterviniente(solarb.getArbexp().getExcodigo(), tipo);

			if (representante != null) {
				DatosPersona datosRepresentante = this.cargarDatosPersona(representante);
				// Le ponemos el idioma del titular
				datosRepresentante.setIdioma(Y41bUtils.idiomaTwoChar(arbinterv.getUaidioma()));
				// Actualizamos los datos del representante validado
				actualizarExpediente.setRepresentante(datosRepresentante);
			}
		}

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solarb.damecodCompletoPlatea());

		actualizarExpediente.setEjercicio(solarb.getSanran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (censoMonitor != null) {
			DatosPersona sender = new DatosPersona();
			sender.setDni(censoMonitor.getModni());
			sender.setNombre(censoMonitor.getMonombre());
			actualizarExpediente.setSender(sender);
		}

		DatosRegistro datosRegistro = new DatosRegistro();
		try {
			datosRegistro.setRegistryNumber(solarb.getArbexp().getExregen());
			datosRegistro.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
					Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
		} catch (Exception e) {
		}

		actualizarExpediente.setDatosRegistro(datosRegistro);

		Calendar cal = Calendar.getInstance();
		try {
			if (solarb != null && solarb.getArbexp() != null && solarb.getArbexp().getExfecini() != null) {
				cal.setTime(solarb.getArbexp().getExfecini());
			} else {
				cal.setTime(new Date());
			}
			actualizarExpediente.setStartTimestamp(cal);
		} catch (Exception e) {
			e.printStackTrace();
			ArbintervServiceImpl.logger.error("Error producido al realizar el setTime sobre Calendar con valor: "
					+ solarb.getArbexp().getExfecini() + e.getMessage(), e);
		}

		this.y41bPlateaAdapterService.actualizarParticipantExpediente(actualizarExpediente);
	}

	/**
	 * Metodo para cargar el objeto DatosPersona con la informacin del
	 * interviniente
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return DatosPersona
	 */
	public DatosPersona cargarDatosPersona(Arbinterv arbinterv) {

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(arbinterv.getUanif().trim().toUpperCase());
		datosPersona.setNombre(StringEscapeUtils.escapeHtml(arbinterv.getUanombre()));

		if (Y41bUtils.isFilled(arbinterv.getUaapellido1())) {
			datosPersona.setApellido1(StringEscapeUtils.escapeHtml(arbinterv.getUaapellido1()));

			if (Y41bUtils.isFilled(arbinterv.getUaapellido2())) {
				datosPersona.setApellido1(StringEscapeUtils.escapeHtml(new StringBuffer(arbinterv.getUaapellido1())
						.append(" ").append(arbinterv.getUaapellido2()).toString()));
			}
		}

		if (Y41bUtils.isFilled(arbinterv.getUacoem())) {
			datosPersona.setMail(arbinterv.getUacoem());
		}
		if (Y41bUtils.isFilled(arbinterv.getUanrtel())) {
			datosPersona.setTelefono(arbinterv.getUanrtel());
		}
		datosPersona.setIdioma(Y41bUtils.idiomaTwoChar(arbinterv.getUaidioma()));

		return datosPersona;
	}

	/**
	 * Finds a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	public Arbinterv find(Arbinterv arbinterv) {
		arbinterv = this.arbintervDao.find(arbinterv);
		arbinterv.setDireccionCompleta(this.dameDireccionCompleta(arbinterv));
		return arbinterv;
	}

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbinterv> findAll(Arbinterv arbinterv, Pagination pagination) {
		List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, pagination);
		for (Arbinterv arbinterv2 : listaIntervinientes) {
			arbinterv2.setDireccionCompleta(this.dameDireccionCompleta(arbinterv2));
			arbinterv2.setCodTipointerv(arbinterv2.getUatipointerv());
		}
		return listaIntervinientes;
	}

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbinterv> findAllCombo(Arbinterv arbinterv, Pagination pagination) {
		List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, pagination);
		for (Arbinterv arbinterv2 : listaIntervinientes) {
			arbinterv2.setNombreCompleto((arbinterv2.getUanombre() == null ? ""
					: arbinterv2.getUanombre().concat(" ")
							.concat(arbinterv2.getUaapellido1() == null ? "" : arbinterv2.getUaapellido1()).concat(" ")
							.concat(arbinterv2.getUaapellido2() == null ? "" : arbinterv2.getUaapellido2())).trim());
		}
		return listaIntervinientes;
	}

	/**
	 * Counts rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Long
	 */
	public Long findAllCount(Arbinterv arbinterv) {
		return this.arbintervDao.findAllCount(arbinterv);
	}

	/**
	 * Finds rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbinterv> findAllLike(Arbinterv arbinterv, Pagination pagination, Boolean startsWith) {
		return (List<Arbinterv>) this.arbintervDao.findAllLike(arbinterv, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbinterv arbinterv, Boolean startsWith) {
		return this.arbintervDao.findAllLikeCount(arbinterv, startsWith);
	}

	/**
	 * Deletes a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbinterv arbinterv) {
		this.arbintervDao.remove(arbinterv);
	}

	/**
	 * Deletes multiple rows in the Arbinterv table.
	 * 
	 * @param arbintervList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbinterv> arbintervList) {
		for (Arbinterv arbintervAux : arbintervList) {
			this.arbintervDao.remove(arbintervAux);
		}
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameDireccionCompleta(Arbinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");
		direccion.append(this.dameLineaDireccion(arbinterb));

		/*
		 * if ((arbinterb.getUalocId() != null) && (arbinterb.getUamunId() !=
		 * null) && (arbinterb.getUaprovId() != null)) {
		 * direccion.append(dameLocalidad(arbinterb)); }
		 */

		if ((arbinterb.getUamunId() != null) && (arbinterb.getUaprovId() != null)) {
			direccion.append(this.dameMunicipio(arbinterb));
		}

		if (arbinterb.getUaprovId() != null) {
			direccion.append(this.dameProvincia(arbinterb));
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameLineaDireccion(Arbinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUadireNocapv())) {
			direccion.append(arbinterb.getUadireNocapv());
			if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUapaisId())
					&& !Y41bConstantes.COD_PAIS_ESTADO.equals(arbinterb.getUapaisId())) {
				if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUacpId())) {
					direccion.append(", ");
					direccion.append(arbinterb.getUacpId());
				}
				direccion.append(", ");
				T17Pais pais = new T17Pais();
				pais.setId(arbinterb.getUapaisId());
				direccion.append(this.t17PaisDao.find(pais).getDsO());
			}
		} else if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUacalleId())) {
			String calle = "";
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(arbinterb.getUacalleId()), null)).getDsO();
			} catch (Exception e) {

			}
			if (Y41bUtils.esNullOCadenaVacia(calle)) {
				if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
					direccion.append(arbinterb.getUanodir());
				}
			} else {
				if (arbinterb.getUaportalId() != null) {
					t17portal.setId(Long.parseLong(arbinterb.getUaportalId()));
					t17portal.setCalleId(Long.parseLong(arbinterb.getUacalleId()));
					List<T17Portal> list = this.t17PortalService.findAll(t17portal, null);
					if (list != null && list.size() > 0) {
						t17portal = list.get(0);
						if (t17portal != null && t17portal.getPortal() != null) {
							direccion.append(" ")
									.append(Y41bUtils.componerDireccion(calle, t17portal.getBloque(),
											t17portal.getPortal(), 0, null, arbinterb.getUanombrePiso(),
											arbinterb.getUanodir()));
						} else if (t17portal != null && t17portal.getNumero() != 0) {
							direccion.append(calle);
							direccion.append(" ");
							direccion.append(t17portal.getNumero());
							if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
								direccion.append(" ").append(arbinterb.getUanodir());
							}
						} else {
							direccion.append(calle);
							if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
								direccion.append(" ").append(arbinterb.getUanodir());
							}
						}
					} else {
						direccion.append(calle);
						if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
							direccion.append(" ").append(arbinterb.getUanodir());
						}
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
						direccion.append(" ").append(arbinterb.getUanodir());
					}
				}
			}
		} else {
			if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
				direccion.append(" ").append(arbinterb.getUanodir());
			}
		}
		return (direccion.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameCodigoPostal(Arbinterv arbinterb) {
		StringBuffer cp = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUaportalId())) {
			t17portal.setId(Long.parseLong(arbinterb.getUaportalId()));
			List<T17Portal> listat17portal = this.t17PortalDao.findAll(t17portal, null);

			if (listat17portal != null && listat17portal.size() > 0) {
				t17portal = listat17portal.get(0);
				return t17portal.getCodigoPostal();
			}

		}

		return (cp.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameLocalidad(Arbinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");
		String localidad = "";

		/* localidad */
		if ((arbinterb.getUalocId() != null) && (arbinterb.getUamunId() != null) && (arbinterb.getUaprovId() != null)) {
			T17Localidad localidadVO = this.t17LocalidadDao.find(new T17Localidad(arbinterb.getUalocId(), null,
					arbinterb.getUamunId(), arbinterb.getUaprovId(), null));
			if (localidadVO != null) {
				localidad = localidadVO.getDsO() == null ? "" : localidadVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(localidad);
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameMunicipio(Arbinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");

		String municipio = "";

		/* localidad */

		if ((arbinterb.getUamunId() != null) && (arbinterb.getUaprovId() != null)) {
			T17Municipio municipiodVO = (this.t17MunicipioDao
					.find(new T17Municipio(arbinterb.getUamunId(), arbinterb.getUaprovId(), null, null)));

			if (municipiodVO != null) {
				municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(municipio);
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameProvincia(Arbinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");

		String provincia = "";
		/* localidad */
		if (arbinterb.getUaprovId() != null) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(arbinterb.getUaprovId(), null, null)));

			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(provincia);

		}
		return (direccion.toString());
	}

	/**
	 * findEstablecimiento
	 * 
	 * @param interviniente
	 *            Arbinterv
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findEstablecimiento(Arbinterv interviniente) {
		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle();
		Establecimiento estableci = null;
		if (interviniente.getUaidinterv() != null && this.arbintervDao.findAllCount(interviniente) > 0) {
			Arbinterv arbinterv = (Arbinterv) this.arbintervDao.find(interviniente);
			estableci = (Establecimiento) this.establecimientoDao.find(new Establecimiento(arbinterv.getUaescodigo()));
			establecidetalle.setEscodigo(arbinterv.getUaescodigo());
			StringBuffer nombre = new StringBuffer("");
			nombre.append(arbinterv.getUanombre());
			if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaapellido1())) {
				nombre.append(" ").append(arbinterv.getUaapellido1());
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaapellido2())) {
				nombre.append(" ").append(arbinterv.getUaapellido2());
			}
			establecidetalle.setEsnombre(nombre.toString());
			establecidetalle.setEsnif(arbinterv.getUanif());
			establecidetalle.setEsnrtel(arbinterv.getUanrtel());
			establecidetalle.setEsnrtel2(arbinterv.getUanrtel2());
			establecidetalle.setEscoem(arbinterv.getUacoem());
			establecidetalle.setEsnoraPaisId(arbinterv.getUapaisId());
			establecidetalle.setProvinciaId(arbinterv.getUaprovId());
			establecidetalle.setMunicipioId(arbinterv.getUamunId());
			establecidetalle.setLocalidadId(arbinterv.getUalocId());
			establecidetalle.setCalleId(arbinterv.getUacalleId());
			establecidetalle.setCpId(arbinterv.getUacpId());
			establecidetalle.setEsnombreCp(this.dameCodigoPostal(arbinterv));
			establecidetalle.setPortalId(arbinterv.getUaportalId());
			establecidetalle.setEsnombrePiso(arbinterv.getUanombrePiso());
			establecidetalle.setEsdireccion_nocapv(arbinterv.getUadireNocapv());
			establecidetalle.setEsfemod(arbinterv.getUafecultmod());
			establecidetalle.setMocodigo(arbinterv.getUausuultmod());
			establecidetalle.setMousu(arbinterv.getUsuarioxlnet());
			establecidetalle.setEsnopeco(arbinterv.getUanopeco());
			establecidetalle.setEsnoco(arbinterv.getUanoco());
			establecidetalle.setEsteurl(arbinterv.getUaurl());
			establecidetalle.setSecodigo(arbinterv.getUasecodigo());
			establecidetalle.setSenombre(arbinterv.getUasenombre());
			establecidetalle.setSenombree(arbinterv.getUasenombree());
			establecidetalle.setEscoidco(arbinterv.getUaidioma());
			establecidetalle.setEsdireccionCompleta(this.dameDireccionCompleta(arbinterv));

			String calle = "";
			if (!Y41bUtils.esNullOCadenaVacia(establecidetalle.getCalleId())) {
				try {
					calle = this.t17CalleDao
							.findCalleConTipoVia(new T17Calle(Long.parseLong(establecidetalle.getCalleId()), null))
							.getDsO();
				} catch (Exception e) {

				}
				establecidetalle.setCalleId_label(calle);
			}

		} else {
			estableci = (Establecimiento) this.establecimientoDao
					.find(new Establecimiento(interviniente.getUaescodigo()));

			StringBuffer direccionCompleta = new StringBuffer();
			if (estableci.getEsnombreCalle() != null && !estableci.getEsnombreCalle().equals("")) {
				direccionCompleta.append(estableci.getEsnombreCalle());

				if (estableci.getEsnombrePortal() != null && !estableci.getEsnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(estableci.getEsnombrePortal());
				}

				if (estableci.getEsnombrePiso() != null && !estableci.getEsnombrePiso().equals("")) {
					direccionCompleta.append(" ").append(estableci.getEsnombrePiso());
				}

				if (estableci.getEsnombreMunicipio() != null && !estableci.getEsnombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(estableci.getEsnombreMunicipio());
				}

				if (estableci.getEsnombreProvincia() != null && !estableci.getEsnombreProvincia().equals("")) {
					direccionCompleta.append(" ").append(estableci.getEsnombreProvincia());
				}
			} else if (estableci.getEsdireccion_nocapv() != null && !estableci.getEsdireccion_nocapv().equals("")) {
				direccionCompleta.append(estableci.getEsdireccion_nocapv());
				if (estableci.getEsnombreMunicipio() != null && !estableci.getEsnombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(estableci.getEsnombreMunicipio());
				}
				if (estableci.getEsnombreProvincia() != null && !estableci.getEsnombreProvincia().equals("")) {
					direccionCompleta.append(" ").append(estableci.getEsnombreProvincia());
				}
			}

			estableci.setEsdireccionCompleta(direccionCompleta.toString());

			EstablecimSector establecSector = new EstablecimSector();
			establecSector.setEstablecimiento(estableci);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecSector);

			establecidetalle = new EstablecimientoDetalle(estableci.getEscodigo(),
					estableci.getCensoMonitor().getMocodigo(), estableci.getCensoMonitor().getMonombre(),
					estableci.getCensoMonitor().getUsuarioxlnet(), estableci.getEsnombre(), estableci.getEstipid(),
					estableci.getEsnif(), estableci.getEsnoan(), estableci.getEsnoco(), estableci.getEsnodir(),
					estableci.getEscolo(), estableci.getEsnrcopo(), estableci.getEsnrtel(), estableci.getEsnrfax(),
					estableci.getEscopa(), estableci.getEsincapr(), estableci.getEsindemp(), estableci.getEsteco(),
					estableci.getEsinadar(), estableci.getEsfeadar(), estableci.getEscoem(), null,
					estableci.getEsinempr(), estableci.getEsnrtel2(), estableci.getEsinfeba(), estableci.getEsfeba(),
					estableci.getEsnoap1(), estableci.getEsnoap2(), estableci.getEsnolo(), estableci.getEscomapv(),
					estableci.getEscoca(), estableci.getEsnopeco(), estableci.getEscoidco(), estableci.getEsinreco(),
					estableci.getEsfemod(), estableci.getEsinesco(), estableci.getEsnomu(), estableci.getEsnorep(),
					estableci.getEsnifrep(), estableci.getDtteemr(), estableci.getEscarep(), estableci.getEsteurl(),
					estableci.getEscooe(), estableci.getEsnodeco(), estableci.getEsintiar(), estableci.getEsfeplad(),
					estableci.getEsindeme(), estableci.getEsnoraPaisId(), estableci.getEsnoraPaisNombre(),
					estableci.getEsnoraProvinciaId(), estableci.getEsnombreProvincia(),
					estableci.getEsnoraMunicipioId(), estableci.getEsnombreMunicipio(),
					estableci.getEsnoraLocalidadId(), estableci.getEsnombreLocalidad(), estableci.getEsnoraCalleId(),
					estableci.getEsnombreCalle(), estableci.getEsnoraCpId(), estableci.getEsnombreCp(),
					estableci.getEsnoraPortalId(), estableci.getEsnombrePortal(), estableci.getEsnombrePiso(),
					estableci.getEsdireccion_nocapv(), estableci.getEsdireccionCompleta(),
					estableci.getEsexpedientesAbiertos(), establecSector.getEacodigo(),
					establecSector.getActividad().getAvcodigo(), establecSector.getActividad().getAvnombre(),
					establecSector.getActividad().getAvnombree(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					establecSector.getEainprse(), estableci.getEsextranjero(), estableci.getEssede());
		}

		establecidetalle.setDireccionAntiguaCompleta(this.dameDireccionAntigua(estableci));
		establecidetalle.setEssede(estableci.getEssede());
		establecidetalle.setEsfeadar(estableci.getEsfeadar());
		establecidetalle.setEsintiar(estableci.getEsintiar());
		establecidetalle.setEsfeerd(estableci.getEsfeerd());
		establecidetalle.setEscooe(estableci.getEscooe());
		establecidetalle.setEsnorep(estableci.getEsnorep());
		establecidetalle.setEsnifrep(estableci.getEsnifrep());
		establecidetalle.setEsfeba(estableci.getEsfeba());
		establecidetalle.setEsteco(estableci.getEsteco());

		establecidetalle.setEstipid(estableci.getEstipid());

		// Mail de avisos
		establecidetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			establecidetalle.setAhfere(establecimArbitra.getAhfere());
			establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
			establecidetalle.setEsinadar(estableci.getEsinadar());
			establecidetalle.setAhindef(establecimArbitra.getAhindef());
			establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
			establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}
		} catch (Exception e) {

		}
		// buscar sedes
		if (estableci.getEssede() != null && estableci.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(estableci.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
		establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());

		return establecidetalle;
	}

	/**
	 * 
	 * @param estableci
	 *            Establecimiento
	 * @return String
	 */
	public String dameDireccionAntigua(Establecimiento estableci) {
		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String escomapv = (estableci.getEscomapv() == null) ? "" : estableci.getEscomapv();
		String esnomu = (estableci.getEsnomu() == null) ? "" : estableci.getEsnomu();
		String esnolo = (estableci.getEsnolo() == null) ? "" : estableci.getEsnolo();
		String esnodir = (estableci.getEsnodir() == null) ? "" : estableci.getEsnodir();
		String esnrcopo = (estableci.getEsnrcopo() == null) ? "" : estableci.getEsnrcopo();

		direccionAntiguaCompleta.append(escomapv).append(" ").append(esnomu).append(" ").append(esnolo).append(" ")
				.append(esnodir).append(" ").append(esnrcopo);
		return direccionAntiguaCompleta.toString();
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param interviniente
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public ConsumidorDetalle findConsumidor(Arbinterv interviniente) {
		ConsumidorDetalle consumidorDetalle = null;
		Consumidor consu = null;
		if (interviniente.getUaidinterv() != null && this.arbintervDao.findAllCount(interviniente) > 0) {
			Arbinterv arbinterv = (Arbinterv) this.arbintervDao.find(interviniente);

			consu = new Consumidor();
			if (arbinterv.getUadtcodigo() != null) {
				consu.setDtcodigo(arbinterv.getUadtcodigo().toString());
				consu = (Consumidor) this.consumidorDao.find(consu);
			} else {
				consu = new Consumidor();
			}

			String calle = "";
			if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUacalleId())) {
				try {
					calle = this.t17CalleDao.find(new T17Calle(Long.parseLong(arbinterv.getUacalleId()), null))
							.getDsO();
				} catch (Exception e) {

				}
			}
			consumidorDetalle = new ConsumidorDetalle(arbinterv.getUadtcodigo(), arbinterv.getUausuultmod(), null,
					arbinterv.getUsuarioxlnet(), arbinterv.getUaedad(), null, arbinterv.getUanombre(),
					arbinterv.getUaapellido1(), arbinterv.getUaapellido2(), arbinterv.getUanif(), null, null, null,
					arbinterv.getUanrtel(), null, null, null, arbinterv.getUacoem(), arbinterv.getUanrtel2(), null,
					arbinterv.getUaidioma(), null, null, null, null, null, null, arbinterv.getUasexo(), null, null,
					arbinterv.getUafecultmod(), null, null, null, null, null, null, null, null, null, null, null,
					arbinterv.getUatipoidentificacion(), arbinterv.getUapaisId(), null, arbinterv.getUaprovId(),
					this.dameProvincia(arbinterv), arbinterv.getUamunId(), this.dameMunicipio(arbinterv),
					arbinterv.getUalocId(), this.dameLocalidad(arbinterv), arbinterv.getUacalleId(), calle,
					arbinterv.getUacpId(), this.dameCodigoPostal(arbinterv), arbinterv.getUaportalId(), null,
					arbinterv.getUanombrePiso(), arbinterv.getUadireNocapv(), this.dameDireccionCompleta(arbinterv),
					null, null, null, Y41bConstantes.COD_PAIS_ESTADO.equals(arbinterv.getUapaisId())
							? Y41bConstantes.VALOR_NO : Y41bConstantes.VALOR_SI);

		} else {
			consu = new Consumidor();
			consu.setDtcodigo(interviniente.getUadtcodigo().toString());
			consu = (Consumidor) this.consumidorDao.find(consu);

			consumidorDetalle = new ConsumidorDetalle(consu.getDtcodigo(), consu.getCensoMonitor().getMocodigo(),
					consu.getCensoMonitor().getMonombre(), consu.getCensoMonitor().getUsuarioxlnet(),
					consu.getRangoEdad().getRancod(), consu.getRangoEdad().getRandesc(), consu.getDtnombre(),
					consu.getDtapellido1(), consu.getDtapellido2(), consu.getDtnif(), consu.getDtnodir(),
					consu.getDtcolo(), consu.getDtnrcopo(), consu.getDtnrtel(), consu.getDtnrfax(), consu.getDtcopa(),
					consu.getDtnrdimu(), consu.getDttecoem(), consu.getDtnrtel2(), consu.getDtnrtel3(),
					consu.getDtcoidco(), consu.getDtinreco(), consu.getDtcoorac(), consu.getDtnoap1(),
					consu.getDtnoap2(), consu.getDtnrsoci(), consu.getDtnran(), consu.getDtcosx(), consu.getDtnorep(),
					consu.getDtnifrep(), consu.getDtfemod(), consu.getDtnolo(), consu.getDtcopv(), consu.getDtinrl(),
					consu.getDtnodirr(), consu.getDtcolor(), consu.getDtnrcopor(), consu.getDtcopvr(),
					consu.getDtnrtelr(), consu.getDtnrtel2r(), consu.getDtnrfaxr(), consu.getDtteemr(),
					consu.getDtintipid(), consu.getDtnoraPaisId(), consu.getDtnoraPaisNombre(),
					consu.getDtnoraProvinciaId(), consu.getDtnombreProvincia(), consu.getDtnoraMunicipioId(),
					consu.getDtnombreMunicipio(), consu.getDtnoraLocalidadId(), consu.getDtnombreLocalidad(),
					consu.getDtnoraCalleId(), consu.getDtnombreCalle(), consu.getDtnoraCpId(), consu.getDtnombreCp(),
					consu.getDtnoraPortalId(), consu.getDtnombrePortal(), consu.getDtnombrePiso(),
					consu.getDtdireccion_nocapv(), consu.getDtdireccionCompleta(), consu.getDtexpedientesAbiertos(),
					null, null, consu.getDtextranjero());

		}
		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String dtcopv = (consu.getDtcopv() == null) ? "" : consu.getDtcopv();
		String dtnolo = (consu.getDtnolo() == null) ? "" : consu.getDtnolo();
		String dtnodir = (consu.getDtnodir() == null) ? "" : consu.getDtnodir();
		String dtnrcopor = (consu.getDtnrcopor() == null) ? "" : consu.getDtnrcopor();

		direccionAntiguaCompleta.append(dtcopv).append(" ").append(dtnolo).append(" ").append(dtnodir).append(" ")
				.append(dtnrcopor);

		consumidorDetalle.setDireccionAntiguaCompleta(direccionAntiguaCompleta.toString());
		return consumidorDetalle;
	}

	/**
	 * Dame reclamado.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbinterv
	 */
	public Arbinterv dameInterviniente(String sacodigo, String tipo) {
		Arbinterv arbinterv = this.arbintervDao.dameInterviniente(sacodigo, tipo);
		if (arbinterv != null) {
			arbinterv.setDireccionCompleta(this.dameDireccionCompleta(arbinterv));
			arbinterv.setProvinciaTxt(this.dameProvincia(arbinterv));
			arbinterv.setMunicipioTxt(this.dameMunicipio(arbinterv));
			if (tipo.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)) {
				// sacar si est adherida o no a arbitraje
				boolean adherida = false;
				String tipoAdh = null;
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(arbinterv.getUaescodigo());
				establecimiento = this.establecimientoDao.find(establecimiento);
				if (establecimiento.getEsfeadar() != null) {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
					// 0150111 aniadimos las nuevas opciones
					// Se comenta las nuevas opciones a raiz de lo decidido el
					// dia 14/04/2020 y se vuelve a poner lo que habia antes
					// if (establecimiento.getEsfeba() != null
					// && new Date().after(establecimiento.getEsfeba())
					// && (establecimiento.getEsfeadar() == null ||
					// (establecimiento
					// .getEsfeadar() != null
					// && establecimArbitra.getAhfeba() != null &&
					// establecimiento
					// .getEsfeba().after(
					// establecimArbitra.getAhfeba())))
					// && (establecimiento.getEsfeadar() == null ||
					// (establecimiento
					// .getEsfeadar() != null
					// && establecimArbitra.getAhfere() != null &&
					// establecimiento
					// .getEsfeba().after(
					// establecimArbitra.getAhfere())))) {
					// tipoAdh = "X";
					// } else if (establecimiento.getEsfeba() != null
					// && new Date().after(establecimiento.getEsfeba())
					// && (establecimArbitra.getAhfeba() == null ||
					// (establecimArbitra
					// .getAhfeba() != null && establecimArbitra
					// .getAhfeba().after(
					// establecimiento.getEsfeba())))
					// && (establecimArbitra.getAhfere() == null ||
					// (establecimArbitra
					// .getAhfere() != null && establecimArbitra
					// .getAhfere().after(
					// establecimiento.getEsfeba())))
					// && establecimiento.getEsfeadar() != null
					// && establecimArbitra.getAhcodigo() != null) {
					// tipoAdh = "C";
					// adherida = true;
					// } else
					// 0153887 aniadimos caso 'S' cuando este cerrado para que
					// no saque icono
					if (establecimiento.getEsfeba() != null) {
						tipoAdh = "S";
					} else if (establecimArbitra.getAhfeba() == null

							|| new Date().before(establecimArbitra.getAhfeba())) {
						adherida = true;
						if (establecimArbitra.getAhtelimi() != null) {
							tipoAdh = "L";
						} else {
							tipoAdh = "A";
						}
						if (establecimiento.getEsintiar() != null) {
							arbinterv.setTipoArb(establecimiento.getEsintiar());
						}
					} else if (new Date().equals(establecimArbitra.getAhfeba())
							|| new Date().after(establecimArbitra.getAhfeba())) {
						tipoAdh = "B";
					}
				}
				arbinterv.setAdherida(adherida);
				arbinterv.setTipoAdh(tipoAdh);

				// 0157454: Incluir literal Establecimiento cerrado en la
				// pestaa hecho de los expedientes
				String cerrado = "";
				cerrado = this.establecimientoService.estadoCerradoEstablecimientoCenso(arbinterv.getUaescodigo());
				arbinterv.setEstablecimientoCerrado(cerrado);
				// 0157454: Incluir literal Establecimiento cerrado en la
				// pestaa hecho de los expedientes
			}
		}
		return arbinterv;
	}

	/**
	 * Dame tipo arbitraje reclamado en censo.
	 * 
	 * @param sacodigo
	 *            String
	 * @return String
	 */
	public String dameTipoArbitrajeReclamadoCenso(String sacodigo) {
		String resultado = "";
		Arbinterv arbinterv = this.arbintervDao.dameInterviniente(sacodigo,
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
		if (arbinterv != null) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(arbinterv.getUaescodigo());
			establecimiento = this.establecimientoDao.find(establecimiento);
			if (establecimiento.getEsfeadar() != null
					&& (establecimiento.getEsfeba() == null || new Date().before(establecimiento.getEsfeba()))) {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
				if (establecimArbitra.getAhfeba() == null || new Date().before(establecimArbitra.getAhfeba())) {
					if (establecimiento.getEsintiar() != null) {
						resultado = establecimiento.getEsintiar();
					}
				}
			}
		}
		return resultado;
	}

	/**
	 * findAllIntervinientesColegio
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List<Intervinientes>
	 */
	public List<Intervinientes> findAllIntervinientesColegio(Intervinientes intervinientes, Pagination pagination) {
		return (List<Intervinientes>) this.arbintervDao.findAllIntervinientesColegio(intervinientes, pagination);
	}

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("nombre")) {
				pagination.setSort("NOMBRE");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("tipoInterviniente")) {
				pagination.setSort("TIPOINTERVINIENTE");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("nif")) {
				pagination.setSort("NIF");
			}
		}

		// // Control para poder paginar por un campo calculado -
		// numeroExpediente
		// // //ASCENDENTE
		// if (pagination.getSort() != null
		// && pagination.getAscDsc().equals("asc")
		// && pagination.getSort().equals("numExpediente")) {
		// pagination.setSort("decoor, denror, denran");
		// }
		//

		//
		// if (pagination.getSort() != null
		// && pagination.getSort().equals("dtnombreMunicipio")) {
		// pagination.setSort("DTNOMBRE_MUNICIPIO");
		// }

		List<Intervinientes> listIntervinientes = this.arbintervDao.findAllIntervinientesColegio(intervinientes,
				pagination);

		for (Intervinientes intervinientesAux : listIntervinientes) {
			StringBuffer direccionCompleta = new StringBuffer();

			if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
				direccionCompleta.append(intervinientesAux.getNombreCalle());

				if (intervinientesAux.getNombrePortal() != null && !intervinientesAux.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
				}

				if (intervinientesAux.getNombreMunicipio() != null
						&& !intervinientesAux.getNombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(intervinientesAux.getNombreMunicipio());
				}

			} else if (intervinientesAux.getDireccionNocapv() != null
					&& !intervinientesAux.getDireccionNocapv().equals("")) {
				direccionCompleta.append(intervinientesAux.getDireccionNocapv());
				if (intervinientesAux.getNombreMunicipio() != null
						&& !intervinientesAux.getNombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(intervinientesAux.getNombreMunicipio());
				}
				if (intervinientesAux.getNombrePais() != null && !intervinientesAux.getNombrePais().equals("")) {
					direccionCompleta.append(" ").append(intervinientesAux.getNombrePais());
				}
			}

			intervinientesAux.setDireccionCompleta(direccionCompleta.toString());
		}

		return listIntervinientes;
	}

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	public Long findAllIntervinientesCount(Intervinientes intervinientes) {
		return this.intervinientesDao.findAllCount(intervinientes);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.ArbintervService#actualizarInterviniente(com.ejie
	 * .y41b.model.Arbinterv)
	 */
	@Override()
	public void actualizarInterviniente(Arbinterv arbinterv) {
		arbinterv = this.arbintervDao.find(arbinterv);
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO.equals(arbinterv.getUatipointerv())) {
			Empper perito = new Empper();
			perito.setPecodigo(arbinterv.getUaentidadId());
			perito = this.empperDao.find(perito);
			arbinterv = new Arbinterv(arbinterv.getUaidinterv(), perito.getPenombre(), perito.getPecif(),
					perito.getPenrtel(), perito.getPenrtel2(), perito.getPeprovId(), perito.getPemunId(),
					perito.getPelocId(), perito.getPecalleId(), perito.getPenrcopo(), perito.getPeportalId(), "",
					((!Y41bConstantes.ARABA.equals(perito.getPeprovId())
							&& !Y41bConstantes.GIPUZKOA.equals(perito.getPeprovId())
							&& !Y41bConstantes.BIZKAIA.equals(perito.getPeprovId())) ? perito.getPenodir() : null),
					"", Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO, arbinterv.getUaexcodigo(), null, null, null, null,
					null, null, null, null, null, null, perito.getPeteem(),
					((Y41bConstantes.ARABA.equals(perito.getPeprovId())
							|| Y41bConstantes.GIPUZKOA.equals(perito.getPeprovId())
							|| Y41bConstantes.BIZKAIA.equals(perito.getPeprovId())) ? perito.getPenodir() : null),
					null, null, Y41bConstantes.COD_PAIS_ESTADO, perito.getPecodigo(), null, null, perito.getPeteurl(),
					null, null, null, null, null, null, null, null, null, null);
			this.arbintervDao.update(arbinterv);
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO.equals(arbinterv.getUatipointerv())) {
			Arbitro arbitro = new Arbitro();
			arbitro.setArcodigo(arbinterv.getUaentidadId());
			arbitro = this.arbitroService.find(arbitro);

			// Cambio arbitros - Independientemente del tipo de arbitro, siempre
			// hay que coger los datos de direccin almacenados en arbitro
			// arbitro = this.arbitroService.tratarDireccionesCentro(arbitro);
			if (Y41bConstantes.CENSO_ARB_ARBITRO_DIR_CEN.equalsIgnoreCase(arbitro.getArindico())) {
				arbinterv = new Arbinterv(arbinterv.getUaidinterv(), arbitro.getArnombre(), arbitro.getArnif(),
						arbitro.getArnrtelc(), arbitro.getArnrtel2c(), arbitro.getArprovcId(), arbitro.getArmuncId(),
						arbitro.getArloccId(), arbitro.getArcallecId(), arbitro.getArnrcopoc(),
						arbitro.getArportalcId(), arbitro.getArnombrecPiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, arbinterv.getUaexcodigo(), null, null, null,
						null, null, null, null, null, null, null, arbitro.getArteemc(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurl(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			} else {
				arbinterv = new Arbinterv(arbinterv.getUaidinterv(), arbitro.getArnombre(), arbitro.getArnif(),
						arbitro.getArnrtel(), arbitro.getArnrtel2(), arbitro.getArprovId(), arbitro.getArmunId(),
						arbitro.getArlocId(), arbitro.getArcalleId(), arbitro.getArnrcopo(), arbitro.getArportalId(),
						arbitro.getArnombrePiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, arbinterv.getUaexcodigo(), null, null, null,
						null, null, null, null, null, null, null, arbitro.getArteem(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir() : null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurl(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			}
		}
		this.arbintervDao.update(arbinterv);
	}

	/**
	 * tratamientoAnyadirIntervinienteSancionado
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	private Establecimiento tratamientoAnyadirIntervinienteSancionado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un sancionado a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}
}
