package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.platea.DatosPersona;

/**
 * ArbintervService  
 * 
 *  
 */

public interface ArbintervService {

	/**
	 * Inserts a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv add(Arbinterv arbinterv);

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv update(Arbinterv arbinterv);

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	Arbinterv actualizaReclamado(Solarb solarb, CensoMonitor censoMonitor);

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	Arbinterv actualizaReclamante(Solarb solarb, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv find(Arbinterv arbinterv);

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbinterv> findAll(Arbinterv arbinterv, Pagination pagination);

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbinterv> findAllCombo(Arbinterv arbinterv, Pagination pagination);

	/**
	 * Counts rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Long
	 */
	Long findAllCount(Arbinterv arbinterv);

	/**
	 * Finds rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbinterv> findAllLike(Arbinterv arbinterv, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbinterv arbinterv, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return
	 */
	void remove(Arbinterv arbinterv);

	/**
	 * Deletes multiple rows in the Arbinterv table.
	 * 
	 * @param arbintervList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbinterv> arbintervList);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	EstablecimientoDetalle findEstablecimiento(Arbinterv intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param interviniente
	 *            Intervinientes
	 * @return Intervinientes
	 */
	ConsumidorDetalle findConsumidor(Arbinterv interviniente);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbinterv
	 */
	Arbinterv dameInterviniente(String sacodigo, String tipo);

	/**
	 * Dame tipo arbitraje reclamado en censo.
	 * 
	 * @param sacodigo
	 *            String
	 * @return String
	 */
	public String dameTipoArbitrajeReclamadoCenso(String sacodigo);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	String dameDireccionCompleta(Arbinterv arbinterb);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	String dameLineaDireccion(Arbinterv arbinterb);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	String dameCodigoPostal(Arbinterv arbinterb);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	String dameLocalidad(Arbinterv arbinterb);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	String dameMunicipio(Arbinterv arbinterb);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	String dameProvincia(Arbinterv arbinterb);

	/**
	 * findAllIntervinientesColegio
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List<Intervinientes>
	 */
	List<Intervinientes> findAllIntervinientesColegio(
			Intervinientes intervinientes, Pagination pagination);

	/**
	 * Method 'getIntervinientesByUaexcodigo'
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List<Intervinientes>
	 */
	List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes,
			Pagination pagination);

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	Long findAllIntervinientesCount(Intervinientes intervinientes);

	/**
	 * 
	 */

	/**
	 * Actualizar expediente
	 * 
	 * @param solarb
	 *            solarb
	 * @param arbinterv
	 *            arbinterv
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param eliminarRep
	 *            boolean
	 */
	void actualizarParticipantPlatea(Solarb solarb, Arbinterv arbinterv,
			CensoMonitor censoMonitor, boolean eliminarRep);

	/**
	 * Metodo para cargar el objeto DatosPersona con la informacin del
	 * interviniente
	 * 
	 * @param arbinterv
	 *            arbinterv
	 * 
	 * @return DatosPersona
	 */
	DatosPersona cargarDatosPersona(Arbinterv arbinterv);

	/**
	 * actualizarInterviniente
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 */
	void actualizarInterviniente(Arbinterv arbinterv);

}
