package com.ejie.y41b.service;

import java.text.ParseException;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.PlantillaTramiteARBDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbexpServiceAbstract
 * 
 *  
 */
public class ArbexpServiceUtil {

	/**
	 * ArbexpServiceUtil
	 */
	private ArbexpServiceUtil() {
	}

	/**
	 * rellenaPropiosCitacion2Audiencia cuando en la misma plantilla tenemos
	 * datos de primera y segunda audiencia
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteAudiencia
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	public static void rellenaPropiosAudiencia(
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteAudiencia) throws ParseException {

		if (tramiteAudiencia.getTrfecaudiencia() != null) {
			// DAtos audiencia
			plantillaTramiteARBDetalle.setFechaAudienciaCas(Y41bUtils
					.formatearDateToString(
							tramiteAudiencia.getTrfecaudiencia(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA,
							Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaAudienciaEus(Y41bUtils
					.formatearDateToStringEuskera(
							tramiteAudiencia.getTrfecaudiencia(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA,
							Y41bConstantes.EUSKERA));
		}

	}

	/**
	 * rellenaPropiosCitacion2Audiencia cuando en la misma plantilla tenemos
	 * datos de primera y segunda audiencia
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteAudiencia
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	public static void rellenaPropiosAudiencia2(
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteAudiencia) throws ParseException {

		if (tramiteAudiencia.getTrfecaudiencia() != null) {
			// DAtos audiencia
			plantillaTramiteARBDetalle.setFechaAudiencia2Cas(Y41bUtils
					.formatearDateToString(
							tramiteAudiencia.getTrfecaudiencia(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA,
							Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaCitacionAudiencia2Eus(Y41bUtils
					.formatearDateToStringEuskera(
							tramiteAudiencia.getTrfecaudiencia(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA,
							Y41bConstantes.EUSKERA));
		}

	}
}
