package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.sql.Blob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbainstanciaDao;
import com.ejie.y41b.dao.ArbcolegioDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbenvioDao;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import com.ejie.y41b.dao.DatosMailSedeDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EmpperDao;
import com.ejie.y41b.dao.EssaDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.LaudosAdoptadoDao;
import com.ejie.y41b.dao.LaudosTipoDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
//import com.ejie.y41b.dao.T17TipoViaDao;
import com.ejie.y41b.dao.TclugaudDao;
import com.ejie.y41b.dao.TipsubsanaDao;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbainstancia;
import com.ejie.y41b.model.Arbcolegio;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Essa;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.LaudosAdoptado;
import com.ejie.y41b.model.LaudosTipo;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteARBDetalle;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
//import com.ejie.y41b.model.T17TipoVia;
import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.Tipsubsana;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bNumberToLetterConverter;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbexpServiceImpl  
 * 
 *  
 */

/**
 * ArbexpServiceImpl
 * 
 *  
 */
@Service(value = "arbexpService")
public class ArbexpServiceImpl implements ArbexpService {

	@Autowired()
	private ArbexpDao arbexpDao;

	@Autowired()
	private Arbexp2Service arbexp2Service;

	@Autowired()
	private ArbintervDao arbintervDao;

	@Autowired()
	private RepresentantesService representantesService;

	@Autowired()
	private ConsumidorDao consumidorDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private EstablecimSectorDao establecimSectorDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired()
	private ArbdoctempDao arbdoctempDao;
	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;
	@Autowired()
	private PlantillaDecisionDao plantillaDecisionDao;
	@Autowired()
	private ArbtramexpDao arbtramexpDao;
	@Autowired()
	private SolarbDao solarbDao;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private ArbintervService arbintervService;
	@Autowired()
	private SedeService sedeService;
	@Autowired()
	private EstablecimientoService establecimientoService;
	@Autowired()
	private TipsubsanaDao tipsubsanaDao;
	@Autowired()
	private ArbcolegioDao arbcolegioDao;
	@Autowired()
	private TclugaudDao tclugaudDao;
	@Autowired()
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;
	@Autowired()
	private DatosMailSedeDao datosMailSedeDao;
	@Autowired()
	private DocumentoHechoDao documentoHechoDao;
	@Autowired()
	private T17CalleDao t17CalleDao;
	@Autowired()
	private T17PortalService t17PortalService;
	@Autowired()
	private T17LocalidadDao t17LocalidadDao;
	@Autowired()
	private T17MunicipioDao t17MunicipioDao;
	// @Autowired()
	// private T17TipoViaDao t17tipoViaDao;
	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;
	@Autowired()
	private EmpperDao empperDao;
	@Autowired()
	private ArbainstanciaDao arbainstanciaDao;
	@Autowired()
	private ArbenvioDao arbenvioDao;
	@Autowired()
	private ArbitroService arbitroService;

	@Autowired()
	private LaudosAdoptadoDao laudosAdoptadoDao;
	@Autowired()
	private LaudosTipoDao laudosTipoDao;
	@Autowired()
	private EssaDao essaDao;
	@Autowired
	private DocumentosFirmaArbitrosTempService documentosFirmaArbitrosTempService;

	/**
	 * Inserts a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbexp add(Arbexp arbexp) {
		return this.arbexpDao.add(arbexp);
	}

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbexp update(Arbexp arbexp) {
		return this.arbexpDao.update(arbexp);
	}

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	public Arbexp find(Arbexp arbexp) {
		return (Arbexp) this.arbexpDao.find(arbexp);
	}

	/**
	 * Finds a List of rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbexp> findAll(Arbexp arbexp, Pagination pagination) {
		return (List<Arbexp>) this.arbexpDao.findAll(arbexp, pagination);
	}

	/**
	 * Counts rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	public Long findAllCount(Arbexp arbexp) {
		return this.arbexpDao.findAllCount(arbexp);
	}

	/**
	 * Finds rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbexp> findAllLike(Arbexp arbexp, Pagination pagination, Boolean startsWith) {
		return (List<Arbexp>) this.arbexpDao.findAllLike(arbexp, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbexp arbexp, Boolean startsWith) {
		return this.arbexpDao.findAllLikeCount(arbexp, startsWith);
	}

	/**
	 * Deletes a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbexp arbexp) {
		this.arbexpDao.remove(arbexp);
	}

	/**
	 * Deletes multiple rows in the Arbexp table.
	 * 
	 * @param arbexpList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbexp> arbexpList) {
		for (Arbexp arbexpAux : arbexpList) {
			this.arbexpDao.remove(arbexpAux);
		}
	}

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	public Arbexp dameDetallesExpediente(Arbexp arbexp) {
		return (Arbexp) this.arbexpDao.dameDetallesExpediente(arbexp);
	}

	/**
	 * Inserts a single row in the Arbinterv table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbinterv addInterviniente(Intervinientes intervinientes, CensoMonitor censoMonitor) {

		Arbinterv arbinterb = null;

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_CONSUMIDOR)) {
			arbinterb = this.cargarIntervinienteConsumidor(intervinientes, censoMonitor);

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_ESTABLECIMIENTO)) {
			arbinterb = this.cargarIntervinienteEstablecimiento(intervinientes, censoMonitor);

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_OTROS)) {
			arbinterb = this.arbexp2Service.cargarIntervinienteOrganismo(intervinientes);
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {

			arbinterb = this.representantesService.cargarIntervinienteRepresentanteARB(intervinientes);
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO)) {
			// try {
			arbinterb = this.arbexp2Service.cargarIntervinienteArbitro(intervinientes, censoMonitor);
			// } catch (Y41bUDAException e) {
			// throw new Y41bUDAException(
			// "error.interviniente.ArbitroNoExiste", true, null);
			// }
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO)) {
			// try {
			arbinterb = this.arbexp2Service.cargarIntervinientePerito(intervinientes, censoMonitor);
			// } catch (Y41bUDAException e) {
			// throw new Y41bUDAException(
			// "error.interviniente.PeritoNoExiste", true, null);
			// }
		}

		return arbinterb;
	}

	/**
	 * Borrado de un interviniente de un expediente
	 * 
	 * @param interviniente
	 *            arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInterviniente(Arbinterv interviniente) {

		try {
			Arbinterv interv = this.arbintervDao.find(interviniente);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(interv.getUaexcodigo());
			documentoHecho.setQ5idinterviniente(interv.getUaidinterv().toString());

			Long numdocumentosAportadosInterviniente = this.documentoHechoDao
					.findAllDocumentosAportadosIntervinienteCount(documentoHecho);

			if (numdocumentosAportadosInterviniente > 0) {
				throw new Y41bUDAException("error.interviniente.DeleteAportacionException", true, new Exception());
			}

			this.arbintervDao.remove(interv);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.interviniente.DataIntegrityViolationException2", true, e);
		}
	}

	/**
	 * CargarIntervinienteConsumidor
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Saninterv
	 */
	private Arbinterv cargarIntervinienteConsumidor(Intervinientes intervinientes, CensoMonitor censoMonitor) {
		Arbinterv arbinterv = new Arbinterv();
		boolean insercion = false;
		String pais;
		Consumidor consumidor = new Consumidor();
		consumidor.setDtcodigo(intervinientes.getIdinterviniente());

		// Alta de interviniente consumidor
		consumidor = this.consumidorDao.find(consumidor);

		try {

			// obtenemos el registro de Solarb

			arbinterv.setUadtcodigo(consumidor.getDtcodigo());
			arbinterv.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			arbinterv.setUaexcodigo(intervinientes.getIdExpediente());
			List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					arbinterv = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			arbinterv = null;
			insercion = true;
		}

		if (arbinterv == null) {
			arbinterv = new Arbinterv();
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		Arbexp arbexp = this.find(new Arbexp(intervinientes.getIdExpediente()));
		solarb.setArbexp(arbexp);

		arbinterv.setSolarb(solarb);
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUanombre(consumidor.getDtnombre());
		arbinterv.setUaapellido1(consumidor.getDtapellido1());
		arbinterv.setUaapellido2(consumidor.getDtapellido2());
		arbinterv.setUacoem(consumidor.getDttecoem());
		arbinterv.setUanif(consumidor.getDtnif());
		arbinterv.setUanrtel(consumidor.getDtnrtel());
		arbinterv.setUanrtel2(consumidor.getDtnrtel2());
		arbinterv.setUaprovId(consumidor.getDtnoraProvinciaId());
		arbinterv.setUamunId(consumidor.getDtnoraMunicipioId());
		arbinterv.setUalocId(consumidor.getDtnoraLocalidadId());
		arbinterv.setUacalleId(consumidor.getDtnoraCalleId());
		// Este campo no se utiliza. Nora y no nora guarda el cp en
		// dtnombrecp
		// arbinterv.setUacpId(consumidor.getDtnoraCpId());
		arbinterv.setUacpId(consumidor.getDtnombreCp());
		arbinterv.setUaportalId(consumidor.getDtnoraPortalId());
		arbinterv.setUanombrePiso(consumidor.getDtnombrePiso());
		arbinterv.setUadireNocapv(consumidor.getDtdireccion_nocapv());
		// En el censo la logica de estos campos esta cambiada.
		arbinterv.setUanodir(consumidor.getDtnombrePiso());
		arbinterv.setUadireAnt(consumidor.getDtnodir());
		arbinterv.setUadtcodigo(consumidor.getDtcodigo());
		pais = (Y41bConstantes.SI.equals(consumidor.getDtextranjero())) ? consumidor.getDtnoraPaisId()
				: Y41bConstantes.COD_PAIS_ESTADO;
		arbinterv.setUapaisId(pais);

		arbinterv.setUafecultmod(consumidor.getDtfemod());
		arbinterv.setUausuultmod(consumidor.getCensoMonitor().getMocodigo());
		arbinterv.setUasexo(consumidor.getDtcosx());
		arbinterv.setUaedad(consumidor.getRangoEdad().getRancod());
		arbinterv.setUaidioma(consumidor.getDtcoidco());
		arbinterv.setUatipoidentificacion(consumidor.getDtintipid());

		if (!insercion) {
			this.arbintervDao.update(arbinterv);

			// tengo que actualizar PLATEA mis gestiones!!!
			if (Y41bUtils.interactuarConDokusi()) {
				if (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea())) {

					this.arbintervService.actualizarParticipantPlatea(solarb, arbinterv, censoMonitor, false);
				}
			}

		} else {
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_CONSUMIDOR);
			this.arbintervDao.add(arbinterv);
		}
		return arbinterv;
	}

	/**
	 * cargarIntervinienteEstablecimiento
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	private Arbinterv cargarIntervinienteEstablecimiento(Intervinientes intervinientes, CensoMonitor censoMonitor) {
		Arbinterv arbinterv = new Arbinterv();
		boolean insercion = false;
		String pais;
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(intervinientes.getIdinterviniente());

		// Alta interviniente establecimiento
		establecimiento = this.establecimientoDao.find(establecimiento);

		establecimiento = this.tratamientoAnyadirIntervinienteSancionado(establecimiento);

		EstablecimSector establecimSector = new EstablecimSector();
		establecimSector.setEstablecimiento(establecimiento);

		EstablecimSector establecSector = new EstablecimSector();
		Actividad actividad = new Actividad();
		Sector sector = new Sector();
		establecSector.setActividad(actividad);
		establecSector.setSector(sector);

		establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

		try {
			arbinterv = new Arbinterv();
			arbinterv.setUaescodigo(intervinientes.getIdinterviniente());
			arbinterv.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					arbinterv = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			arbinterv = null;
			insercion = true;
		}
		if (arbinterv == null) {
			arbinterv = new Arbinterv();
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		solarb = this.solarbDao.find(solarb);
		solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));
		arbinterv.setSolarb(solarb);
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUanombre(establecimiento.getEsnombre());
		arbinterv.setUacoem(establecimiento.getEscoem());
		arbinterv.setUanif(establecimiento.getEsnif());
		arbinterv.setUanrtel(establecimiento.getEsnrtel());
		arbinterv.setUanrtel2(establecimiento.getEsnrtel2());
		arbinterv.setUaprovId(establecimiento.getEsnoraProvinciaId());
		arbinterv.setUamunId(establecimiento.getEsnoraMunicipioId());
		arbinterv.setUalocId(establecimiento.getEsnoraLocalidadId());
		arbinterv.setUacalleId(establecimiento.getEsnoraCalleId());
		arbinterv.setUacpId(establecimiento.getEsnombreCp());
		arbinterv.setUaportalId(establecimiento.getEsnoraPortalId());
		arbinterv.setUanombrePiso(establecimiento.getEsnombrePiso());
		arbinterv.setUadireNocapv(establecimiento.getEsdireccion_nocapv());
		// En el censo la logica de estos campos esta cambiada.
		arbinterv.setUanodir(establecimiento.getEsnombrePiso());
		arbinterv.setUadireAnt(establecimiento.getEsnodir());
		arbinterv.setUaescodigo(intervinientes.getIdinterviniente());
		if (Y41bConstantes.SI.equals(establecimiento.getEsextranjero())) {
			pais = establecimiento.getEsnoraPaisId();
		} else {
			pais = Y41bConstantes.COD_PAIS_ESTADO;
		}
		arbinterv.setUapaisId(pais);

		arbinterv.setUanopeco(establecimiento.getEsnopeco());
		arbinterv.setUaurl(establecimiento.getEsteurl());
		arbinterv.setUanoco(establecimiento.getEsnoco());
		arbinterv.setUasecodigo(establecSector.getSector().getSecodigo());
		arbinterv.setUasenombre(establecSector.getSector().getSenombre());
		arbinterv.setUasenombree(establecSector.getSector().getSenombree());

		arbinterv.setUafecultmod(establecimiento.getEsfemod());
		arbinterv.setUausuultmod(establecimiento.getCensoMonitor().getMocodigo());
		arbinterv.setUaidioma(establecimiento.getEscoidco());
		if (insercion) {
			Arbinterv arbinterv2 = new Arbinterv();
			arbinterv2.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			arbinterv2.setUaexcodigo(solarb.getSacodigo());
			arbinterv2.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			boolean existeReclamado = (this.arbintervDao.findAll(arbinterv2, null).size() > 0);
			if (existeReclamado) {
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO);
				this.arbintervDao.add(arbinterv);
			} else {
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbintervDao.add(arbinterv);
				// por mantener coherencia con histricos hay que insertar en la
				// tabla
				// ESSA - DTSA
				Essa essa = new Essa();
				essa.setSolarb(solarb);
				this.essaDao.remove(essa);
				essa.setEstablecimiento(establecimiento);
				this.essaDao.add(essa);
			}

		} else {
			this.arbintervDao.update(arbinterv);
			// tengo que actualizar PLATEA mis gestiones!!!
			if (Y41bUtils.interactuarConDokusi() && solarb != null && solarb.getArbexp() != null) {
				if (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea())) {

					this.arbintervService.actualizarParticipantPlatea(solarb, arbinterv, censoMonitor, false);
				}
			}
		}
		return arbinterv;
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            the tipodocumento
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		// No es necesario porque en el guardado previo no se vaca la temporal
		// this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
		// this.arbdoctempDao.addArbAdjuntarDocs(tramiteComun);

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
		String plantilla = "";
		String nombreDocumento = "";
		boolean tratamientoPlantillaNormal = false;

		adjuntardocs.setThcodocumento(this.arbdoctempDao.getNewPK().toString());

		/*
		 * EL COMPORTAMIENTO ES DIFERENTE PARA RESOLUCION, RSTO DE TRAMITES
		 * IGUAL
		 */
		if (tramiteComun.getIdTipoTramite() == null) {
			// tramites de BM
			tratamientoPlantillaNormal = true;
		} else if (tramiteComun.getIdTipoTramite().equals(Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION)) {
			tratamientoPlantillaNormal = false;
		} else {
			tratamientoPlantillaNormal = true;
		}

		if (tratamientoPlantillaNormal) {
			plantilla = this.findPlantilla(plantillaTramite, tramiteComun);
			plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
			nombreDocumento = new StringBuffer(plantillaTramite.getPtnombre()).append(".rtf").toString();
		} else {
			/* PLANTILLA DECISION PARA RESOLUCION */
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(adjuntardocs.getPtcodigo());
			plantillaDecision = this.plantillaDecisionDao.find(plantillaDecision);
			plantilla = this.findPlantillaDecision(plantillaDecision, tramiteComun);
			nombreDocumento = new StringBuffer(plantillaDecision.getPdnombre()).append(".rtf").toString();
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);
		String codigoExpediente = solarb.damecodCompletoPlatea();
		nombreDocumento = codigoExpediente.concat("-").concat(nombreDocumento);

		adjuntardocs.setThcodocumento(this.arbdoctempDao.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");
		adjuntardocs.setThnofile(nombreDocumento);
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		adjuntardocs.setThfecha(new Date());
		adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

		if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
			adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
			adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);

			// 155021
			if (Y41bConstantes.PORTAFIRMAS_ARBITROS_HABILITADO) {
				if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equalsIgnoreCase(tramiteComun.getIdTipoTramite())) {

					if (Y41bConstantes.PERFIL_FIRMA_ARBITRO.equals(adjuntardocs.getPerfil().getIdPerfil())) {
						DocumentosFirmaArbitrosTemp documento = new DocumentosFirmaArbitrosTemp();
						documento.setIddocumentosfirmaarbtemp(adjuntardocs.getThcodocumento());
						this.documentosFirmaArbitrosTempService.add(documento);

						adjuntardocs.setPerfil(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));

					}
				}
			}
			// 155021
		}
		// 155021 comentamos esto para que no haga nada con el portafirmas
		// deshabilitado
		if (Y41bConstantes.PORTAFIRMAS_ARBITROS_HABILITADO) {
			if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equalsIgnoreCase(tramiteComun.getIdTipoTramite())) {

				// vamos a insertar en la tabla temporal de
				// documentosFirmaArbitros todods los documentos que esten en la
				// bandejaFirmaArbitros union tmporal con arbdoctemp y que no
				// esten documentosFirmaArbitros
				List<DocumentosFirmaArbitrosTemp> docusAInsertar = this.documentosFirmaArbitrosTempService
						.insertarTemporales(tramiteComun.getIdTramite());

				for (DocumentosFirmaArbitrosTemp insertoDoc : docusAInsertar) {
					this.documentosFirmaArbitrosTempService.add(insertoDoc);
				}
			}
		}
		// 155021 comentamos esto para que no haga nada con el portafirmas
		// deshabilitad
		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public String findPlantilla(PlantillaTramite plantillaTramite, TramiteComun tramiteComun) throws Exception {

		// Obtener la plantilla del tramite
		PlantillaTramite plantillaTramite2 = this.plantillaTramiteDao.find(plantillaTramite);

		// Obtener los datos de la sancion
		PlantillaTramiteARBDetalle plantillaTramiteARBDetalle = new PlantillaTramiteARBDetalle();
		plantillaTramiteARBDetalle.setSacodigo(tramiteComun.getIdExpediente());

		// Obtener los datos del tramite
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp = this.arbtramexpDao.find(arbtramexp);
		if (arbtramexp != null) {
			plantillaTramiteARBDetalle.setArbtramexp(arbtramexp);
		}

		String ficheroGenerado = "";
		if (plantillaTramite2.getPtplantilla() != null) {
			plantillaTramiteARBDetalle = this.completeInfoplantillaTramiteARBDetalle(plantillaTramiteARBDetalle);

			// Transformar el documento en castellano
			String plantilla = Y41bUtils.blobToString(plantillaTramite2.getPtplantilla());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

			rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_ARB_CASTELLANO);

			ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
					plantillaTramiteARBDetalle, plantilla);
		}

		return ficheroGenerado;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaDecision
	 *            the plantilla decision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public String findPlantillaDecision(PlantillaDecision plantillaDecision, TramiteComun tramiteComun)
			throws Exception {
		String ficheroGenerado = "";
		// Obtener la plantilla del tramite
		PlantillaDecision plantillaDecision2 = this.plantillaDecisionDao.find(plantillaDecision);

		// Obtener los datos de la sancion
		if (plantillaDecision2.getPdplantilla() != null) {
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle = new PlantillaTramiteARBDetalle();
			plantillaTramiteARBDetalle.setSacodigo(tramiteComun.getIdExpediente());

			// Obtener los datos del tramite
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramiteComun.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
			if (arbtramexp != null) {
				plantillaTramiteARBDetalle.setArbtramexp(arbtramexp);
			}

			if (plantillaDecision2.getPdplantilla() != null) {
				plantillaTramiteARBDetalle = this.completeInfoplantillaTramiteARBDetalle(plantillaTramiteARBDetalle);

				// Transformar el documento en castellano
				String plantilla = Y41bUtils.blobToString(plantillaDecision2.getPdplantilla());

				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

				StringBuffer rutaPlantilla = (new StringBuffer(
						prop.getProperty("y41bVistaWar.rutaxml.plantillas.word")))
								.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_ARB_CASTELLANO);

				ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
						plantillaTramiteARBDetalle, plantilla);
			}
		}
		return ficheroGenerado;
	}

	/**
	 * Complete information of the object plantillaTramiteARBDetalle.
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @return PlantillaTramiteARBDetalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private PlantillaTramiteARBDetalle completeInfoplantillaTramiteARBDetalle(
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) throws ParseException {

		try {
			// Expediente
			Solarb solarb = new Solarb();
			solarb.setSacodigo(plantillaTramiteARBDetalle.getExcodigo());
			solarb = this.solarbDao.find(solarb);
			plantillaTramiteARBDetalle.setSacoja(solarb.getSacoja());
			plantillaTramiteARBDetalle.setSanror(solarb.getSanror());
			plantillaTramiteARBDetalle.setSanran(solarb.getSanran());
			StringBuffer numeroExpediente = new StringBuffer();
			numeroExpediente.append(solarb.getSacoja()).append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP)
					.append(solarb.getSanror()).append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP)
					.append(solarb.getSanran());
			// Incidencia 74262 - Con Caracter general todos los impresos deben
			// incluir el cdigo de procedimiento en el cdigo de expediente
			plantillaTramiteARBDetalle.setNumExpediente(Y41bConstantes.TIPO_PROC_ARBITRAJE
					+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + numeroExpediente.toString());
			plantillaTramiteARBDetalle.setNumExpedienteCompleto(Y41bConstantes.TIPO_PROC_ARBITRAJE
					+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + numeroExpediente.toString());

			// Fecha solicitud
			plantillaTramiteARBDetalle.setFechaSolicitudCas(Y41bUtils.formatearDateToString(solarb.getSafesoli(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaSolicitudEus(Y41bUtils.formatearDateToStringEuskera(solarb.getSafesoli(),
					Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			// Hecho
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(plantillaTramiteARBDetalle.getExcodigo());
			arbexp = this.arbexpDao.find(arbexp);
			solarb.setArbexp(arbexp);

			Arbexp arbexpAux = this.arbexpDao.findLobTablaTemporal(arbexp);
			if (arbexpAux != null) {
				plantillaTramiteARBDetalle.setHdte(arbexpAux.getHdte());
			}

			// Fecha
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				plantillaTramiteARBDetalle.setFechaTexto(Y41bUtils.formatearDateToStringEuskera(new Date(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			} else {
				plantillaTramiteARBDetalle.setFechaTexto(Y41bUtils.formatearDateToString(new Date(),
						Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			}
			plantillaTramiteARBDetalle.setFechaTextoCas(Y41bUtils.formatearDateToString(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaTextoEus(Y41bUtils.formatearDateToStringEuskera(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			plantillaTramiteARBDetalle.setFecha(Y41bUtils.parseDateToString(new Date(), idioma));
			plantillaTramiteARBDetalle.setFechaCas(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaEus(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.EUSKERA));

			// Pie y organismo
			this.rellenaJuntaArbitralConsumoEuskadi(solarb, plantillaTramiteARBDetalle);

			// 0154940: Actualizacin de datos explcitos en plantillas a uso de
			// campos
			// combinados
			this.arbexp2Service.rellenaCentralPieOficina(solarb, plantillaTramiteARBDetalle);
			// 0154940

			// Instructor
			CensoMonitor censoMonitor = new CensoMonitor();
			if (!Y41bUtils.esNullOCadenaVacia(arbexp.getExmocodigo())) {
				censoMonitor.setMocodigo(arbexp.getExmocodigo());
				censoMonitor = this.censoMonitorDao.find(censoMonitor);
				plantillaTramiteARBDetalle.setInstructor(censoMonitor.getMonombre());

			}

			plantillaTramiteARBDetalle.setTextoPuestoInstructorCas(this.appMessageSource
					.getMessage("plantilla.puestorespexp", null, new Locale(Y41bConstantes.CASTELLANO)));
			plantillaTramiteARBDetalle.setTextoPuestoInstructorEus(this.appMessageSource
					.getMessage("plantilla.puestorespexp", null, new Locale(Y41bConstantes.EUSKERA)));

			// Ejecutor, censoMonitor que crea el tramite todav�a sin tramitar
			CensoMonitor censoMonitorEj = new CensoMonitor();
			censoMonitorEj.setMocodigo(plantillaTramiteARBDetalle.getArbtramexp().getCensoMonitor().getMocodigo());
			censoMonitorEj = this.censoMonitorDao.find(censoMonitorEj);
			plantillaTramiteARBDetalle.setEjecutor(censoMonitorEj.getMonombre());

			// Director
			this.rellenaDirector(solarb, plantillaTramiteARBDetalle);

			// Coordinador (Secretario Junta Arbitral)
			this.rellenaCoordinador(solarb, plantillaTramiteARBDetalle);

			// SI NOTIFICO A SEDE
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrsede() != null) {
				if (plantillaTramiteARBDetalle.getArbtramexp().getTrsede().equals(Y41bConstantes.SI)) {
					this.rellenaSedeReclamado(solarb, plantillaTramiteARBDetalle);
				} else {
					this.rellenaReclamado(solarb, plantillaTramiteARBDetalle);
				}
			} else {
				this.rellenaReclamado(solarb, plantillaTramiteARBDetalle);
			}
			// Destinatario
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrsede() != null) {
				if (plantillaTramiteARBDetalle.getArbtramexp().getTrsede().equals(Y41bConstantes.SI)) {
					this.rellenaSedeDestinatario(solarb, plantillaTramiteARBDetalle);
				} else {
					this.rellenaDestinatario(solarb, plantillaTramiteARBDetalle);
				}
			} else {
				this.rellenaDestinatario(solarb, plantillaTramiteARBDetalle);
			}

			// Tipo arbitraje
			// datos del tipo de arbitraje
			if (solarb.getSaintiso() != null) {

				if ("E".equals(solarb.getSaintiso())) {
					plantillaTramiteARBDetalle.setEquidadDerechoCas(this.appMessageSource
							.getMessage("plantilla.adhesion.equidad", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteARBDetalle.setEquidadDerechoEus(this.appMessageSource
							.getMessage("plantilla.adhesion.equidad", null, new Locale(Y41bConstantes.EUSKERA)));
				} else if ("D".equals(solarb.getSaintiso())) {
					plantillaTramiteARBDetalle.setEquidadDerechoCas(this.appMessageSource
							.getMessage("plantilla.adhesion.derecho", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteARBDetalle.setEquidadDerechoEus(this.appMessageSource
							.getMessage("plantilla.adhesion.derecho", null, new Locale(Y41bConstantes.EUSKERA)));
				} else {
					plantillaTramiteARBDetalle.setEquidadDerechoCas("");
					plantillaTramiteARBDetalle.setEquidadDerechoEus("");
				}
			}

			// Organismo que presenta la solicitud
			this.rellenaOrganismoSolicitud(solarb, plantillaTramiteARBDetalle);
			// Reclamante
			this.rellenaReclamante(solarb, plantillaTramiteARBDetalle);

			// *** esto hay que revisar - todas las etiquetas no se resuelven
			// siempre.**/
			// notificacion
			this.rellenaNotificacion(solarb, plantillaTramiteARBDetalle);
			// comunicacion
			this.rellenaComunicacion(solarb, plantillaTramiteARBDetalle);

			// Subsanacion
			this.rellenaSubsanacion(solarb, plantillaTramiteARBDetalle);
			// Designacion colegio
			this.rellenaColegioDesignado(solarb, plantillaTramiteARBDetalle);
			// Citacin 1a audiencia
			this.rellenaCitacionAudiencia(solarb, plantillaTramiteARBDetalle);
			// Suspension
			this.rellenaSuspensionAudiencia(solarb, plantillaTramiteARBDetalle);
			// Citacin prueba
			this.rellenaCitacionAPrueba(solarb, plantillaTramiteARBDetalle);
			// Pago pericial
			this.rellenaPagoPericial(solarb, plantillaTramiteARBDetalle);
			// Rersolucion
			this.rellenaResolucion(solarb, plantillaTramiteARBDetalle);
			// Laudo
			this.rellenaLaudo(solarb, plantillaTramiteARBDetalle);
			// Pago Laudo
			this.rellenaPagoLaudo(solarb, plantillaTramiteARBDetalle);
			// aclaracion
			this.rellenaAclaracion(solarb, plantillaTramiteARBDetalle);
			// acreditacion representacion
			this.arbexp2Service.rellenaRequerimientoAcreditacionRepresentacion(solarb, plantillaTramiteARBDetalle);

			// bopv
			this.rellenaElaboracionBOPV(solarb, plantillaTramiteARBDetalle);
			// mediacion
			this.rellenaMediacion(solarb, plantillaTramiteARBDetalle);

			return plantillaTramiteARBDetalle;
		} catch (ParseException e) {
			throw new Y41bUDAException("error.solicitud.alta.tramite", true, e);
		} catch (Y41bUDAException e) {
			throw e;
		}
	}

	/**
	 * rellenaOrganismoSolicitud
	 * 
	 * @param solarb
	 *            Solarb
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 */
	private void rellenaOrganismoSolicitud(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		// Rellenamos el pie dependiendo de la oficiona de la provincia
		// correspondiente
		if (!Y41bUtils.esNullOCadenaVacia(solarb.getArbexp().getExcoorg())) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(solarb.getArbexp().getExcoorg());
			organismo = this.organismoDao.find(organismo);
			if (organismo != null && organismo.getEntidadId() != null) {
				plantillaTramiteARBDetalle.setNombreOrgSolicitudEs(organismo.getNombreEs());
				plantillaTramiteARBDetalle.setNombreOrgSolicitudEu(organismo.getNombreEu());
				plantillaTramiteARBDetalle.setProvOrgSolicitud(
						organismo.getNombreProvincia() != null ? organismo.getNombreProvincia() : "");
				plantillaTramiteARBDetalle.setMunOrgSolicitud(
						organismo.getNombreMunicipio() != null ? organismo.getNombreMunicipio() : "");
				plantillaTramiteARBDetalle.setLocOrgSolicitud(
						organismo.getNombreLocalidad() != null ? organismo.getNombreLocalidad() : "");
				plantillaTramiteARBDetalle
						.setDirOrgSolicitud(organismo.getNombreCalle() != null ? organismo.getNombreCalle()
								: "" + " " + organismo.getNombrePortal() != null ? organismo.getNombrePortal() : "");
				plantillaTramiteARBDetalle
						.setCpOrgSolicitud(organismo.getNombreCp() != null ? organismo.getNombreCp() : "");
			}
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaJuntaArbitralConsumoEuskadi(Solarb solarb,
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		// Rellenamos el pie dependiendo de la oficiona de la provincia
		// correspondiente
		Organismo organismo = new Organismo();
		organismo.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		List<Organismo> listaoficinaProvincia = this.organismoDao.findAll(organismo, null);
		if (listaoficinaProvincia != null) {
			organismo = listaoficinaProvincia.get(0);
			if (organismo != null && organismo.getEntidadId() != null) {
				plantillaTramiteARBDetalle.setDireccionOficina(organismo.getAdressCallePortal());
				plantillaTramiteARBDetalle.setCpOficina(organismo.getAdressCP());
				plantillaTramiteARBDetalle.setTelefonoOficina(organismo.getTelefono());
				plantillaTramiteARBDetalle.setFaxOficina(organismo.getFax());
				/* cogemos solo el municipio */
				plantillaTramiteARBDetalle.setLocalidadOficina(organismo.getNombreMunicipio());

				plantillaTramiteARBDetalle.setNombreOficina(organismo.getNombreEs());
				plantillaTramiteARBDetalle.setNombreOficinaEus(organismo.getNombreEu());
				plantillaTramiteARBDetalle.setLugarOficina(organismo.getNombreLocalidad());
				plantillaTramiteARBDetalle.setMunOrgSolicitud(organismo.getNombreMunicipio());
				plantillaTramiteARBDetalle
						.setDireccionOficina(organismo.getNombreCalle() + " " + organismo.getNombrePortal());
				plantillaTramiteARBDetalle.setCpOficina(organismo.getNombreCp());
				plantillaTramiteARBDetalle.setProvinciaOficina(organismo.getNombreProvincia());
				plantillaTramiteARBDetalle.setTelefonoOficina(organismo.getTelefono());
				plantillaTramiteARBDetalle.setFaxOficina(organismo.getFax());

				// Creamos el campo pie pagina linea1
				StringBuffer piepagina_linea1 = new StringBuffer();

				piepagina_linea1.append(plantillaTramiteARBDetalle.getDireccionOficina()).append(" - ")
						.append(plantillaTramiteARBDetalle.getCpOficina()).append(" / ").append(" Tl. ")
						.append(plantillaTramiteARBDetalle.getTelefonoOficina());

				plantillaTramiteARBDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

				// Creamos el campo pie pagina linea2
				StringBuffer piepagina_linea2 = new StringBuffer();

				piepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
						.append(organismo.getUrl());

				plantillaTramiteARBDetalle.setPiePaginaLinea2(piepagina_linea2.toString());
			}
		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaCoordinador(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		// Coordinador
		CensoMonitor coordinador = this.censoMonitorDao.findCoordinadorArbitraje();
		if (coordinador == null || (coordinador != null && coordinador.getMonombre() == null)) {
			throw new Y41bUDAException("error.tramite.nocoordinador", true, new Exception());
		} else {
			plantillaTramiteARBDetalle
					.setCoordinador((coordinador.getMonombre() == null) ? "" : coordinador.getMonombre());
		}

		// recuperar texto de properties
		plantillaTramiteARBDetalle.setTextoPuestoCoordinadorCas(this.appMessageSource
				.getMessage("plantilla.puestosecretarioJJAA", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteARBDetalle.setTextoPuestoCoordinadorEus(this.appMessageSource
				.getMessage("plantilla.puestosecretarioJJAA", null, new Locale(Y41bConstantes.EUSKERA)));
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaDirector(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		// Director
		CensoMonitor director = this.censoMonitorDao.findDirectorArbitraje();
		if (director == null || (director != null && director.getMonombre() == null)) {
			throw new Y41bUDAException("error.tramite.nodirector", true, new Exception());
		} else {
			plantillaTramiteARBDetalle.setDirector((director.getMonombre() == null) ? "" : director.getMonombre());
		}

		// recuperar texto de properties
		plantillaTramiteARBDetalle.setTextoPuestoDirectorCas(this.appMessageSource
				.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteARBDetalle.setTextoPuestoDirectorEus(
				this.appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaReclamado(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		// Reclamado
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(solarb);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		if (larbinterv != null && larbinterv.size() > 0) {
			arbinterv = larbinterv.get(0);
			plantillaTramiteARBDetalle.setCifReclamado(arbinterv.getUanif());

			plantillaTramiteARBDetalle.setNombreReclamado(arbinterv.getUanombre());

			plantillaTramiteARBDetalle.setDirReclamado(this.arbintervService.dameLineaDireccion(arbinterv));
			if (arbinterv.getUacpId() != null) {
				plantillaTramiteARBDetalle.setCpReclamado(arbinterv.getUacpId());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteARBDetalle.setCpReclamado(this.arbintervService.dameCodigoPostal(arbinterv));
			}

			plantillaTramiteARBDetalle.setProvReclamado(this.arbintervService.dameProvincia(arbinterv));
			plantillaTramiteARBDetalle.setMunReclamado(this.arbintervService.dameMunicipio(arbinterv));
			plantillaTramiteARBDetalle.setLocReclamado(this.arbintervService.dameLocalidad(arbinterv));

		}
		Establecimiento establecimiento = new Establecimiento(arbinterv.getUaescodigo());
		establecimiento = this.establecimientoDao.find(establecimiento);

		plantillaTramiteARBDetalle.setNombreRepresentante(establecimiento.getEsnorep());
		plantillaTramiteARBDetalle.setCifRepresentante(establecimiento.getEsnifrep());

		// Texto para el representante del establecimiento en las plantillas de
		// acta de laudo
		StringBuffer txtRepCas = new StringBuffer(Y41bConstantes.NUM_40);
		if (establecimiento.getEsnorep() != null && establecimiento.getEsnorep().toString() != "") {
			txtRepCas.append("Representante legal: ").append(establecimiento.getEsnorep().toString())
					.append("{\\\\line}");
		}
		if (establecimiento.getEsnifrep() != null && establecimiento.getEsnifrep().toString() != "") {
			txtRepCas.append("NIF/CIF/NIE: ").append(establecimiento.getEsnifrep().toString()).append("{\\\\line}");
		}
		plantillaTramiteARBDetalle.setTextoRepresentanteCas(txtRepCas.toString());

		StringBuffer txtRepEus = new StringBuffer(Y41bConstantes.NUM_40);
		if (establecimiento.getEsnorep() != null && establecimiento.getEsnorep().toString() != "") {
			txtRepEus.append("Ordezkari legala: ");
			txtRepEus.append(establecimiento.getEsnorep().toString());
			txtRepEus.append("{\\\\line}");
		}
		if (establecimiento.getEsnifrep() != null && establecimiento.getEsnifrep().toString() != "") {
			txtRepEus.append("IFZ/IFK/AIZ: ");
			txtRepEus.append(establecimiento.getEsnifrep().toString());
			txtRepEus.append("{\\\\line}");
		}
		plantillaTramiteARBDetalle.setTextoRepresentanteEus(txtRepEus.toString());

		if (!Y41bUtils.esNullOCadenaVacia(establecimiento.getEscooe())) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(establecimiento.getEscooe());
			organismo = this.organismoDao.find(organismo);
			plantillaTramiteARBDetalle.setOoeeReclamado(organismo.getNombreEu() == null ? ""
					: organismo.getNombreEu().concat(" / ")
							.concat(organismo.getNombreEs() == null ? "" : organismo.getNombreEs()));
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaReclamante(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		// Reclamado
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(solarb);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		if (larbinterv != null && larbinterv.size() > 0) {
			arbinterv = larbinterv.get(0);
			plantillaTramiteARBDetalle.setCifReclamante(arbinterv.getUanif());

			StringBuffer nombre = new StringBuffer("");
			nombre.append(arbinterv.getUanombre() == null ? "" : arbinterv.getUanombre()).append(" ")
					.append(arbinterv.getUaapellido1() == null ? "" : arbinterv.getUaapellido1()).append(" ")
					.append(arbinterv.getUaapellido2() == null ? "" : arbinterv.getUaapellido2());
			plantillaTramiteARBDetalle.setNombreReclamante(nombre.toString().trim());

			plantillaTramiteARBDetalle.setDirReclamante(this.arbintervService.dameLineaDireccion(arbinterv));
			if (arbinterv.getUacpId() != null) {
				plantillaTramiteARBDetalle.setCpReclamante(arbinterv.getUacpId());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteARBDetalle.setCpReclamante(this.arbintervService.dameCodigoPostal(arbinterv));
			}

			plantillaTramiteARBDetalle.setProvReclamante(this.arbintervService.dameProvincia(arbinterv));
			plantillaTramiteARBDetalle.setMunReclamante(this.arbintervService.dameMunicipio(arbinterv));
			plantillaTramiteARBDetalle.setLocReclamante(this.arbintervService.dameLocalidad(arbinterv));

		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the Solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaSedeReclamado(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		// Reclamado
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(solarb);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

		Establecimiento establecimientoAux = new Establecimiento();
		Establecimiento establecimientoSede = new Establecimiento();

		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		if (larbinterv != null && larbinterv.size() > 0) {
			arbinterv = larbinterv.get(0);

			establecimientoAux.setEsnif(arbinterv.getUanif());
			establecimientoSede = this.establecimientoService.obtenerEstablecimientoSede(establecimientoAux);

			Sede sedeAux = new Sede();
			sedeAux.setEscodigo(establecimientoSede.getEscodigo());
			sedeAux.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			Sede sede = this.establecimientoService.findEstablecimientoSede(sedeAux);

			plantillaTramiteARBDetalle.setCifReclamado(arbinterv.getUanif());

			plantillaTramiteARBDetalle.setNombreReclamado(arbinterv.getUanombre());

			plantillaTramiteARBDetalle.setDirReclamado(this.sedeService.dameLineaDireccion(sede));

			if (sede.getNombreCp() != null) {
				plantillaTramiteARBDetalle.setCpReclamado(sede.getNombreCp());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteARBDetalle.setCpReclamado(this.sedeService.dameCodigoPostal(sede));
			}

			plantillaTramiteARBDetalle.setProvReclamado(this.sedeService.dameProvincia(sede));
			plantillaTramiteARBDetalle.setMunReclamado(this.sedeService.dameMunicipio(sede));
			plantillaTramiteARBDetalle.setLocReclamado(this.sedeService.dameLocalidad(sede));
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaSedeDestinatario(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		// Reclamado
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(solarb);
		arbinterv.setUaidinterv(plantillaTramiteARBDetalle.getArbtramexp().getTruaidinterv());
		arbinterv = this.arbintervDao.find(arbinterv);

		Establecimiento establecimientoAux = new Establecimiento();
		Establecimiento establecimientoSede = new Establecimiento();

		establecimientoAux.setEsnif(arbinterv.getUanif());
		establecimientoSede = this.establecimientoService.obtenerEstablecimientoSede(establecimientoAux);
		if (establecimientoSede != null) {
			Sede sedeAux = new Sede();
			sedeAux.setEscodigo(establecimientoSede.getEscodigo());
			sedeAux.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			Sede sede = this.establecimientoService.findEstablecimientoSede(sedeAux);

			plantillaTramiteARBDetalle.setCifDestinatario(arbinterv.getUanif());

			plantillaTramiteARBDetalle.setNombreDestinatario(arbinterv.getUanombre());

			plantillaTramiteARBDetalle.setDirDestinatario(this.sedeService.dameLineaDireccion(sede));

			if (sede.getNombreCp() != null) {
				plantillaTramiteARBDetalle.setCpDestinatario(sede.getNombreCp());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteARBDetalle.setCpDestinatario(this.sedeService.dameCodigoPostal(sede));
			}

			plantillaTramiteARBDetalle.setProvDestinatario(this.sedeService.dameProvincia(sede));
			plantillaTramiteARBDetalle.setMunDestinatario(this.sedeService.dameMunicipio(sede));
			plantillaTramiteARBDetalle.setLocDestinatario(this.sedeService.dameLocalidad(sede));

		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaDestinatario(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		Arbinterv destinatario = null;
		if (plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()
				.equals(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE)) {
			// Cogemos el destinatario del tramite
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(plantillaTramiteARBDetalle.getArbtramexp().getTrainstcopia());
			destinatario = this.arbintervDao.find(arbinterv);
		} else {

			// Cogemos el destinatario del tramite
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(plantillaTramiteARBDetalle.getArbtramexp().getTruaidinterv());
			destinatario = this.arbintervDao.find(arbinterv);
		}

		if (destinatario != null) {
			plantillaTramiteARBDetalle.setCifDestinatario(destinatario.getUanif());

			if (destinatario.getUacpId() != null) {
				plantillaTramiteARBDetalle.setCpDestinatario(destinatario.getUacpId());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteARBDetalle.setCpDestinatario(this.arbintervService.dameCodigoPostal(destinatario));
			}

			plantillaTramiteARBDetalle.setNombreDestinatario((destinatario.getUanombre() == null ? ""
					: destinatario.getUanombre().concat(" ")
							.concat(destinatario.getUaapellido1() == null ? "" : destinatario.getUaapellido1())
							.concat(" ")
							.concat(destinatario.getUaapellido2() == null ? "" : destinatario.getUaapellido2()))
									.trim());

			plantillaTramiteARBDetalle.setDirDestinatario(this.arbintervService.dameLineaDireccion(destinatario));
			plantillaTramiteARBDetalle.setCpDestinatario(destinatario.getUacpId());

			plantillaTramiteARBDetalle.setProvDestinatario(this.arbintervService.dameProvincia(destinatario));
			plantillaTramiteARBDetalle.setMunDestinatario(this.arbintervService.dameMunicipio(destinatario));
			plantillaTramiteARBDetalle.setLocDestinatario(this.arbintervService.dameLocalidad(destinatario));
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaSubsanacion(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		StringBuffer textoes = new StringBuffer();
		StringBuffer textoeu = new StringBuffer();
		Locale localeES = new Locale(Y41bConstantes.CASTELLANO);
		Locale localeEU = new Locale(Y41bConstantes.EUSKERA);
		if ((plantillaTramiteARBDetalle.getArbtramexp() != null) && (plantillaTramiteARBDetalle.getArbtramexp()
				.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION))) {
			Tipsubsana tipsubsana = new Tipsubsana();
			tipsubsana.setTipsubsanaByTrid(plantillaTramiteARBDetalle.getArbtramexp().getTrid());
			Pagination pagination = new Pagination();
			pagination.setSort("TSORDEN");
			pagination.setSord("ASC");

			List<Tipsubsana> ltipsubsana = this.tipsubsanaDao.findAllPorTramite(tipsubsana, pagination);
			textoes.append("{\\\\qj");
			textoeu.append("{\\\\qj");
			boolean pintarInfoAdicional = true;
			if (ltipsubsana != null) {
				for (int i = 0; i < ltipsubsana.size(); i++) {
					if (ltipsubsana.get(i).getTsgrupo() == null) {
						textoes.append("{\\\\line} -").append(ltipsubsana.get(i).getTstextoes()).append("\\\\par ");
						textoeu.append("{\\\\line} -").append(ltipsubsana.get(i).getTstextoeu()).append("\\\\par ");
					} else {
						if (ltipsubsana.get(i).getTsgrupo().intValue() == 0) {
							String textoAsustituires = ltipsubsana.get(i).getTstextoes();
							String textoAsustituireu = ltipsubsana.get(i).getTstextoeu();
							if (!Y41bUtils.esNullOCadenaVacia(plantillaTramiteARBDetalle.getNombreReclamado())) {
								textoAsustituires = textoAsustituires.replaceFirst("\\.{2}+",
										plantillaTramiteARBDetalle.getNombreReclamado());
								textoAsustituireu = textoAsustituireu.replaceFirst("\\.{2}+",
										plantillaTramiteARBDetalle.getNombreReclamado());
							}
							/*
							 * if (!Y41bUtils
							 * .esNullOCadenaVacia(plantillaTramiteARBDetalle
							 * .getNombreRepReclamante())) { textoAsustituires =
							 * textoAsustituires.replaceFirst( "\\.{2}+",
							 * plantillaTramiteARBDetalle
							 * .getNombreRepReclamante()); textoAsustituireu =
							 * textoAsustituireu.replaceFirst( "\\.{2}+",
							 * plantillaTramiteARBDetalle
							 * .getNombreRepReclamante()); } if (!Y41bUtils
							 * .esNullOCadenaVacia(plantillaTramiteARBDetalle
							 * .getCifRepReclamante())) { textoAsustituires =
							 * textoAsustituires.replaceFirst( "\\.{2}+",
							 * plantillaTramiteARBDetalle
							 * .getCifRepReclamante()); textoAsustituireu =
							 * textoAsustituireu.replaceFirst( "\\.{2}+",
							 * plantillaTramiteARBDetalle
							 * .getCifRepReclamante()); }
							 */
							textoes.append("\\\\par ").append(textoAsustituires).append("\\\\par ");

							textoeu.append("\\\\par ").append(textoAsustituireu).append("\\\\par ");
						} else {
							if (pintarInfoAdicional) {
								textoes.append("{\\\\line} -").append(this.appMessageSource
										.getMessage("plantilla.aportarDocAdicional", null, localeES))
										.append("\\\\par ");
								textoeu.append("{\\\\line} -").append(this.appMessageSource
										.getMessage("plantilla.aportarDocAdicional", null, localeEU))
										.append("\\\\par ");
								pintarInfoAdicional = false;
							}
							textoes.append("{\\\\line\\\\tab\\\\bullet} ").append(ltipsubsana.get(i).getTstextoes())
									.append("\\\\par ");
							textoeu.append("{\\\\line\\\\tab\\\\bullet} ").append(ltipsubsana.get(i).getTstextoeu())
									.append("\\\\par ");
						}
					}
				}
			}
			textoes.append("}");
			textoeu.append("}");
			plantillaTramiteARBDetalle.setElementoASubsanarCas(textoes.toString());
			plantillaTramiteARBDetalle.setElementoASubsanarEus(textoeu.toString());
		}

	}

	/**
	 * Rellena AACCOOEE segun tipo arbitro.
	 * 
	 * @param arb
	 *            the Arbitro
	 * @param texto
	 *            the StringBuffer texto
	 * @param textoCas
	 *            the StringBuffer textoCas
	 * @param textoEus
	 *            the StringBuffer textoEus
	 */
	private void rellenaAACCOOEE(Arbitro arb, StringBuffer texto, StringBuffer textoCas, StringBuffer textoEus) {
		if (arb != null) {
			if (arb.getCcars() != null) {
				for (int i = 0; i < arb.getCcars().size(); i++) {
					Aacc aacc = arb.getCcars().get(i).getAacc();
					texto.append("{\\\\line\\\\tab\\\\bullet} ");
					texto.append(aacc.getCccodigo());
					if (textoCas != null) {
						textoCas.append("{\\\\line\\\\tab\\\\bullet} ");
						textoCas.append(aacc.getCccodigo());
					}
					if (textoEus != null) {
						textoEus.append("{\\\\line\\\\tab\\\\bullet} ");
						textoEus.append(aacc.getCccodigo());
					}
					if (aacc.getOrganismo() != null) {
						texto.append("-").append(aacc.getOrganismo().getNombreEs());
						if (textoCas != null) {
							textoCas.append("-").append(aacc.getOrganismo().getNombreEs());
						}
						if (textoEus != null) {
							textoEus.append("-").append(aacc.getOrganismo().getNombreEu());
						}
					}
				}
			}
			if (arb.getOears() != null) {
				for (int i = 0; i < arb.getOears().size(); i++) {
					Ooee ooee = arb.getOears().get(i).getOoee();
					texto.append("{\\\\line\\\\tab\\\\bullet} ");
					texto.append(ooee.getOecodigo());
					if (textoCas != null) {
						textoCas.append("{\\\\line\\\\tab\\\\bullet} ");
						textoCas.append(ooee.getOecodigo());
					}
					if (textoEus != null) {
						textoEus.append("{\\\\line\\\\tab\\\\bullet} ");
						textoEus.append(ooee.getOecodigo());
					}
					if (ooee.getOrganismo() != null) {
						texto.append("-").append(ooee.getOrganismo().getNombreEs());
						if (textoCas != null) {
							textoCas.append("-").append(ooee.getOrganismo().getNombreEs());
						}
						if (textoEus != null) {
							textoEus.append("-").append(ooee.getOrganismo().getNombreEs());
						}
					}
				}
			}
		}
	}

	/**
	 * rellenaColegioDesignado
	 * 
	 * @param solarb
	 *            Solarb
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaColegioDesignado(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {
		StringBuffer texto = new StringBuffer("\\\\ql");
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())) {

			if (plantillaTramiteARBDetalle.getArbtramexp().getTrfecdesigna() != null) {
				// DAtos audiencia
				plantillaTramiteARBDetalle.setFechaDesigColegioCas(
						Y41bUtils.formatearDateToString(plantillaTramiteARBDetalle.getArbtramexp().getTrfecdesigna(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaDesigColegioEus(Y41bUtils.formatearDateToStringEuskera(
						plantillaTramiteARBDetalle.getArbtramexp().getTrfecdesigna(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			Arbcolegio arbcolegio = new Arbcolegio();
			Arbitro arb = new Arbitro();
			arbcolegio.setXjtrid(plantillaTramiteARBDetalle.getArbtramexp().getTrid());
			arbcolegio = this.arbcolegioDao.find(arbcolegio);
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrintica().equals("3")) {
				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral", null,
								new Locale(Y41bConstantes.CASTELLANO))));
			} else {
				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.presidenteOrganoArbitralUnipersonal", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.presidenteOrganoArbitralUnipersonal", null,
								new Locale(Y41bConstantes.CASTELLANO))));
			}
			texto.append("\\\\tx175\\\\tab ").append(arbcolegio.getPresidenteT().getArnombre()).append("\\\\par ")
					.append("\\\\tab ").append("\\\\b ")
					.append(this.appMessageSource.getMessage("plantilla.suplente", null,
							new Locale(Y41bConstantes.EUSKERA)))
					.append(" / ")
					.append(this.appMessageSource.getMessage("plantilla.suplente", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(":\\\\b0\\\\par ").append("\\\\tab ").append(arbcolegio.getPresidenteS().getArnombre())
					.append("\\\\par ");
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrintica().equals("3")) {
				plantillaTramiteARBDetalle.setTipoColegioEus(this.appMessageSource
						.getMessage("plantilla.colegioArbitral", null, new Locale(Y41bConstantes.EUSKERA))
						.toUpperCase());
				plantillaTramiteARBDetalle.setTipoColegioCas(this.appMessageSource
						.getMessage("plantilla.colegioArbitral", null, new Locale(Y41bConstantes.CASTELLANO))
						.toUpperCase());

				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.arbitroConsumidor", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.arbitroConsumidor", null,
								new Locale(Y41bConstantes.CASTELLANO))))
						.append("\\\\tx175\\\\tab ").append(arbcolegio.getConsumidorT().getArnombre());

				arb = this.arbitroService.find(arbcolegio.getConsumidorT());
				this.rellenaAACCOOEE(arb, texto, null, null);

				texto.append("\\\\par ").append("\\\\tab ").append("\\\\b ")
						.append(this.appMessageSource.getMessage("plantilla.suplente", null,
								new Locale(Y41bConstantes.EUSKERA)))
						.append(" / ")
						.append(this.appMessageSource.getMessage("plantilla.suplente", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(":\\\\b0\\\\par ").append("\\\\tab ").append(arbcolegio.getConsumidorS().getArnombre());

				arb = this.arbitroService.find(arbcolegio.getConsumidorS());
				this.rellenaAACCOOEE(arb, texto, null, null);

				texto.append("\\\\par ")
						.append(this.construirTextoRtfBullet(
								this.appMessageSource.getMessage("plantilla.arbitroEmpresarial", null,
										new Locale(Y41bConstantes.EUSKERA)),
								this.appMessageSource.getMessage("plantilla.arbitroEmpresarial", null,
										new Locale(Y41bConstantes.CASTELLANO))))
						.append("\\\\tx175\\\\tab ").append(arbcolegio.getEmpresarialT().getArnombre());

				arb = this.arbitroService.find(arbcolegio.getEmpresarialT());
				this.rellenaAACCOOEE(arb, texto, null, null);

				texto.append("\\\\par ").append("\\\\tab ").append("\\\\b ")
						.append(this.appMessageSource.getMessage("plantilla.suplente", null,
								new Locale(Y41bConstantes.EUSKERA)))
						.append(" / ")
						.append(this.appMessageSource.getMessage("plantilla.suplente", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(":\\\\b0\\\\par ").append("\\\\tab ")
						.append(arbcolegio.getEmpresarialS().getArnombre());

				arb = this.arbitroService.find(arbcolegio.getEmpresarialS());
				this.rellenaAACCOOEE(arb, texto, null, null);

				texto.append("\\\\par ");
			} else {
				plantillaTramiteARBDetalle.setTipoColegioEus(this.appMessageSource
						.getMessage("plantilla.organoArbitralUnipersonal", null, new Locale(Y41bConstantes.EUSKERA))
						.toUpperCase());
				plantillaTramiteARBDetalle.setTipoColegioCas(this.appMessageSource
						.getMessage("plantilla.organoArbitralUnipersonal", null, new Locale(Y41bConstantes.CASTELLANO))
						.toUpperCase());
			}
			texto.append(this.construirTextoRtfBullet(
					this.appMessageSource.getMessage("plantilla.secretario", null, new Locale(Y41bConstantes.EUSKERA)),
					this.appMessageSource.getMessage("plantilla.secretario", null,
							new Locale(Y41bConstantes.CASTELLANO))))
					.append("\\\\tx175\\\\tab ").append(arbcolegio.getSecretarioT().getSrnombre()).append("\\\\par ")
					.append("\\\\tab ").append("\\\\b ")
					.append(this.appMessageSource.getMessage("plantilla.suplente", null,
							new Locale(Y41bConstantes.EUSKERA)))
					.append(" / ")
					.append(this.appMessageSource.getMessage("plantilla.suplente", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(":\\\\b0\\\\par ").append("\\\\tab ").append(arbcolegio.getSecretarioS().getSrnombre())
					.append("\\\\par ");
			plantillaTramiteARBDetalle.setColegio(texto.toString());
		}

	}

	/**
	 * findAllMailOrigen
	 * 
	 * @param idExpediente
	 *            String
	 * @return List<DatosMailOrigen> lista
	 */
	public List<DatosMailOrigen> findAllMailOrigen(String idExpediente) {
		DatosMailOrigen datosMailOrigen = new DatosMailOrigen();
		List<DatosMailOrigen> listDatosMailOrigen = new ArrayList<DatosMailOrigen>();

		// Buscar el monitor
		CensoMonitor remitente = new CensoMonitor();
		if (idExpediente != null) {

			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(idExpediente);

			arbexp = this.arbexpDao.find(arbexp);
			remitente.setMocodigo(arbexp.getExmocodigo());

			remitente = this.censoMonitorDao.find(remitente);

			datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
			datosMailOrigen.setEmail(remitente.getMocoem());
			datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
			datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

			listDatosMailOrigen.add(datosMailOrigen);
		}

		// Buscar el organismo
		Organismo organismo = new Organismo();
		organismo.setCodOrg("01J001");

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
		datosMailOrigen.setEmail(organismo.getEmail());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		return listDatosMailOrigen;
	}

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen datosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(String idExpediente, DatosMailOrigen datosMailOrigen) {

		DatosMailOrigen datosMailOrigenAux = new DatosMailOrigen();

		if (Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el monitor
			CensoMonitor remitente = new CensoMonitor();
			if (idExpediente == null) {
				remitente.setOrganismo(new Organismo("01J001"));
				List<CensoMonitor> lremitente = this.censoMonitorDao.findAll(remitente, null);
				if (lremitente != null && lremitente.size() > 0) {
					datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
					datosMailOrigen.setEmail(lremitente.get(0).getMocoem());
					datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
					datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

				}
			} else {
				Arbexp arbexp = new Arbexp();
				arbexp.setExcodigo(idExpediente);

				arbexp = this.arbexpDao.find(arbexp);
				remitente.setMocodigo(arbexp.getExmocodigo());

				remitente = this.censoMonitorDao.find(remitente);

				datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
				datosMailOrigenAux.setEmail(remitente.getMocoem());
				datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
				datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);
			}

		} else if (Y41bConstantes.ID_MAIL_ORIGEN_GENERICO.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg("01J001");

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
			datosMailOrigenAux.setEmail(organismo.getEmail());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);
		}

		return datosMailOrigenAux;
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaLaudo(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		if (plantillaTramiteARBDetalle.getArbtramexp() != null && (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO
						.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				Arbtramexp tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, false,
						false);

			}

			// datos para acta de audiencia del trmite de citacin audiencia.
			// (lugar)
			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
				Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);
				this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);
			}

			// datos relacionados con el tramite de 2 audiencia.
			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion2 = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion2 != null && lTramiteCitacion2.size() > 0) {
				Arbtramexp tramiteCitacion2 = lTramiteCitacion2.get(0);
				this.rellenaPropiosCitacion2Audiencia(plantillaTramiteARBDetalle, tramiteCitacion2);
			}

			// datos relacionados con el trmite de alegaciones

			// coger todos las recepciones de alegaciones del RECLAMADO (tipo
			// Reconvencion -- NO DE CUALQUIER TIPO) y por cada alegacin
			// pondremos una fila con la
			// fecha de la alegacin
			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			// arbtramexp
			// .setTrtipoalega(Y41bConstantes.ARB_TIPO_ALEGACION_RECONVENCION);
			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteAlegaciones = this.arbtramexpDao.findAll(arbtramexp, pagination);

			StringBuilder textoAlegacionesCas = new StringBuilder("");
			StringBuilder textoAlegacionesEus = new StringBuilder("");

			StringBuilder textoPretensionesCas = new StringBuilder("");
			StringBuilder textoPretensionesEus = new StringBuilder("");

			String[] argumentosMsg = new String[2];

			if (lTramiteAlegaciones != null && lTramiteAlegaciones.size() > 0) {

				for (int i = 0; i < lTramiteAlegaciones.size(); i++) {

					Arbtramexp tramiteAlegacion = lTramiteAlegaciones.get(i);
					// buscamos el interviniente para comprobar si es el
					// reclamado

					Arbinterv arbintervorigen = new Arbinterv(tramiteAlegacion.getTrintervorigen());
					arbintervorigen = this.arbintervDao.find(arbintervorigen);
					if (arbintervorigen != null) {
						if (arbintervorigen.getUatipointerv() != null && Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
								.equals(arbintervorigen.getUatipointerv())) {

							argumentosMsg[0] = Y41bUtils.formatearDateToString(tramiteAlegacion.getTrfecrecepcion(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO);

							argumentosMsg[1] = plantillaTramiteARBDetalle.getNombreReclamado();

							textoAlegacionesCas.append("\\\\line\\\\tab").append(" ")
									.append(this.appMessageSource.getMessage("plantilla.arbitraje.alegacionreclamado",
											argumentosMsg, new Locale(Y41bConstantes.CASTELLANO)));
							textoAlegacionesCas.append("\\\\par ");

							textoPretensionesCas.append("\\\\line\\\\tab").append(" ")
									.append(this.appMessageSource.getMessage("plantilla.arbitraje.pretensionreclamado",
											argumentosMsg, new Locale(Y41bConstantes.CASTELLANO)));
							textoPretensionesCas.append("\\\\par ");

							argumentosMsg[0] = Y41bUtils.formatearDateToStringEuskera(
									tramiteAlegacion.getTrfecrecepcion(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA,
									Y41bConstantes.EUSKERA);

							textoAlegacionesEus.append("\\\\line\\\\tab").append(" ")
									.append(this.appMessageSource.getMessage("plantilla.arbitraje.alegacionreclamado",
											argumentosMsg, new Locale(Y41bConstantes.EUSKERA)))
									.append("\\\\par ");

							textoPretensionesEus.append("\\\\line\\\\tab").append(" ")
									.append(this.appMessageSource.getMessage("plantilla.arbitraje.pretensionreclamado",
											argumentosMsg, new Locale(Y41bConstantes.EUSKERA)))
									.append("\\\\par ");

						}
					}

				}

			}

			// en la parte de alegaciones hay que aadir una frase de
			// audiencia, si es que la hay
			argumentosMsg[1] = plantillaTramiteARBDetalle.getNombreReclamado();
			if (plantillaTramiteARBDetalle.getFechaAudienciaCas() != null) {

				argumentosMsg[0] = plantillaTramiteARBDetalle.getFechaAudienciaCas();
				textoAlegacionesCas.append("\\\\line\\\\tab").append(" ")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.alegacionreclamado.audiencia",
								argumentosMsg, new Locale(Y41bConstantes.CASTELLANO)))
						.append("\\\\par ");

			}
			if (plantillaTramiteARBDetalle.getFechaAudienciaEus() != null) {

				argumentosMsg[0] = plantillaTramiteARBDetalle.getFechaAudienciaEus();
				textoAlegacionesEus.append("\\\\line\\\\tab").append(" ")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.alegacionreclamado.audiencia",
								argumentosMsg, new Locale(Y41bConstantes.EUSKERA)))
						.append("\\\\par ");

			}

			if (plantillaTramiteARBDetalle.getFechaAudiencia2Cas() != null) {

				argumentosMsg[0] = plantillaTramiteARBDetalle.getFechaAudiencia2Cas();
				textoAlegacionesCas.append("\\\\line\\\\tab").append(" ")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.alegacionreclamado.audiencia",
								argumentosMsg, new Locale(Y41bConstantes.CASTELLANO)));
				textoAlegacionesCas.append("\\\\par ");

			}
			if (plantillaTramiteARBDetalle.getFechaAudiencia2Eus() != null) {

				argumentosMsg[0] = plantillaTramiteARBDetalle.getFechaAudiencia2Eus();
				textoAlegacionesEus.append("\\\\line\\\\tab").append(" ")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.alegacionreclamado.audiencia",
								argumentosMsg, new Locale(Y41bConstantes.EUSKERA)));
				textoAlegacionesEus.append("\\\\par ");

			}

			plantillaTramiteARBDetalle.setAlegacionesRdCas(textoAlegacionesCas.toString());
			plantillaTramiteARBDetalle.setAlegacionesRdEus(textoAlegacionesEus.toString());

			plantillaTramiteARBDetalle.setPretensionesRdCas(textoPretensionesCas.toString());
			plantillaTramiteARBDetalle.setPretensionesRdEus(textoPretensionesEus.toString());

			// los datos para cuando hay citacin a prueba

			arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacionPrueba = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacionPrueba != null && lTramiteCitacionPrueba.size() > 0) {
				Arbtramexp tramiteCitacionPrueba = lTramiteCitacionPrueba.get(0);
				this.rellenaPropiosCitacionPrueba(plantillaTramiteARBDetalle, tramiteCitacionPrueba);

			}

			// los datos del tramite recepcin de arbitraje
			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteAceptacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteAceptacion != null && lTramiteAceptacion.size() > 0) {
				Arbtramexp tramiteAceptacion = lTramiteAceptacion.get(0);
				this.rellenaPropiosAceptacionArbitraje(plantillaTramiteARBDetalle, tramiteAceptacion);
			}

			// los datos del propio Laudo
			this.rellenaPropiosLaudo(solarb, plantillaTramiteARBDetalle, plantillaTramiteARBDetalle.getArbtramexp());
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaSuspensionAudiencia(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())) {
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
				Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);

				this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);

			}
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaCitacionAPrueba(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())) {
			// Fecha de la audiencia
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
				Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);
				this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);
			}

			// Colegio y tipo colegio
			Arbtramexp tramiteColegio = new Arbtramexp();
			tramiteColegio.setSolarb(solarb);
			tramiteColegio.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			tramiteColegio.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(tramiteColegio, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, false,
						false);

			}

			// propios de la citacin
			this.rellenaPropiosCitacionPrueba(plantillaTramiteARBDetalle, plantillaTramiteARBDetalle.getArbtramexp());

		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPagoPericial(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())) {

			// Fecha de la audiencia
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
				Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);
				this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);
			}

			// Colegio y tipo colegio
			Arbtramexp tramiteColegio = new Arbtramexp();
			tramiteColegio.setSolarb(solarb);
			tramiteColegio.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			tramiteColegio.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(tramiteColegio, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, true, false);

			}

			this.rellenaPropiosPagoPericial(plantillaTramiteARBDetalle, plantillaTramiteARBDetalle.getArbtramexp());
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             exc
	 */
	private void rellenaResolucion(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())) {
			if (!Y41bUtils.esNullOCadenaVacia(plantillaTramiteARBDetalle.getArbtramexp().getTrcot5())) {
				StringBuffer motivo = new StringBuffer("");
				motivo.append("plantilla.arbitraje.inadmision.")
						.append(Integer.parseInt(plantillaTramiteARBDetalle.getArbtramexp().getTrcot5()));
				plantillaTramiteARBDetalle.setMotivoInadmisionCas(this.appMessageSource.getMessage(motivo.toString(),
						null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setMotivoInadmisionEus(
						this.appMessageSource.getMessage(motivo.toString(), null, new Locale(Y41bConstantes.EUSKERA)));
			}
			if (!Y41bUtils.esNullOCadenaVacia(plantillaTramiteARBDetalle.getArbtramexp().getTrresotipo())
					&& Y41bConstantes.DECISION_ARBITRAJE_NOSUBSANA
							.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrresotipo())) {
				// Acuse y notif de subsanacion (Fechas del primer req. de
				// subsanacion)
				Arbtramexp reqSubsanacion = new Arbtramexp();
				reqSubsanacion.setSolarb(solarb);
				reqSubsanacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION);
				reqSubsanacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				Pagination pagination = new Pagination();
				pagination.setSidx("TRFECFIN");
				pagination.setSord("DESC");
				List<Arbtramexp> lreqSubsanacion = this.arbtramexpDao.findAll(reqSubsanacion, pagination);

				Arbenvio arbenvio = new Arbenvio();
				Date fechaEnvio = null;
				Date fechaAcuse = null;
				if (lreqSubsanacion != null && lreqSubsanacion.size() > 0) {

					// tenemos que buscar la notificacion/comunicacin
					// relacionada
					reqSubsanacion = lreqSubsanacion.get(0);

					Arbtramexp reqNotifComun = new Arbtramexp();
					reqNotifComun.setTrtridrel(reqSubsanacion.getTrid());
					reqNotifComun.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					pagination = new Pagination();
					pagination.setSidx("TRFECFIN");
					pagination.setSord("DESC");

					List<Arbtramexp> lreqNotifComun = this.arbtramexpDao.findAll(reqNotifComun, pagination);
					if (lreqNotifComun != null && lreqNotifComun.size() > 0) {

						// nos quedamos con el trmite de notificacin
						reqNotifComun = lreqNotifComun.get(0);
						if (Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(reqNotifComun.getTrcodigo())) {
							// si es comunicacin la fecha de envio son ambas
							// fechas
							fechaEnvio = reqNotifComun.getTrfecnotif();
							fechaAcuse = reqNotifComun.getTrfecnotif();
						} else if (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(reqNotifComun.getTrcodigo())) {
							// si es notificacin tenemos que ir con ese id a
							// arbenvio
							arbenvio.setEnexid(solarb.getSacodigo());

							arbenvio.setArbtramexpByEntrid(new Arbtramexp(reqNotifComun.getTrid()));
							pagination.setSidx("ENFECENVIO");
							pagination.setSord("ASC");
							List<Arbenvio> larbenvio = this.arbenvioDao.findAll(arbenvio, pagination);

							if (larbenvio != null && larbenvio.size() > 0) {
								arbenvio = larbenvio.get(0);
								if (arbenvio.getEnfecenvio() != null) {
									fechaEnvio = arbenvio.getEnfecenvio();
								}
								if (arbenvio.getEnfecacuse() != null) {
									fechaAcuse = arbenvio.getEnfecacuse();
								}
							}
						}

					}

					// Id del tramite que se acusa
					// arbenvio.setArbtramexpByEntridacuse(reqSubsanacion);

				}

				if (fechaEnvio != null) {
					plantillaTramiteARBDetalle.setFechaNotReqSubsanaCas(Y41bUtils.formatearDateToString(fechaEnvio,
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle.setFechaNotReqSubsanaEus(Y41bUtils.formatearDateToStringEuskera(
							fechaEnvio, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
				}

				if (fechaAcuse != null) {
					plantillaTramiteARBDetalle.setFechaAcuseReqSubsanaCas(Y41bUtils.formatearDateToString(fechaAcuse,
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle.setFechaAcuseReqSubsanaEus(Y41bUtils.formatearDateToStringEuskera(
							fechaAcuse, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
				}

			}
			if (!Y41bUtils.esNullOCadenaVacia(plantillaTramiteARBDetalle.getArbtramexp().getTrcosaac())) {
				Solarb solarbAc = new Solarb();
				solarbAc.setSacodigo(plantillaTramiteARBDetalle.getArbtramexp().getTrcosaac());
				solarbAc = this.solarbDao.find(solarbAc);
				StringBuffer numeroExpediente = new StringBuffer();
				numeroExpediente.append(Y41bConstantes.TIPO_PROC_ARBITRAJE)
						.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP).append(solarbAc.getSacoja())
						.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP).append(solarbAc.getSanror())
						.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP).append(solarbAc.getSanran());
				plantillaTramiteARBDetalle.setNumExpedienteAc(numeroExpediente.toString());
			}
			if (solarb.getSafedeco() != null) {
				plantillaTramiteARBDetalle.setFechaDecoCas(Y41bUtils.formatearDateToString(solarb.getSafedeco(),
						Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaDecoEus(Y41bUtils.formatearDateToStringEuskera(solarb.getSafedeco(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrfecdesis() != null) {
				plantillaTramiteARBDetalle.setFechaDesiCas(
						Y41bUtils.formatearDateToString(plantillaTramiteARBDetalle.getArbtramexp().getTrfecdesis(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaDesiEus(Y41bUtils.formatearDateToStringEuskera(
						plantillaTramiteARBDetalle.getArbtramexp().getTrfecdesis(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrfecauerdo() != null) {
				plantillaTramiteARBDetalle.setFechaAcuerdoCas(
						Y41bUtils.formatearDateToString(plantillaTramiteARBDetalle.getArbtramexp().getTrfecauerdo(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaAcuerdoEus(Y41bUtils.formatearDateToStringEuskera(
						plantillaTramiteARBDetalle.getArbtramexp().getTrfecauerdo(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}
			if (!Y41bUtils.esNullOCadenaVacia(plantillaTramiteARBDetalle.getArbtramexp().getTrcoortr())) {
				Organismo organismo = new Organismo();
				organismo.setCodOrg(plantillaTramiteARBDetalle.getArbtramexp().getTrcoortr());
				organismo = this.organismoDao.find(organismo);
				if (organismo != null) {
					plantillaTramiteARBDetalle.setNombreOrgTrasladoEs(organismo.getNombreEs());
					plantillaTramiteARBDetalle.setNombreOrgTrasladoEu(organismo.getNombreEu());
					plantillaTramiteARBDetalle.setProvOrgTraslado(
							organismo.getNombreProvincia() != null ? organismo.getNombreProvincia() : "");
					plantillaTramiteARBDetalle.setMunOrgTraslado(
							organismo.getNombreMunicipio() != null ? organismo.getNombreMunicipio() : "");
					plantillaTramiteARBDetalle.setLocOrgTraslado(
							organismo.getNombreLocalidad() != null ? organismo.getNombreLocalidad() : "");
					plantillaTramiteARBDetalle.setDirOrgTraslado(organismo.getNombreCalle() != null
							? organismo.getNombreCalle()
							: "" + " " + organismo.getNombrePortal() != null ? organismo.getNombrePortal() : "");
					plantillaTramiteARBDetalle
							.setCpOrgTraslado(organismo.getNombreCp() != null ? organismo.getNombreCp() : "");
				}
			}
		}
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento) {

		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailEstablecimiento.getIdDatomail())) {
			// buscar el interviniente demandado
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(new Solarb(tramiteComun.getIdExpediente()));
			/*
			 * arbinterv
			 * .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			 */
			arbinterv.setUaidinterv(new BigDecimal(idDestinatario));

			List<Arbinterv> listArbinterv = this.arbintervDao.findAll(arbinterv, null);

			if (listArbinterv != null && listArbinterv.size() > 0) {
				datosMailEstablecimientoAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
				datosMailEstablecimientoAux.setEmail(listArbinterv.get(0).getUacoem());
				datosMailEstablecimientoAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
				datosMailEstablecimientoAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

			}

		} else {
			datosMailEstablecimientoAux = this.datosMailEstablecimientoDao.find(datosMailEstablecimiento);
		}

		return datosMailEstablecimientoAux;
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, Arbinterv arbinterv,
			Pagination pagination) {

		List<DatosMailSede> listDatosMailSede = new ArrayList<DatosMailSede>();

		Sede sede = new Sede();
		sede.setEscodigo(arbinterv.getUaescodigo());
		sede.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

		sede = this.establecimientoService.findEstablecimientoSede(sede);

		DatosMailSede datosMailSede = new DatosMailSede();

		datosMailSede.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailSede.setEmail(sede.getEmail());
		datosMailSede.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailSede.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailSede.add(datosMailSede);

		// buscar todos los mails del establecimiento
		DatosMailSede datosMailSedeAux = new DatosMailSede();
		datosMailSedeAux.setEscodigo(arbinterv.getUaescodigo());
		datosMailSedeAux.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

		List<DatosMailSede> listDatosMailSedeAux = this.datosMailSedeDao.findAll(datosMailSedeAux, null);

		for (DatosMailSede datosMailSedeAux2 : listDatosMailSedeAux) {
			// aadirlo a la lista
			listDatosMailSede.add(datosMailSedeAux2);
		}

		return listDatosMailSede;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede) {

		DatosMailSede datosMailSedeAux = new DatosMailSede();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailSede.getIdDatomail())) {

			Sede sede = new Sede();
			sede.setEscodigo(datosMailSede.getEscodigo());
			sede.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

			sede = this.establecimientoService.findEstablecimientoSede(sede);

			datosMailSedeAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
			datosMailSedeAux.setEmail(sede.getEmail());
			datosMailSedeAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
			datosMailSedeAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		} else {
			datosMailSedeAux = this.datosMailSedeDao.find(datosMailSede);
		}

		return datosMailSedeAux;
	}

	/**
	 * Finds a List of rows in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun, Arbinterv arbinterv,
			Pagination pagination) {

		List<DatosMailEstablecimiento> listDatosMailEstablecimiento = new ArrayList<DatosMailEstablecimiento>();

		Arbinterv arbinterv2 = this.arbintervDao.find(arbinterv);

		DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();

		datosMailEstablecimiento.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailEstablecimiento.setEmail(arbinterv2.getUacoem());
		datosMailEstablecimiento.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailEstablecimiento.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailEstablecimiento.add(datosMailEstablecimiento);

		// buscar todos los mails del establecimiento
		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();
		datosMailEstablecimientoAux.setEscodigo(arbinterv2.getUaescodigo());

		List<DatosMailEstablecimiento> listDatosMailEstablecimientoAux = this.datosMailEstablecimientoDao
				.findAll(datosMailEstablecimientoAux, null);

		for (DatosMailEstablecimiento datosMailEstablecimientoAux2 : listDatosMailEstablecimientoAux) {
			// aadirlo a la lista
			listDatosMailEstablecimiento.add(datosMailEstablecimientoAux2);
		}

		return listDatosMailEstablecimiento;
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param calleId
	 *            String
	 * @param portalId
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param idioma
	 *            String
	 * @return the string
	 */
	public String dameLineaDireccion(String calleId, String portalId, String nombrePiso, String idioma) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();
		StringBuffer calleconVia = new StringBuffer();
		if (!Y41bUtils.esNullOCadenaVacia(calleId)) {
			T17Calle calle = null;
			// try {
			calle = this.t17CalleDao.find(new T17Calle(Long.parseLong(calleId), null));
			// if (calle.getTipoViaId() != null) {
			// T17TipoVia t17TipoVia = this.t17tipoViaDao
			// .find(new T17TipoVia(calle.getTipoViaId(), null,
			// null));
			// if (Y41bConstantes.EUSKERA.equals(idioma)) {
			// calleconVia
			// .append(calle.getDsO())
			// .append(" ")
			// .append(t17TipoVia == null
			// || t17TipoVia.getDsE() == null ? ""
			// : t17TipoVia.getDsE());
			// } else {
			// calleconVia
			// .append(t17TipoVia == null
			// || t17TipoVia.getDsC() == null ? ""
			// : t17TipoVia.getDsC()).append(" ")
			// .append(calle.getDsO());
			// }
			// } else {
			// calleconVia.append(calle.getDsO());
			// }
			if (calle != null && calle.getTipoVia() != null) {
				calleconVia.append(calle.getTipoVia());
				calleconVia.append(" ");
				if (Y41bConstantes.EUSKERA.equals(idioma) && calle.getDsE() != null) {
					calleconVia.append(calle.getDsE());
				} else {
					calleconVia.append(calle.getDsO());
				}
			}
			// } catch (Exception e) {
			// if (calle != null && calle.getDsO() != null) {
			// calleconVia.append(calle.getDsO());
			// }
			// }
			if (!Y41bUtils.esNullOCadenaVacia(portalId)) {
				t17portal.setId(Long.parseLong(portalId));
				t17portal.setCalleId(Long.parseLong(calleId));
				List<T17Portal> list = this.t17PortalService.findAll(t17portal, null);
				if (list != null && list.size() > 0) {
					t17portal = list.get(0);
					if (t17portal != null && t17portal.getPortal() != null) {
						direccion.append(" ").append(Y41bUtils.componerDireccion(calleconVia.toString(),
								t17portal.getBloque(), t17portal.getPortal(), 0, null, nombrePiso, null));
					}
				}
			}
		}
		return (direccion.toString());

	}

	/**
	 * dame direccion compelta
	 * 
	 * @param locId
	 *            String
	 * @param provId
	 *            String
	 * @param munId
	 *            String
	 * @return String
	 */
	public String dameLocalidad(String locId, String provId, String munId) {
		StringBuffer direccion = new StringBuffer("");
		String localidad = "";
		if (!Y41bUtils.esNullOCadenaVacia(provId) && !Y41bUtils.esNullOCadenaVacia(munId)
				&& !Y41bUtils.esNullOCadenaVacia(locId)) {
			T17Localidad localidadVO = this.t17LocalidadDao.find(new T17Localidad(locId, null, munId, provId, null));
			if (localidadVO != null) {
				localidad = localidadVO.getDsO() == null ? "" : localidadVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(localidad);
		}
		return (direccion.toString());
	}

	/**
	 * dame municipio
	 * 
	 * @param provId
	 *            String
	 * @param munId
	 *            String
	 * @return String
	 */
	private String dameMunicipio(String provId, String munId) {
		String municipio = "";
		if (!Y41bUtils.esNullOCadenaVacia(provId) && !Y41bUtils.esNullOCadenaVacia(munId)) {
			if ((munId != null) && (provId != null)) {
				T17Municipio municipiodVO = (this.t17MunicipioDao.find(new T17Municipio(munId, provId, null, null)));

				if (municipiodVO != null) {
					municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
				}
			}
		}
		return municipio;
	}

	/**
	 * dame descripcin territorio compelta
	 * 
	 * @param provId
	 *            String
	 * @return String
	 */
	private String dameTerritorio(String provId) {
		StringBuffer direccion = new StringBuffer("");
		String provincia = "";
		if (!Y41bUtils.esNullOCadenaVacia(provId)) {
			T17Provincia provinciaVO = this.t17ProvinciaDao.find(new T17Provincia(provId, null, null));
			if (provinciaVO != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(provincia);
		}
		return (direccion.toString());
	}

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	public Long findExpedientesAbiertos(Arbexp arbexp) {

		return this.arbexpDao.findExpedientesAbiertos(arbexp);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateTrasvaseTotalCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor)
			throws Exception {

		// Actualizar la tabla de expediente sancionador
		String codInstrAnterior = solicitudCambioInstructor.getInstructorActual().getMocodigo();
		String codOrg = solicitudCambioInstructor.getOrganismo().getCodOrg();
		// buscar todos los expedientes sancionadores abiertos del instructor
		// origen
		Arbexp filtroArbitraje = new Arbexp();
		filtroArbitraje.setExmocodigo(codInstrAnterior);
		filtroArbitraje.setExcoor(codOrg);
		filtroArbitraje.setExfecfin(new Date());
		List<Arbexp> listArbitrajeBusqueda = this.arbexpDao.findAllExcodigo(filtroArbitraje, null);
		SolicitudCambioInstructor solicitudCambioInstructorExpdte = new SolicitudCambioInstructor();

		// por cada expediente sancionador abierto, cambiar el instructor
		for (Arbexp arbitraje : listArbitrajeBusqueda) {
			solicitudCambioInstructorExpdte.setIdExpediente(arbitraje.getExcodigo());
			solicitudCambioInstructorExpdte.setInstructorActual(solicitudCambioInstructor.getInstructorActual());
			solicitudCambioInstructorExpdte.setInstructorNuevo(solicitudCambioInstructor.getInstructorNuevo());
			solicitudCambioInstructorExpdte.setOrganismo(solicitudCambioInstructor.getOrganismo());
			try {
				this.solarbService.updateCambioInstructor(solicitudCambioInstructorExpdte);
			} catch (Exception e) {
				e.printStackTrace();
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaCitacionAudiencia(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA
						.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				Arbtramexp tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, true, false, false, false);
			}

			Establecimiento establecimiento = new Establecimiento();
			Essa essa = new Essa();
			essa.setSolarb(solarb);
			essa.setEstablecimiento(establecimiento);
			pagination.setSidx("MACOES ");
			List<Essa> lista = this.essaDao.findAll(essa, pagination);
			if (lista != null && lista.size() > 0) {
				essa = lista.get(0);
				establecimiento = this.establecimientoDao.find(essa.getEstablecimiento());
				String tipoArbitrajeCas = "";
				String tipoArbitrajeEus = "";
				if (establecimiento != null && establecimiento.getEsintiar() != null) {
					if ("E".equalsIgnoreCase(establecimiento.getEsintiar())) {
						tipoArbitrajeCas = this.appMessageSource.getMessage("plantilla.arbitraje.equidad", null,
								new Locale(Y41bConstantes.CASTELLANO));
						tipoArbitrajeEus = this.appMessageSource.getMessage("plantilla.arbitraje.equidad", null,
								new Locale(Y41bConstantes.EUSKERA));
					} else if ("D".equalsIgnoreCase(establecimiento.getEsintiar())) {
						tipoArbitrajeCas = this.appMessageSource.getMessage("plantilla.arbitraje.derecho", null,
								new Locale(Y41bConstantes.CASTELLANO));
						tipoArbitrajeEus = this.appMessageSource.getMessage("plantilla.arbitraje.derecho", null,
								new Locale(Y41bConstantes.EUSKERA));
					}
					plantillaTramiteARBDetalle.setTipoArbitrajeCas(tipoArbitrajeCas);
					plantillaTramiteARBDetalle.setTipoArbitrajeEus(tipoArbitrajeEus);
				}
			}

			this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle,
					plantillaTramiteARBDetalle.getArbtramexp());

		}
	}

	/**
	 * construirTextoRtfBullet
	 * 
	 * @param s1
	 *            String
	 * @return StringBuffer resultado
	 */
	private StringBuffer construirTextoRtfBullet(String s1) {
		return this.construirTextoRtfBullet(s1, null);
	}

	/**
	 * construirTextoRtfBullet
	 * 
	 * @param s1
	 *            String
	 * @param s2
	 *            String
	 * @return StringBuffer resultado
	 */
	private StringBuffer construirTextoRtfBullet(String s1, String s2) {
		StringBuffer resultado = new StringBuffer(Y41bConstantes.NUM_60);
		resultado.append("{\\\\line\\\\bullet} ");
		resultado.append("\\\\b ").append(s1);
		if (s2 != null) {
			resultado.append(" / ").append(s2);
		}
		resultado.append(":\\\\b0\\\\par ");
		return resultado;
	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            plantillaTramiteARBDetalle
	 * @param tramiteColegio
	 *            Arbtramexp
	 * @param mostrarSuplentes
	 *            boolean
	 * @param mostrarAACCOOEE
	 *            boolean
	 * @param pago
	 *            boolean
	 * @param mostrarBOPV
	 *            booolean
	 * @throws ParseException
	 *             pe
	 */
	private void rellenaCamposTramiteColegio(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteColegio, boolean mostrarSuplentes, boolean mostrarAACCOOEE, boolean pago,
			boolean mostrarBOPV) throws ParseException {

		StringBuffer texto = new StringBuffer("\\\\ql");
		StringBuffer textoCas = new StringBuffer("\\\\ql");
		StringBuffer textoEus = new StringBuffer("\\\\ql");
		StringBuffer textoSoloNombres = new StringBuffer("");

		if (tramiteColegio != null) {

			Arbitro arb = new Arbitro();
			Arbcolegio arbcolegio = new Arbcolegio();
			arbcolegio.setXjtrid(tramiteColegio.getTrid());
			arbcolegio = this.arbcolegioDao.find(arbcolegio);

			if (tramiteColegio.getTrintica().equals("3")) {
				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral", null,
								new Locale(Y41bConstantes.CASTELLANO))));
			} else {
				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.presidenteOrganoArbitralUnipersonal", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.presidenteOrganoArbitralUnipersonal", null,
								new Locale(Y41bConstantes.CASTELLANO))));
			}
			texto.append("\\\\tx175\\\\tab ");
			if (mostrarSuplentes) {
				texto.append(arbcolegio.getPresidenteT().getArnombre());
			} else {
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivop())) {
					texto.append(arbcolegio.getPresidenteT().getArnombre());
				} else {
					texto.append(arbcolegio.getPresidenteS().getArnombre());
				}
			}
			texto.append("\\\\par ");
			if (mostrarSuplentes) {
				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.suplente", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.suplente", null,
								new Locale(Y41bConstantes.CASTELLANO))));
				texto.append("\\\\tab ");
				texto.append(arbcolegio.getPresidenteS().getArnombre());
				texto.append("\\\\par ");
			}

			// texto solo nombres
			if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivop())) {
				textoSoloNombres.append(arbcolegio.getPresidenteT().getArnombre());
			} else {
				textoSoloNombres.append(arbcolegio.getPresidenteS().getArnombre());
			}

			// texto castellano
			if (tramiteColegio.getTrintica().equals("3")) {
				textoCas.append(this.construirTextoRtfBullet(this.appMessageSource.getMessage(
						"plantilla.presidenteColegioArbitral", null, new Locale(Y41bConstantes.CASTELLANO))));
			} else {
				textoCas.append(this.construirTextoRtfBullet(this.appMessageSource.getMessage(
						"plantilla.presidenteOrganoArbitralUnipersonal", null, new Locale(Y41bConstantes.CASTELLANO))));
			}
			textoCas.append("\\\\tx175\\\\tab ");
			if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivop())) {
				textoCas.append(arbcolegio.getPresidenteT().getArnombre());
			} else {
				textoCas.append(arbcolegio.getPresidenteS().getArnombre());
			}
			textoCas.append("\\\\par ");

			// texto euskera
			if (tramiteColegio.getTrintica().equals("3")) {
				textoEus.append(this.construirTextoRtfBullet(this.appMessageSource
						.getMessage("plantilla.presidenteColegioArbitral", null, new Locale(Y41bConstantes.EUSKERA))));
			} else {
				textoEus.append(this.construirTextoRtfBullet(this.appMessageSource.getMessage(
						"plantilla.presidenteOrganoArbitralUnipersonal", null, new Locale(Y41bConstantes.EUSKERA))));
			}
			textoEus.append("\\\\tx175\\\\tab ");
			if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivop())) {
				textoEus.append(arbcolegio.getPresidenteT().getArnombre());
			} else {
				textoEus.append(arbcolegio.getPresidenteS().getArnombre());
			}
			textoEus.append("\\\\par ");

			if (tramiteColegio.getTrintica().equals("3")) {

				plantillaTramiteARBDetalle.setTipoColegioEus(this.appMessageSource
						.getMessage("plantilla.colegioArbitral", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteARBDetalle.setTipoColegioCas(this.appMessageSource
						.getMessage("plantilla.colegioArbitral", null, new Locale(Y41bConstantes.CASTELLANO)));

				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.arbitroConsumidor", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.arbitroConsumidor", null,
								new Locale(Y41bConstantes.CASTELLANO))));

				texto.append("\\\\tx175\\\\tab ");
				if (mostrarSuplentes) {
					texto.append(arbcolegio.getConsumidorT().getArnombre());
				} else {
					if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoaacc())) {
						texto.append(arbcolegio.getConsumidorT().getArnombre());
					} else {
						texto.append(arbcolegio.getConsumidorS().getArnombre());
					}
				}

				texto.append("\\\\par ");

				// texto solo nombres
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoaacc())) {
					textoSoloNombres.append(", ").append(arbcolegio.getConsumidorT().getArnombre());
				} else {
					textoSoloNombres.append(", ").append(arbcolegio.getConsumidorS().getArnombre());
				}

				// texto castellano arbitro consumidor
				textoCas.append(this.construirTextoRtfBullet(this.appMessageSource
						.getMessage("plantilla.arbitroConsumidor", null, new Locale(Y41bConstantes.CASTELLANO))));
				textoCas.append("\\\\tx175\\\\tab ");
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoaacc())) {
					textoCas.append(arbcolegio.getConsumidorT().getArnombre());
				} else {
					textoCas.append(arbcolegio.getConsumidorS().getArnombre());
				}

				// texto euskera arbitro consumidor
				textoEus.append(this.construirTextoRtfBullet(this.appMessageSource
						.getMessage("plantilla.arbitroConsumidor", null, new Locale(Y41bConstantes.EUSKERA))));
				textoEus.append("\\\\tx175\\\\tab ");
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoaacc())) {
					textoEus.append(arbcolegio.getConsumidorT().getArnombre());
				} else {
					textoEus.append(arbcolegio.getConsumidorS().getArnombre());
				}

				if (mostrarAACCOOEE) {
					// buscamos las asociaciones del consumidor
					arb = this.arbitroService.find(arbcolegio.getConsumidorT());
					this.rellenaAACCOOEE(arb, texto, textoCas, textoEus);
				}

				if (mostrarSuplentes) {
					texto.append(this.construirTextoRtfBullet(
							this.appMessageSource.getMessage("plantilla.suplente", null,
									new Locale(Y41bConstantes.EUSKERA)),
							this.appMessageSource.getMessage("plantilla.suplente", null,
									new Locale(Y41bConstantes.CASTELLANO))));
					texto.append("\\\\tab ");
					texto.append(arbcolegio.getConsumidorS().getArnombre());
					texto.append("\\\\par ");
				}

				texto.append(this.construirTextoRtfBullet(
						this.appMessageSource.getMessage("plantilla.arbitroEmpresarial", null,
								new Locale(Y41bConstantes.EUSKERA)),
						this.appMessageSource.getMessage("plantilla.arbitroEmpresarial", null,
								new Locale(Y41bConstantes.CASTELLANO))));
				texto.append("\\\\tx175\\\\tab ");
				if (mostrarSuplentes) {
					texto.append(arbcolegio.getEmpresarialT().getArnombre());
				} else {
					if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoooee())) {
						texto.append(arbcolegio.getEmpresarialT().getArnombre());
					} else {
						texto.append(arbcolegio.getEmpresarialS().getArnombre());
					}
				}

				texto.append("\\\\par ");

				// texto solo nombres
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoooee())) {
					textoSoloNombres.append(", ").append(arbcolegio.getEmpresarialT().getArnombre());
				} else {
					textoSoloNombres.append(", ").append(arbcolegio.getEmpresarialS().getArnombre());
				}

				// castellano
				textoCas.append("\\\\par ");
				textoCas.append(this.construirTextoRtfBullet(this.appMessageSource
						.getMessage("plantilla.arbitroEmpresarial", null, new Locale(Y41bConstantes.CASTELLANO))));
				textoCas.append("\\\\tx175\\\\tab ");
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoooee())) {
					textoCas.append(arbcolegio.getEmpresarialT().getArnombre());
				} else {
					textoCas.append(arbcolegio.getEmpresarialS().getArnombre());
				}

				// euskera
				textoEus.append("\\\\par ");
				textoEus.append(this.construirTextoRtfBullet(this.appMessageSource
						.getMessage("plantilla.arbitroEmpresarial", null, new Locale(Y41bConstantes.EUSKERA))));
				textoEus.append("\\\\tx175\\\\tab ");
				if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoooee())) {
					textoEus.append(arbcolegio.getEmpresarialT().getArnombre());
				} else {
					textoEus.append(arbcolegio.getEmpresarialS().getArnombre());
				}

				if (mostrarAACCOOEE) {
					// buscamos las asociaciones del arbitro empresa
					arb = this.arbitroService.find(arbcolegio.getEmpresarialT());
					this.rellenaAACCOOEE(arb, texto, textoCas, textoEus);
				}

				if (mostrarSuplentes) {
					texto.append(this.construirTextoRtfBullet(
							this.appMessageSource.getMessage("plantilla.suplente", null,
									new Locale(Y41bConstantes.EUSKERA)),
							this.appMessageSource.getMessage("plantilla.suplente", null,
									new Locale(Y41bConstantes.CASTELLANO))));
					texto.append("\\\\tx175\\\\tab ");
					texto.append(arbcolegio.getEmpresarialS().getArnombre());
				}

				texto.append("\\\\par ");
				textoCas.append("\\\\par ");
				textoEus.append("\\\\par ");

			} else {
				plantillaTramiteARBDetalle.setTipoColegioEus(this.appMessageSource
						.getMessage("plantilla.organoArbitralUnipersonal", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteARBDetalle.setTipoColegioCas(this.appMessageSource.getMessage(
						"plantilla.organoArbitralUnipersonal", null, new Locale(Y41bConstantes.CASTELLANO)));
			}

			if (pago) {
				this.rellenaCamposTramiteColegioPago(plantillaTramiteARBDetalle, arbcolegio);
			}

			if (mostrarBOPV) {
				this.rellenaCamposTramiteColegioBOPV(plantillaTramiteARBDetalle, tramiteColegio, arbcolegio);
			}

			// bilinge
			plantillaTramiteARBDetalle.setColegio(texto.toString());
			// castellano
			plantillaTramiteARBDetalle.setColegioCas(textoCas.toString());
			// euskera
			plantillaTramiteARBDetalle.setColegioEus(textoEus.toString());

			// solo nombres
			plantillaTramiteARBDetalle.setColegioSoloNombres(textoSoloNombres.toString());

			// nombre Secretaria del colegio
			plantillaTramiteARBDetalle
					.setColegioSecreNombre(Y41bUtils.trataNull(arbcolegio.getSecretarioT().getSrnombre()));

			// puesto secretario segun tipo colegio
			StringBuilder textoPuestoSecreEus = new StringBuilder("");
			StringBuilder textoPuestoSecreCas = new StringBuilder("");
			textoPuestoSecreEus.append(plantillaTramiteARBDetalle.getTipoColegioEus().toUpperCase()).append("KO ")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.puestosecretario", null,
							new Locale(Y41bConstantes.EUSKERA)));
			textoPuestoSecreCas
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.puestosecretario", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(" DEL ").append(plantillaTramiteARBDetalle.getTipoColegioCas().toUpperCase());

			plantillaTramiteARBDetalle.setTextoPuestoSecreColeCas(textoPuestoSecreCas.toString());
			plantillaTramiteARBDetalle.setTextoPuestoSecreColeEus(textoPuestoSecreEus.toString());

			// fecha designacin de colegio
			if (tramiteColegio.getTrfecdesigna() != null) {
				// DAtos audiencia
				plantillaTramiteARBDetalle
						.setFechaDesigColegioCas(Y41bUtils.formatearDateToString(tramiteColegio.getTrfecdesigna(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaDesigColegioEus(
						Y41bUtils.formatearDateToStringEuskera(tramiteColegio.getTrfecdesigna(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

		}
	}

	/**
	 * rellenaCamposTramiteColegioPago
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param arbcolegio
	 *            Arbcolegio
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaCamposTramiteColegioPago(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbcolegio arbcolegio) throws ParseException {
		StringBuffer textoCertPagoCas = new StringBuffer(Y41bConstantes.NUM_50);
		StringBuffer textoCertPagoEus = new StringBuffer(Y41bConstantes.NUM_50);
		textoCertPagoCas.append("\\\\ql");
		textoCertPagoEus.append("\\\\ql");
		// texto para certificado de pago laudo cas
		textoCertPagoCas.append("{\\\\line} ");
		textoCertPagoCas.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivop())) {
			textoCertPagoCas.append(" ").append(arbcolegio.getPresidenteT().getArnombre());
			textoCertPagoCas.append(" (")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(": ").append(arbcolegio.getPresidenteT().getArnif()).append(")\\\\par  ");

			// texto para certificado de pago laudo EUS
			textoCertPagoEus.append("{\\\\line} ");
			textoCertPagoEus.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			textoCertPagoEus.append(" ").append(arbcolegio.getPresidenteT().getArnombre());
			textoCertPagoEus.append(" (")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
							new Locale(Y41bConstantes.EUSKERA)))
					.append(": ").append(arbcolegio.getPresidenteT().getArnif()).append(")\\\\par  ");
		} else {
			textoCertPagoCas.append(" ").append(arbcolegio.getPresidenteS().getArnombre());
			textoCertPagoCas.append(" (")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(": ").append(arbcolegio.getPresidenteS().getArnif()).append(")\\\\par  ");

			// texto para certificado de pago laudo EUS
			textoCertPagoEus.append("{\\\\line} ");
			textoCertPagoEus.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			textoCertPagoEus.append(" ").append(arbcolegio.getPresidenteS().getArnombre());
			textoCertPagoEus.append(" (")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
							new Locale(Y41bConstantes.EUSKERA)))
					.append(": ").append(arbcolegio.getPresidenteS().getArnif()).append(")\\\\par  ");
		}

		if (arbcolegio.getConsumidorT().getArcodigo() != null) {
			if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoaacc())) {
				// texto para certificado de pago laudo cas
				textoCertPagoCas.append("{\\\\line} ");
				textoCertPagoCas.append(this.appMessageSource.getMessage("plantilla.arbitraje.vocal", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoCas.append(" ").append(arbcolegio.getConsumidorT().getArnombre());
				textoCertPagoCas.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(arbcolegio.getConsumidorT().getArnif()).append(")\\\\par  ");

				// texto para certificado de pago laudo EUS
				textoCertPagoEus.append("{\\\\line} ");
				textoCertPagoEus.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto",
						null, new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoEus.append(" ").append(arbcolegio.getConsumidorT().getArnombre());
				textoCertPagoEus.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.EUSKERA)))
						.append(": ").append(arbcolegio.getConsumidorT().getArnif()).append(")\\\\par  ");
			} else {
				// texto para certificado de pago laudo cas
				textoCertPagoCas.append("{\\\\line} ");
				textoCertPagoCas.append(this.appMessageSource.getMessage("plantilla.arbitraje.vocal", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoCas.append(" ").append(arbcolegio.getConsumidorS().getArnombre());
				textoCertPagoCas.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(arbcolegio.getConsumidorS().getArnif()).append(")\\\\par  ");

				// texto para certificado de pago laudo EUS
				textoCertPagoEus.append("{\\\\line} ");
				textoCertPagoEus.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto",
						null, new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoEus.append(" ").append(arbcolegio.getConsumidorS().getArnombre());
				textoCertPagoEus.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.EUSKERA)))
						.append(": ").append(arbcolegio.getConsumidorS().getArnif()).append(")\\\\par  ");
			}

		}

		if (arbcolegio.getEmpresarialT().getArcodigo() != null) {
			if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(arbcolegio.getXjactivoooee())) {
				// texto para certificado de pago laudo cas
				textoCertPagoCas.append("{\\\\line} ");
				textoCertPagoCas.append(this.appMessageSource.getMessage("plantilla.arbitraje.vocal", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoCas.append(" ").append(arbcolegio.getEmpresarialT().getArnombre());
				textoCertPagoCas.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(arbcolegio.getEmpresarialT().getArnif()).append(")\\\\par  ");

				// texto para certificado de pago laudo EUS
				textoCertPagoEus.append("{\\\\line} ");
				textoCertPagoEus.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto",
						null, new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoEus.append(" ").append(arbcolegio.getEmpresarialT().getArnombre());
				textoCertPagoEus.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.EUSKERA)))
						.append(": ").append(arbcolegio.getEmpresarialT().getArnif()).append(") ");
			} else {
				// texto para certificado de pago laudo cas
				textoCertPagoCas.append("{\\\\line} ");
				textoCertPagoCas.append(this.appMessageSource.getMessage("plantilla.arbitraje.vocal", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoCas.append(" ").append(arbcolegio.getEmpresarialS().getArnombre());
				textoCertPagoCas.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(arbcolegio.getEmpresarialS().getArnif()).append(")\\\\par  ");

				// texto para certificado de pago laudo EUS
				textoCertPagoEus.append("{\\\\line} ");
				textoCertPagoEus.append(this.appMessageSource.getMessage("plantilla.presidenteColegioArbitral.corto",
						null, new Locale(Y41bConstantes.CASTELLANO)));
				textoCertPagoEus.append(" ").append(arbcolegio.getEmpresarialS().getArnombre());
				textoCertPagoEus.append(" (")
						.append(this.appMessageSource.getMessage("plantilla.arbitraje.dni", null,
								new Locale(Y41bConstantes.EUSKERA)))
						.append(": ").append(arbcolegio.getEmpresarialS().getArnif()).append(") ");
			}

		}

		// lista para plantilla de certificado pago laudo
		plantillaTramiteARBDetalle.setColegioCertPagoEus(textoCertPagoEus.toString());
		plantillaTramiteARBDetalle.setColegioCertPagoCas(textoCertPagoCas.toString());
	}

	/**
	 * rellenaCamposTramiteColegioBOPV
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteColegio
	 *            Arbtramexp
	 * @param arbcolegio
	 *            Arbcolegio
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaCamposTramiteColegioBOPV(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteColegio, Arbcolegio arbcolegio) throws ParseException {

		StringBuffer textoBopvCas = new StringBuffer("");
		StringBuffer textoBopvEus = new StringBuffer("");

		// texto para el bopv
		textoBopvCas
				.append(plantillaTramiteARBDetalle.getTipoColegioCas()).append(" ").append(this.appMessageSource
						.getMessage("plantilla.arbitraje.formadopor", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append(" ");
		textoBopvCas.append(arbcolegio.getPresidenteT().getArnombre()).append(" ").append(this.appMessageSource
				.getMessage("plantilla.arbitraje.presidentebopv", null, new Locale(Y41bConstantes.CASTELLANO)));

		textoBopvEus
				.append(plantillaTramiteARBDetalle.getTipoColegioCas()).append(" ").append(this.appMessageSource
						.getMessage("plantilla.arbitraje.formadopor", null, new Locale(Y41bConstantes.EUSKERA)))
				.append(" ");
		textoBopvEus.append(arbcolegio.getPresidenteT().getArnombre()).append(" ").append(this.appMessageSource
				.getMessage("plantilla.arbitraje.presidentebopv", null, new Locale(Y41bConstantes.EUSKERA)));

		if (tramiteColegio.getTrintica().equals("3")) {
			textoBopvCas.append(", ").append(arbcolegio.getConsumidorT().getArnombre()).append(" ")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.y", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(" ").append(arbcolegio.getEmpresarialT().getArnombre());

			textoBopvEus.append(", ").append(arbcolegio.getConsumidorT().getArnombre()).append(" ")
					.append(this.appMessageSource.getMessage("plantilla.arbitraje.y", null,
							new Locale(Y41bConstantes.EUSKERA)))
					.append(" ").append(arbcolegio.getEmpresarialT().getArnombre());
		}

		plantillaTramiteARBDetalle.setColegioBopvCas(textoBopvCas.toString());
		plantillaTramiteARBDetalle.setColegioBopvEus(textoBopvEus.toString());
	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteCitacionAudiencia
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosCitacionAudiencia(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteCitacionAudiencia) throws ParseException {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(plantillaTramiteARBDetalle.getExcodigo());

		if (!tramiteCitacionAudiencia.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA)) {
			// citacion 1 audiencia
			if (tramiteCitacionAudiencia.getTrfeccitacion() != null) {
				// DAtos audiencia
				plantillaTramiteARBDetalle.setFechaCitacionAudienciaCas(
						Y41bUtils.formatearDateToString(tramiteCitacionAudiencia.getTrfeccitacion(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaCitacionAudienciaEus(
						Y41bUtils.formatearDateToStringEuskera(tramiteCitacionAudiencia.getTrfeccitacion(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			if (tramiteCitacionAudiencia.getTrhoracitacion() != null) {
				plantillaTramiteARBDetalle
						.setHoraAudiencia(plantillaTramiteARBDetalle.getArbtramexp().getTrhoracitacion());
			}
			if (tramiteCitacionAudiencia.getTrclugaud() != null) {
				Tclugaud lugar = new Tclugaud();
				lugar.setT4codigo(tramiteCitacionAudiencia.getTrclugaud());
				lugar = this.tclugaudDao.find(lugar);
				plantillaTramiteARBDetalle.setLugarAudienciaCas(lugar.getT4nombre());
				plantillaTramiteARBDetalle.setLugarAudienciaEus(lugar.getT4nombre());
				plantillaTramiteARBDetalle.setDirLugarAudienciaCas(this.dameLineaDireccion(lugar.getT4noraCalleId(),
						lugar.getT4noraPortalId(), lugar.getT4nombrePiso(), Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setDirLugarAudienciaEus(this.dameLineaDireccion(lugar.getT4noraCalleId(),
						lugar.getT4noraPortalId(), lugar.getT4nombrePiso(), Y41bConstantes.EUSKERA));

				plantillaTramiteARBDetalle.setTerLugarAudiencia(this.dameTerritorio(lugar.getT4noraProvinciaId()));

				StringBuffer loc = new StringBuffer();
				loc.append(lugar.getT4noraCpId());
				loc.append(" ");
				loc.append(this.dameLocalidad(lugar.getT4noraLocalidadId(), lugar.getT4noraMunicipioId(),
						lugar.getT4noraProvinciaId()));
				plantillaTramiteARBDetalle.setLocLugarAudiencia(loc.toString());
			}

			// cogemos los datos de la audiciencia (fecha)

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteAudiencia = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteAudiencia != null && lTramiteAudiencia.size() > 0) {
				Arbtramexp tramiteAudiencia = lTramiteAudiencia.get(0);
				ArbexpServiceUtil.rellenaPropiosAudiencia(plantillaTramiteARBDetalle, tramiteAudiencia);
			}

		} else {
			// citacion 2 audiencia
			if (tramiteCitacionAudiencia.getTrfeccitacion() != null) {
				// DAtos audiencia
				plantillaTramiteARBDetalle.setFechaCitacionAudiencia2Cas(
						Y41bUtils.formatearDateToString(tramiteCitacionAudiencia.getTrfeccitacion(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaCitacionAudiencia2Eus(
						Y41bUtils.formatearDateToStringEuskera(tramiteCitacionAudiencia.getTrfeccitacion(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}
			if (tramiteCitacionAudiencia.getTrhoracitacion() != null) {
				plantillaTramiteARBDetalle
						.setHoraAudiencia2(plantillaTramiteARBDetalle.getArbtramexp().getTrhoracitacion());
			}
			if (tramiteCitacionAudiencia.getTrclugaud() != null) {
				Tclugaud lugar = new Tclugaud();
				lugar.setT4codigo(tramiteCitacionAudiencia.getTrclugaud());
				lugar = this.tclugaudDao.find(lugar);
				plantillaTramiteARBDetalle.setLugarAudiencia2Cas(lugar.getT4nombre());
				plantillaTramiteARBDetalle.setLugarAudiencia2Eus(lugar.getT4nombre());
				plantillaTramiteARBDetalle.setDirLugarAudiencia2Cas(this.dameLineaDireccion(lugar.getT4noraCalleId(),
						lugar.getT4noraPortalId(), lugar.getT4nombrePiso(), Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setDirLugarAudiencia2Eus(this.dameLineaDireccion(lugar.getT4noraCalleId(),
						lugar.getT4noraPortalId(), lugar.getT4nombrePiso(), Y41bConstantes.EUSKERA));

				plantillaTramiteARBDetalle.setTerLugarAudiencia(this.dameTerritorio(lugar.getT4noraProvinciaId()));

				StringBuffer loc = new StringBuffer();
				loc.append(lugar.getT4noraCpId());
				loc.append(" ");
				loc.append(this.dameLocalidad(lugar.getT4noraLocalidadId(), lugar.getT4noraMunicipioId(),
						lugar.getT4noraProvinciaId()));
				plantillaTramiteARBDetalle.setLocLugarAudiencia2(loc.toString());

			}

			// cogemos los datos de la audiciencia 2 (fecha)

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_2AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteAudiencia = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteAudiencia != null && lTramiteAudiencia.size() > 0) {
				Arbtramexp tramiteAudiencia = lTramiteAudiencia.get(0);
				ArbexpServiceUtil.rellenaPropiosAudiencia2(plantillaTramiteARBDetalle, tramiteAudiencia);
			}

		}
	}

	/**
	 * rellenaPropiosCitacion2Audiencia cuando en la misma plantilla tenemos
	 * datos de primera y segunda audiencia
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteCitacionAudiencia
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosCitacion2Audiencia(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteCitacionAudiencia) throws ParseException {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(plantillaTramiteARBDetalle.getExcodigo());

		if (tramiteCitacionAudiencia.getTrfeccitacion() != null) {
			// DAtos audiencia
			plantillaTramiteARBDetalle.setFechaCitacionAudiencia2Cas(
					Y41bUtils.formatearDateToString(tramiteCitacionAudiencia.getTrfeccitacion(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaCitacionAudiencia2Eus(
					Y41bUtils.formatearDateToStringEuskera(tramiteCitacionAudiencia.getTrfeccitacion(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}
		if (tramiteCitacionAudiencia.getTrhoracitacion() != null) {
			plantillaTramiteARBDetalle
					.setHoraAudiencia2(plantillaTramiteARBDetalle.getArbtramexp().getTrhoracitacion());
		}
		if (tramiteCitacionAudiencia.getTrclugaud() != null) {
			Tclugaud lugar = new Tclugaud();
			lugar.setT4codigo(tramiteCitacionAudiencia.getTrclugaud());
			lugar = this.tclugaudDao.find(lugar);
			plantillaTramiteARBDetalle.setLugarAudiencia2Cas(lugar.getT4nombre());
			plantillaTramiteARBDetalle.setLugarAudiencia2Eus(lugar.getT4nombre());
			plantillaTramiteARBDetalle.setDirLugarAudiencia2Cas(this.dameLineaDireccion(lugar.getT4noraCalleId(),
					lugar.getT4noraPortalId(), lugar.getT4nombrePiso(), Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setDirLugarAudiencia2Eus(this.dameLineaDireccion(lugar.getT4noraCalleId(),
					lugar.getT4noraPortalId(), lugar.getT4nombrePiso(), Y41bConstantes.EUSKERA));
			StringBuffer loc = new StringBuffer();
			loc.append(lugar.getT4noraCpId());
			loc.append(" ");
			loc.append(this.dameLocalidad(lugar.getT4noraLocalidadId(), lugar.getT4noraMunicipioId(),
					lugar.getT4noraProvinciaId()));
			plantillaTramiteARBDetalle.setLocLugarAudiencia2(loc.toString());
		}

		// cogemos los datos de la audiciencia 2 (fecha)

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_2AUDIENCIA);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		arbtramexp.setSolarb(solarb);
		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteAudiencia = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteAudiencia != null && lTramiteAudiencia.size() > 0) {
			Arbtramexp tramiteAudiencia = lTramiteAudiencia.get(0);
			ArbexpServiceUtil.rellenaPropiosAudiencia2(plantillaTramiteARBDetalle, tramiteAudiencia);
		}
	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteCitacionAPrueba
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosCitacionPrueba(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteCitacionAPrueba) throws ParseException {

		// Objeto de la prueba
		Arbtramexp arbTramExpAux = (Arbtramexp) this.arbtramexpDao.find(tramiteCitacionAPrueba);
		plantillaTramiteARBDetalle.setObjetoPrueba(Y41bUtils.clobToString(arbTramExpAux.getTrobjeto()));

		// perito
		Empper empper = new Empper();
		empper.setPecodigo(tramiteCitacionAPrueba.getTrcope1());
		empper = this.empperDao.find(empper);
		if (empper != null && empper.getPenombre() != null) {
			plantillaTramiteARBDetalle.setPeritoNombre(empper.getPenombre());
		} else {
			plantillaTramiteARBDetalle.setPeritoNombre("");
		}

		// A instancia de
		if (tramiteCitacionAPrueba.getTrainstanciade() != null) {
			Arbainstancia arbainstancia = new Arbainstancia();
			arbainstancia.setAicodigo(tramiteCitacionAPrueba.getTrainstanciade());
			arbainstancia = this.arbainstanciaDao.find(arbainstancia);
			StringBuffer texto = new StringBuffer("");
			if (Y41bConstantes.TIPO_ARBINSTANCIA_RECLAMANTE.equals(arbainstancia.getAicodigo())) {
				texto.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamante", null,
						new Locale(Y41bConstantes.EUSKERA)))
						.append(" / ")
						.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamante", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(plantillaTramiteARBDetalle.getNombreReclamante());
			} else if (Y41bConstantes.TIPO_ARBINSTANCIA_RECLAMADO.equals(arbainstancia.getAicodigo())) {
				texto.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamado", null,
						new Locale(Y41bConstantes.EUSKERA)))
						.append(" / ")
						.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamado", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(plantillaTramiteARBDetalle.getNombreReclamado());
			} else if (Y41bConstantes.TIPO_ARBINSTANCIA_AMBOS.equals(arbainstancia.getAicodigo())) {
				texto.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamante", null,
						new Locale(Y41bConstantes.EUSKERA)))
						.append(" / ")
						.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamante", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(plantillaTramiteARBDetalle.getNombreReclamante());
				texto.append("\\\\par ");
				texto.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamado", null,
						new Locale(Y41bConstantes.EUSKERA)))
						.append(" / ")
						.append(this.appMessageSource.getMessage("arbitraje.audiencia.reclamado", null,
								new Locale(Y41bConstantes.CASTELLANO)))
						.append(": ").append(plantillaTramiteARBDetalle.getNombreReclamado());
			} /*
				 * else if (Y41bConstantes.TIPO_ARBINSTANCIA_OFICIO
				 * .equals(arbainstancia.getAicodigo())) {
				 * texto.append(arbainstancia.getAitextoeu()).append(" / ")
				 * .append(arbainstancia.getAitextoes()).append(": "); }
				 */

			plantillaTramiteARBDetalle.setAInstanciaDeNombre(texto.toString());

			texto.setLength(0);
			texto.append(arbainstancia.getAitextoeu());
			plantillaTramiteARBDetalle.setAInstanciaDeNombreEus(texto.toString());
			texto.setLength(0);

			texto.append(arbainstancia.getAitextoes());
			plantillaTramiteARBDetalle.setAInstanciaDeNombreCas(texto.toString());
			texto.setLength(0);
		}

		// Fecha de la prueba
		if (tramiteCitacionAPrueba.getTrfeccitacion() != null) {
			plantillaTramiteARBDetalle
					.setFechaPruebaCas(Y41bUtils.formatearDateToString(tramiteCitacionAPrueba.getTrfeccitacion(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle
					.setFechaPruebaEus(Y41bUtils.formatearDateToStringEuskera(tramiteCitacionAPrueba.getTrfeccitacion(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}
		// Hora de la prueba
		if (tramiteCitacionAPrueba.getTrhoracitacion() != null) {
			plantillaTramiteARBDetalle.setHoraPrueba(tramiteCitacionAPrueba.getTrhoracitacion());
		}
		// Lugar
		plantillaTramiteARBDetalle
				.setDirLugarPruebaCas(this.dameLineaDireccion(tramiteCitacionAPrueba.getTrnoraCalleId(),
						plantillaTramiteARBDetalle.getArbtramexp().getTrnoraPortalId(),
						plantillaTramiteARBDetalle.getArbtramexp().getTrnombrePiso(), Y41bConstantes.CASTELLANO));
		plantillaTramiteARBDetalle
				.setDirLugarPruebaEus(this.dameLineaDireccion(tramiteCitacionAPrueba.getTrnoraCalleId(),
						plantillaTramiteARBDetalle.getArbtramexp().getTrnoraPortalId(),
						plantillaTramiteARBDetalle.getArbtramexp().getTrnombrePiso(), Y41bConstantes.EUSKERA));
		StringBuffer loc = new StringBuffer();
		loc.append(tramiteCitacionAPrueba.getTrnoraCpId());
		loc.append(" ");
		loc.append(this.dameMunicipio(tramiteCitacionAPrueba.getTrnoraProvinciaId(),
				tramiteCitacionAPrueba.getTrnoraMunicipioId()));
		plantillaTramiteARBDetalle.setLocLugarPrueba(loc.toString());

		// realizada por Perito/colegio
		if (tramiteCitacionAPrueba.getTrrealizadapor() != null) {
			if (tramiteCitacionAPrueba.getTrrealizadapor().equals(Y41bConstantes.ARB_PRUEBA_REALIZADOPOR_COLEGIO)) {

				plantillaTramiteARBDetalle.setRealizadaPorEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.prueba.colegio", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setRealizadaPorCas(this.appMessageSource
						.getMessage("plantilla.arbitraje.prueba.colegio", null, new Locale(Y41bConstantes.CASTELLANO)));

			} else if (tramiteCitacionAPrueba.getTrrealizadapor()
					.equals(Y41bConstantes.ARB_PRUEBA_REALIZADOPOR_PERITO)) {
				plantillaTramiteARBDetalle.setRealizadaPorEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.prueba.perito", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setRealizadaPorCas(this.appMessageSource
						.getMessage("plantilla.arbitraje.prueba.perito", null, new Locale(Y41bConstantes.CASTELLANO)));
			} else {
				plantillaTramiteARBDetalle.setRealizadaPorEus("");

				plantillaTramiteARBDetalle.setRealizadaPorCas("");
			}
		} else {
			plantillaTramiteARBDetalle.setRealizadaPorEus("");

			plantillaTramiteARBDetalle.setRealizadaPorCas("");
		}

	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteAceptacionArb
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosAceptacionArbitraje(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteAceptacionArb) throws ParseException {

		// Fecha de la prueba
		if (tramiteAceptacionArb.getTrfecrecepcion() != null) {
			plantillaTramiteARBDetalle
					.setFechaAceptacionArbCas(Y41bUtils.formatearDateToString(tramiteAceptacionArb.getTrfecrecepcion(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaAceptacionArbEus(
					Y41bUtils.formatearDateToStringEuskera(tramiteAceptacionArb.getTrfecrecepcion(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPagoLaudo(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		if (plantillaTramiteARBDetalle.getArbtramexp() != null && (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO
						.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				Arbtramexp tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, true, false);

			}

			arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteLaudo = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteLaudo != null && lTramiteLaudo.size() > 0) {
				Arbtramexp tramiteLaudo = lTramiteLaudo.get(0);
				this.rellenaPropiosLaudo(solarb, plantillaTramiteARBDetalle, tramiteLaudo);

			}

		}
	}

	/**
	 * @param solarb
	 *            Solarb
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteLaudo
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosLaudo(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteLaudo) throws ParseException {

		// los datos del propio Laudo

		// Fecha del Laudo
		if (tramiteLaudo.getTrresofecha() != null) {
			plantillaTramiteARBDetalle.setFechaLaudoCas(Y41bUtils.formatearDateToString(tramiteLaudo.getTrresofecha(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaLaudoEus(Y41bUtils.formatearDateToStringEuskera(
					tramiteLaudo.getTrresofecha(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

		// Resultado del laudo y accion laudo segun decisin.
		if (Y41bUtils.isFilled(tramiteLaudo.getTrresultado())) {

			LaudosTipo laudosTipo = new LaudosTipo();
			laudosTipo.setL21r3codigo(tramiteLaudo.getTrresultado());
			laudosTipo = this.laudosTipoDao.find(laudosTipo);
			if (laudosTipo != null) {

				plantillaTramiteARBDetalle
						.setResultadoLaudoCas(laudosTipo.getL21r3tipoc() != null ? laudosTipo.getL21r3tipoc() : "");
				plantillaTramiteARBDetalle
						.setResultadoLaudoEus(laudosTipo.getL21r3tipoe() != null ? laudosTipo.getL21r3tipoe() : "");
			} else {
				plantillaTramiteARBDetalle.setResultadoLaudoCas("");
				plantillaTramiteARBDetalle.setResultadoLaudoEus("");
			}

			if (tramiteLaudo.getTrresultado().equals(Y41bConstantes.ARB_LAUDO_RDO_ESTIMADO)) {

				plantillaTramiteARBDetalle.setResultadoLaudoTxtCas(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoestima", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteARBDetalle.setResultadoLaudoTxtEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoestima", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setAccionLaudoTxtCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.laudoaccionpagar", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteARBDetalle.setAccionLaudoTxtEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoaccionpagar", null, new Locale(Y41bConstantes.EUSKERA)));

			} else if (tramiteLaudo.getTrresultado().equals(Y41bConstantes.ARB_LAUDO_RDO_DESESTIMADO)) {

				plantillaTramiteARBDetalle.setResultadoLaudoTxtCas(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudodesestima", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteARBDetalle.setResultadoLaudoTxtEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudodesestima", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setAccionLaudoTxtCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.laudoaccionabonar", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteARBDetalle.setAccionLaudoTxtEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoaccionabonar", null, new Locale(Y41bConstantes.EUSKERA)));

			} else if (tramiteLaudo.getTrresultado().equals(Y41bConstantes.ARB_LAUDO_RDO_PARCIAL)) {

				plantillaTramiteARBDetalle.setResultadoLaudoTxtCas(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoparcial", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteARBDetalle.setResultadoLaudoTxtEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoparcial", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setAccionLaudoTxtCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.laudoaccionpagar", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteARBDetalle.setAccionLaudoTxtEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.laudoaccionpagar", null, new Locale(Y41bConstantes.EUSKERA)));

			} else {
				plantillaTramiteARBDetalle.setResultadoLaudoTxtCas("");
				plantillaTramiteARBDetalle.setResultadoLaudoTxtEus("");
				plantillaTramiteARBDetalle.setAccionLaudoTxtCas("");
				plantillaTramiteARBDetalle.setAccionLaudoTxtEus("");
			}
		} else {
			plantillaTramiteARBDetalle.setResultadoLaudoTxtCas("");
			plantillaTramiteARBDetalle.setResultadoLaudoTxtEus("");
			plantillaTramiteARBDetalle.setAccionLaudoTxtCas("");
			plantillaTramiteARBDetalle.setAccionLaudoTxtEus("");
			plantillaTramiteARBDetalle.setResultadoLaudoCas("");
			plantillaTramiteARBDetalle.setResultadoLaudoEus("");
		}

		// importe del laudo

		if (tramiteLaudo.getTrresoimporte() != null) {

			plantillaTramiteARBDetalle.setResoImporte(
					Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(tramiteLaudo.getTrresoimporte().doubleValue()));

			plantillaTramiteARBDetalle.setResoImporteTxtCas(
					Y41bNumberToLetterConverter.convertNumberToLetter(tramiteLaudo.getTrresoimporte().doubleValue()));

		} else {
			plantillaTramiteARBDetalle.setResoImporte("0");
			plantillaTramiteARBDetalle.setResoImporteTxtCas("");
			plantillaTramiteARBDetalle.setResoImporteTxtEus("");
		}

		// MODO DEL LAUDO
		if (tramiteLaudo.getTrmodolaudo() != null) {

			LaudosAdoptado laudosadoptado = new LaudosAdoptado();
			laudosadoptado.setL21r4codigo(tramiteLaudo.getTrmodolaudo());
			laudosadoptado = this.laudosAdoptadoDao.find(laudosadoptado);
			if (laudosadoptado != null) {
				plantillaTramiteARBDetalle.setModoLaudoCas(laudosadoptado.getL21r4adoptadoc());
				plantillaTramiteARBDetalle.setModoLaudoEus(laudosadoptado.getL21r4adoptadoe());
			} else {
				plantillaTramiteARBDetalle.setModoLaudoCas("");
				plantillaTramiteARBDetalle.setModoLaudoEus("");
			}
		} else {
			plantillaTramiteARBDetalle.setModoLaudoCas("");
			plantillaTramiteARBDetalle.setModoLaudoEus("");
		}

		// DECISION ARBITRAL
		if (tramiteLaudo.getTrdecision() != null) {
			plantillaTramiteARBDetalle.setDecisionArbitral(Y41bUtils.clobToString(tramiteLaudo.getTrdecision()));
		} else {
			plantillaTramiteARBDetalle.setDecisionArbitral("");
		}

	}

	/**
	 * @param sacodigo
	 *            String
	 * @return Organismo
	 */
	public Organismo dameNombreOrganismo(String sacodigo) {
		Organismo resultado = null;
		try {
			Arbexp arbexp = this.arbexpDao.find(new Arbexp(sacodigo));
			resultado = this.organismoDao.find(new Organismo(arbexp.getExcoorg()));
		} catch (Exception e) {
			resultado = null;
		}
		return resultado;

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaAclaracion(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		if (plantillaTramiteARBDetalle.getArbtramexp() != null && (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
						.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				Arbtramexp tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, true, false, false, false);

			}

			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
				Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);
				this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);
			}

			// rellena propios de la aclaracion
			// Fecha de la recepcin
			if (plantillaTramiteARBDetalle.getArbtramexp().getTrfecrecepcion() != null) {
				plantillaTramiteARBDetalle.setFechaAclaracionCas(
						Y41bUtils.formatearDateToString(plantillaTramiteARBDetalle.getArbtramexp().getTrfecrecepcion(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaAclaracionEus(Y41bUtils.formatearDateToStringEuskera(
						plantillaTramiteARBDetalle.getArbtramexp().getTrfecrecepcion(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			// interviniente origen.hay que encontrar primero el tramite de
			// recepcin de aclaracin
			this.rellenaPropiosAclaracion(plantillaTramiteARBDetalle, plantillaTramiteARBDetalle.getArbtramexp(),
					solarb);

		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaNotificacion(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		// if (plantillaTramiteARBDetalle.getArbtramexp() != null
		// && (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION
		// .equals(plantillaTramiteARBDetalle.getArbtramexp()
		// .getTrcodigo()))) {

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ANALISIS_EMPRESA);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteAnalisis = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteAnalisis != null && lTramiteAnalisis.size() > 0) {
			Arbtramexp tramiteAnalisis = lTramiteAnalisis.get(0);
			this.rellenaPropiosAnalisisEmpresa(plantillaTramiteARBDetalle, tramiteAnalisis);

		}

		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
			Arbtramexp tramiteColegio = lTramiteColegio.get(0);
			this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, false, false);
		}

		// datos pago pericial
		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramitePagoPericial = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramitePagoPericial != null && lTramitePagoPericial.size() > 0) {
			Arbtramexp tramitePagoPericial = lTramitePagoPericial.get(0);
			this.rellenaPropiosPagoPericial(plantillaTramiteARBDetalle, tramitePagoPericial);
		}

		// los datos para cuando hay citacin a prueba
		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteCitacionPrueba = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteCitacionPrueba != null && lTramiteCitacionPrueba.size() > 0) {
			Arbtramexp tramiteCitacionPrueba = lTramiteCitacionPrueba.get(0);
			this.rellenaPropiosCitacionPrueba(plantillaTramiteARBDetalle, tramiteCitacionPrueba);

		}

		// citacion audiencia
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
			Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);

			this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);
		}

		// buscamos la fecha de notificacion de aceptacion de arbitraje para

		this.rellenaFechaNotificacionArbitraje(plantillaTramiteARBDetalle, solarb);

		// }
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaComunicacion(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		// if (plantillaTramiteARBDetalle.getArbtramexp() != null
		// && (Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION
		// .equals(plantillaTramiteARBDetalle.getArbtramexp()
		// .getTrcodigo()))) {

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ANALISIS_EMPRESA);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteAnalisis = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteAnalisis != null && lTramiteAnalisis.size() > 0) {
			Arbtramexp tramiteAnalisis = lTramiteAnalisis.get(0);
			this.rellenaPropiosAnalisisEmpresa(plantillaTramiteARBDetalle, tramiteAnalisis);

		}

		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
			Arbtramexp tramiteColegio = lTramiteColegio.get(0);
			this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, false, false);
		}

		// DATOS LAUDO
		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteLaudo = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteLaudo != null && lTramiteLaudo.size() > 0) {
			Arbtramexp tramiteLaudo = lTramiteLaudo.get(0);

			this.rellenaPropiosLaudo(solarb, plantillaTramiteARBDetalle, tramiteLaudo);

		}

		// }
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaElaboracionBOPV(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		if (plantillaTramiteARBDetalle.getArbtramexp() != null && (Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {

			// tengo que buscar el trmite de notificacion

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteLaudo = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteLaudo != null && lTramiteLaudo.size() > 0) {
				Arbtramexp tramiteLaudo = lTramiteLaudo.get(0);
				this.rellenaPropiosLaudo(solarb, plantillaTramiteARBDetalle, tramiteLaudo);

			}

			// campos del colegio
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteColegio = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteColegio != null && lTramiteColegio.size() > 0) {
				Arbtramexp tramiteColegio = lTramiteColegio.get(0);
				this.rellenaCamposTramiteColegio(plantillaTramiteARBDetalle, tramiteColegio, false, false, false, true);

			}

			// datos para acta de audiencia del trmite de citacin audiencia.
			// (lugar)
			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			List<Arbtramexp> lTramiteCitacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteCitacion != null && lTramiteCitacion.size() > 0) {
				Arbtramexp tramiteCitacion = lTramiteCitacion.get(0);
				this.rellenaPropiosCitacionAudiencia(plantillaTramiteARBDetalle, tramiteCitacion);
			}

			// como dato propio hay que buscar el notificado.
			// buscar la notificacion del laudo
			arbtramexp = new Arbtramexp();
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
			arbtramexp.setTrid(plantillaTramiteARBDetalle.getArbtramexp().getTrtridrel());

			// DUDA si dejarlo solamente filtrado por el id que manda el acuse o
			// afinar con el laudo. de momento sin afinar.
			// arbtramexp
			// .setTrtiponotplatea(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_LAUDO);

			arbtramexp.setSolarb(solarb);
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");
			Arbtramexp tramiteNotificacionLaudo = this.arbtramexpDao.find(arbtramexp);
			if (tramiteNotificacionLaudo != null && tramiteNotificacionLaudo.getTruaidinterv() != null) {

				// buscamos el interviniente destino de la notificacion sobre la
				// que se est haciendo la bopv
				Arbinterv notificado = new Arbinterv(tramiteNotificacionLaudo.getTruaidinterv());
				notificado = this.arbintervDao.find(notificado);
				if (notificado != null) {
					plantillaTramiteARBDetalle.setNotificadoNombre(notificado.getUanombre());
					plantillaTramiteARBDetalle.setNotificadoNif(Y41bUtils.trataNull(notificado.getUanif()));
				}

			}

		}
	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteAnalisis
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosAnalisisEmpresa(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteAnalisis) throws ParseException {

		// A instancia de
		if (tramiteAnalisis.getTranalisis() != null) {

			// if (plantillaTramiteARBDetalle.getArbtramexp() != null
			// && (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION
			// .equals(plantillaTramiteARBDetalle.getArbtramexp()
			// .getTrcodigo()))) {
			// Analisis A
			if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_A.equals(tramiteAnalisis.getTranalisis())) {

				plantillaTramiteARBDetalle.setRdoAnalisisTextoEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.notif.analisis.A", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setRdoAnalisisTextoCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.notif.analisis.A", null, new Locale(Y41bConstantes.CASTELLANO)));
				// Analisis C
			} else if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_C.equals(tramiteAnalisis.getTranalisis())) {

				plantillaTramiteARBDetalle.setRdoAnalisisTextoEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.notif.analisis.C", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setRdoAnalisisTextoCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.notif.analisis.C", null, new Locale(Y41bConstantes.CASTELLANO)));
				// Analisis B
			} else if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_B.equals(tramiteAnalisis.getTranalisis())) {

				plantillaTramiteARBDetalle.setRdoAnalisisTextoEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.notif.analisis.B", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setRdoAnalisisTextoCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.notif.analisis.B", null, new Locale(Y41bConstantes.CASTELLANO)));
				// Analisis D
			} else if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_D.equals(tramiteAnalisis.getTranalisis())) {

				plantillaTramiteARBDetalle.setRdoAnalisisTextoEus(this.appMessageSource
						.getMessage("plantilla.arbitraje.notif.analisis.D", null, new Locale(Y41bConstantes.EUSKERA)));

				plantillaTramiteARBDetalle.setRdoAnalisisTextoCas(this.appMessageSource.getMessage(
						"plantilla.arbitraje.notif.analisis.D", null, new Locale(Y41bConstantes.CASTELLANO)));
			} else {
				plantillaTramiteARBDetalle.setRdoAnalisisTextoEus("");
				plantillaTramiteARBDetalle.setRdoAnalisisTextoCas("");
			}
		}

	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramitePagoPericial
	 *            Arbtramexp
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosPagoPericial(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramitePagoPericial) throws ParseException {

		plantillaTramiteARBDetalle.setNumFactura(tramitePagoPericial.getTrreffactura());
		if (tramitePagoPericial.getTrimporte() != null) {
			plantillaTramiteARBDetalle.setImporteFactura(
					Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(tramitePagoPericial.getTrimporte().doubleValue()));
		}

		// Fecha factura
		plantillaTramiteARBDetalle
				.setFechaFacturaPericialCas(Y41bUtils.formatearDateToString(tramitePagoPericial.getTrfecemision(),
						Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteARBDetalle.setFechaFacturaPericialEus(
				Y41bUtils.formatearDateToStringEuskera(tramitePagoPericial.getTrfecemision(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

		// perito
		if (tramitePagoPericial.getTrcope1() != null) {
			Empper empper = new Empper();
			empper.setPecodigo(tramitePagoPericial.getTrcope1());
			empper = this.empperDao.find(empper);
			plantillaTramiteARBDetalle.setPeritoNombre(empper.getPenombre());
		}
	}

	/**
	 * rellenaMediacion
	 * 
	 * @param solarb
	 *            Solarb
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaMediacion(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws ParseException {

		// Si el tramite actual es mediacion se saca del tramite
		if (plantillaTramiteARBDetalle.getArbtramexp() != null && Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo())) {
			plantillaTramiteARBDetalle.setResumenMediacion(
					Y41bUtils.clobToString(plantillaTramiteARBDetalle.getArbtramexp().getTrresumen()));
		} else { // en caso contrario del ultimo tramite de mediacion tramitado
			Arbtramexp tramiteMediacion = null;

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");

			List<Arbtramexp> lTramiteMediacion = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteMediacion != null && lTramiteMediacion.size() > 0) {
				tramiteMediacion = lTramiteMediacion.get(0);
			}

			if (tramiteMediacion != null && tramiteMediacion.getTrresumen() != null) {
				plantillaTramiteARBDetalle.setResumenMediacion(Y41bUtils.clobToString(tramiteMediacion.getTrresumen()));
			}
		}
	}

	/**
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param tramiteAclaracion
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @throws ParseException
	 *             ex
	 */
	private void rellenaPropiosAclaracion(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle,
			Arbtramexp tramiteAclaracion, Solarb solarb) throws ParseException {

		// interviniente origen.hay que encontrar primero el tramite de
		// recepcin de aclaracin

		// si estamos en el de recepcin no tenemos que buscar el trmite porque
		// ya lo tenemos.
		// y si estamos en la aclaracin tenemos que buscar el de recepcin
		Arbtramexp tramiteRecepcion = null;
		if (plantillaTramiteARBDetalle.getArbtramexp() != null
				&& (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
						.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {
			tramiteRecepcion = tramiteAclaracion;
		} else if (plantillaTramiteARBDetalle.getArbtramexp() != null && (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION
				.equals(plantillaTramiteARBDetalle.getArbtramexp().getTrcodigo()))) {

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexp.setTrid(tramiteAclaracion.getTrtridrel());
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN ");
			pagination.setSord("desc");

			List<Arbtramexp> lTramiteRecepcin = this.arbtramexpDao.findAll(arbtramexp, pagination);
			if (lTramiteRecepcin != null && lTramiteRecepcin.size() > 0) {
				tramiteRecepcion = lTramiteRecepcin.get(0);
			}
		}

		if (tramiteRecepcion != null && tramiteRecepcion.getTrintervorigen() != null) {

			Arbinterv arbintervorigen = new Arbinterv(tramiteRecepcion.getTrintervorigen());
			arbintervorigen = this.arbintervDao.find(arbintervorigen);
			if (arbintervorigen != null) {
				plantillaTramiteARBDetalle.setPresentadoPorNombre(arbintervorigen.getUanombre());

				if (arbintervorigen.getUatipointerv() != null
						&& Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbintervorigen.getUatipointerv())) {

					plantillaTramiteARBDetalle.setAlegacionOrigenCas(this.appMessageSource
							.getMessage("plantilla.arbitraje.reclamado", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteARBDetalle.setAlegacionOrigenEus(this.appMessageSource
							.getMessage("plantilla.arbitraje.reclamado", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (arbintervorigen.getUatipointerv() != null
						&& Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbintervorigen.getUatipointerv())) {

					plantillaTramiteARBDetalle.setAlegacionOrigenCas(this.appMessageSource
							.getMessage("plantilla.arbitraje.reclamante", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteARBDetalle.setAlegacionOrigenEus(this.appMessageSource
							.getMessage("plantilla.arbitraje.reclamante", null, new Locale(Y41bConstantes.EUSKERA)));

				} else {
					plantillaTramiteARBDetalle.setAlegacionOrigenCas("");
					plantillaTramiteARBDetalle.setAlegacionOrigenEus("");
				}

			} else {
				plantillaTramiteARBDetalle.setPresentadoPorNombre("");
				plantillaTramiteARBDetalle.setAlegacionOrigenCas("");
				plantillaTramiteARBDetalle.setAlegacionOrigenEus("");
			}

		} else {
			plantillaTramiteARBDetalle.setPresentadoPorNombre("");
			plantillaTramiteARBDetalle.setAlegacionOrigenCas("");
			plantillaTramiteARBDetalle.setAlegacionOrigenEus("");
		}
	}

	/**
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @param solarb
	 *            Solarb
	 * @throws ParseException
	 *             ex
	 */
	void rellenaFechaNotificacionArbitraje(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle, Solarb solarb)
			throws ParseException {

		// no adheridas y no adheridas con limit.
		List<String> listaCodigosRelacionados = new ArrayList<String>();
		listaCodigosRelacionados.add(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA);
		listaCodigosRelacionados.add(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM);

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		// puede ser notificacion o comunicacion?
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// hay que buscar notificaciones de un resultado de analisis de no
		// adherida o adherido con limitaciones del destinatario de la
		// notificacion y quedarnos con el mas nuevo
		arbtramexp.setListaCodigosTramiteRelacionados(listaCodigosRelacionados);
		arbtramexp.setTipoIntervinienteDestino(Y41bConstantes.TIPO_INTERVINIENTEARB_CONSUMIDOR);
		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		List<Arbtramexp> lTramiteNotifRdoAnalisis = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteNotifRdoAnalisis != null && lTramiteNotifRdoAnalisis.size() > 0) {

			Arbtramexp tramiteNotif = lTramiteNotifRdoAnalisis.get(0);
			plantillaTramiteARBDetalle
					.setFechaNotifArbitrajeConsCas(Y41bUtils.formatearDateToString(tramiteNotif.getTrfecnotif(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaNotifArbitrajeConsEus(Y41bUtils.formatearDateToStringEuskera(
					tramiteNotif.getTrfecnotif(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

		arbtramexp.setListaCodigosTramiteRelacionados(listaCodigosRelacionados);
		arbtramexp.setTipoIntervinienteDestino(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO);
		lTramiteNotifRdoAnalisis = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteNotifRdoAnalisis != null && lTramiteNotifRdoAnalisis.size() > 0) {

			Arbtramexp tramiteNotif = lTramiteNotifRdoAnalisis.get(0);
			plantillaTramiteARBDetalle
					.setFechaNotifArbitrajeEstCas(Y41bUtils.formatearDateToString(tramiteNotif.getTrfecnotif(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaNotifArbitrajeEstEus(Y41bUtils.formatearDateToStringEuskera(
					tramiteNotif.getTrfecnotif(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

		// aqui buscamos la fecha para poner en la correccion de los que se les
		// envo notificacin de adherida cuando en realidad estaba en
		// limitacin/no adherida
		listaCodigosRelacionados = new ArrayList<String>();
		listaCodigosRelacionados.add(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA);
		arbtramexp.setListaCodigosTramiteRelacionados(listaCodigosRelacionados);
		arbtramexp.setTipoIntervinienteDestino(Y41bConstantes.TIPO_INTERVINIENTEARB_CONSUMIDOR);
		pagination = new Pagination();
		pagination.setSidx("TRFECFIN ");
		pagination.setSord("desc");
		lTramiteNotifRdoAnalisis = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteNotifRdoAnalisis != null && lTramiteNotifRdoAnalisis.size() > 0) {

			Arbtramexp tramiteNotif = lTramiteNotifRdoAnalisis.get(0);
			plantillaTramiteARBDetalle
					.setFechaNotifArbitrajeConsAdhCas(Y41bUtils.formatearDateToString(tramiteNotif.getTrfecnotif(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaNotifArbitrajeConsAdhEus(Y41bUtils.formatearDateToStringEuskera(
					tramiteNotif.getTrfecnotif(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

		arbtramexp.setTipoIntervinienteDestino(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO);
		lTramiteNotifRdoAnalisis = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (lTramiteNotifRdoAnalisis != null && lTramiteNotifRdoAnalisis.size() > 0) {

			Arbtramexp tramiteNotif = lTramiteNotifRdoAnalisis.get(0);
			plantillaTramiteARBDetalle
					.setFechaNotifArbitrajeEstAdhCas(Y41bUtils.formatearDateToString(tramiteNotif.getTrfecnotif(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaNotifArbitrajeEstAdhEus(Y41bUtils.formatearDateToStringEuskera(
					tramiteNotif.getTrfecnotif(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

	}

	/**
	 * tratamientoAnyadirIntervinienteSancionado
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	private Establecimiento tratamientoAnyadirIntervinienteSancionado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un sancionado a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

	/**
	 * Mtodo para actualizar el estado de adhesin del establecimiento
	 * 
	 * @param idExpediente
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	public void actualizarEstAdhEstablecimiento(String idExpediente) throws Exception {

		// Coger el cdigo del interviniente reclamado (establecemiento)
		Arbinterv reclamadoArb = this.arbintervDao.dameInterviniente(idExpediente,
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

		// Actualizar el estado de la adhesin del establecimiento
		this.arbexpDao.actualizarEstAdhEstablecimiento(idExpediente, reclamadoArb.getUaescodigo());
	}

}