package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbexpService  
 * 
 *  
 */

public interface ArbexpService {

	/**
	 * Inserts a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp add(Arbexp arbexp);

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp update(Arbexp arbexp);

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp find(Arbexp arbexp);

	/**
	 * Finds a List of rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbexp> findAll(Arbexp arbexp, Pagination pagination);

	/**
	 * Counts rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	Long findAllCount(Arbexp arbexp);

	/**
	 * Finds rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbexp> findAllLike(Arbexp arbexp, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbexp arbexp, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return
	 */
	void remove(Arbexp arbexp);

	/**
	 * Deletes multiple rows in the Arbexp table.
	 * 
	 * @param arbexpList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbexp> arbexpList);

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp dameDetallesExpediente(Arbexp arbexp);

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Arbinterv addInterviniente(Intervinientes intervinientes,
			CensoMonitor censomonitor);

	/**
	 * Borrado de un interviniente de un expediente
	 * 
	 * @param interviniente
	 *            Saninterv
	 */
	void removeInterviniente(Arbinterv interviniente);

	/**
	 * @param adjuntardocs
	 * @param tramiteComun
	 * @param tipoDocArb
	 */
	void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun,
			String tipoDocArb) throws Exception;

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @return List
	 */
	List<DatosMailOrigen> findAllMailOrigen(String idExpediente);

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	DatosMailOrigen findMailOrigen(String idExpediente,
			DatosMailOrigen datosMailOrigen);

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario,
			TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List<DatosMailSede>
	 */
	List<DatosMailSede> findAllMailEstablecimientoSede(
			TramiteComun tramiteComun, Arbinterv arbinterv,
			Pagination pagination);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun,
			DatosMailSede datosMailSede);

	/**
	 * Finds a List of rows in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailEstablecimiento> findAllMailEstablecimiento(
			TramiteComun tramiteComun, Arbinterv arbinterv,
			Pagination pagination);

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	Long findExpedientesAbiertos(Arbexp arbexp);

	/**
	 * dameNombreOrganismo
	 * 
	 * @param sacodigo
	 *            String
	 * @return Organismo
	 */
	Organismo dameNombreOrganismo(String sacodigo);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             the exception
	 */
	void updateTrasvaseTotalCambioInstructor(
			SolicitudCambioInstructor solicitudCambioInstructor)
			throws Exception;

	/**
	 * Mtodo para actualizar el estado de adhesin del establecimiento
	 * 
	 * @param idExpediente
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	void actualizarEstAdhEstablecimiento(String idExpediente) throws Exception;

}
