/**
 * 
 */
package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbitroDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.EmpperDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PlantillaTramiteARBDetalle;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * Arbexp2ServiceImpl  
 * 
 *  
 */

/**
 *  
 * 
 */
@Service(value = "arbexp2Service")
public class Arbexp2ServiceImpl implements Arbexp2Service {

	@Autowired()
	private ArbintervDao arbintervDao;

	@Autowired()
	private ArbitroDao arbitroDao;

	@Autowired()
	private EmpperDao empperDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private ArbtramexpDao arbtramexpDao;

	/**
	 * Rellena RequerimientoAcreditacionRepresentacion.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @throws exception
	 *             Y41bUDAException
	 */
	public void rellenaRequerimientoAcreditacionRepresentacion(Solarb solarb,
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) throws Y41bUDAException {
		Arbinterv representante = new Arbinterv();
		Arbinterv reclamado = new Arbinterv();
		Arbinterv reclamante = new Arbinterv();
		Arbtramexp reqAcredRepresentacion = new Arbtramexp();
		try {
			List<Arbtramexp> lreqAcredRepresentacion = null;
			reqAcredRepresentacion.setTrexcodigo(solarb.getSacodigo());
			reqAcredRepresentacion
					.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION);
			reqAcredRepresentacion.setSolarb(solarb);
			// reqAcredRepresentacion.setTrexcodigo(solarb.getSacodigo());
			lreqAcredRepresentacion = this.arbtramexpDao.findAll(reqAcredRepresentacion, null);
			if (lreqAcredRepresentacion != null && lreqAcredRepresentacion.size() > 0) {
				reqAcredRepresentacion = lreqAcredRepresentacion.get(0);
			}

			List<Arbinterv> representantes = null, reclamados = null, reclamantes = null;
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(reqAcredRepresentacion.getTipoDestOrigen())) {
				representantes = this.arbintervDao.findAllByTipo(solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
				reclamados = this.arbintervDao.findAllByTipo(solarb, Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
					.equals(reqAcredRepresentacion.getTipoDestOrigen())) {
				representantes = this.arbintervDao.findAllByTipo(solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
				reclamantes = this.arbintervDao.findAllByTipo(solarb, Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			}

			if (representantes != null && representantes.size() > 0) {
				representante = representantes.get(0);
				/*
				 * ALIMENTAR CAMPOS DE REPRESENTANTE (EL DE LA PARTICIPACION QUE
				 * CORRESPONDA)
				 */
				if (representante.getNombreCompleto() != null) {
					plantillaTramiteARBDetalle.setNombreRepresentante(representante.getNombreCompleto());
				} else {
					plantillaTramiteARBDetalle.setNombreRepresentante(representante.getUanombre().trim());
					if (representante.getUaapellido1() != null) {
						plantillaTramiteARBDetalle.setNombreRepresentante(plantillaTramiteARBDetalle
								.getNombreRepresentante().concat(" ").concat(representante.getUaapellido1().trim()));
					}
					if (representante.getUaapellido2() != null) {
						plantillaTramiteARBDetalle.setNombreRepresentante(plantillaTramiteARBDetalle
								.getNombreRepresentante().concat(" ").concat(representante.getUaapellido2().trim()));
					}
				}
				if (plantillaTramiteARBDetalle.getNombreRepresentante() != null) {
					plantillaTramiteARBDetalle
							.setNombreRepresentante(plantillaTramiteARBDetalle.getNombreRepresentante().toUpperCase());
				}
				if (representante.getUanif() != null) {
					plantillaTramiteARBDetalle.setCifRepresentante(representante.getUanif());
				}
				// } else {
				// throw new Exception();
			}
			if (reclamados != null && reclamados.size() > 0) {
				reclamado = reclamados.get(0);
				/*
				 * ALIMENTAR DESTINATARIO CON LOS DATOS DEL RECLAMADO
				 */
				if (reclamado.getUanombre() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(reclamado.getUanombre().trim());
				}
				if (reclamado.getUaapellido1() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen().concat(" ")
									.concat(reclamado.getUaapellido1().trim()));
				}
				if (reclamado.getUaapellido2() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen().concat(" ")
									.concat(reclamado.getUaapellido2().trim()));
				}
				if (plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen().toUpperCase());
				}
				if (plantillaTramiteARBDetalle.getDirReclamado() != null) {
					plantillaTramiteARBDetalle.setDireccionTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getDirReclamado().trim());
				}
				if (plantillaTramiteARBDetalle.getCpReclamado() != null) {
					plantillaTramiteARBDetalle
							.setCpTitularParticipacionOrigen(plantillaTramiteARBDetalle.getCpReclamado().trim());
				}
				if (plantillaTramiteARBDetalle.getLocReclamado() != null) {
					plantillaTramiteARBDetalle.setLocalidadTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getLocReclamado().trim());
				}
				if (plantillaTramiteARBDetalle.getProvReclamado() != null) {
					plantillaTramiteARBDetalle.setMunicipioTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getMunReclamado().trim());
				}
				if (plantillaTramiteARBDetalle.getProvReclamado() != null) {
					plantillaTramiteARBDetalle.setProvinciaTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getProvReclamado().trim());
				}
			}
			if (reclamantes != null && reclamantes.size() > 0) {
				reclamante = reclamantes.get(0);
				/*
				 * ALIMENTAR DESTINATARIO CON LOS DATOS DEL RECLAMANTE
				 */
				if (reclamante.getUanombre() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(reclamante.getUanombre().trim());
				}
				if (reclamante.getUaapellido1() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen().concat(" ")
									.concat(reclamante.getUaapellido1().trim()));
				}
				if (reclamante.getUaapellido2() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen().concat(" ")
									.concat(reclamante.getUaapellido2().trim()));
				}
				if (plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen() != null) {
					plantillaTramiteARBDetalle.setNombreTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getNombreTitularParticipacionOrigen().toUpperCase());
				}
				if (plantillaTramiteARBDetalle.getDirReclamante() != null) {
					plantillaTramiteARBDetalle.setDireccionTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getDirReclamante().trim());
				}
				if (plantillaTramiteARBDetalle.getCpReclamante() != null) {
					plantillaTramiteARBDetalle
							.setCpTitularParticipacionOrigen(plantillaTramiteARBDetalle.getCpReclamante().trim());
				}
				if (plantillaTramiteARBDetalle.getLocReclamante() != null) {
					plantillaTramiteARBDetalle.setLocalidadTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getLocReclamante().trim());
				}
				if (plantillaTramiteARBDetalle.getProvReclamante() != null) {
					plantillaTramiteARBDetalle.setMunicipioTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getMunReclamante().trim());
				}
				if (plantillaTramiteARBDetalle.getProvReclamante() != null) {
					plantillaTramiteARBDetalle.setProvinciaTitularParticipacionOrigen(
							plantillaTramiteARBDetalle.getProvReclamante().trim());
				}
			}

		} catch (Exception e) {
			throw new Y41bUDAException("error.tramiteRequerimientoAcreditacionRepresentacion.norepresentado", true,
					new Exception());
		}
	}

	/**
	 * cargaIntervinienteOrganismo
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Arbinterv
	 */
	public Arbinterv cargarIntervinienteOrganismo(Intervinientes intervinientes) {
		Arbinterv arbinterv = new Arbinterv();
		boolean insercion = false;
		/*
		 * ORGANISMO
		 */
		Organismo organismo = new Organismo();
		organismo.setEntidadId(intervinientes.getIdinterviniente());
		organismo = this.organismoDao.findOrganismoById(organismo);

		try {
			arbinterv = new Arbinterv();
			arbinterv.setUaentidadId(intervinientes.getIdinterviniente());
			arbinterv.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			arbinterv.setUaexcodigo(intervinientes.getIdExpediente());
			List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					arbinterv = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			arbinterv = null;
			insercion = true;
		}

		if (arbinterv == null) {
			arbinterv = new Arbinterv();
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		arbinterv.setSolarb(solarb);
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUanombre(organismo.getNombreEs());
		// arbinterv.setUacoem(establecimiento.getEscoem());
		arbinterv.setUanif(organismo.getCif());
		arbinterv.setUanrtel(organismo.getTelefono());
		arbinterv.setUanrtel2(null);
		arbinterv.setUaprovId(organismo.getNoraProvinciaId());
		arbinterv.setUamunId(organismo.getNoraMunicipioId());
		arbinterv.setUalocId(organismo.getNoraLocalidadId());
		arbinterv.setUacalleId(organismo.getNoraCalleId());
		// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
		// nombrecp
		// arbinterv.setUacpId(organismo.getNoraCpId());
		arbinterv.setUacpId(organismo.getNombreCp());
		arbinterv.setUaportalId(organismo.getNoraPortalId());
		if (organismo.getCompleDirec() != null && organismo.getCompleDirec().length() > Y41bConstantes.NUM_40) {
			arbinterv.setUanombrePiso(organismo.getCompleDirec().substring(0, Y41bConstantes.NUM_40));
		} else {
			arbinterv.setUanombrePiso(organismo.getCompleDirec());
		}
		if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraProvinciaId())
				|| (!Y41bConstantes.ARABA.equals(organismo.getNoraProvinciaId())
						&& !Y41bConstantes.BIZKAIA.equals(organismo.getNoraProvinciaId())
						&& !Y41bConstantes.GIPUZKOA.equals(organismo.getNoraProvinciaId()))) {
			arbinterv.setUadireNocapv(organismo.getNombreCalle());
		}
		arbinterv.setUadireAnt(organismo.getCompleDirec());
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_OTRO);
		arbinterv.setUaentidadId(organismo.getEntidadId());
		if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraPaisId())) {
			arbinterv.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
		} else {
			arbinterv.setUapaisId(organismo.getNoraPaisId());
		}
		arbinterv.setUaurl(organismo.getUrl());
		arbinterv.setUacoem(organismo.getEmail());

		arbinterv.setUafecultmod(null);
		arbinterv.setUausuultmod(null);

		if (!insercion) {
			this.arbintervDao.update(arbinterv);
		} else {
			this.arbintervDao.add(arbinterv);
		}

		return arbinterv;
	}

	/**
	 * cargarIntervinienteArbitro
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	public Arbinterv cargarIntervinienteArbitro(Intervinientes intervinientes, CensoMonitor censoMonitor) {
		Arbinterv arbinterv = new Arbinterv();
		boolean insercion = false;
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(intervinientes.getIdinterviniente());

		// Alta interviniente arbitro
		arbitro = this.arbitroDao.find(arbitro);

		try {
			arbinterv = new Arbinterv();
			arbinterv.setUaentidadId(intervinientes.getIdinterviniente());
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
			arbinterv.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					arbinterv = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			arbinterv = null;
			insercion = true;
		}
		if (arbinterv == null) {
			arbinterv = new Arbinterv();
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		arbinterv.setSolarb(solarb);
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUaentidadId(arbitro.getArcodigo());
		arbinterv.setUanombre(arbitro.getArnombre());
		arbinterv.setUacoem(arbitro.getArteem());
		arbinterv.setUanif(arbitro.getArnif());
		arbinterv.setUanrtel(arbitro.getArnrtel());
		arbinterv.setUanrtel2(arbitro.getArnrtel2());
		arbinterv.setUaprovId(arbitro.getArprovId());
		arbinterv.setUamunId(arbitro.getArmunId());
		arbinterv.setUalocId(arbitro.getArlocId());
		arbinterv.setUacalleId(arbitro.getArcalleId());
		arbinterv.setUacpId(arbitro.getArnrcopo() != null ? arbitro.getArnrcopo() : arbitro.getArnombreCp());
		arbinterv.setUaportalId(arbitro.getArportalId());
		arbinterv.setUanombrePiso(arbitro.getArnombrePiso());
		arbinterv.setUadireNocapv(arbitro.getArdireccionNoCAPV());
		arbinterv.setUanodir(arbitro.getArnodir());
		arbinterv.setUadireAnt(arbitro.getArdireccionAntigua());

		arbinterv.setUafecultmod(arbitro.getArfemod());
		arbinterv.setUausuultmod(arbitro.getArusualta());
		arbinterv.setUaidioma(arbitro.getAridioma());
		if (insercion) {
			/*
			 * Arbinterv arbinterv2 = new Arbinterv();
			 * arbinterv2.setUaentidadId(arbinterv.getUaentidadId());
			 * arbinterv2.setSolarb(new
			 * Solarb(intervinientes.getIdExpediente()));
			 * arbinterv2.setUaexcodigo(solarb.getSacodigo()); arbinterv2
			 * .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
			 * boolean existeArbitro = (this.arbintervDao .findAll(arbinterv2,
			 * null).size() > 0); if (!existeArbitro) { try { throw new
			 * Y41bUDAException( "error.interviniente.ArbitroNoExiste", true,
			 * null); } catch (Exception e) { throw new Y41bUDAException(
			 * "error.interviniente.ArbitroNoExiste", true, null); } } else {
			 */
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
			// this.arbintervDao.update(arbinterv);
			this.arbintervDao.add(arbinterv);
			// }
		} else {
			this.arbintervDao.update(arbinterv);
		}

		return arbinterv;
	}

	/**
	 * cargarIntervinientePerito
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	public Arbinterv cargarIntervinientePerito(Intervinientes intervinientes, CensoMonitor censoMonitor) {
		Arbinterv arbinterv = new Arbinterv();
		boolean insercion = false;
		Empper perito = new Empper();
		perito.setPecodigo(intervinientes.getIdinterviniente());

		// Alta interviniente arbitro
		perito = this.empperDao.find(perito);

		try {
			arbinterv = new Arbinterv();
			arbinterv.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			arbinterv.setUanif(perito.getPecif());
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO);
			List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(arbinterv, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					arbinterv = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			arbinterv = null;
			insercion = true;
		}
		if (arbinterv == null) {
			arbinterv = new Arbinterv();
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		arbinterv.setSolarb(solarb);
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUanombre(perito.getPenombre());
		arbinterv.setUacoem(perito.getPeteem());
		arbinterv.setUanif(perito.getPecif());
		arbinterv.setUanrtel(perito.getPenrtel());
		arbinterv.setUanrtel2(perito.getPenrtel2());
		arbinterv.setUaprovId(perito.getPeprovId());
		arbinterv.setUamunId(perito.getPemunId());
		arbinterv.setUalocId(perito.getPelocId());
		arbinterv.setUacalleId(perito.getPecalleId());
		arbinterv.setUacpId(perito.getPenrcopo() != null ? perito.getPenrcopo() : perito.getPenombreCp());
		arbinterv.setUaportalId(perito.getPeportalId());
		arbinterv.setUanombrePiso(perito.getPenombrePiso());
		arbinterv.setUadireNocapv(perito.getPedireccionNoCAPV());
		// En el censo la logica de estos campos esta cambiada.
		arbinterv.setUanodir(perito.getPenodir());
		arbinterv.setUadireAnt(perito.getPedireccionAntigua());

		arbinterv.setUanopeco(perito.getPecozs());
		arbinterv.setUaurl(perito.getPeteurl());
		arbinterv.setUasecodigo(perito.getSecodigo());
		arbinterv.setUasenombre(perito.getSenombre());

		arbinterv.setUafecultmod(perito.getPefemod());
		arbinterv.setUausuultmod(perito.getPeusualta());

		if (insercion) {
			/*
			 * Arbinterv arbinterv2 = new Arbinterv();
			 * arbinterv2.setUaidinterv(arbinterv.getUaidinterv());
			 * arbinterv2.setSolarb(new
			 * Solarb(intervinientes.getIdExpediente()));
			 * arbinterv2.setUaexcodigo(solarb.getSacodigo()); arbinterv2
			 * .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO);
			 * boolean existePerito = (this.arbintervDao.find(arbinterv2) !=
			 * null); if (!existePerito) { throw new Y41bUDAException(
			 * "error.interviniente.PeritoNoExiste", true, null); } else {
			 */
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO);
			this.arbintervDao.add(arbinterv);
			// }
		} else {
			this.arbintervDao.update(arbinterv);
		}

		return arbinterv;
	}

	// 0154940: Actualizacin de datos explcitos en plantillas a uso de campos
	// combinados
	/**
	 * Rellena el pie de la oficina central .
	 * 
	 * @param solarb
	 *            the solarb
	 * @param PlantillaTramiteARBDetalle
	 *            the plantilla tramite arb detalle
	 */

	public void rellenaCentralPieOficina(Solarb solarb, PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		Organismo organismo = new Organismo();
		// organismo.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		organismo.setCodOrg(Y41bConstantes.OFICINA_CENTRAL);
		organismo = this.organismoDao.findOrganismo(organismo);

		if (organismo != null && organismo.getEntidadId() != null) {

			// Creamos el campo central pie pagina linea1
			StringBuffer centralpiepagina_linea1 = new StringBuffer();

			centralpiepagina_linea1.append(organismo.getNombreCalle()).append(" ").append(organismo.getNombrePortal())
					.append(" - ").append(organismo.getNombreCp()).append(" / ").append(" Tl. ")
					.append(organismo.getTelefono());

			plantillaTramiteARBDetalle.setCentralPiePaginaLinea1(centralpiepagina_linea1.toString());

			// Creamos el campo central pie pagina linea2
			StringBuffer centralpiepagina_linea2 = new StringBuffer();

			centralpiepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
					.append(organismo.getUrl());

			plantillaTramiteARBDetalle.setCentralPiePaginaLinea2(centralpiepagina_linea2.toString());

			plantillaTramiteARBDetalle.setCentralMail(organismo.getEmail());

			plantillaTramiteARBDetalle.setCentralTelefono(organismo.getTelefono());
		}

	}
	// 0154940
}
