/**
 * 
 */
package com.ejie.y41b.service;

import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.PlantillaTramiteARBDetalle;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * Arbexp2Service  
 * 
 *  
 */
public interface Arbexp2Service {

	/**
	 * Rellena RequerimientoAcreditacionRepresentacion.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @throws exception
	 *             Y41bUDAException
	 */
	void rellenaRequerimientoAcreditacionRepresentacion(Solarb solarb,
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle)
			throws Y41bUDAException;

	/**
	 * cargaIntervinienteOrganismo
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Arbinterv
	 */
	public Arbinterv cargarIntervinienteOrganismo(Intervinientes intervinientes);

	/**
	 * cargarIntervinienteArbitro
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Y41bUDAException
	 *             Exception
	 * @return Arbinterv
	 */
	public Arbinterv cargarIntervinienteArbitro(Intervinientes intervinientes,
			CensoMonitor censoMonitor);

	/**
	 * cargarIntervinientePerito
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbinterv
	 */
	public Arbinterv cargarIntervinientePerito(Intervinientes intervinientes,
			CensoMonitor censoMonitor);

	void rellenaCentralPieOficina(Solarb solarb,
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle);
}
