package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbenvioDao;
import java.util.List;
import java.util.ListIterator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbenvioServiceImpl  
 * 
 *  
 */

@Service(value = "arbenvioService")
public class ArbenvioServiceImpl implements ArbenvioService {

	@Autowired
	private ArbenvioDao arbenvioDao;

	@Autowired
	private ArbdoctempDao arbdoctempDao;

	/**
	 * Inserts a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Arbenvio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbenvio add(Arbenvio arbenvio) {
		return this.arbenvioDao.add(arbenvio);
	}

	/**
	 * Updates a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Arbenvio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbenvio update(Arbenvio arbenvio) {
		return this.arbenvioDao.update(arbenvio);
	}

	/**
	 * Finds a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Arbenvio
	 */
	public Arbenvio find(Arbenvio arbenvio) {
		return (Arbenvio) this.arbenvioDao.find(arbenvio);
	}

	/**
	 * Finds a List of rows in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbenvio> findAll(Arbenvio arbenvio, Pagination pagination) {
		if (pagination != null && pagination.getSort() != null) {
			if ("fecharegistro".equals(pagination.getSort())) {
				pagination.setSort("FECHAREGISTRO");
			} else if ("arbtramexpByEntrid.tridnotifplatea".equals(pagination
					.getSort())) {
				pagination.setSort("t2.tridnotifplatea");
			} else if ("arbinterv.uanombre".equals(pagination.getSort())) {
				pagination.setSort("t3.uanombre");
			}
		}
		List<Arbenvio> listArbitrajeEnvios = this.arbenvioDao.findAll(arbenvio,
				pagination);

		if (listArbitrajeEnvios != null && listArbitrajeEnvios.size() > 0) {
			ListIterator<Arbenvio> iter = listArbitrajeEnvios
					.listIterator(listArbitrajeEnvios.size());

			Arbenvio arbitrajeEnviosAux = null;
			TramiteComun tramiteComun = new TramiteComun();
			while (iter.hasPrevious()) {
				arbitrajeEnviosAux = (Arbenvio) iter.previous();

				// buscar los documentos del tramite
				tramiteComun.setIdTramite(arbitrajeEnviosAux
						.getArbtramexpByEntrid().getTrid().toString());

				List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao
						.findAllDocumentosTramite(tramiteComun, null);

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null
						&& listDocumentoHecho.size() == 1) {
					arbitrajeEnviosAux
							.setIndVariosDocumentos(Y41bConstantes.NO);

					arbitrajeEnviosAux.setX5codocumento(listDocumentoHecho.get(
							0).getX5codocumento());
					arbitrajeEnviosAux.setX5tedesfile(listDocumentoHecho.get(0)
							.getX5tedesfile());
				} else {
					if (listDocumentoHecho != null
							&& listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						arbitrajeEnviosAux
								.setIndVariosDocumentos(Y41bConstantes.SI);
					}
				}
			}
		}
		return listArbitrajeEnvios;
	}

	/**
	 * Counts rows in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Long
	 */
	public Long findAllCount(Arbenvio arbenvio) {
		return this.arbenvioDao.findAllCount(arbenvio);
	}

	/**
	 * Finds rows in the Arbenvio table using like.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbenvio> findAllLike(Arbenvio arbenvio, Pagination pagination,
			Boolean startsWith) {
		return (List<Arbenvio>) this.arbenvioDao.findAllLike(arbenvio,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbenvio table using like.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbenvio arbenvio, Boolean startsWith) {
		return this.arbenvioDao.findAllLikeCount(arbenvio, startsWith);
	}

	/**
	 * Deletes a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbenvio arbenvio) {
		this.arbenvioDao.remove(arbenvio);
	}

	/**
	 * Deletes multiple rows in the Arbenvio table.
	 * 
	 * @param arbenvioList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbenvio> arbenvioList) {
		for (Arbenvio arbenvioAux : arbenvioList) {
			this.arbenvioDao.remove(arbenvioAux);
		}
	}

}
