package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbenvio;

/**
 * ArbenvioService  
 *  
 */

public interface ArbenvioService {

	/**
	 * Inserts a single row in the Arbenvio table.
	 *
	 * @param arbenvio Arbenvio
	 * @return Arbenvio
	 */
    Arbenvio add(Arbenvio arbenvio);

	/**
	 * Updates a single row in the Arbenvio table.
	 *
	 * @param arbenvio Arbenvio
	 * @return Arbenvio
	 */
	Arbenvio update(Arbenvio arbenvio);

	/**
	 * Finds a single row in the Arbenvio table.
	 *
	 * @param arbenvio Arbenvio
	 * @return Arbenvio
	 */
	Arbenvio find(Arbenvio arbenvio);

	/**
	 * Finds a List of rows in the Arbenvio table.
	 *
	 * @param arbenvio Arbenvio
	 * @param pagination Pagination
	 * @return List
	 */
	List<Arbenvio> findAll(Arbenvio arbenvio, Pagination pagination);

	/**
	 * Counts rows in the Arbenvio table.
	 *
	 * @param arbenvio Arbenvio
	 * @return Long
	 */
	Long findAllCount(Arbenvio arbenvio);
	
	/**
	 * Finds rows in the Arbenvio table using like.
	 *
	 * @param arbenvio Arbenvio
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Arbenvio> findAllLike(Arbenvio arbenvio, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Arbenvio table using like.
	 *
	 * @param arbenvio Arbenvio
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Arbenvio arbenvio, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Arbenvio table.
	 *
	 * @param arbenvio Arbenvio
	 * @return 
	 */
	void remove(Arbenvio arbenvio);
	
	/**
	 * Deletes multiple rows in the Arbenvio table.
	 *
	 * @param arbenvioList List
	 * @return 
	 */	
	void removeMultiple(List<Arbenvio> arbenvioList);
    
}


