package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbintervDao;

import java.sql.Blob;
import java.util.List;

import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * ArbdoctempServiceImpl  
 * 
 *  
 */

@Service(value = "arbdoctempService")
public class ArbdoctempServiceImpl implements ArbdoctempService {

	@Autowired
	private ArbdoctempDao arbdoctempDao;

	@Autowired
	private ArbintervDao arbintervDao;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	/**
	 * Inserts a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbdoctemp add(Arbdoctemp arbdoctemp) {
		return this.arbdoctempDao.add(arbdoctemp);
	}

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbdoctemp update(Arbdoctemp arbdoctemp) {
		return this.arbdoctempDao.update(arbdoctemp);
	}

	/**
	 * Finds a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public Arbdoctemp find(Arbdoctemp arbdoctemp) throws Exception {
		arbdoctemp = (Arbdoctemp) this.arbdoctempDao.find(arbdoctemp);
		if (arbdoctemp != null && arbdoctemp.getX5iddocumentum() != null
				&& !arbdoctemp.getX5iddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure
					.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
			documento.setProcedure(procedure);
			documento.setOidDokusi(arbdoctemp.getX5iddocumentum());

			Documento docDokusi = y41bDokusiAdapterService
					.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			arbdoctemp.setX5datafile(blob);
			arbdoctemp.setX5conttype(docDokusi.getContentType());
			arbdoctemp.setX5nofile(Y41bUtils.getNameFileDokusi(docDokusi
					.getNombre()));
			arbdoctemp.setX5sizefile(Integer.valueOf((int) docDokusi
					.getLength()));
		}
		return arbdoctemp;
	}

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbdoctemp> findAll(Arbdoctemp arbdoctemp, Pagination pagination) {
		return (List<Arbdoctemp>) this.arbdoctempDao.findAll(arbdoctemp,
				pagination);
	}

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Long
	 */
	public Long findAllCount(Arbdoctemp arbdoctemp) {
		return this.arbdoctempDao.findAllCount(arbdoctemp);
	}

	/**
	 * Finds rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbdoctemp> findAllLike(Arbdoctemp arbdoctemp,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbdoctemp>) this.arbdoctempDao.findAllLike(arbdoctemp,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbdoctemp arbdoctemp, Boolean startsWith) {
		return this.arbdoctempDao.findAllLikeCount(arbdoctemp, startsWith);
	}

	/**
	 * Deletes a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbdoctemp arbdoctemp) {
		this.arbdoctempDao.remove(arbdoctemp);
	}

	/**
	 * Deletes multiple rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctempList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbdoctemp> arbdoctempList) {
		for (Arbdoctemp arbdoctempAux : arbdoctempList) {
			this.arbdoctempDao.remove(arbdoctempAux);
		}
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination) {

		if (pagination != null) {
			if ("codocumento".equals(pagination.getSort())) {
				pagination.setSort("X5CODOCUMENTO");
			} else if ("nofile".equals(pagination.getSort())) {
				pagination.setSort("X5NOFILE");
			} else if ("fecha".equals(pagination.getSort())) {
				pagination.setSort("X5FECHA");
			} else if ("origen".equals(pagination.getSort())) {
				pagination.setSort("X5ORIGEN");
			} else if ("tedesfile".equals(pagination.getSort())) {
				pagination.setSort("X5TEDESFILE");
			}
		}
		List<DocumentoExpediente> lista = this.arbdoctempDao
				.findAllDocumentosExpediente(tramiteComun, pagination);
		if (lista != null && lista.size() > 0) {
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(new Solarb(tramiteComun.getIdExpediente()));
			arbinterv
					.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			long cont = this.arbintervDao.findAllCount(arbinterv);
			if (cont == 0) {
				for (int i = 0; i < lista.size(); i++) {
					if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE
							.equals((((DocumentoExpediente) lista.get(i))
									.getOrigen()))) {
						((DocumentoExpediente) lista.get(i))
								.setOrigen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2);
					}
				}
			}
		}
		return lista;
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun) {

		return this.arbdoctempDao
				.findAllDocumentosExpedienteCount(tramiteComun);
	}

	/**
	 * Get a New PK ARBDOCTEMP.
	 * 
	 * @return Long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long getNewPK() {
		return this.arbdoctempDao.getNewPK();
	}

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Arbdoctemp>
	 */
	public List<Arbdoctemp> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination) {
		return this.arbdoctempDao.findAllDocumentosTramite(tramiteComun,
				pagination);
	}

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		return this.arbdoctempDao.findAllDocumentosTramiteCount(tramiteComun);
	}
}
