package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbdoctempService  
 * 
 *  
 */

public interface ArbdoctempService {

	/**
	 * Inserts a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp add(Arbdoctemp arbdoctemp);

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp update(Arbdoctemp arbdoctemp);

	/**
	 * Finds a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp find(Arbdoctemp arbdoctemp) throws Exception;

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbdoctemp> findAll(Arbdoctemp arbdoctemp, Pagination pagination);

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Long
	 */
	Long findAllCount(Arbdoctemp arbdoctemp);

	/**
	 * Finds rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbdoctemp> findAllLike(Arbdoctemp arbdoctemp, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbdoctemp arbdoctemp, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return
	 */
	void remove(Arbdoctemp arbdoctemp);

	/**
	 * Deletes multiple rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctempList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbdoctemp> arbdoctempList);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 * @return Long
	 */
	Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun);

	/**
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Arbdoctemp>
	 */
	List<Arbdoctemp> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Arbdoctemp table using like.
	 * 
	 * @param tramiteComun
	 *            tramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

}
