package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbcolegioDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbcolegio;

/**
 * ArbcolegioServiceImpl  
 *  
 */

@Service(value = "arbcolegioService")
public class ArbcolegioServiceImpl implements ArbcolegioService {

	@Autowired
	private ArbcolegioDao arbcolegioDao;

	/**
	 * Inserts a single row in the Arbcolegio table.
	 *
	 * @param arbcolegio Arbcolegio
	 * @return Arbcolegio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbcolegio add(Arbcolegio arbcolegio) {
		return this.arbcolegioDao.add(arbcolegio);
	}

	/**
	 * Updates a single row in the Arbcolegio table.
	 *
	 * @param arbcolegio Arbcolegio
	 * @return Arbcolegio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbcolegio update(Arbcolegio arbcolegio) {
		return this.arbcolegioDao.update(arbcolegio);
	 }

	/**
	 * Finds a single row in the Arbcolegio table.
	 *
	 * @param arbcolegio Arbcolegio
	 * @return Arbcolegio
	 */
	public Arbcolegio find(Arbcolegio arbcolegio) {
		return (Arbcolegio) this.arbcolegioDao.find(arbcolegio);
	}

	/**
	 * Finds a List of rows in the Arbcolegio table.
	 *
	 * @param arbcolegio Arbcolegio
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Arbcolegio> findAll(Arbcolegio arbcolegio, Pagination pagination) {
		return (List<Arbcolegio>) this.arbcolegioDao.findAll(arbcolegio, pagination);
	}
    
	/**
	 * Counts rows in the Arbcolegio table.
	 *
	 * @param arbcolegio Arbcolegio
	 * @return Long
	 */
	public Long findAllCount(Arbcolegio arbcolegio) {        
		return  this.arbcolegioDao.findAllCount(arbcolegio);
	}

	/**
	 * Finds rows in the Arbcolegio table using like.
	 *
	 * @param arbcolegio Arbcolegio
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Arbcolegio> findAllLike(Arbcolegio arbcolegio, Pagination pagination, Boolean startsWith) {
		return (List<Arbcolegio>) this.arbcolegioDao.findAllLike(arbcolegio, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbcolegio table using like.
	 *
	 * @param arbcolegio Arbcolegio
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbcolegio arbcolegio, Boolean startsWith) {
		return this.arbcolegioDao.findAllLikeCount(arbcolegio, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Arbcolegio table.
	 *
	 * @param arbcolegio Arbcolegio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbcolegio arbcolegio) {
		this.arbcolegioDao.remove(arbcolegio);
	}
	
	/**
	 * Deletes multiple rows in the Arbcolegio table.
	 *
	 * @param arbcolegioList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbcolegio> arbcolegioList) {
		for (Arbcolegio  arbcolegioAux:arbcolegioList) {
			this.arbcolegioDao.remove(arbcolegioAux);
		}
	}
	
}

