package com.ejie.y41b.service;

//import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.ArbbandejaDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaArbitrajeDao;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbbandejaServiceImpl  
 * 
 *  
 */

@Service(value = "arbbandejaService")
public class ArbbandejaServiceImpl implements ArbbandejaService {

	@Autowired()
	private ArbbandejaDao arbbandejaDao;

	@Autowired()
	private ArbdoctempDao arbdoctempDao;

	@Autowired()
	private ParametrosDao parametrosDao;
	@Autowired()
	private ArbtramexpDao arbtramexpDao;
	@Autowired()
	private ArbintervDao arbintervDao;
	@Autowired()
	private BandejaFirmaArbitrajeDao bandejaFirmaArbitrajeDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbbandeja add(Arbbandeja arbbandeja) {
		return this.arbbandejaDao.add(arbbandeja);
	}

	/**
	 * Updates a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbbandeja update(Arbbandeja arbbandeja) {
		return this.arbbandejaDao.update(arbbandeja);
	}

	/**
	 * Finds a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	public Arbbandeja find(Arbbandeja arbbandeja) {
		return (Arbbandeja) this.arbbandejaDao.find(arbbandeja);
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbbandeja> findAll(Arbbandeja arbbandeja, Pagination pagination) {
		return (List<Arbbandeja>) this.arbbandejaDao.findAll(arbbandeja, pagination);
	}

	/**
	 * Counts rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Long
	 */
	public Long findAllCount(Arbbandeja arbbandeja) {
		return this.arbbandejaDao.findAllCount(arbbandeja);
	}

	/**
	 * Finds rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbbandeja> findAllLike(Arbbandeja arbbandeja, Pagination pagination, Boolean startsWith) {
		return (List<Arbbandeja>) this.arbbandejaDao.findAllLike(arbbandeja, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbbandeja arbbandeja, Boolean startsWith) {
		return this.arbbandejaDao.findAllLikeCount(arbbandeja, startsWith);
	}

	/**
	 * Deletes a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbbandeja arbbandeja) {
		this.arbbandejaDao.remove(arbbandeja);
	}

	/**
	 * Deletes multiple rows in the Arbbandeja table.
	 * 
	 * @param arbbandejaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbbandeja> arbbandejaList) {
		for (Arbbandeja arbbandejaAux : arbbandejaList) {
			this.arbbandejaDao.remove(arbbandejaAux);
		}
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	public List<Arbbandeja> dameBandeja(Arbbandeja arbbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		if (pagination != null) {
			if ("solarb.sacodigo".equals(pagination.getSort())) {
				pagination.setSort("SACODIGO");
			} else if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("solarb.codCompleto")) {
				pagination.setSort(" SOLARBSACOJA ASC , SOLARBEXNRAN ASC , LPAD(SOLARBEXNROR, 12) ");
			} else if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& "solarb.codCompleto".equals(pagination.getSort())) {
				pagination.setSort(" SOLARBSACOJA DESC , SOLARBEXNRAN DESC , LPAD(SOLARBEXNROR, 12) ");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBREE");
			} else if ("arbtramexp.trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("arbtramexp.trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("arbinterv.uanombre".equals(pagination.getSort())) {
				pagination.setSort("ArbintervUANOMBRE");
			} else if ("abnomdoc".equals(pagination.getSort())) {
				pagination.setSort("ABNOMDOC");
			} else if ("arbtramexp.trfecfin".equals(pagination.getSort())) {
				pagination.setSort("TRFECFIN");
			} else if ("abestado".equals(pagination.getSort())) {
				pagination.setSort("ABESTADO");
			} else if ("monitor.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONITORMONOMBRE");
			} else if ("tramitesPendientes".equals(pagination.getSort())) {
				pagination.setSort("TRAMITESPENDIENTES");
			} else if ("avisos".equals(pagination.getSort())) {
				pagination.setSort("AVISOS");
			} else if ("solarb.dtnombre".equals(pagination.getSort())) {
				pagination.setSort("SOLARBDTNOMBRE");
			}
		}
		List<Arbbandeja> listaBandeja = (List<Arbbandeja>) this.arbbandejaDao.dameBandeja(arbbandeja, pagination,
				censoMonitor, perfil);
		Arbtramexp arbtramexpAux = new Arbtramexp();

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);
		int minutos = 0;

		if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
			minutos = Integer.parseInt(parametros.getValor());
		}

		for (Arbbandeja registroBandeja : listaBandeja) {
			// Batrid es el id del tramite en cuestin o del tramite relacionado
			// con el aviso
			if (registroBandeja.getAbtrid() != null) {

				String idTramite = registroBandeja.getAbtrid();
				TramiteComun tramiteComun = new TramiteComun();

				tramiteComun.setIdTramite(idTramite.toString());

				List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
				arbtramexpAux = registroBandeja.getArbtramexp();
				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					arbtramexpAux.setIndVariosDocumentos(Y41bConstantes.NO);

					arbtramexpAux.setX5codocumento(listDocumentoHecho.get(0).getX5codocumento());
					arbtramexpAux.setX5nofile(listDocumentoHecho.get(0).getX5nofile());
					arbtramexpAux.setX5sizefile(listDocumentoHecho.get(0).getX5sizefile());
					arbtramexpAux.setX5contenttypefile(listDocumentoHecho.get(0).getX5conttype());
					arbtramexpAux.setX5tedesfile(listDocumentoHecho.get(0).getX5tedesfile());
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						arbtramexpAux.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}
				// Formatear estado del tramite segun sus documentos
				if (registroBandeja.getAbtipo() == null) {
					if (listDocumentoHecho != null) {
						boolean error = false;
						boolean sinLocalizarPorTiempo = false;
						boolean localizado = false;
						boolean firmado = false;

						for (Arbdoctemp arbdoctemp : listDocumentoHecho) {
							if (arbdoctemp.getX5fechasollocalizador() != null
									&& !registroBandeja.getAbestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
									&& !registroBandeja.getAbestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !registroBandeja.getAbestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
								if (arbdoctemp != null && arbdoctemp.getX5nofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(arbdoctemp.getX5nofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

									Date d1 = null;
									Date d2 = null;
									long diffMinutes = 0;
									try {
										d1 = format.parse(format.format(arbdoctemp.getX5fechasollocalizador()));

										d2 = format.parse(format.format(new Date()));

										long diff = d2.getTime() - d1.getTime();

										diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
									} catch (ParseException e) {
										diffMinutes = 0;
									}

									if (diffMinutes > minutos) {

										error = true;
									} else {

										sinLocalizarPorTiempo = true;
									}
								} else {
									if (registroBandeja.getAbestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
										firmado = true;
									} else if (!registroBandeja.getAbestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
										localizado = true;
									}
								}
							}
						}
						if (error) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
						} else if (sinLocalizarPorTiempo) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
						} else if (firmado) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
						} else if (localizado) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
						}
						registroBandeja.setArbtramexp(arbtramexpAux);
					}
				}
			}

			if (registroBandeja.getArbtramexp().getTrfechaenviobopvboe() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getArbtramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(Y41bUtils.parseDateToString(registroBandeja.getArbtramexp().getTrfechaenviobopvboe(),
						Y41bConstantes.CASTELLANO));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getArbtramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(Y41bUtils.parseDateToString(registroBandeja.getArbtramexp().getTrfechaenviobopvboe(),
						Y41bConstantes.EUSKERA));
				sbTrnombree.append(")");

				registroBandeja.getArbtramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getArbtramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			if (registroBandeja.getArbtramexp().getTristelematica() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getArbtramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getArbtramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				registroBandeja.getArbtramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getArbtramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			// Consulta si hay documentos pendiente de firma
			Arbdoctemp arbdoctemp = new Arbdoctemp();
			arbdoctemp.setX5excodigo(registroBandeja.getSolarb().getSacodigo());
			arbdoctemp.setX5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.arbdoctempDao.findAllCount(arbdoctemp);
			if (numDocumentosPendienteFirma > 0) {
				registroBandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}

			// Ultimo documento firma arbitros expediente
			BandejaFirmaArbitraje bandejaFirmaArbitraje = this.bandejaFirmaArbitrajeDao
					.findUltimoDocumentoFirmaArbitrosExpediente(registroBandeja.getSolarb().getSacodigo());

			if (bandejaFirmaArbitraje != null) {
				// Consulta documentos pendiente de firma, rechazados y firmados
				// por arbitros
				BandejaFirmaArbitraje filtroBandejaFirmaArbitraje = new BandejaFirmaArbitraje();
				filtroBandejaFirmaArbitraje.setIdexpediente(registroBandeja.getSolarb().getSacodigo());
				filtroBandejaFirmaArbitraje.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
				filtroBandejaFirmaArbitraje.setIdtramitehecho(bandejaFirmaArbitraje.getIdtramitehecho());
				filtroBandejaFirmaArbitraje.setEstado(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				numDocumentosPendienteFirma = this.bandejaFirmaArbitrajeDao.findAllCount(filtroBandejaFirmaArbitraje);
				filtroBandejaFirmaArbitraje.setEstado(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
				Long numDocumentosFirmaDenegada = this.bandejaFirmaArbitrajeDao
						.findAllCount(filtroBandejaFirmaArbitraje);
				filtroBandejaFirmaArbitraje.setEstado(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
				Long numDocumentosFirmados = this.bandejaFirmaArbitrajeDao.findAllCount(filtroBandejaFirmaArbitraje);
				// INICIO - 0183229: Bandeja de arbitros: columna firma arbitros
				// Se cambio de un if a otro el rellenado dla columna de estado
				// firma arbitro porque solo debe rellenarse cuando exista algo
				// pendiente, es decir, cuando existan documentos pendientes de
				// firma o rechazados
				// if (numDocumentosPendienteFirma > 0 ||
				// numDocumentosFirmaDenegada > 0 || numDocumentosFirmados > 0)
				// {
				// registroBandeja.setEstadoFirmaArbitros(numDocumentosFirmados
				// + "/"
				// + (numDocumentosFirmados + numDocumentosFirmaDenegada +
				// numDocumentosPendienteFirma));
				// registroBandeja.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
				// registroBandeja.setIdTramiteHecho(bandejaFirmaArbitraje.getIdtramitehecho());
				// }
				if (numDocumentosPendienteFirma > 0 || numDocumentosFirmaDenegada > 0) {
					registroBandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
					registroBandeja.setEstadoFirmaArbitros(numDocumentosFirmados + "/"
							+ (numDocumentosFirmados + numDocumentosFirmaDenegada + numDocumentosPendienteFirma));
					registroBandeja.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
					registroBandeja.setIdTramiteHecho(bandejaFirmaArbitraje.getIdtramitehecho());
				}
				// FIN - 0183229: Bandeja de arbitros: columna firma arbitros
			}
		}
		return listaBandeja;

	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long dameBandejaCount(Arbbandeja arbbandeja, CensoMonitor censoMonitor, String perfil) {
		return this.arbbandejaDao.dameBandejaCount(arbbandeja, censoMonitor, perfil);

	}

	/**
	 * Finds a single row in the Arbbandeja table.
	 * 
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void deleteBandejaAvisosCaducados() {
		this.arbbandejaDao.deleteBandejaAvisosCaducados();
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	public List<Arbbandeja> dameBandejaTP(Arbbandeja arbbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		if (pagination != null) {
			if ("solarb.sacodigo".equals(pagination.getSort())) {
				pagination.setSort("SACODIGO");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBREE");
			} else if ("arbtramexp.trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("arbtramexp.trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("arbtramexp.trfecini".equals(pagination.getSort())) {
				pagination.setSort("TRFECINI");
			} else if ("baestado".equals(pagination.getSort())) {
				pagination.setSort("ABESTADO");
			} else if ("monitor.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONITORMONOMBRE");
			}
		}
		List<Arbbandeja> listaBandeja = (List<Arbbandeja>) this.arbbandejaDao.dameBandejaTP(arbbandeja, pagination,
				censoMonitor, perfil);
		Arbtramexp arbtramexpAux = new Arbtramexp();

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);
		int minutos = 0;

		if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
			minutos = Integer.parseInt(parametros.getValor());
		}

		for (Arbbandeja registroBandeja : listaBandeja) {
			// Batrid es el id del tramite en cuestin o del tramite relacionado
			// con el aviso
			if (registroBandeja.getAbtrid() != null) {

				String idTramite = registroBandeja.getAbtrid();
				TramiteComun tramiteComun = new TramiteComun();

				tramiteComun.setIdTramite(idTramite.toString());

				List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
				arbtramexpAux = registroBandeja.getArbtramexp();

				// Formatear estado del tramite segun sus documentos
				if (registroBandeja.getAbtipo() == null) {
					if (listDocumentoHecho != null) {
						boolean error = false;
						boolean sinLocalizarPorTiempo = false;
						boolean localizado = false;
						boolean firmado = false;

						for (Arbdoctemp arbdoctemp : listDocumentoHecho) {
							if (arbdoctemp.getX5fechasollocalizador() != null
									&& !registroBandeja.getAbestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
									&& !registroBandeja.getAbestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !registroBandeja.getAbestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
								if (arbdoctemp != null && arbdoctemp.getX5nofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(arbdoctemp.getX5nofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

									Date d1 = null;
									Date d2 = null;
									long diffMinutes = 0;
									try {
										d1 = format.parse(format.format(arbdoctemp.getX5fechasollocalizador()));

										d2 = format.parse(format.format(new Date()));

										long diff = d2.getTime() - d1.getTime();

										diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
									} catch (ParseException e) {
										diffMinutes = 0;
									}

									if (diffMinutes > minutos) {

										error = true;
									} else {

										sinLocalizarPorTiempo = true;
									}
								} else {
									if (registroBandeja.getAbestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
										firmado = true;
									} else if (!registroBandeja.getAbestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
											&& !registroBandeja.getAbestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
										localizado = true;
									}
								}
							}
						}
						if (error) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
						} else if (sinLocalizarPorTiempo) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
						} else if (firmado) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
						} else if (localizado) {
							registroBandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
						}
						registroBandeja.setArbtramexp(arbtramexpAux);
					}
				}
			}

			if (registroBandeja.getArbtramexp().getTrfechaenviobopvboe() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getArbtramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(Y41bUtils.parseDateToString(registroBandeja.getArbtramexp().getTrfechaenviobopvboe(),
						Y41bConstantes.CASTELLANO));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getArbtramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(Y41bUtils.parseDateToString(registroBandeja.getArbtramexp().getTrfechaenviobopvboe(),
						Y41bConstantes.EUSKERA));
				sbTrnombree.append(")");

				registroBandeja.getArbtramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getArbtramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			// Mostrar una observacin que depende del tipo de tramite
			if (Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(registroBandeja.getArbtramexp().getTrcodigo())
					|| Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION
							.equals(registroBandeja.getArbtramexp().getTrcodigo())
					|| Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
							.equals(registroBandeja.getArbtramexp().getTrcodigo())) {

				// Datos de arbtramexp
				arbtramexpAux = registroBandeja.getArbtramexp();
				arbtramexpAux = this.arbtramexpDao.find(arbtramexpAux);

				// Datos de tramite (tabla basica)
				if (arbtramexpAux.getTrtridrel() != null) {
					Arbtramexp tramiteOrigenYRelacionado = new Arbtramexp();
					tramiteOrigenYRelacionado.setSolarb(arbtramexpAux.getSolarb());
					tramiteOrigenYRelacionado.setTrid(arbtramexpAux.getTrtridrel());
					tramiteOrigenYRelacionado = this.arbtramexpDao.find(tramiteOrigenYRelacionado);

					// Si es acuse, buscamos el tramite relacionado con la
					// notificacin
					if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
							.equals(registroBandeja.getArbtramexp().getTrcodigo()) && tramiteOrigenYRelacionado != null
							&& tramiteOrigenYRelacionado.getTrtridrel() != null) {

						Arbtramexp tramiteOrigenNoti = tramiteOrigenYRelacionado;
						tramiteOrigenYRelacionado = new Arbtramexp();
						tramiteOrigenYRelacionado.setSolarb(tramiteOrigenNoti.getSolarb());
						tramiteOrigenYRelacionado.setTrid(tramiteOrigenNoti.getTrtridrel());
						tramiteOrigenYRelacionado = this.arbtramexpDao.find(tramiteOrigenYRelacionado);

						registroBandeja.setObs_tramiteOrigenFecha(tramiteOrigenYRelacionado.getTrfecfin());
						if (tramiteOrigenYRelacionado.getTramite() != null) {
							registroBandeja
									.setObs_tramiteOrigenNombre(tramiteOrigenYRelacionado.getTramite().getTrnombre());
							registroBandeja
									.setObs_tramiteOrigenNombree(tramiteOrigenYRelacionado.getTramite().getTrnombree());
						}
					} else if (tramiteOrigenYRelacionado != null) {
						registroBandeja.setObs_tramiteOrigenFecha(tramiteOrigenYRelacionado.getTrfecfin());
						if (tramiteOrigenYRelacionado.getTramite() != null) {
							registroBandeja
									.setObs_tramiteOrigenNombre(tramiteOrigenYRelacionado.getTramite().getTrnombre());
							registroBandeja
									.setObs_tramiteOrigenNombree(tramiteOrigenYRelacionado.getTramite().getTrnombree());
						}
					}

					// notificaciones/comunicaciones/acuses: Nombre del
					// destinatario
					Arbinterv intervinientes = new Arbinterv();
					intervinientes.setUaidinterv(arbtramexpAux.getTruaidinterv());
					intervinientes = this.arbintervDao.find(intervinientes);
					if (null != intervinientes) {
						StringBuffer sbPerson = new StringBuffer();
						if (Y41bUtils.isFilled(intervinientes.getUanoco())) {
							sbPerson.append(intervinientes.getUanoco());
							sbPerson.append(" ");
						} else {
							if (Y41bUtils.isFilled(intervinientes.getUanombre())) {
								sbPerson.append(intervinientes.getUanombre());
								sbPerson.append(" ");
							}
							if (Y41bUtils.isFilled(intervinientes.getUaapellido1())) {
								sbPerson.append(intervinientes.getUaapellido1());
								sbPerson.append(" ");
							}
							if (Y41bUtils.isFilled(intervinientes.getUaapellido2())) {
								sbPerson.append(intervinientes.getUaapellido2());
								sbPerson.append(" ");
							}
						}
						registroBandeja.setObs_destinatarioNombre(sbPerson.toString());

						// notificaciones/comunicaciones: Tipo de destinatario
						registroBandeja.setObs_tipoDestinatario(intervinientes.getUatipointerv());
					}
				}
			}

			if (registroBandeja.getArbtramexp().getTristelematica() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getArbtramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getArbtramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				registroBandeja.getArbtramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getArbtramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}
		}
		return listaBandeja;

	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long dameBandejaTPCount(Arbbandeja arbbandeja, CensoMonitor censoMonitor, String perfil) {
		return this.arbbandejaDao.dameBandejaTPCount(arbbandeja, censoMonitor, perfil);

	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	public List<Arbbandeja> dameBandejaAvisos(Arbbandeja arbbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		if (pagination != null) {
			if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBREE");
			} else if ("abtexto".equals(pagination.getSort())) {
				pagination.setSort("ABTEXTO");
			} else if ("abtextoe".equals(pagination.getSort())) {
				pagination.setSort("ABTEXTOE");
			} else if ("arbtramexp.trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("ABTIPO");
			} else if ("arbtramexp.trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("ABTIPO");
			} else if ("abfeclimite".equals(pagination.getSort())) {
				pagination.setSort("ABFECLIMITE");
			}
		}
		List<Arbbandeja> listaBandeja = (List<Arbbandeja>) this.arbbandejaDao.dameBandejaAvisos(arbbandeja, pagination,
				censoMonitor, perfil);
		try {
			for (Arbbandeja registroBandeja : listaBandeja) {
				Parametros parametrosAvisos = new Parametros();
				parametrosAvisos.setParametro(registroBandeja.getAbtipo() + "_TEXTOES");
				parametrosAvisos = this.parametrosDao.find(parametrosAvisos);
				String tipoAvisoES = parametrosAvisos.getValor();
				parametrosAvisos = new Parametros();
				parametrosAvisos.setParametro(registroBandeja.getAbtipo() + "_TEXTOEU");
				parametrosAvisos = this.parametrosDao.find(parametrosAvisos);
				String tipoAvisoEU = parametrosAvisos.getValor();
				registroBandeja.setAbtexto(tipoAvisoES);
				registroBandeja.setAbtextoe(tipoAvisoEU);

			}
		} catch (Exception e) {
		}
		return listaBandeja;

	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long dameBandejaAvisosCount(Arbbandeja arbbandeja, CensoMonitor censoMonitor, String perfil) {
		return this.arbbandejaDao.dameBandejaAvisosCount(arbbandeja, censoMonitor, perfil);

	}

}
