package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Arbbandeja;

/**
 * ArbbandejaService  
 * 
 *  
 */

public interface ArbbandejaService {

	/**
	 * Inserts a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja add(Arbbandeja arbbandeja);

	/**
	 * Updates a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja update(Arbbandeja arbbandeja);

	/**
	 * Finds a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja find(Arbbandeja arbbandeja);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbbandeja> findAll(Arbbandeja arbbandeja, Pagination pagination);

	/**
	 * Counts rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Long
	 */
	Long findAllCount(Arbbandeja arbbandeja);

	/**
	 * Finds rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbbandeja> findAllLike(Arbbandeja arbbandeja, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbbandeja arbbandeja, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return
	 */
	void remove(Arbbandeja arbbandeja);

	/**
	 * Deletes multiple rows in the Arbbandeja table.
	 * 
	 * @param arbbandejaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbbandeja> arbbandejaList);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */
	List<Arbbandeja> dameBandeja(Arbbandeja arbbandeja, Pagination pagination,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */

	public Long dameBandejaCount(Arbbandeja arbbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a single row in the Arbbandeja table.
	 */

	public void deleteBandejaAvisosCaducados();

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */
	List<Arbbandeja> dameBandejaTP(Arbbandeja arbbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */

	public Long dameBandejaTPCount(Arbbandeja arbbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */
	List<Arbbandeja> dameBandejaAvisos(Arbbandeja arbbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */

	public Long dameBandejaAvisosCount(Arbbandeja arbbandeja,
			CensoMonitor censoMonitor, String perfil);

}
