package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbainstanciaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbainstancia;

/**
 * ArbainstanciaServiceImpl  
 *  
 */

@Service(value = "arbainstanciaService")
public class ArbainstanciaServiceImpl implements ArbainstanciaService {

	@Autowired
	private ArbainstanciaDao arbainstanciaDao;

	/**
	 * Inserts a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Arbainstancia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbainstancia add(Arbainstancia arbainstancia) {
		return this.arbainstanciaDao.add(arbainstancia);
	}

	/**
	 * Updates a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Arbainstancia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbainstancia update(Arbainstancia arbainstancia) {
		return this.arbainstanciaDao.update(arbainstancia);
	 }

	/**
	 * Finds a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Arbainstancia
	 */
	public Arbainstancia find(Arbainstancia arbainstancia) {
		return (Arbainstancia) this.arbainstanciaDao.find(arbainstancia);
	}

	/**
	 * Finds a List of rows in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Arbainstancia> findAll(Arbainstancia arbainstancia, Pagination pagination) {
		return (List<Arbainstancia>) this.arbainstanciaDao.findAll(arbainstancia, pagination);
	}
    
	/**
	 * Counts rows in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Long
	 */
	public Long findAllCount(Arbainstancia arbainstancia) {        
		return  this.arbainstanciaDao.findAllCount(arbainstancia);
	}

	/**
	 * Finds rows in the Arbainstancia table using like.
	 *
	 * @param arbainstancia Arbainstancia
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Arbainstancia> findAllLike(Arbainstancia arbainstancia, Pagination pagination, Boolean startsWith) {
		return (List<Arbainstancia>) this.arbainstanciaDao.findAllLike(arbainstancia, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbainstancia table using like.
	 *
	 * @param arbainstancia Arbainstancia
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbainstancia arbainstancia, Boolean startsWith) {
		return this.arbainstanciaDao.findAllLikeCount(arbainstancia, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbainstancia arbainstancia) {
		this.arbainstanciaDao.remove(arbainstancia);
	}
	
	/**
	 * Deletes multiple rows in the Arbainstancia table.
	 *
	 * @param arbainstanciaList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbainstancia> arbainstanciaList) {
		for (Arbainstancia  arbainstanciaAux:arbainstanciaList) {
			this.arbainstanciaDao.remove(arbainstanciaAux);
		}
	}
	
}

