package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbainstancia;

/**
 * ArbainstanciaService  
 *  
 */

public interface ArbainstanciaService {

	/**
	 * Inserts a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Arbainstancia
	 */
    Arbainstancia add(Arbainstancia arbainstancia);

	/**
	 * Updates a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Arbainstancia
	 */
	Arbainstancia update(Arbainstancia arbainstancia);

	/**
	 * Finds a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Arbainstancia
	 */
	Arbainstancia find(Arbainstancia arbainstancia);

	/**
	 * Finds a List of rows in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @param pagination Pagination
	 * @return List
	 */
	List<Arbainstancia> findAll(Arbainstancia arbainstancia, Pagination pagination);

	/**
	 * Counts rows in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return Long
	 */
	Long findAllCount(Arbainstancia arbainstancia);
	
	/**
	 * Finds rows in the Arbainstancia table using like.
	 *
	 * @param arbainstancia Arbainstancia
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Arbainstancia> findAllLike(Arbainstancia arbainstancia, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Arbainstancia table using like.
	 *
	 * @param arbainstancia Arbainstancia
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Arbainstancia arbainstancia, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Arbainstancia table.
	 *
	 * @param arbainstancia Arbainstancia
	 * @return 
	 */
	void remove(Arbainstancia arbainstancia);
	
	/**
	 * Deletes multiple rows in the Arbainstancia table.
	 *
	 * @param arbainstanciaList List
	 * @return 
	 */	
	void removeMultiple(List<Arbainstancia> arbainstanciaList);
    
}


