package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbadocorrelDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbadocorrel;

/**
 * ArbadocorrelServiceImpl  
 *  
 */

@Service(value = "arbadocorrelService")
public class ArbadocorrelServiceImpl implements ArbadocorrelService {

	@Autowired
	private ArbadocorrelDao arbadocorrelDao;

	/**
	 * Inserts a single row in the Arbadocorrel table.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @return Arbadocorrel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadocorrel add(Arbadocorrel arbadocorrel) {
		return this.arbadocorrelDao.add(arbadocorrel);
	}

	/**
	 * Updates a single row in the Arbadocorrel table.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @return Arbadocorrel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadocorrel update(Arbadocorrel arbadocorrel) {
		return this.arbadocorrelDao.update(arbadocorrel);
	 }

	/**
	 * Finds a single row in the Arbadocorrel table.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @return Arbadocorrel
	 */
	public Arbadocorrel find(Arbadocorrel arbadocorrel) {
		return (Arbadocorrel) this.arbadocorrelDao.find(arbadocorrel);
	}

	/**
	 * Finds a List of rows in the Arbadocorrel table.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Arbadocorrel> findAll(Arbadocorrel arbadocorrel, Pagination pagination) {
		return (List<Arbadocorrel>) this.arbadocorrelDao.findAll(arbadocorrel, pagination);
	}
    
	/**
	 * Counts rows in the Arbadocorrel table.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @return Long
	 */
	public Long findAllCount(Arbadocorrel arbadocorrel) {        
		return  this.arbadocorrelDao.findAllCount(arbadocorrel);
	}

	/**
	 * Finds rows in the Arbadocorrel table using like.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Arbadocorrel> findAllLike(Arbadocorrel arbadocorrel, Pagination pagination, Boolean startsWith) {
		return (List<Arbadocorrel>) this.arbadocorrelDao.findAllLike(arbadocorrel, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbadocorrel table using like.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbadocorrel arbadocorrel, Boolean startsWith) {
		return this.arbadocorrelDao.findAllLikeCount(arbadocorrel, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Arbadocorrel table.
	 *
	 * @param arbadocorrel Arbadocorrel
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbadocorrel arbadocorrel) {
		this.arbadocorrelDao.remove(arbadocorrel);
	}
	
	/**
	 * Deletes multiple rows in the Arbadocorrel table.
	 *
	 * @param arbadocorrelList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbadocorrel> arbadocorrelList) {
		for (Arbadocorrel  arbadocorrelAux:arbadocorrelList) {
			this.arbadocorrelDao.remove(arbadocorrelAux);
		}
	}
	
}

