// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosAvisosEstablecDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbadhdocDao;
import com.ejie.y41b.dao.ArbadhintervDao;
import com.ejie.y41b.dao.ArbadhsolDao;
import com.ejie.y41b.dao.ArbadhtramDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteADHApertura;
import com.ejie.y41b.model.TramiteADHResolucion;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Formato;
//import com.ejie.y41b.model.dokusi.TransformarDocumento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;

/**
 * ArbadhtramServiceImpl  
 * 
 *  
 */

@Service(value = "arbadhtramService")
public class ArbadhtramServiceImpl implements ArbadhtramService {

	private static final Logger logger = LoggerFactory.getLogger(ArbadhtramServiceImpl.class);

	@Autowired
	private ArbadhtramDao arbadhtramDao;

	@Autowired
	private ArbadhsolDao arbadhsolDao;

	@Autowired
	private ArbadhdocDao arbadhdocDao;

	@Autowired
	private ArbtipdocDao arbtipdocDao;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;
	@Autowired()
	private ArbadhtramDao arbadhsoltramDao;
	@Autowired()
	private TramiteDao tramiteDao;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private EstablecimientoService establecimientoService;
	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;
	@Autowired()
	private RemesaDao remesaDao;
	@Autowired()
	private PlantillaDecisionDao plantillaDecisionDao;
	@Autowired()
	private ArbadhintervDao arbadhintervDao;
	@Autowired()
	private ArbadhdocService arbadhdocService;
	@Autowired()
	private AdjuntardocsService adjuntardocsService;
	@Autowired()
	private DocumentoHechoDao documentoHechoDao;
	@Autowired()
	private DenunciaService denunciaService;
	@Autowired
	private AdjunDatosAvisosEstablecDao adjunDatosAvisosEstablecDao;

	/**
	 * Inserts a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram add(Arbadhtram arbadhtram) {
		return this.arbadhtramDao.add(arbadhtram);
	}

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram update(Arbadhtram arbadhtram) {
		return this.arbadhtramDao.update(arbadhtram);
	}

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram find(Arbadhtram arbadhtram) {
		return (Arbadhtram) this.arbadhtramDao.find(arbadhtram);
	}

	/**
	 * Finds a Single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param codocumento
	 *            String
	 * @return Long
	 */
	public Long findByExpediente(Arbadhtram arbadhtram, String codocumento) {
		return (Long) this.arbadhtramDao.findDocTramiteResolucion(arbadhtram, codocumento);
	}

	/**
	 * Finds a List of rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbadhtram> findAll(Arbadhtram arbadhtram, Pagination pagination) {

		if (pagination != null) {
			if ("trestado".equals(pagination.getSort())) {
				pagination.setSort("TRESTADO");
			} else if ("censoMonitorEj.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("trfecfin".equals(pagination.getSort())) {
				pagination.setSort("TRFECFIN");
			} else if ("trfecini".equals(pagination.getSort())) {
				if ("desc".equalsIgnoreCase(pagination.getSord())) {
					pagination.setSort("TRFECINI DESC, TRID");
				} else {
					pagination.setSort("TRFECINI ASC, TRID");
				}
			} else if ("trcodigo".equals(pagination.getSort())) {
				if ("desc".equalsIgnoreCase(pagination.getSord())) {
					pagination.setSort("TRFECINI DESC, TRID");
				} else {
					pagination.setSort("TRFECINI ASC, TRID");
				}
			} else if ("trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FNOMBREE");
			} else if ("trid".equals(pagination.getSort())) {
				pagination.setSort("TRID");
			}
		}

		List<Arbadhtram> listTramite = this.arbadhtramDao.findAll(arbadhtram, pagination);

		if (listTramite != null && listTramite.size() > 0) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(arbadhtram.getTrexcodigo());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);
			String tipoProcedimiento = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;
			}
			TramiteComun tramiteComun = new TramiteComun();
			for (Arbadhtram tramiteDetalle : listTramite) {

				Arbadhinterv arbadhinterv = new Arbadhinterv();
				arbadhinterv.setUaexcodigo(tramiteDetalle.getTrexcodigo().toString());
				List<Arbadhinterv> listArbadhinterv = (List<Arbadhinterv>) this.arbadhintervDao.findAll(arbadhinterv,
						null);

				tramiteComun.setIdTramite(tramiteDetalle.getTrid().toString());
				tramiteComun.setIdExpediente(tramiteDetalle.getTrexcodigo().toString());
				tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));
				List<Arbadhdoc> listDocumentoSolicitud = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoSolicitud != null && listDocumentoSolicitud.size() == 1) {
					tramiteDetalle.setIndVariosDocumentos(Y41bConstantes.NO);

					tramiteDetalle.setX5codocumento(listDocumentoSolicitud.get(0).getX5codocumento());
					tramiteDetalle.setX5nofile(listDocumentoSolicitud.get(0).getX5nofile());
					tramiteDetalle.setX5sizefile(listDocumentoSolicitud.get(0).getX5sizefile());
					tramiteDetalle.setX5contenttypefile(listDocumentoSolicitud.get(0).getX5conttype());
					tramiteDetalle.setX5tedesfile(listDocumentoSolicitud.get(0).getX5tedesfile());
					tramiteDetalle.setX5origen(listDocumentoSolicitud.get(0).getX5origen());
				} else {
					if (listDocumentoSolicitud != null && listDocumentoSolicitud.size() > 1) {
						// si tiene mas de un documento
						tramiteDetalle.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}

				/* esta pendiente de localizador */
				int minutos = 0;
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				if (listDocumentoSolicitud != null) {
					boolean error = false;
					boolean sinLocalizarPorTiempo = false;
					boolean localizado = false;
					boolean firmado = false;
					String origenDestino = "";
					for (Arbadhdoc arbadhdoc : listDocumentoSolicitud) {
						// Para el origen de la aportacion
						if (Y41bConstantes.TRAMITE_ADHESION_APORTAR_ALTA.equals(tramiteDetalle.getTrcodigo())
								|| Y41bConstantes.TRAMITE_ADHESION_APORTAR_BAJA.equals(tramiteDetalle.getTrcodigo())
								|| Y41bConstantes.TRAMITE_ADHESION_APORTAR_MOD.equals(tramiteDetalle.getTrcodigo())) {
							if (!Y41bUtils.esNullOCadenaVacia(arbadhdoc.getX5origen())
									&& (Y41bUtils.esNullOCadenaVacia(origenDestino)
											|| arbadhdoc.getX5origen().equals(origenDestino))) {
								origenDestino = arbadhdoc.getX5origen();
							} else {
								origenDestino = Y41bConstantes.VALOR_NO;
							}
						}
						if (arbadhdoc.getX5fechasollocalizador() != null
								&& !tramiteDetalle.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !tramiteDetalle.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !tramiteDetalle.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
							if (arbadhdoc != null && arbadhdoc.getX5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
									.getExtensionFile(arbadhdoc.getX5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(arbadhdoc.getX5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}
								if (diffMinutes > minutos) {
									error = true;
								} else {
									sinLocalizarPorTiempo = true;
								}

							} else {
								if (tramiteDetalle.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									firmado = true;
								} else if (!tramiteDetalle.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
										&& !tramiteDetalle.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
										&& !tramiteDetalle.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
										&& !tramiteDetalle.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
										&& !tramiteDetalle.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
									localizado = true;
								}
							}
						}

					}
					if (error) {
						tramiteDetalle.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
					} else if (sinLocalizarPorTiempo) {
						tramiteDetalle.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
					} else if (firmado) {
						tramiteDetalle.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else if (localizado) {
						tramiteDetalle.setTrestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
					}
					tramiteDetalle.setNombreDestOrigen("");

					if (Y41bConstantes.TRAMITE_ADHESION_APORTAR_ALTA.equals(tramiteDetalle.getTrcodigo())
							|| Y41bConstantes.TRAMITE_ADHESION_APORTAR_BAJA.equals(tramiteDetalle.getTrcodigo())
							|| Y41bConstantes.TRAMITE_ADHESION_APORTAR_MOD.equals(tramiteDetalle.getTrcodigo())) {
						tramiteDetalle.setTipoDestOrigen(origenDestino);
						tramiteDetalle.setNombreDestOrigen(arbadhsol.getAdhesnom());
					}
				}
				// Para comunicaciones/notificaciones
				if (Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA.equals(tramiteDetalle.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA.equals(tramiteDetalle.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD.equals(tramiteDetalle.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA.equals(tramiteDetalle.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA.equals(tramiteDetalle.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD.equals(tramiteDetalle.getTrcodigo())) {
					if (tramiteDetalle.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
						if (tramiteDetalle.getTruaidinterv() != null && listArbadhinterv != null) {
							for (Arbadhinterv arbadhintervAux : listArbadhinterv) {
								if (arbadhintervAux.getUaidinterv().equals(tramiteDetalle.getTruaidinterv())) {
									tramiteDetalle.setTipoDestOrigen(arbadhintervAux.getUatipointerv());
									tramiteDetalle.setNombreDestOrigen(
											arbadhintervAux.getUanombre() == null ? "" : arbadhintervAux.getUanombre());
								}
							}
						}
					} else {
						Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
						if (datosEstablecimientoValidado != null
								&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
							tramiteDetalle.setNombreDestOrigen(datosEstablecimientoValidado.getAdhesnom());
						} else {
							tramiteDetalle.setNombreDestOrigen(arbadhsol.getAdhesnom());
						}
					}
				}
			}

		}

		return listTramite;

	}

	/**
	 * Counts rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Long
	 */
	public Long findAllCount(Arbadhtram arbadhtram) {
		return this.arbadhtramDao.findAllCount(arbadhtram);
	}

	/**
	 * Finds rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbadhtram> findAllLike(Arbadhtram arbadhtram, Pagination pagination, Boolean startsWith) {
		return (List<Arbadhtram>) this.arbadhtramDao.findAllLike(arbadhtram, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbadhtram arbadhtram, Boolean startsWith) {
		return this.arbadhtramDao.findAllLikeCount(arbadhtram, startsWith);
	}

	/**
	 * Deletes a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbadhtram arbadhtram) {
		this.arbadhtramDao.remove(arbadhtram);
	}

	/**
	 * Deletes multiple rows in the Arbadhtram table.
	 * 
	 * @param arbadhtramList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbadhtram> arbadhtramList) {
		for (Arbadhtram arbadhtramAux : arbadhtramList) {
			this.arbadhtramDao.remove(arbadhtramAux);
		}
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param expedienAux
	 *            Arbadhsol
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacion(Arbadhsol expedienAux,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception {
		Arbadhdoc arbadhdoc = null;
		String procedimientoPlatea = "";
		String tipoDocumento = "";
		String tipoProcedimiento = "";
		try {
			ArbadhtramServiceImpl.logger.info("generarTramiteAportacionDocumentacion - Inicio");

			Arbadhtram arbadhtram = new Arbadhtram();
			List<Arbadhsol> listaSolicitudes = this.arbadhsolDao.findAll(expedienAux, null);

			Arbadhsol arbadhsol = new Arbadhsol();

			if (listaSolicitudes != null && listaSolicitudes.size() > 0) {
				arbadhsol = listaSolicitudes.get(0);
			}

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			arbadhtram.setTrfecini(todayWithZeroTime);

			arbadhtram.setTrfecfin(todayWithZeroTime);

			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			arbadhtram.setArbadhsol(arbadhsol);
			arbadhtram.setTrexcodigo(arbadhsol.getAdhid());

			if (arbadhsol != null && arbadhsol.getAdhtipo() != null) {

				if (arbadhsol.getAdhtipo().equals(Y41bConstantes.ADH_TIPO_ALTA)) {

					arbadhtram.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_APORTAR_ALTA);
					procedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;

					tipoDocumento = Y41bConstantes.TIPO_DOC_ADH_ALTA_APORTACIONDOCUMENTACION;

					tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;

				} else if (arbadhsol.getAdhtipo().equals(Y41bConstantes.ADH_TIPO_BAJA)
						|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {

					arbadhtram.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_APORTAR_BAJA);
					procedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
					tipoDocumento = Y41bConstantes.TIPO_DOC_ADH_BAJA_APORTACIONDOCUMENTACION;
					tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;

				} else if (arbadhsol.getAdhtipo().equals(Y41bConstantes.ADH_TIPO_MODIF)) {

					arbadhtram.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_APORTAR_MOD);
					procedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
					tipoDocumento = Y41bConstantes.TIPO_DOC_ADH_MOD_APORTACIONDOCUMENTACION;
					tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;

				}
			}

			// la solicitud ahora no tiene la fase.
			// arbadhtram.setFase(arbexp.getFase());

			arbadhtram.setTrid((this.arbadhtramDao.getNewPK()).toString());

			this.arbadhtramDao.add(arbadhtram);

			List<Documento> listDocumentos = mensajeAportacionDoc.getDocumentosAportados();

			for (Documento documentoAux : listDocumentos) {
				// descargar documentos dokusi
				if (Y41bUtils.interactuarConDokusi()) {
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(procedimientoPlatea);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = this.y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);
					ArbadhtramServiceImpl.logger.debug("generarTramiteAportacionDocumentacion-Paso 1");
					// insertar el documento
					arbadhdoc = new Arbadhdoc();
					arbadhdoc.setX5codocumento(this.arbadhdocDao.getNewPK().toString());
					arbadhdoc.setX5excodigo(arbadhsol.getAdhid().toString());
					arbadhdoc.setX5nofile(docDokusi.getNombre());
					arbadhdoc.setX5sizefile((int) docDokusi.getLength());
					arbadhdoc.setX5origen(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
					arbadhdoc.setX5tedesfile(documentoAux.getDescripcion());
					arbadhdoc.setX5iddocumentum(documentoAux.getOidDokusi());
					arbadhdoc.setX5conttype(docDokusi.getContentType());
					SimpleDateFormat formatterFechaRegistro = new SimpleDateFormat(
							Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					Date dateFechaRegistro = formatterFechaRegistro
							.parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
					arbadhdoc.setX5fecha(dateFechaRegistro);
					arbadhdoc.setX5fechaaportacion(dateFechaRegistro);
					arbadhdoc.setArbadhtram(arbadhtram);

					arbadhdoc.setArbtipdoc(new Arbtipdoc(tipoDocumento));

					arbadhdoc.setX5fechaentrada(dateFechaRegistro);
					arbadhdoc.setX5numregistroentrada(mensajeAportacionDoc.getRegistro().getRegistryNumber());
					// Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi
					// .getBytes()));
					// arbadhdoc.setX5datafile(blob);
					this.arbadhdocDao.add(arbadhdoc);

					// insertar en la tabla de relacion
					this.arbadhdocDao.insertArbDocTramite(arbadhtram.getTrid(), arbadhdoc.getX5codocumento(),
							tipoProcedimiento);

					// llamar a transformar docuumentos
					// Ya no se transforman los documentos aportados por
					// ciudadania
					// (INC 0097665 y 115908)
					// if (com.ejie.y41b.utils.Y41bUtils
					// .isDocumentoTransformable(docDokusi)) {
					// TransformarDocumento transformarDocumento = new
					// TransformarDocumento();
					// transformarDocumento.setProcedure(documento
					// .getProcedure());
					// transformarDocumento.setUser(documento.getUser());
					// transformarDocumento.setOidDocumento(documento
					// .getOidDokusi());
					//
					// this.y41bDokusiAdapterService
					// .transformarDocumentoDokusi(transformarDocumento);
					//
					// this.arbadhdocDao.updateFechaLocalizacion(arbadhdoc);
					// }
				}
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbadhtram.getTrid().toString());
			tramiteComunAux.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));
			List<Arbadhdoc> listDocumentoHecho = this.arbadhdocDao.findAllDocumentosTramite(tramiteComunAux, null);

			this.actualizarMisGestionesAportaciondocumentacion(arbadhtram, listDocumentoHecho, procedimientoPlatea);

		} catch (Y41bUDAException e) {
			ArbadhtramServiceImpl.logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e);
			ArbadhtramServiceImpl.logger
					.error("generarTramiteAportacionDocumentacion DATOS ***** " + arbadhdoc.toString());
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			ArbadhtramServiceImpl.logger.error("generarTramiteAportacionDocumentacion ERROR ***** ",
					e_tratamientoAportacionDocumentacion);
			ArbadhtramServiceImpl.logger
					.error("generarTramiteAportacionDocumentacion DATOS ***** " + arbadhdoc.toString());
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			ArbadhtramServiceImpl.logger.info("generarTramiteAportacionDocumentacion - Final");
		}

	}

	/**
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param listDocumentos
	 *            List<Arbadhdoc>
	 * @param procedimientoPlatea
	 *            String
	 * 
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesAportaciondocumentacion(Arbadhtram arbadhtram, List<Arbadhdoc> listDocumentos,
			String procedimientoPlatea) throws SQLException {
		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(procedimientoPlatea);

		actualizarMisGestiones.setProcedure(procedure);
		DatosPersona datosPersona = new DatosPersona();

		datosPersona.setDni(arbadhtram.getArbadhsol().getAdhnif().trim().toUpperCase());
		datosPersona.setNombre(arbadhtram.getArbadhsol().getAdhesnom());

		datosPersona.setMail(arbadhtram.getArbadhsol().getAdhescoem());
		datosPersona.setTelefono(arbadhtram.getArbadhsol().getAdhesnrtel());
		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(arbadhtram.getArbadhsol().damecodCompletoPlatea());

		actualizarMisGestiones.setEjercicio(arbadhtram.getArbadhsol().getAdhsolnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		actualizarMisGestiones.setProceedingsID(this.arbadhtramDao.getNewPKProceedingsPlatea().toString());
		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentos != null && listDocumentos.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (Arbadhdoc documentoHecho : listDocumentos) {
				if (documentoHecho.getX5origen() != null
						&& documentoHecho.getX5origen().equals(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO)) {
					documento = new Documento();
					documento.setNombre(documentoHecho.getX5nofile());
					documento.setDescripcion(documentoHecho.getX5tedesfile());
					documento.setOidDokusi(documentoHecho.getX5iddocumentum());
					String tipoDocumental = "";
					if (Y41bUtils.isFilled(documentoHecho.getArbtipdoc().getTdid())) {
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(documentoHecho.getArbtipdoc().getTdid());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						tipoDocumental = arbtipdoc.getIdTipodoc();

					} else {
						tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					}
					documento.setTipoDocumental(tipoDocumental);
					listaDocumentosRdo.add(documento);
				}
			}
		}

		// Los documentos son de origen interesado
		if (listaDocumentosRdo != null && listaDocumentosRdo.size() > 0) {
			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			}

			arbadhtram.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.arbadhtramDao.updateProceedingsIdPlatea(arbadhtram);
		}

	}

	/**
	 * 
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun) {
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		this.arbadhdocDao.addArbAdhAdjuntarDocs(tramiteComun);

	}

	/**
	 * 
	 * @param tramiteComun
	 *            tramiteComun TramiteComun
	 * @param anyadirPlantilla
	 *            String
	 * @return List<Arbadhdoc>
	 */
	public List<Arbadhdoc> tratarDocumentosTemporal(TramiteComun tramiteComun, String anyadirPlantilla) {
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbadhdoc> listArbadhdocEliminados = this.arbadhdocDao.findAllDocumentosEliminados(tramiteComun, null);

		this.arbadhdocDao.removeAdhDocTramite(tramiteComun);
		// INICIO Codigo sustituido
		// this.arbadhdocDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
		// FIN Codigo sustituido
		// INICIO Se sustituye por
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			try {
				this.documentoHechoDao.remove(documentoHechoAux);
			} catch (DataIntegrityViolationException dataIntegrityViolationException) {
				throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
			}
		}
		// FIN Se sustituye por
		this.arbadhdocDao.addDocumentosHechoAdjuntarDocs(tramiteComun);
		this.arbadhdocDao.addAdjuntarDocsAdhDocTramite(tramiteComun);

		// borrar temporal
		if (!Y41bConstantes.VALOR_SI.equals(anyadirPlantilla)) {
			this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		}

		return listArbadhdocEliminados;

	}

	/**
	 * @param tramite
	 *            TramiteADHApertura
	 * @param monitor
	 *            CensoMonitor
	 * @return
	 */
	public TramiteADHApertura findTramiteApertura(TramiteADHApertura tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbadhtram arbadhtram = new Arbadhtram();
			String trid = new String(tramite.getIdTramite());
			arbadhtram.setTrid(trid);
			arbadhtram = this.arbadhsoltramDao.find(arbadhtram);

			TramiteADHApertura tramiteAux = new TramiteADHApertura();
			tramiteAux.setIdTramite(arbadhtram.getTrid().toString());
			tramiteAux.setFechaInicio(arbadhtram.getTrfecini());
			tramiteAux.setFechaFin(arbadhtram.getTrfecfin());

			tramiteAux.setInstructorAsignado(arbadhtram.getCensoMonitor());

			tramiteAux.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());

			tramiteAux.setEstadoTramite(arbadhtram.getTrestado());
			tramiteAux.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));

			if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbadhtramServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * @param tramite
	 *            TramiteADHResolucion
	 * @param monitor
	 *            CensoMonitor
	 * @return
	 */
	public TramiteADHResolucion findTramiteResolucion(TramiteADHResolucion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbadhtram arbadhtram = new Arbadhtram();
			String trid = new String(tramite.getIdTramite());
			arbadhtram.setTrid(trid);
			arbadhtram = this.arbadhsoltramDao.find(arbadhtram);

			TramiteADHResolucion tramiteAux = new TramiteADHResolucion();
			tramiteAux.setIdTramite(arbadhtram.getTrid().toString());
			tramiteAux.setFechaInicio(arbadhtram.getTrfecini());
			tramiteAux.setFechaFin(arbadhtram.getTrfecfin());

			tramiteAux.setInstructorAsignado(arbadhtram.getCensoMonitor());
			tramiteAux.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());

			tramiteAux.setEstadoTramite(arbadhtram.getTrestado());
			tramiteAux.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));

			tramiteAux.setFecha(arbadhtram.getTrresofecha());
			tramiteAux.setResultado(arbadhtram.getTrresotipo());

			if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbadhtramServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param censoMonitor
	 *            censoMonitor CensoMonitor
	 * @return boolean
	 */
	public boolean tratamientoSeguridad(Arbadhtram arbadhtram, CensoMonitor censoMonitor) {
		// obtener la solicitud

		ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. INICIO ." + arbadhtram.getTrid() + ".");

		if (censoMonitor == null || censoMonitor.getPerfilArbitraje() == null
				|| censoMonitor.getPerfilArbitraje().getIdPerfil() == null) {
			return false;
		}

		Tramite tramite = new Tramite();
		tramite.setTrcodigo(arbadhtram.getTrcodigo());
		tramite = this.tramiteDao.find(tramite);

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. PERFIL USUARIO CONECTADO:"
				+ censoMonitor.getPerfilArbitraje().getIdPerfil() + ".");
		ArbadhtramServiceImpl.logger
				.info("ARBITRAJE.tratamientoSeguridad. TIPO DE TRAMITE:" + arbadhtram.getTrcodigo() + ".");
		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_CONSULTAS)) {
			return false;
		}
		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return false;
		}
		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return false;

		}
		// Si tiene marca BOPV puede tramitar
		if (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE)) {
			if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
				return true;
			}
		}

		// Si tiene marca Pago Laudo puede tramitar
		if (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO)) {
			if (censoMonitor.getMopagolaudo() != null && censoMonitor.getMopagolaudo().equals(Y41bConstantes.SI)) {
				return true;
			}
		}
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(arbadhtram.getTrexcodigo());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);
		// String responsable = arbadhsol.getAdhusumodif();

		if (tramite != null && tramite.getIdPerfil() != null) {
			ArbadhtramServiceImpl.logger
					.info("ARBITRAJE.tratamientoSeguridad. ID PERFIL DEL TRAMITE:" + tramite.getIdPerfil() + ".");
			if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO) && (censoMonitor.getPerfilArbitraje()
					.getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
					|| (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(
							Y41bConstantes.PERFIL_INSTRUCTOR) /*
																 * &&
																 * responsable .
																 * equals (
																 * censoMonitor
																 * . getMocodigo
																 * ( ) )
																 */)
					|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
				ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad.123.RETURN TRUE");
				return true;
			} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					&& ((censoMonitor.getPerfilArbitraje().getIdPerfil().equals(
							Y41bConstantes.PERFIL_INSTRUCTOR) /*
																 * &&
																 * responsable
																 * .equals(
																 * censoMonitor
																 * . getMocodigo
																 * ())
																 */)
							|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
							|| censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
				ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad.124.RETURN TRUE");
				return true;
			} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR) && (censoMonitor
					.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
				ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad.125.RETURN TRUE");
				return true;
			} else {
				ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. RETURN FALSE1.");
				return false;
			}
		} else {
			ArbadhtramServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. RETURN FALSE2.");
			return false;
		}

	}

	/**
	 * @return Long
	 */
	public Long getNewPK() {
		return this.arbadhtramDao.getNewPK();
	}

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAcuseRecibo addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, boolean reintento) throws Exception {
		return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma, tramitar, null, false, reintento);
	}

	/*
	 * private TramiteAcuseRecibo addTramiteAcuseReciboDesdeRemesa(
	 * TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun, String
	 * idioma, boolean tramitar, Arbadhdoc docHechoPEE) throws Exception {
	 * return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma,
	 * tramitar, docHechoPEE, true); }
	 */

	// Metodo comun para realizar Tramitar acuse de recibo
	private TramiteAcuseRecibo addTramiteAcuseRecibo0(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, Arbadhdoc docHechoPEE, boolean esRemesa, boolean reintento)
			throws Exception {
		try {

			ArbadhtramServiceImpl.logger.info("ArbbandejaDaoImpl - addTramiteAcuseRecibo - Inicio.");

			Arbadhtram arbadhtram = new Arbadhtram();
			arbadhtram.setTrid(tramiteComun.getIdTramite());
			arbadhtram = this.arbadhtramDao.find(arbadhtram);

			if (arbadhtram.getTrestado() != null
					&& !arbadhtram.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {

				Arbadhsol arbadhsol = new Arbadhsol();
				arbadhsol.setAdhid(tramiteComun.getIdExpediente());
				arbadhsol = this.arbadhsolDao.find(arbadhsol);

				arbadhtram.setFase(null);
				arbadhtram.setTrfecini(tramiteAcuseRecibo.getFechaInicio());
				if (tramitar) {
					arbadhtram.setTrfecfin(tramiteAcuseRecibo.getFechaFin());
					arbadhtram.setCensoMonitorEj(tramiteAcuseRecibo.getInstructorEjecucion());
					// llamnar a platea
					// cambiar fase
					arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				} else {
					arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
				arbadhtram.setArbadhsol(arbadhsol);
				arbadhtram.setFase(null);
				arbadhtram.setCensoMonitor(tramiteAcuseRecibo.getInstructorAsignado());
				arbadhtram.setTrobserves(Y41bUtils.stringToClob(tramiteAcuseRecibo.getComentario()));

				// Info de Acuse recibo ini
				arbadhtram.setTrfecacuse(tramiteAcuseRecibo.getFechaacuse());
				arbadhtram.setTrestadoacuse(tramiteAcuseRecibo.getSituacionacuse());
				// Info de Acuse recibo fin

				// Se actualiza el tramite, nunca se inserta porque ya existe
				arbadhtram = this.setArbadhtram(arbadhtram);

				// buscar los documentos que no estan en la tabla de trabajo de
				// documentos y que pertenecen al Tramite
				List<Arbadhdoc> listArbadhdocEliminados = null;
				if (esRemesa) {
					if (docHechoPEE != null) {

						this.arbadhdocDao.add(docHechoPEE);
						this.arbadhdocDao.insertArbDocTramite(tramiteComun.getIdTramite(),
								docHechoPEE.getX5codocumento(), tramiteComun.getTipoProcedimiento().getPcodigo());

					}
				} else {
					listArbadhdocEliminados = this.tratarDocumentosTemporal(tramiteComun,
							tramiteAcuseRecibo.getAnyadirPlantilla());

				}

				// Se actualiza el origen de la lista de documentos del tramite
				// dependiendo del destinatario de la notificacion
				this.actualizarOrigenDocsTramiteAcuseRecibo(tramiteComun,
						tramiteAcuseRecibo.getTramiteNotificacion().getDestinatario());

				if (tramitar) {
					if (!reintento) {
						if (!this.tratarTramitacionAcuse(arbadhtram)) {
							tramiteAcuseRecibo.getTramiteNotificacion().setTramiteRelacionado(Y41bConstantes.VALOR_NO);
						}
					}
				}

				if (listArbadhdocEliminados != null) {
					this.eliminarDocumentosDokusi(listArbadhdocEliminados,
							tramiteComun.getTipoProcedimiento().getPcodigo());
				}

				tramiteAcuseRecibo.setAcuseSinNotificacion(arbadhtram.getAcuseSinNotificacion());

				if (reintento) {
					// actualizar el campo del tramite de acuse a
					// TRACUSEREINTENTADO
					// a S
					arbadhtram.setTracusereintentado(Y41bConstantes.SI);
					this.arbadhtramDao.updateAcuseReintentado(arbadhtram);

					// generar la notificacin
					TramiteComun tramiteComunNot = new TramiteComun();
					tramiteComunNot.setIdTramite(arbadhtram.getTrtridrel());
					tramiteComunNot.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
					this.generarReintentoTramiteNotificacion(arbadhtram.getTrtridrel(), tramiteComunNot);
				}

				return tramiteAcuseRecibo;
			} else {

				if (reintento) {
					// actualizar el campo del tramite de acuse a
					// TRACUSEREINTENTADO
					// a S
					arbadhtram.setTracusereintentado(Y41bConstantes.SI);
					this.arbadhtramDao.updateAcuseReintentado(arbadhtram);

					// generar la notificacin
					TramiteComun tramiteComunNot = new TramiteComun();
					tramiteComunNot.setIdTramite(arbadhtram.getTrtridrel());
					tramiteComunNot.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
					this.generarReintentoTramiteNotificacion(arbadhtram.getTrtridrel(), tramiteComunNot);
				}

				return tramiteAcuseRecibo;
			}

		} catch (Exception e) {
			ArbadhtramServiceImpl.logger
					.error("ArbbandejaDaoImpl - addTramiteAcuseRecibo - EXCEPTION. " + e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Generar Reintento Tramite de Notificacion
	 * 
	 * @param trtridrel
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void generarReintentoTramiteNotificacion(String trtridrel, TramiteComun tramiteComun) throws Exception {

		// Coger la notificacin relacionada con el sancionador
		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(trtridrel);
		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		// Crear la nueva notificacin en base a los campos de la ltima
		Arbadhtram arbadhtramNuevo = new Arbadhtram();
		arbadhtramNuevo.setTrcodigo(arbadhtram.getTrcodigo());
		arbadhtramNuevo.setTrexcodigo(arbadhtram.getTrexcodigo());
		arbadhtramNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
		arbadhtramNuevo.setCensoMonitor(arbadhtram.getCensoMonitor());
		arbadhtramNuevo.setTrcodigorel(arbadhtram.getTrcodigorel());
		arbadhtramNuevo.setTrtridrel(arbadhtram.getTrtridrel());
		arbadhtramNuevo.setFase(arbadhtram.getFase());
		arbadhtramNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		arbadhtramNuevo.setTrasuntocomunicacion(arbadhtram.getTrasuntocomunicacion());
		arbadhtramNuevo.setTruaidinterv(arbadhtram.getTruaidinterv());
		arbadhtramNuevo.setTrfecnotif(Y41bUtils.obtenerFechaHoy());
		arbadhtramNuevo.setTrenvrem(arbadhtram.getTrenvrem());
		arbadhtramNuevo.setTrtiponotplatea(arbadhtram.getTrtiponotplatea());
		arbadhtramNuevo.setTridnotifplatea(arbadhtram.getTridnotifplatea());
		arbadhtramNuevo.setTrtexto(arbadhtram.getTrtexto());
		arbadhtramNuevo.setTrautomatico(Y41bConstantes.VALOR_SI);

		arbadhtramNuevo.setTrid((this.arbadhtramDao.getNewPK()).toString());
		arbadhtramNuevo = this.add(arbadhtramNuevo);

		// Asignar los documentos a la nueva notificacin
		List<Arbadhdoc> documentos = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);

		// Relaciono tramite - documento
		if (documentos != null && documentos.size() > 0) {
			for (Arbadhdoc documento : documentos) {
				if (Y41bUtils.esNullOCadenaVacia(documento.getX5destino())
						|| documento.getX5destino().equals(arbadhtram.getTruaidinterv())) {
					this.arbadhdocDao.insertArbDocTramite(arbadhtramNuevo.getTrid(), documento.getX5codocumento(),
							documento.getX5pcodigo());
				}
			}
		}
	}

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram setArbadhtram(Arbadhtram arbadhtram) {

		if (this.arbadhtramDao.exists(arbadhtram)) {
			return this.arbadhtramDao.update(arbadhtram);
		} else {
			return this.arbadhtramDao.add(arbadhtram);
		}
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite
	 * acuse de recibo con el parametro recibido
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param destinatario
	 *            String
	 */
	private void actualizarOrigenDocsTramiteAcuseRecibo(TramiteComun tramiteComun, String destinatario) {
		String origen_doc = Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO;

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		tramiteComunAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		List<Arbadhdoc> listDocumentoHecho = this.arbadhdocDao.findAllDocumentosTramite(tramiteComunAux, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Arbadhdoc documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setX5origen(origen_doc);
				this.arbadhdocDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listArbadhdoc
	 *            List<Arbadhdoc>
	 * @throws SQLException
	 *             SQLException
	 */
	private void eliminarDocumentosDokusi(List<Arbadhdoc> listArbadhdoc, String procedimiento) throws SQLException {
		// Eliminamos los documentos de dokusi
		if (listArbadhdoc != null && listArbadhdoc.size() > 0) {
			for (Arbadhdoc arbadhdoc : listArbadhdoc) {
				if (arbadhdoc != null && arbadhdoc.getX5iddocumentum() != null
						&& !arbadhdoc.getX5iddocumentum().equals("")) {

					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(
							Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(procedimiento));
					documento.setProcedure(procedure);
					documento.setOidDokusi(arbadhdoc.getX5iddocumentum());
					documento.setBoolAllVersions("true");

					this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);

				}
			}
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 */
	public boolean tratarTramitacionAcuse(Arbadhtram arbadhtram) throws Exception {
		try {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(arbadhtram.getTrexcodigo());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);
			String tipoProcedimiento = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;
			}
			String idTramitenotificacion = arbadhtram.getTrtridrel();
			Arbadhtram arbadhtramTramiteNotificacion = new Arbadhtram();
			arbadhtramTramiteNotificacion.setTrid(idTramitenotificacion);
			arbadhtramTramiteNotificacion = this.arbadhtramDao.find(arbadhtramTramiteNotificacion);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbadhtramTramiteNotificacion.getTrid().toString());
			tramiteComunAux.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));
			List<Arbadhdoc> listDocumentos = this.arbadhdocDao.findAllDocumentosTramite(tramiteComunAux, null);

			if (!Y41bConstantes.ESTADO_ACUSE_NO_ENTREGADO.equals(arbadhtram)) {
				Arbadhtram tramiteRelacionado = null;
				if (arbadhtramTramiteNotificacion != null) {
					if (arbadhtramTramiteNotificacion.getTrtridrel() != null) {
						tramiteRelacionado = this.arbadhtramDao
								.find(new Arbadhtram(arbadhtramTramiteNotificacion.getTrtridrel()));
						if (tramiteRelacionado != null
								&& !Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrcodigo())
								&& (tramiteRelacionado.getTrcodigo()
										.equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA)
										|| tramiteRelacionado.getTrcodigo()
												.equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA)
										|| tramiteRelacionado.getTrcodigo()
												.equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD))) {
							Arbadhtram resolucion = new Arbadhtram();
							if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
								resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
							} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
								resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
							} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
									|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
								resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
							}
							resolucion.setTrexcodigo(arbadhtram.getTrexcodigo());
							List<Arbadhtram> ltramites = arbadhtramDao.findAll(resolucion, null);
							if (ltramites != null && ltramites.size() > 0) {
								Arbadhtram cierre = new Arbadhtram();
								cierre.setTrid(this.arbadhtramDao.getNewPK().toString());
								cierre.setTrexcodigo(arbadhtram.getTrexcodigo());
								if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
									cierre.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_ALTA);
								} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
										|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
									cierre.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_BAJA);
								} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
									cierre.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_MOD);
								}
								cierre.setTrfecini(Y41bUtils.hoy());
								cierre.setTrfecfin(Y41bUtils.hoy());
								cierre.setCensoMonitorEj(arbadhtram.getCensoMonitorEj());

								if (!Y41bConstantes.ESTADO_ACUSE_NO_ENTREGADO.equals(arbadhtram)) {
									cierre.setTrfeccierre(Y41bUtils.hoy());
									cierre.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
								} else {
									cierre.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
								}
								this.arbadhtramDao.add(cierre);

								arbadhsol.setAdhestado(ltramites.get(0).getTrresotipo());
								this.arbadhsolDao.update(arbadhsol);
							}
						}
					}
				}
			}
			this.actualizarMisGestionesNotificacion(arbadhtram, listDocumentos);

			return true;
		} catch (Exception e) {
			ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - tratarTramitacionAcuse - ExceptionException .");
			ArbadhtramServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * 
	 * @param arbadhtram
	 *            arbadhtram
	 * @param listDocumentos
	 *            Arbadhdoc
	 * @throws SQLException
	 */
	public void actualizarMisGestionesNotificacion(Arbadhtram arbadhtram, List<Arbadhdoc> listDocumentos)
			throws SQLException {

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(arbadhtram.getTrexcodigo());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		String tipoProc = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}

		// arbadhtram es el acuse
		Arbadhtram tramiteNotificacion = null;
		Arbadhtram tramiteRelacionado = null;
		if (arbadhtram.getTrtridrel() != null) {
			tramiteNotificacion = this.arbadhtramDao.find(new Arbadhtram(arbadhtram.getTrtridrel()));

			if (tramiteNotificacion != null) {
				if (tramiteNotificacion.getTrtridrel() != null) {
					tramiteRelacionado = this.arbadhtramDao.find(new Arbadhtram(tramiteNotificacion.getTrtridrel()));
					if (tramiteRelacionado != null) {
						this.actualizarMisGestiones(tramiteRelacionado);
					}
				}

				ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento(tipoProc);

				actualizarMisGestiones.setProcedure(procedure);
				actualizarMisGestiones.setNumeroExpediente(arbadhsol.getNumExpediente());

				DatosPersona datosPersona = new DatosPersona();
				Arbadhsol validacionEstablecimiento = this.arbadhsolDao.findDatosValidacion(arbadhsol);
				if (validacionEstablecimiento != null
						&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
					datosPersona.setDni(validacionEstablecimiento.getAdhnif().trim().toUpperCase());
					datosPersona.setNombre(validacionEstablecimiento.getAdhesnom());
					datosPersona.setMail(validacionEstablecimiento.getAdhescoem());
					datosPersona.setTelefono(validacionEstablecimiento.getAdhesnrtel());
				} else {
					datosPersona.setDni(arbadhsol.getAdhnif().trim().toUpperCase());
					datosPersona.setNombre(arbadhsol.getAdhesnom());
					datosPersona.setMail(arbadhsol.getAdhescoem());
					datosPersona.setTelefono(arbadhsol.getAdhesnrtel());
				}
				actualizarMisGestiones.setSolicitante(datosPersona);
				actualizarMisGestiones.setEjercicio(arbadhsol.getAdhsolnran().toString());

				actualizarMisGestiones.setNumeroExpediente(arbadhsol.getNumExpediente());

				actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);

				actualizarMisGestiones.setProceedingsID(arbadhtramDao.getNewPKProceedingsPlatea().toString());

				actualizarMisGestiones.setIdnotificacionplatea(tramiteNotificacion.getTridnotifplatea());
				actualizarMisGestiones.setIdTiponotificacionplatea(tramiteNotificacion.getTrtiponotplatea());

				Calendar notificacionPublicationTimestamp = Calendar.getInstance();
				notificacionPublicationTimestamp.setTime(tramiteNotificacion.getTrfecfin());
				actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);
				if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteNotificacion.getTrtiponot())) {
					actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
				} else {
					actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
				}

				Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
				notificacionDeliveryTimestamp.setTime(arbadhtram.getTrfecacuse());
				actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);

				actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(arbadhtram.getTrestadoacuse());

				List<Documento> listaDocumentosRdo = null;
				if (listDocumentos != null && listDocumentos.size() > 0) {
					listaDocumentosRdo = new ArrayList<Documento>();
					Documento documento = null;
					for (Arbadhdoc documentoHecho : listDocumentos) {
						documento = new Documento();
						documento.setNombre(documentoHecho.getX5nofile());
						documento.setDescripcion(documentoHecho.getX5tedesfile());
						documento.setOidDokusi(documentoHecho.getX5iddocumentum());
						String tipoDocumental = "";
						if (documentoHecho.getArbtipdoc() != null
								&& Y41bUtils.isFilled(documentoHecho.getArbtipdoc().getTdid())) {
							Arbtipdoc arbtipdoc = new Arbtipdoc();
							arbtipdoc.setTdid(documentoHecho.getArbtipdoc().getTdid());
							arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
							tipoDocumental = arbtipdoc.getIdTipodoc();

						} else {
							tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
						}
						documento.setTipoDocumental(tipoDocumental);
						listaDocumentosRdo.add(documento);
					}
				}

				actualizarMisGestiones.setDocumentos(listaDocumentosRdo);
				if (Y41bUtils.interactuarConDokusi()) {
					y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);
				}

				arbadhtram.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
				this.arbadhtramDao.updateProceedingsIdPlatea(arbadhtram);
			}
		}
		if (tramiteRelacionado != null && !Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrcodigo())
				&& (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA)
						|| tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA)
						|| tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD))) {
			if (!Y41bConstantes.ESTADO_ACUSE_NO_ENTREGADO.equals(arbadhtram)) {
				// Tras la resolucion y comunicacion hacemos el cierre
				CierreExpediente cierreExpediente = new CierreExpediente();
				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento(tipoProc);
				cierreExpediente.setProcedure(procedure);
				cierreExpediente.setNumeroExpediente(arbadhsol.getNumExpediente());
				cierreExpediente.setEjercicio(arbadhsol.getAdhsolnran().toString());
				if (Y41bUtils.interactuarConDokusi()) {
					this.y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
				}
			}
		}
	}

	/**
	 * 
	 * @param arbadhtram
	 *            arbadhtram
	 * @param listDocumentos
	 *            Arbadhdoc
	 * @throws SQLException
	 */
	public void actualizarMisGestionesComunicacion(Arbadhtram tramiteComunicacion, List<Arbadhdoc> listDocumentos)
			throws SQLException {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComunicacion.getTrexcodigo());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		String tipoProc = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(tipoProc);
		actualizarMisGestiones.setProcedure(procedure);
		actualizarMisGestiones.setNumeroExpediente(arbadhsol.getNumExpediente());

		Arbadhtram tramiteRelacionado = null;
		if (tramiteComunicacion.getTrtridrel() != null) {
			tramiteRelacionado = this.arbadhtramDao.find(new Arbadhtram(tramiteComunicacion.getTrtridrel()));
		}
		if (tramiteRelacionado != null && Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())) {
			this.actualizarMisGestiones(tramiteRelacionado);
		}

		DatosPersona datosPersona = new DatosPersona();
		Arbadhsol validacionEstablecimiento = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		if (validacionEstablecimiento != null
				&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
			datosPersona.setDni(validacionEstablecimiento.getAdhnif().trim().toUpperCase());
			datosPersona.setNombre(validacionEstablecimiento.getAdhesnom());
			datosPersona.setMail(validacionEstablecimiento.getAdhescoem());
			datosPersona.setTelefono(validacionEstablecimiento.getAdhesnrtel());
		} else {
			datosPersona.setDni(arbadhsol.getAdhnif().trim().toUpperCase());
			datosPersona.setNombre(arbadhsol.getAdhesnom());
			datosPersona.setMail(arbadhsol.getAdhescoem());
			datosPersona.setTelefono(arbadhsol.getAdhesnrtel());
		}
		actualizarMisGestiones.setSolicitante(datosPersona);
		actualizarMisGestiones.setEjercicio(arbadhsol.getAdhsolnran().toString());

		if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteComunicacion.getTrtipocom())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones.setProceedingsID(arbadhtramDao.getNewPKProceedingsPlatea().toString());

		actualizarMisGestiones.setIdnotificacionplatea(tramiteComunicacion.getTridnotifplatea());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentos != null && listDocumentos.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (Arbadhdoc documentoHecho : listDocumentos) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getX5nofile());
				documento.setDescripcion(documentoHecho.getX5tedesfile());
				documento.setOidDokusi(documentoHecho.getX5iddocumentum());
				String tipoDocumental = "";
				if (documentoHecho.getArbtipdoc() != null
						&& Y41bUtils.isFilled(documentoHecho.getArbtipdoc().getTdid())) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(documentoHecho.getArbtipdoc().getTdid());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
					tipoDocumental = arbtipdoc.getIdTipodoc();

				} else {
					tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
				}
				documento.setTipoDocumental(tipoDocumental);
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);
		if (Y41bUtils.interactuarConDokusi()) {
			y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);
		}

		tramiteComunicacion.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.arbadhtramDao.updateProceedingsIdPlatea(tramiteComunicacion);

		// Tras la resolucion y comunicacion hacemos el cierre
		if (tramiteRelacionado != null && !Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrcodigo())
				&& (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA)
						|| tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA)
						|| tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD))) {
			CierreExpediente cierreExpediente = new CierreExpediente();
			procedure = new Procedure();
			procedure.setIdProcedimiento(tipoProc);
			cierreExpediente.setProcedure(procedure);
			cierreExpediente.setNumeroExpediente(arbadhsol.getNumExpediente());
			cierreExpediente.setEjercicio(arbadhsol.getAdhsolnran().toString());
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
			}
		}
	}

	/**
	 * @param sanadhtram
	 *            Sanadhtram
	 * @throws SQLException
	 *             SQLException
	 */
	private void actualizarMisGestiones(Arbadhtram arbadhtram) throws SQLException {
		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(arbadhtram.getTrexcodigo());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		Procedure procedure = new Procedure();
		String tipoTramite = "";
		String tipoProc = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA;
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD;
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA;
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}
		procedure.setIdProcedimiento(tipoProc);
		actualizarMisGestiones.setProcedure(procedure);

		DatosPersona datosPersona = new DatosPersona();
		Arbadhsol validacionEstablecimiento = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		if (validacionEstablecimiento != null
				&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
			datosPersona.setDni(validacionEstablecimiento.getAdhnif().trim().toUpperCase());
			datosPersona.setNombre(validacionEstablecimiento.getAdhesnom());
			datosPersona.setMail(validacionEstablecimiento.getAdhescoem());
			datosPersona.setTelefono(validacionEstablecimiento.getAdhesnrtel());
		} else {
			datosPersona.setDni(arbadhsol.getAdhnif().trim().toUpperCase());
			datosPersona.setNombre(arbadhsol.getAdhesnom());
			datosPersona.setMail(arbadhsol.getAdhescoem());
			datosPersona.setTelefono(arbadhsol.getAdhesnrtel());
		}
		actualizarMisGestiones.setSolicitante(datosPersona);

		actualizarMisGestiones.setEjercicio(arbadhsol.getAdhsolnran().toString());

		actualizarMisGestiones.setNumeroExpediente(arbadhsol.getNumExpediente());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (arbadhtram != null && !Y41bUtils.esNullOCadenaVacia(arbadhtram.getTrproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(arbadhtram.getTrproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(arbadhtramDao.getNewPKProceedingsPlatea().toString());
		}
		if (tipoTramite.equals(arbadhtram.getTrcodigo())) {
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RESOLUCION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
			Locale locale_castellano = new Locale(Y41bConstantes.CASTELLANO);
			Locale locale_euskera = new Locale(Y41bConstantes.EUSKERA);
			if (Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				actualizarMisGestiones.setDecisionEus(
						this.appMessageSource.getMessage("excel.estado.rechazada", null, locale_euskera));
				actualizarMisGestiones.setDecisionCas(
						this.appMessageSource.getMessage("excel.estado.rechazada", null, locale_castellano));
			} else {
				actualizarMisGestiones.setDecisionEus(
						this.appMessageSource.getMessage("excel.estado.aceptada", null, locale_euskera));
				actualizarMisGestiones.setDecisionCas(
						this.appMessageSource.getMessage("excel.estado.aceptada", null, locale_castellano));
			}
			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(arbadhtram.getTrresofecha());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
		}

		if (Y41bUtils.interactuarConDokusi()) {
			this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
		}

	}

	/**
	 * Inserts a single row in the Arbadhtram table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbadhtram
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}

		if (tramitar) {
			arbadhtram.setTrfecfin(tramiteGenerico.getFechaFin());
			arbadhtram.setCensoMonitorEj(tramiteGenerico.getInstructorEjecucion());
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		arbadhtram.setFase(null);
		arbadhtram.setTrfecini(tramiteGenerico.getFechaInicio());
		arbadhtram.setArbadhsol(arbadhsol);
		String tipoTramite = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_GENERICO_ALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_GENERICO_MOD;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_GENERICO_BAJA;
		}
		arbadhtram.setTrcodigo(tipoTramite);
		arbadhtram.setFase(null);

		arbadhtram.setCensoMonitor(tramiteGenerico.getInstructorAsignado());
		arbadhtram.setTrnomtrames(tramiteGenerico.getNombreTramite());
		arbadhtram.setTrobserves(Y41bUtils.stringToClob(tramiteGenerico.getComentario()));

		arbadhtram.setTrid(tramiteComun.getIdTramite());
		arbadhtram.setTrexcodigo(tramiteComun.getIdExpediente());

		arbadhtram = this.setArbadhtram(arbadhtram);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbadhdoc> listArbadhdocEliminados = this.tratarDocumentosTemporal(tramiteComun, Y41bConstantes.VALOR_NO);

		this.eliminarDocumentosDokusi(listArbadhdocEliminados, tramiteComun.getTipoProcedimiento().getPcodigo());
		return arbadhtram;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param monitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor monitor) {

		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbadhtram arbadhtram = new Arbadhtram();
		String trid = new String(tramiteGenerico.getIdTramite());
		arbadhtram.setTrid(trid);
		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		TramiteGenerico tramiteGenericoAux = new TramiteGenerico();
		tramiteGenericoAux.setIdTramite(arbadhtram.getTrid().toString());
		tramiteGenericoAux.setFechaInicio(arbadhtram.getTrfecini());
		tramiteGenericoAux.setFechaFin(arbadhtram.getTrfecfin());

		tramiteGenericoAux.setInstructorAsignado(arbadhtram.getCensoMonitor());
		tramiteGenericoAux.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());
		tramiteGenericoAux.setEstadoTramite(arbadhtram.getTrestado());
		tramiteGenericoAux.setNombreTramite(arbadhtram.getTrnomtrames());

		tramiteGenericoAux.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));

		if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteGenericoAux;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor monitor) {

		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbadhtram arbadhtram = new Arbadhtram();
		String trid = new String(tramiteCierre.getIdTramite());
		arbadhtram.setTrid(trid);
		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		TramiteCierre tramite = new TramiteCierre();
		tramite.setIdTramite(arbadhtram.getTrid().toString());
		tramite.setFechaInicio(arbadhtram.getTrfecini());
		tramite.setFechaFin(arbadhtram.getTrfecfin());

		tramite.setInstructorAsignado(arbadhtram.getCensoMonitor());

		tramite.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());

		tramite.setEstadoTramite(arbadhtram.getTrestado());

		tramite.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));

		tramite.setFechaCierre(arbadhtram.getTrfeccierre());

		if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
			tramite.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramite.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramite;
	}

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile, CensoMonitor censoMonitor) throws Exception {
		if (tramitar) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (arbadhsol != null) {
				tramiteComunicacion.setDestinatario(
						String.valueOf(this.arbadhintervDao.volcarDatosValidacion(tramiteComun.getIdExpediente())));
			} else {
				tramiteComunicacion.setDestinatario(
						String.valueOf(this.arbadhintervDao.volcarDatosSolicitud(tramiteComun.getIdExpediente())));
			}
		} else {
			tramiteComunicacion.setDestinatario("-1");
		}
		return addTramiteComunicacion0(tramiteComunicacion, tramiteComun, idioma, tramitar, modoEditar,
				esComunicacionOrdinaria, esComunicacionElectronica, idZipFile, censoMonitor);
	}

	/**
	 * Guardar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esComunicacionOrdinaria
	 *            the es notificacion ordinaria
	 * @param esComunicacionElectronica
	 *            the es notificacion tipo electronica
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public Arbadhtram addTramiteComunicacion0(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile, CensoMonitor censoMonitor) throws Exception {

		if (tramitar && Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
			this.validarSiExisteSede(tramiteComun.getIdExpediente());
		}

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 1/14.\ntramitar:" + tramitar
				+ ".\nmodoEditar" + modoEditar + ".\nesNotificacionTipoElectronica" + esComunicacionElectronica + ".");
		Arbadhtram arbadhtram = new Arbadhtram();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}

		arbadhtram.setFase(null);
		String tipoTramite = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA;
		}
		arbadhtram.setTrcodigo(tipoTramite);
		arbadhtram.setTrfecini(tramiteComunicacion.getFechaInicio());

		arbadhtram.setTrfecfin(tramiteComunicacion.getFechaFin());
		arbadhtram.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());

		// Remesas Ini
		arbadhtram.setTrenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		arbadhtram.setTrcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin

		if (tramitar) {
			arbadhtram.setTrfecfin(tramiteComunicacion.getFechaFin());
			arbadhtram.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 2/14.");

		arbadhtram.setArbadhsol(arbadhsol);
		arbadhtram.setFase(null);
		arbadhtram.setCensoMonitor(null);
		arbadhtram.setTrobserves(Y41bUtils.stringToClob(tramiteComunicacion.getComentario()));

		arbadhtram.setTrfecnotif(tramiteComunicacion.getFechaComunicacion());
		if (tramitar) {
			arbadhtram.setTruaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
		} else {
			arbadhtram.setTruaidinterv(new BigDecimal("-1"));
		}
		arbadhtram.setTrsede(tramiteComunicacion.getSede());
		arbadhtram.setTrtipocom(esComunicacionElectronica ? Y41bConstantes.TIPO_COMUNICACION_TELEMATICA
				: Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO);
		arbadhtram.setTrfecregs(tramiteComunicacion.getFechasalida());
		arbadhtram.setTrnumregs(tramiteComunicacion.getNumregistrosalida());
		arbadhtram.setTrasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());
		arbadhtram.setTrtexto(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));
		arbadhtram.setTridmailorigen(tramiteComunicacion.getIdmailorigen());
		arbadhtram.setTrmailorigen(tramiteComunicacion.getMailorigen());
		arbadhtram.setTridmaildestino(tramiteComunicacion.getIdmaildestino());
		arbadhtram.setTrmaildestino(tramiteComunicacion.getMaildestino());

		// Se inserta el tramite
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		arbadhtram.setTrexcodigo(tramiteComun.getIdExpediente());

		ArbadhtramServiceImpl.logger.info(
				"ArbadhtramServiceImpl - addTramiteComunicacion: 3/14." + new BigDecimal(tramiteComun.getIdTramite()));

		// Obtener registro salida si no viene de pantalla
		if (tramitar && esComunicacionOrdinaria) {
			if (arbadhtram.getTrenvrem() == null || Y41bConstantes.NO.equals(arbadhtram.getTrenvrem())) {
				if (arbadhtram.getTrnumregs() == null || arbadhtram.getTrnumregs().equals("")) {
					RegistroSalida registroSalida = this.getRegistroSalida(tramiteComun,
							arbadhtram.getTruaidinterv().toString(), false);
					arbadhtram.setTrnumregs(registroSalida.getRegistryNumber());
					arbadhtram.setTrfecregs(registroSalida.getRegistryDate());
				}
			}
		}
		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 4/14.");
		arbadhtram = this.setArbadhtram(arbadhtram);

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

		ArbadhtramServiceImpl.logger
				.info("ArbadhtramServiceImpl - addTramiteComunicacion: 5/14.\n" + tramiteComun.toString());

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbadhdoc> listArbadhdocEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramiteComunicacion.getAnyadirPlantilla());

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 6/14.");

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		tramiteComunAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		List<Arbadhdoc> listDocumentoHecho = this.arbadhdocDao.findAllDocumentosTramite(tramiteComunAux, null);
		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 7/14.");

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				if (Y41bUtils.interactuarConDokusi()) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 9/14.");

			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl - addTramiteComunicacion: 9B/14. Comprobaciones de formato.");
			/***
			 * COMPROBAMOS SI TODOS LOS DOCUMENTOS TIENE LOCALIZADOR PARA LA
			 * ORDINARIA
			 */
			if (esComunicacionOrdinaria) {
				if (!"S".equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
					this.comprobarFormatoDocumentosEnviar(listadjuntardocs, true,
							tramiteComun.getTipoProcedimiento().getPcodigo());
					ArbadhtramServiceImpl.logger
							.info("ArbadhtramServiceImpl - addTramiteComunicacion: 9C/14. Creamos ZIP.");
					this.crearZipDocumentosExpediente(idZipFile, listadjuntardocs, arbadhsol);
				} else {
					this.comprobarFormatoDocumentosEnviar(listadjuntardocs, false,
							tramiteComun.getTipoProcedimiento().getPcodigo());
				}
			}

			if (tramiteComunicacion.getEnvRemesaComunicacion() != null
					&& Y41bConstantes.SI.equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
				if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
					this.controlDocumentosProtegidosRemesa(listadjuntardocs);
				}
			}

			if (tramiteComunicacion.getEjgvDocument() != null) {
				ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: 13/14."
						+ tramiteComunicacion.getEjgvDocument().length());
			}

			/* creamos el zip */

			if (esComunicacionElectronica) {
				String textoNotificacionComunicacion = tramiteComunicacion.getTextoComunicacion();
				String destinatario = tramiteComunicacion.getDestinatario();
				String envRemesa = tramiteComunicacion.getEnvRemesaComunicacion();

				CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramiteComun.getIdExpediente(),
						tramiteComun.getIdTramite(), Y41bConstantes.NOTIFICACION_COMUNICACION,
						textoNotificacionComunicacion, destinatario, envRemesa, listDocumentoHecho, censoMonitor,
						tramiteComun.getTipoProcedimiento().getPcodigo());

				RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
						.procesarEnviarNotificacionX43(crearNotifEJGV);

				// EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
				// envioNotifEJGV.setEjgvDocument(tramiteComunicacion
				// .getEjgvDocument());
				// // ******************* Anadimos FIRMA SERVIDOR
				// // ********************
				// //
				// ****************************************************************
				// // envioNotifEJGV.setFirma(tramiteNotificacion.getFirma());
				//
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl - addTramiteComunicacion:
				// 14/14.");
				//
				// if (Y41bUtils.interactuarConDokusi()) {
				// envioNotifEJGV.setFirma(this
				// .creaFirmaServidor(tramiteComunicacion
				// .getEjgvDocument()));
				// } else {
				// envioNotifEJGV.setFirma("firmaficticia");
				// }
				//
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl - addTramiteComunicacion:
				// 15/14.");
				//
				// RespuestaNotificacion respuestaNotif = new
				// RespuestaNotificacion();
				// if (esComunicacionElectronica
				// && Y41bUtils.interactuarConDokusi()) {
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl. - addTramiteComunicacion.
				// Inicio Llamada a Platea");
				// respuestaNotif = this.y41bPlateaAdapterService
				// .procesarEnviarComunicacion(envioNotifEJGV);
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl. - addTramiteComunicacion. Fin
				// Llamada a Platea");
				//
				// } else {
				// respuestaNotif.setNumeroRegistro("");
				// }
				arbadhtram.setTridnotifplatea(respuestaNotif.getNumeroRegistro());
				this.arbadhtramDao.updateIdNotificacionPlatea(arbadhtram);

				if (esComunicacionElectronica && Y41bUtils.interactuarConDokusi()) {
					// 4.2 Recuperar segistro salida de notificacion y
					// actualizar
					// tabla
					// tramite hecho con el registro de salida y su fecha de
					// registro
					TNotification tNotification = this.y41bPlateaAdapterService
							.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

					arbadhtram.setTrnumregs(tNotification.getRegistryID().getRegistryNumber());
					arbadhtram.setTrfecregs(
							Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));

					// RegistroSalida registroSalida =
					// this.y41bPlateaAdapterService
					// .getRegistroSalidaFromIdNotificacion(respuestaNotif
					// .getNumeroRegistro());
					//
					// arbadhtram.setTrnumregs(registroSalida.getRegistryNumber());
					// arbadhtram.setTrfecregs(Y41bUtils
					// .parseNotificationRegistrytimestamp(registroSalida
					// .getRegistryTimestamp()));
					this.arbadhtramDao.updateRegistroSalidaPlatea(arbadhtram);
				}

			}

			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl - addTramiteComunicacion - Genero el aviso para la orden del consejero si procede. ");

			/******************************************/
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl - addTramiteComunicacion: INICIO SUBIDA DE DOCUMENTOS A DOKUSI.");
			// Obtenemos los documentos del tramite
			listDocumentoHecho = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);
			if (listDocumentoHecho != null) {
				ArbadhtramServiceImpl.logger
						.info("ArbadhtramServiceImpl - addTramiteComunicacion: Numero de documentos."
								+ listDocumentoHecho.size());
			}
			// Subimos los documentos a dokusi
			this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);

			// Para las comunicaciones que no van por remesa, informamos a mis
			// gestiones
			if (!"S".equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
				this.actualizarMisGestionesComunicacion(arbadhtram, listDocumentoHecho);
			}

		} else {

			/******************************************/
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl - addTramiteComunicacion: INICIO SUBIDA DE DOCUMENTOS A DOKUSI.");
			// Obtenemos los documentos del tramite
			if (listDocumentoHecho != null) {
				this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
			}
		}

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteComunicacion: FIN.");

		this.eliminarDocumentosDokusi(listArbadhdocEliminados, tramiteComun.getTipoProcedimiento().getPcodigo());

		return arbadhtram;

	}

	/**
	 * Metodo que crea el objeto CrearNotifEJGV para envio de
	 * notificacin/comunicacin electrnica
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoNotificacion
	 *            String
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param envRemesa
	 *            String
	 * @param listDocumentoHecho
	 *            List<Arbadhdoc>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return CrearNotifEJGV
	 * @throws Exception
	 */
	private CrearNotifEJGV crearObjetoCrearNotifEJGV(String idExpediente, String idTramite, String idTipoNotificacion,
			String textoNotificacionComunicacion, String destinatario, String envRemesa,
			List<Arbadhdoc> listDocumentoHecho, CensoMonitor censoMonitor, String tipoProcedimiento) throws Exception {

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure
				.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProcedimiento));
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
		crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

		// buscar el interviniente
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(idExpediente);
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		if (datosEstablecimientoValidado != null
				&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
			datosPersonaSolicitante.setDni(datosEstablecimientoValidado.getAdhnif().trim().toUpperCase());
			datosPersonaSolicitante.setNombre(datosEstablecimientoValidado.getAdhesnom());
			datosPersonaSolicitante.setMail(datosEstablecimientoValidado.getAdhescoem());
			datosPersonaSolicitante.setTelefono(datosEstablecimientoValidado.getAdhesnrtel());
			// 0173496: Mail de aviso en notificaciones/comunicaciones Platea
			if (Y41bUtils.isFilled(datosEstablecimientoValidado.getAdhescodigo())) {
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(datosEstablecimientoValidado.getAdhescodigo());
				establecimiento = this.establecimientoService.find(establecimiento);

				AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
				adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
				adjunDatosAvisosEstablec.setYipcodigo(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
				adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);

				if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
					datosPersonaSolicitante.setMail(adjunDatosAvisosEstablec.getYiemail());
				} else if (establecimiento != null && Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
					datosPersonaSolicitante.setMail(establecimiento.getEsmailnotificacion());
				}
			}
			// 0173496: Mail de aviso en notificaciones/comunicaciones Platea
		} else {
			datosPersonaSolicitante.setDni(arbadhsol.getAdhnif().trim().toUpperCase());
			datosPersonaSolicitante.setNombre(arbadhsol.getAdhesnom());
			datosPersonaSolicitante.setMail(arbadhsol.getAdhescoem());
			datosPersonaSolicitante.setTelefono(arbadhsol.getAdhesnrtel());
			// 0173496: Mail de aviso en notificaciones/comunicaciones Platea
			if (Y41bUtils.isFilled(arbadhsol.getAdhescodigo())) {
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(arbadhsol.getAdhescodigo());
				establecimiento = this.establecimientoService.find(establecimiento);

				AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
				adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
				adjunDatosAvisosEstablec.setYipcodigo(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
				adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);

				if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
					datosPersonaSolicitante.setMail(adjunDatosAvisosEstablec.getYiemail());
				} else if (establecimiento != null && Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
					datosPersonaSolicitante.setMail(establecimiento.getEsmailnotificacion());
				}
			}
			// 0173496: Mail de aviso en notificaciones/comunicaciones Platea
		}

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		// Obtener el numero de expediente
		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(idTramite);
		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		crearNotifEJGV.setNumeroExpediente(arbadhsol.getNumExpediente());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		// Indicar la serie documental que corresponde al expediente
		String tipoProc = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}

		String serieDocumental = prop.getProperty(
				tipoProc + ".serie." + Y41bDokusiHelper.getProvSerieFromNumExp(arbadhsol.getNumExpediente()));

		crearNotifEJGV.setSerieDocumental(serieDocumental);

		// El tipo de notificacion para PLATEA
		crearNotifEJGV.setIdTipoNotificacion(idTipoNotificacion);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		List<Documento> listDocumentos = this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return crearNotifEJGV;
	}

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram addTramiteComunicacionMail(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception {
		return addTramiteComunicacionMail0(tramiteComunicacion, tramiteComun, modoEditar, censoMonitor);
	}

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public Arbadhtram addTramiteComunicacionMail0(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception {

		if (Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
			this.validarSiExisteSede(tramiteComun.getIdExpediente());
		}

		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}

		Arbadhtram arbadhtram = new Arbadhtram();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}
		arbadhtram.setFase(null);
		arbadhtram.setTrfecini(tramiteComunicacion.getFechaInicio());

		arbadhtram.setTrfecfin(tramiteComunicacion.getFechaFin());
		arbadhtram.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());

		arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		arbadhtram.setArbadhsol(arbadhsol);
		arbadhtram.setTrexcodigo(tramiteComun.getIdExpediente());
		String tipoTramite = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA;
		}
		arbadhtram.setTrcodigo(tipoTramite);
		arbadhtram.setFase(null);
		arbadhtram.setCensoMonitor(null);
		arbadhtram.setTrobserves(Y41bUtils.stringToClob(tramiteComunicacion.getComentario()));

		arbadhtram.setTrfecnotif(tramiteComunicacion.getFechaComunicacion());

		arbadhtram.setTruaidinterv(new BigDecimal(this.arbadhintervDao.volcarDatosValidacion(arbadhsol.getAdhid())));
		// Remesas Ini
		arbadhtram.setTrenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		arbadhtram.setTrcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin
		arbadhtram.setTrsede(tramiteComunicacion.getSede());
		arbadhtram.setTrtipocom(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO);
		arbadhtram.setTrfecregs(tramiteComunicacion.getFechasalida());
		arbadhtram.setTrnumregs(tramiteComunicacion.getNumregistrosalida());
		arbadhtram.setTrasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());

		arbadhtram.setTrtexto(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));

		arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		arbadhtram.setTridmailorigen(tramiteComunicacion.getIdmailorigen());
		arbadhtram.setTrmailorigen(tramiteComunicacion.getMailorigen());
		arbadhtram.setTridmaildestino(tramiteComunicacion.getIdmaildestino());
		arbadhtram.setTrmaildestino(tramiteComunicacion.getMaildestino());

		arbadhtram = this.setArbadhtram(arbadhtram);

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbadhdoc> listArbadhdocEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramiteComunicacion.getAnyadirPlantilla());

		// Mando el email
		boolean enviadoOk = this.envioEmailComunicacion(tramiteComunicacion, tramiteComun, listadjuntardocs,
				censoMonitor);
		if (!enviadoOk) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}

		this.eliminarDocumentosDokusi(listArbadhdocEliminados, tramiteComun.getTipoProcedimiento().getPcodigo());

		return arbadhtram;
	}

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esNotificacionTipoElectronica
	 *            the electronica no ordinaria
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esNotificacionTipoElectronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {
		if (tramitar) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (arbadhsol != null) {
				tramiteNotificacion.setDestinatario(
						String.valueOf(this.arbadhintervDao.volcarDatosValidacion(tramiteComun.getIdExpediente())));
			} else {
				tramiteNotificacion.setDestinatario(
						String.valueOf(this.arbadhintervDao.volcarDatosSolicitud(tramiteComun.getIdExpediente())));
			}
		} else {
			tramiteNotificacion.setDestinatario("-1");
		}
		return this.addTramiteNotificacion0(tramiteNotificacion, tramiteComun, idioma, tramitar, modoEditar,
				esNotificacionTipoElectronica, idZipFile, censoMonitor);
	}

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esNotificacionTipoElectronica
	 *            the electronica no ordinaria
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public Arbadhtram addTramiteNotificacion0(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esNotificacionTipoElectronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		if (tramitar && Y41bConstantes.VALOR_SI.equals(tramiteNotificacion.getSede())) {
			this.validarSiExisteSede(tramiteComun.getIdExpediente());
		}

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 1/14");

		// 1. Se genera el tramite de Notificacion
		Arbadhtram arbadhtram = new Arbadhtram();
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}
		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 2/14");

		// Remesas Ini
		arbadhtram.setTrenvrem(tramiteNotificacion.getEnvRemesaNotificacion());
		arbadhtram.setTrcodrem(tramiteNotificacion.getIdRemesaNotificacion());
		// Remesas Fin

		arbadhtram.setFase(null);
		arbadhtram.setTrfecini(tramiteNotificacion.getFechaInicio());
		if (tramitar) {
			arbadhtram.setTrfecfin(tramiteNotificacion.getFechaFin());
			arbadhtram.setCensoMonitorEj(tramiteNotificacion.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		arbadhtram.setArbadhsol(arbadhsol);
		String tipoTramite = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoTramite = Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA;
		}
		arbadhtram.setTrcodigo(tipoTramite);
		arbadhtram.setFase(null);
		arbadhtram.setCensoMonitor(tramiteNotificacion.getInstructorAsignado());
		arbadhtram.setTrobserves(Y41bUtils.stringToClob(tramiteNotificacion.getComentario()));

		arbadhtram.setTrtiponot(tramiteNotificacion.getTipoNotificacion());

		arbadhtram.setTrtiponotplatea(tramiteNotificacion.getTipoNotificacionPlatea());
		arbadhtram.setTruaidinterv(new BigDecimal(tramiteNotificacion.getDestinatario()));
		arbadhtram.setTrfecnotif(tramiteNotificacion.getFechaComunicacion());
		arbadhtram.setTrsede(tramiteNotificacion.getSede());
		arbadhtram.setTrtiponot((tramiteNotificacion.getTipoNotificacion()));

		arbadhtram.setTridnotifplatea((tramiteNotificacion.getTipoNotificacionPlatea()));
		arbadhtram.setTrfecregs(tramiteNotificacion.getFechasalida());
		arbadhtram.setTrnumregs(tramiteNotificacion.getNumregistrosalida());
		arbadhtram.setTrtexto(Y41bUtils.stringToClob(tramiteNotificacion.getTextoComunicacion()));

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 3/14");

		if (tramitar) {
			if (esNotificacionTipoElectronica) {
				arbadhtram.setTrtiponot(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			} else {
				arbadhtram.setTrtiponot(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			}
		}

		// Se inserta el tramite
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		arbadhtram.setTrexcodigo(tramiteComun.getIdExpediente());

		if (tramitar) {
			// sustituimos la fecha de notificacion
			if (arbadhtram.getTrtiponot().equals(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
				arbadhtram.setTrfecnotif(Y41bUtils.obtenerFechaHoy());
			}
		}

		// Obtener registro salida si no viene de pantalla
		if (tramitar && !esNotificacionTipoElectronica) {
			if (arbadhtram.getTrenvrem() == null || Y41bConstantes.NO.equals(arbadhtram.getTrenvrem())) {
				if (arbadhtram.getTrnumregs() == null || arbadhtram.getTrnumregs().equals("")) {
					RegistroSalida registroSalida = this.getRegistroSalida(tramiteComun,
							arbadhtram.getTruaidinterv().toString(), true);
					arbadhtram.setTrnumregs(registroSalida.getRegistryNumber());
					arbadhtram.setTrfecregs(registroSalida.getRegistryDate());
				}
			}
		}

		arbadhtram = this.setArbadhtram(arbadhtram);

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 6/14");

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbadhdoc> listArbadhdocEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramiteNotificacion.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Arbadhdoc> listDocumentoHecho = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 7/14");

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				if (Y41bUtils.interactuarConDokusi()) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}

			// Incidencias 72966 y 74108. Envo ordinario no genera
			// comunicacion en PLATEA
			// Se incluye este if que si no es ordinaria hace lo que se
			// hacia antes y en caso contrario un codigo que comprueba que
			// se pueda generar el zip por estar todo localizado
			/***
			 * COMPROBAMOS SI TODOS LOS DOCUMENTOS TIENE LOCALIZADOR PARA LA
			 * ORDINARIA
			 */
			if (!esNotificacionTipoElectronica) {
				if (!"S".equals(tramiteNotificacion.getEnvRemesaNotificacion())) {
					this.comprobarFormatoDocumentosEnviar(listadjuntardocs, true,
							tramiteComun.getTipoProcedimiento().getPcodigo());
					ArbadhtramServiceImpl.logger
							.info("ArbadhtramServiceImpl - addTramiteComunicacion: 9A/14. Creamos ZIP.");
					this.crearZipDocumentosExpediente(idZipFile, listadjuntardocs, arbadhsol);
				} else {
					this.comprobarFormatoDocumentosEnviar(listadjuntardocs, false,
							tramiteComun.getTipoProcedimiento().getPcodigo());
					ArbadhtramServiceImpl.logger
							.info("ArbadhtramServiceImpl - addTramiteComunicacion: 9A/14. Todo localizado.");
				}
			}

			if (tramiteNotificacion.getEnvRemesaNotificacion() != null
					&& Y41bConstantes.SI.equals(tramiteNotificacion.getEnvRemesaNotificacion())) {
				if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
					this.controlDocumentosProtegidosRemesa(listadjuntardocs);
				}
			}

			if (!esNotificacionTipoElectronica) {// Es POSTAL
				ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 9AB14");
				String idEspera = null;
				this.generarTramiteAcuseReciboAutomatico(idEspera, arbadhtram, tramiteComun);

			} else {

				// notificacion electronica
				// 2. Se genera el tramite de acuse de recibo vinculado al
				// tramite de
				// notificacion
				String idEspera = this.arbadhsolDao.getNewEsperaPK() + "";

				Arbadhtram tramiteAcuse = this.generarTramiteAcuseReciboAutomatico(idEspera, arbadhtram, tramiteComun);
				ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 9/14");

				// 3. Enviamos telematicamente la solicitud
				String textoNotificacionComunicacion = tramiteNotificacion.getTextoComunicacion();
				String destinatario = tramiteNotificacion.getDestinatario();
				String envRemesa = tramiteNotificacion.getEnvRemesaNotificacion();

				CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramiteComun.getIdExpediente(),
						tramiteComun.getIdTramite(), tramiteNotificacion.getTipoNotificacionPlatea(),
						textoNotificacionComunicacion, destinatario, envRemesa, listDocumentoHecho, censoMonitor,
						tramiteComun.getTipoProcedimiento().getPcodigo());

				RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
						.procesarEnviarNotificacionX43(crearNotifEJGV);

				// EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
				// envioNotifEJGV.setEjgvDocument(tramiteNotificacion
				// .getEjgvDocument());
				//
				// // ******************* Anadimos FIRMA SERVIDOR
				// // ********************
				// //
				// ****************************************************************
				// // envioNotifEJGV.setFirma(tramiteNotificacion.getFirma());
				// if (Y41bUtils.interactuarConDokusi()) {
				// envioNotifEJGV.setFirma(this
				// .creaFirmaServidor(tramiteNotificacion
				// .getEjgvDocument()));
				// } else {
				// envioNotifEJGV.setFirma("firmaficticia");
				// }
				//
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl - addTramiteNotificacion:
				// 11/14");
				//
				// /**
				// * ENVIO DE NOTIFICACION
				// * ****************************************
				// * ***************************************
				// */
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl. - procesarEnviarNotificacion.
				// Inicio Llamada a Platea");
				// RespuestaNotificacion respuestaNotif = new
				// RespuestaNotificacion();
				// if (Y41bUtils.interactuarConDokusi()) {
				// respuestaNotif = this.y41bPlateaAdapterService
				// .procesarEnviarNotificacion(envioNotifEJGV);
				// } else {
				// respuestaNotif.setNumeroRegistro("XXX/1234");
				// }
				// ArbadhtramServiceImpl.logger
				// .info("ArbadhtramServiceImpl. - procesarEnviarNotificacion.
				// Fin Llamada a Platea");
				//
				// 4.1 Update tramite notificacion (campo
				// idnotificacionplatea)
				arbadhtram.setTridnotifplatea(respuestaNotif.getNumeroRegistro());
				this.arbadhtramDao.updateIdNotificacionPlatea(arbadhtram);

				// 4.2 Recuperar segistro salida de notificacion y
				// actualizar
				// tabla
				// tramite hecho con el registro de salida y su fecha de
				// registro
				if (Y41bUtils.interactuarConDokusi()) {
					TNotification tNotification = this.y41bPlateaAdapterService
							.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

					arbadhtram.setTrnumregs(tNotification.getRegistryID().getRegistryNumber());
					arbadhtram.setTrfecregs(
							Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));

					// RegistroSalida registroSalida =
					// this.y41bPlateaAdapterService
					// .getRegistroSalidaFromIdNotificacion(respuestaNotif
					// .getNumeroRegistro());
					//
					// arbadhtram.setTrnumregs(registroSalida.getRegistryNumber());
					// arbadhtram.setTrfecregs(Y41bUtils
					// .parseNotificationRegistrytimestamp(registroSalida
					// .getRegistryTimestamp()));
				} else {

					arbadhtram.setTrfecregs(new Date());

					respuestaNotif.setNumeroRegistro(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				}

				this.arbadhtramDao.updateRegistroSalidaPlatea(arbadhtram);

				// 4.3 Add notificacion / acuse recibo (tabla)
				NotificacionAcuseRecibo notificacionAcuseRecibo = new NotificacionAcuseRecibo();
				notificacionAcuseRecibo.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
				notificacionAcuseRecibo.setEhcodigoacuse(tramiteAcuse.getTrid().toString());
				notificacionAcuseRecibo.setEhpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

				this.arbadhtramDao.addNotificacionAcuseRecibo(notificacionAcuseRecibo);

				ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 12/14");

				ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: 13/14");
			}
			/******************************************/
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl - addTramiteNotificacion: INICIO SUBIDA DE DOCUMENTOS A DOKUSI.");
			// Obtenemos los documentos del tramite
			List<Arbadhdoc> listDocumentoHechoAux = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);
			if (listDocumentoHechoAux != null) {
				ArbadhtramServiceImpl.logger
						.info("ArbadhtramServiceImpl - addTramiteNotificacion: Numero de documentos."
								+ listDocumentoHechoAux.size());
			}
			// Subimos los documentos a dokusi
			this.registrarDocumentosDokusi(listDocumentoHechoAux, tramiteComun);
			/******************************************/
		} else {

			// Subimos los documentos a dokusi
			/******************************************/
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl - addTramiteNotificacion: INICIO SUBIDA DE DOCUMENTOS A DOKUSI.");
			// Obtenemos los documentos del tramite
			List<Arbadhdoc> listDocumentoHechoAux = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);
			if (listDocumentoHechoAux != null) {
				ArbadhtramServiceImpl.logger
						.info("ArbadhtramServiceImpl - addTramiteNotificacion: Numero de documentos."
								+ listDocumentoHechoAux.size());
				this.localizacionDocumentos(listDocumentoHechoAux, tramiteComun.getTipoProcedimiento().getPcodigo());
			}
			this.registrarDocumentosDokusi(listDocumentoHechoAux, tramiteComun);
		}

		String duenioExp = arbadhsol.getAdhusumodif();
		CensoMonitor censoMonitor2 = new CensoMonitor();
		censoMonitor2.setMocodigo(duenioExp);
		if (!Y41bUtils.esNullOCadenaVacia(duenioExp)) {
			censoMonitor2 = this.censoMonitorDao.find(censoMonitor2);
		} else {
			ArbadhtramServiceImpl.logger.info("ERROR. arbadhsol no tiene mocodigo");
		}

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteNotificacion: FIN.");

		this.eliminarDocumentosDokusi(listArbadhdocEliminados, tramiteComun.getTipoProcedimiento().getPcodigo());

		return arbadhtram;
	}

	private void localizacionDocumentos(List<Arbadhdoc> listDocumentoHechoAux, String tipoProcedimiento) {
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		Arbadhdoc documentoHecho = null;
		for (int i = 0; i < listDocumentoHechoAux.size(); i++) {
			documentoHecho = listDocumentoHechoAux.get(i);
			if (documentoHecho.getX5fechasollocalizador() != null) {
				if (documentoHecho != null && documentoHecho.getX5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
						.getExtensionFile(documentoHecho.getX5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

					int minutos = 0;
					if (parametros != null && parametros.getValor() != null
							&& Y41bUtils.isNumeric(parametros.getValor())) {
						minutos = Integer.parseInt(parametros.getValor());
					}

					SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

					Date d1 = null;
					Date d2 = null;
					long diffMinutes = 0;
					try {
						d1 = format.parse(format.format(documentoHecho.getX5fechasollocalizador()));

						d2 = format.parse(format.format(new Date()));

						long diff = d2.getTime() - d1.getTime();

						diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
					} catch (ParseException e) {
						diffMinutes = 0;
					}

					if (diffMinutes > minutos) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(
								Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProcedimiento));
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getX5iddocumentum());
						documento.setBoolAllVersions("true");

						try {
							this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
						} catch (Exception e) {
						}

						documentoHecho.setX5fechasollocalizador(null);
						documentoHecho.setX5iddocumentum(null);
					}
				}
			}
		}
	}

	/**
	 * 
	 * @param adhid
	 *            String
	 */
	private void validarSiExisteSede(String adhid) {
		// Recuperamos la solicitud
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(adhid);
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		// Recuperamos datos del establacimiento validado
		Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		String nif = "";
		if (datosEstablecimientoValidado != null
				&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
			nif = datosEstablecimientoValidado.getAdhnif();
		} else {
			nif = arbadhsol.getAdhnif();
		}
		if (Y41bUtils.isFilled(nif)) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(nif);

			establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

			if (establecimiento == null) {
				throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
			}
		} else {
			throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
		}
	}

	/**
	 * Finds registro entrada document.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterv
	 *            String
	 * @param esNotificacion
	 *            boolean
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(TramiteComun tramiteComun, String idInterv, boolean esNotificacion)
			throws Exception {

		WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

		datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		Arbadhinterv arbadhinterv = new Arbadhinterv();
		if ("-1".equals(idInterv)) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);

			// Recuperamos datos del establacimiento validado
			Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (datosEstablecimientoValidado != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				if (Y41bUtils.isFilled(datosEstablecimientoValidado.getAdhnif())) {
					sbPerson.append(datosEstablecimientoValidado.getAdhnif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(datosEstablecimientoValidado.getAdhesnoco())) {
					sbPerson.append(datosEstablecimientoValidado.getAdhesnoco());
					sbPerson.append(" ");
				} else {
					if (Y41bUtils.isFilled(datosEstablecimientoValidado.getAdhesnom())) {
						sbPerson.append(datosEstablecimientoValidado.getAdhesnom());
						sbPerson.append(" ");
					}
				}
			} else {
				if (Y41bUtils.isFilled(arbadhsol.getAdhnif())) {
					sbPerson.append(arbadhsol.getAdhnif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(arbadhsol.getAdhesnoco())) {
					sbPerson.append(arbadhsol.getAdhesnoco());
					sbPerson.append(" ");
				} else {
					if (Y41bUtils.isFilled(arbadhsol.getAdhesnom())) {
						sbPerson.append(arbadhsol.getAdhesnom());
						sbPerson.append(" ");
					}
				}
			}
		} else {
			arbadhinterv.setUaidinterv(new BigDecimal(idInterv));
			arbadhinterv = this.arbadhintervDao.find(arbadhinterv);

			if (Y41bUtils.isFilled(arbadhinterv.getUanif())) {
				sbPerson.append(arbadhinterv.getUanif());
				sbPerson.append(" - ");
			}
			if (Y41bUtils.isFilled(arbadhinterv.getUanoco())) {
				sbPerson.append(arbadhinterv.getUanoco());
				sbPerson.append(" ");
			} else {
				if (Y41bUtils.isFilled(arbadhinterv.getUanombre())) {
					sbPerson.append(arbadhinterv.getUanombre());
					sbPerson.append(" ");
				}
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(
				esNotificacion ? Y41bConstantes.LITERAL_NOTIFICACION_ES : Y41bConstantes.LITERAL_COMUNICACION_ES);
		sbMatter.append(" - [");
		sbMatter.append(tramiteComun.getNumExpediente());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

		RegistroSalida registroSalida = new RegistroSalida();
		registroSalida.setRegistryNumber(wSOutputRegister.getNumber());
		registroSalida.setRegistryDate(new Date());

		return registroSalida;
	}

	/**
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param esOrdinariaSinRemesa
	 *            boolean
	 */
	private void comprobarFormatoDocumentosEnviar(List<Adjuntardocs> listadjuntardocs, boolean esOrdinariaSinRemesa,
			String tipoProc) {

		ArbadhtramServiceImpl.logger.debug("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar().");
		// Adjuntardocs adjuntardocs = new Adjuntardocs();

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			ArbadhtramServiceImpl.logger.debug("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar().Cuantos:"
					+ listadjuntardocs.size() + ".");
			int i = 0;
			for (Adjuntardocs adjuntardocs : listadjuntardocs) {
				Documento documento = new Documento();
				if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
						&& !adjuntardocs.getPtcodigo().equals("")) {
					PlantillaTramite plantillaTramite = new PlantillaTramite();
					plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
					// Obtener la plantilla del tramite
					// Obtener la plantilla del tramite
					List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite, null);
					if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
						documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
					} else {// No existe la
							// plantilla_tramite,
							// miramos en plantilla_decision
					}
				}

				if (Y41bUtils.isDocumentoLocalizable(adjuntardocs)) {
					if (esOrdinariaSinRemesa && (documento != null && documento.getNolocalizable() != null
							&& documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {
						// Ni se envia a remesa ni es localizable, no se
						// controla nada
						ArbadhtramServiceImpl.logger.debug("Ni se envia a remesa ni documento localizable");
					} else {
						// Solo se comprueba si se ha localizado/transformado si
						// no es Ordinaria sin remesa
						if (!StringUtils.isBlank(adjuntardocs.getThiddocumentum())) {
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(
									Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProc));
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocs.getThiddocumentum());
							if (Y41bUtils.interactuarConDokusi()) {
								Formato formato = this.y41bDokusiAdapterService
										.recuperarFormatosDocumentosDokusi(documento);

								if (formato != null) {
									ArbadhtramServiceImpl.logger
											.debug("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar()Loop." + i
													+ ".Formato:" + formato + ".");
								} else {
									ArbadhtramServiceImpl.logger
											.debug("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar()Loop." + i
													+ ".Formato NULO.");
								}

								if (formato != null && formato.getName().equalsIgnoreCase(Y41bConstantes.PDFA)) {
									if (adjuntardocs != null && adjuntardocs.getThnofile() != null
											&& !com.ejie.y41b.utils.Y41bUtils
													.getExtensionFile(adjuntardocs.getThnofile())
													.equalsIgnoreCase(Y41bConstantes.PDF)) {

										ArbadhtramServiceImpl.logger
												.error("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar()Loop."
														+ i + ".SIN LOCALIZADOR.CASE 1.");

										throw new Y41bUDAException("error.documentos.sinlocalizador", true,
												new Exception());
									}
								} else {
									ArbadhtramServiceImpl.logger
											.error("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar()Loop." + i
													+ ".SIN LOCALIZADOR.CASE 2.");
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							}
						} else {
							ArbadhtramServiceImpl.logger
									.error("ArbadhtramServiceImpl.comprobarFormatoDocumentosEnviar()Loop." + i
											+ ".SIN LOCALIZADOR.CASE 3.");
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}
				} else {
					if (!esOrdinariaSinRemesa) {
						if (adjuntardocs != null && adjuntardocs.getThnofile() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(adjuntardocs.getThnofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					} else {
						// Si el documento es no localizable y no enviamos por
						// remesa, al ser postal, no hace falta transformar
						ArbadhtramServiceImpl.logger.debug("Ni se envia a remesa ni documento localizable");
					}
				}
				i++;
			}
		}
	}

	/**
	 * Metodo que crea un zip con nombre zipName, y comprime los documentos del
	 * tramite del expediente
	 * 
	 * @param zipName
	 *            String
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return boolean true si hay ficheros en el zip / false si no hay ficheros
	 *         en el zip
	 */
	private boolean crearZipDocumentosExpediente(String zipName, List<Adjuntardocs> listadjuntardocs,
			Arbadhsol arbadhsol) {

		ArbadhtramServiceImpl.logger
				.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Inicio.");
		Arbadhdoc documentoHechoDetalle = null;
		boolean zipConFicheros = true;
		boolean zipSinFicheros = false;
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Ej. /datos/y41b/tmp/zip/
		String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147
		String strZipDirectory = strTmpZipDirectory + zipName;
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
		String strZipFile = strTmpZipDirectory + zipName + Y41bConstantes.EXTENSION_ZIP;
		try {
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 1.");
			// 1. Validamos que exista el directorio TMP para los ZIP. Si no
			// existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 2.");
			// 2. Validamos que exista el directorio TMP para el ZIP actual. Si
			// no existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strZipDirectory);
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 3.");
			// 3. Creamos el ZIP
			Y41bFicheroUtils.crearFichero(new File(strZipFile));
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 4.");
			// ******* Borramos historico de ficheros con mas de 1 minuto
			// (60000ms) de
			// diferencia en la fecha de creacion
			Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), Y41bConstantes.NUM_60000);
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 5.");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				ArbadhtramServiceImpl.logger
						.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 6."
								+ listadjuntardocs.size() + ".");
				String nombreFichero = null;
				InputStream ficheroStream = null;
				File fileFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					ArbadhtramServiceImpl.logger
							.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 7.Bucle"
									+ numDoc + ".");

					documentoHechoDetalle = new Arbadhdoc();
					documentoHechoDetalle.setX5codocumento(adjuntardocs.getThcodocumento());
					documentoHechoDetalle = this.arbadhdocService.find(documentoHechoDetalle);

					nombreFichero = StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getX5nofile());
					ficheroStream = documentoHechoDetalle.getX5datafile().getBinaryStream();

					String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

					if ("true".equals(local)) {
						fileFichero = new File(strZipDirectory + "\\" + numDoc + "." + nombreFichero);
					} else {
						fileFichero = new File(strZipDirectory + "/" + numDoc + "." + nombreFichero);
					}

					ArbadhtramServiceImpl.logger
							.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 7.Bucle"
									+ numDoc + "." + strZipDirectory + "\\" + numDoc + "." + nombreFichero + ".");
					Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				ArbadhtramServiceImpl.logger.info(
						"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 8.");

				// 5. Comprimimos el directorio del zip en el fichero zip que
				// hemos creado
				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);
				ArbadhtramServiceImpl.logger.info(
						"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 9.");
				// 8.1. Hay ficheros en el zip
				return zipConFicheros;
			} else {
				ArbadhtramServiceImpl.logger.info(
						"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 5.B.");
				// 8.2.1. Eliminamos el zip vacio (no sirve de nada)
				Y41bFicheroUtils.deleteFile(new File(strZipFile));
				// 8.2.2. No hay ficheros en el zip
				return zipSinFicheros;
			}
		} catch (Exception e) {
			// Eliminamos el zip vacio si existe
			ArbadhtramServiceImpl.logger
					.error("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. ERROR. EXCEPTION" + e.getMessage());
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. ERROR. EXCEPTION" + e.getMessage());

			Y41bFicheroUtils.deleteFile(new File(strZipFile));
			throw new Y41bUDAException("error.zip.crearZipDocumentosExpediente", true, new Exception());
		} finally {
			// 6. Eliminamos de la zona temporal de BDDD para los LOB
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 10.FINALLY.");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					documentoHechoDetalle = new Arbadhdoc();
					documentoHechoDetalle.setX5codocumento(adjuntardocs.getThcodocumento());
					ArbadhtramServiceImpl.logger
							.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 11. FINALLY. bucle."
									+ adjuntardocs.getThcodocumento() + ".");

				}
			}
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 12.FINALLY.");
			// 7. Borramos el directorio temporal del ZIP y su contenido
			File directoryToDelete = new File(strZipDirectory);
			if (directoryToDelete.exists()) {
				Y41bFicheroUtils.deleteDirectory(directoryToDelete);
			}
			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 13.FINALLY.");

			if (directoryToDelete.exists()) {
				directoryToDelete.delete();
			}
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Fin.");
		}
	}

	/**
	 * Metodo que comprueba que los documentos enviados a remesa no tienen
	 * problemas para ser remesados
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 */
	private void controlDocumentosProtegidosRemesa(List<Adjuntardocs> listadjuntardocs) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		Arbadhdoc documentoHechoDetalle = null;
		for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
			documentoHechoDetalle = new Arbadhdoc();
			documentoHechoDetalle.setX5codocumento(adjuntardocsAux.getThcodocumento());
			documentoHechoDetalle = this.arbadhdocService.find(documentoHechoDetalle);

			Blob contenido = documentoHechoDetalle.getX5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());
			try {
				Document document = new Document();
				int totalPages = 0;
				PdfReader pdfReader = new PdfReader(bContenido);
				totalPages = pdfReader.getNumberOfPages();

				ByteArrayOutputStream bos = new ByteArrayOutputStream();

				ObjectOutputStream os = new ObjectOutputStream(bos);

				// Create a writer for the outputstream
				PdfWriter writer = PdfWriter.getInstance(document, os);

				document.open();
				BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
				PdfContentByte cb = writer.getDirectContent(); // Holds
																// the
																// PDF
				// data

				boolean paginate = false;
				int pageOfCurrentReaderPDF = 0;
				int currentPageNumber = 0;
				PdfImportedPage page;
				// Create a new page in the target for each source page.
				while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
					Rectangle r = pdfReader.getPageSize(pdfReader.getPageN(pageOfCurrentReaderPDF + 1));
					// if (r.getWidth() == 792.0 && r.getHeight() ==
					// 612.0)
					if (r.getWidth() > r.getHeight()) {
						document.setPageSize(PageSize.A4.rotate());
					} else {
						document.setPageSize(PageSize.A4);
					}
					document.newPage();
					pageOfCurrentReaderPDF++;
					currentPageNumber++;
					page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
					cb.addTemplate(page, 0, 0);

					// Code for pagination.
					if (paginate) {
						cb.beginText();
						cb.setFontAndSize(bf, Y41bConstantes.NUM_9);
						cb.showTextAligned(PdfContentByte.ALIGN_CENTER, "" + currentPageNumber + " of " + totalPages,
								Y41bConstantes.NUM_520, Y41bConstantes.NUM_5, 0);
						cb.endText();
					}
				}
				pageOfCurrentReaderPDF = 0;
				pdfReader.close();

				if (document.isOpen()) {
					document.close();
				}
				writer.close();
				os.writeObject(new Date());
				os.close();
			} catch (Exception e) {
				StringBuffer errorPassword = new StringBuffer();
				errorPassword
						.append(this.appMessageSource.getMessage("error.documentos.passwordremesapdf", null, locale));
				errorPassword.append(documentoHechoDetalle.getX5nofile());
				throw new Y41bUDAException(errorPassword.toString(), true, new Exception());
			}
		}
	}

	// /**
	// * 'creaFirmaServidor'
	// *
	// * @param ejgvDocument
	// * String
	// * @return String
	// */
	// private String creaFirmaServidor(String ejgvDocument) {
	// Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
	// NSHFServiceImpl nshf = new NSHFServiceImpl();
	// EjgvDocumentType EjgvDocumentFirma = nshf.createAdESSignature(
	// prop.getProperty("CERTIFICADO_SERVIDOR"), ejgvDocument,
	// Y41bConstantes.TIPO_FIRMA_ENVELOPED);
	// return EjgvDocumentFirma.getEjgvDocument().getBody().getSign();
	// }

	/**
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram updateRegistroSalidaPlatea(Arbadhtram arbadhtram) {
		return this.arbadhtramDao.updateRegistroSalidaPlatea(arbadhtram);
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentosTramite
	 *            List<Arbadhsolcomdoc>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List<Document>
	 * @throws Exception
	 */
	private List<Documento> registrarDocumentosDokusi(List<Arbadhdoc> listDocumentosTramite, TramiteComun tramiteComun)
			throws Exception {

		List<Documento> listDocumentos = new ArrayList<Documento>();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		ArbadhtramServiceImpl.logger.debug("Inicio registrarDocumentosDokusi()");

		if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			Arbadhdoc arbdocTempDocumentoTratar = null;
			Arbtipdoc arbtipdoc = new Arbtipdoc();
			for (int i = 0; i < listDocumentosTramite.size(); i++) {
				Documento documento = new Documento();
				arbdocTempDocumentoTratar = listDocumentosTramite.get(i);
				arbdocTempDocumentoTratar = this.limpiarOidSiErrorLocalizacion(arbdocTempDocumentoTratar, arbadhsol);
				if (!Y41bUtils.isFilled(arbdocTempDocumentoTratar.getX5iddocumentum())) {

					ArbadhtramServiceImpl.logger.debug("registrarDocumentosDokusi (NO OID). X5codocumento"
							+ arbdocTempDocumentoTratar.getX5codocumento() + ".");

					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					String tipoProc = "";
					if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
					} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
					} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
							|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
					}
					procedure.setIdProcedimiento(tipoProc);
					documento.setProcedure(procedure);
					// 2.Tipo Documental
					String serieDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					if (arbdocTempDocumentoTratar.getArbtipdoc().getTdid() != null) {
						arbtipdoc.setTdid(arbdocTempDocumentoTratar.getArbtipdoc().getTdid());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						if (arbtipdoc != null) {
							serieDocumental = (arbtipdoc.getIdTipodoc());
						} else {
							ArbadhtramServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
						}
					} else {
						ArbadhtramServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
					}
					documento.setTipoDocumental(serieDocumental);

					ArbadhtramServiceImpl.logger
							.debug("registrarDocumentosDokusi. TIPO DOCUMENTAL:" + serieDocumental + ".");

					documento.setIdDocumento(arbdocTempDocumentoTratar.getX5codocumento().toString());

					String nombreFichero = Y41bUtils.getNameFile(arbdocTempDocumentoTratar.getX5nofile());
					documento.setNombre(nombreFichero);
					documento.setDescripcion(arbdocTempDocumentoTratar.getX5tedesfile());

					String extensionFichero = Y41bUtils.getExtensionFile(arbdocTempDocumentoTratar.getX5nofile());
					documento.setExtension(extensionFichero);

					ArbadhtramServiceImpl.logger.debug(
							"registrarDocumentosDokusi. FICHERO:" + nombreFichero + "." + extensionFichero + ".");

					// Recupero el [] byte
					Arbadhdoc sandocTempAux = new Arbadhdoc();
					sandocTempAux.setX5codocumento(arbdocTempDocumentoTratar.getX5codocumento());

					sandocTempAux = this.arbadhdocService.find(sandocTempAux);

					Blob contenido = sandocTempAux.getX5datafile();

					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
					documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
					// COMPROBAR SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE
					// Obtener tramite
					if (arbdocTempDocumentoTratar != null && arbdocTempDocumentoTratar.getX5ptcodigo() != null
							&& !arbdocTempDocumentoTratar.getX5ptcodigo().equals("")) {

						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(arbdocTempDocumentoTratar.getX5ptcodigo());
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						} else {// No existe la
								// plantilla_tramite,
								// miramos en plantilla_decision
						}
					}

					ArbadhtramServiceImpl.logger
							.debug("registrarDocumentosDokusi.noLocalizable:" + documento.getNolocalizable() == null
									|| !"S".equals(documento.getNolocalizable()) ? "Localizable" : "No localizable");
					StringBuffer numeroExpedienteDokusi = new StringBuffer();
					numeroExpedienteDokusi.append(arbadhsol.getNumExpediente());

					documento.setNumeroExpediente(numeroExpedienteDokusi.toString());

					// Actualizo OID Dokusi en tabla documentos intermedia
					Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();
					adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());

					if (Y41bUtils.interactuarConDokusi()) {
						Documento documentoRdo = this.y41bDokusiAdapterService.registrarDocumentoDokusi(documento);
						ArbadhtramServiceImpl.logger
								.debug("registrarDocumentosDokusi. OidDokusi:" + documentoRdo.getOidDokusi() + ".");
						arbdocTempDocumentoTratar.setX5iddocumentum(documentoRdo.getOidDokusi());
						adjuntardocsAuxUpdateOID.setThiddocumentum(documentoRdo.getOidDokusi());

					}

					// Actualizo OID Dokusi en tabla documentos intermedia
					this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);
					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
					} else {
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}

					// Actualizo OID Dokusi en tabla documentos
					this.arbadhdocDao.updateOIDDokusi(arbdocTempDocumentoTratar);
					if (Y41bUtils.isDocumentoTransformable(documento)) {
						ArbadhtramServiceImpl.logger.debug("registrarDocumentosDokusi. Es Transformable: S");
						this.arbadhdocDao.updateFechaLocalizacion(arbdocTempDocumentoTratar);
					} else {
						ArbadhtramServiceImpl.logger.debug("registrarDocumentosDokusi. Es Transformable: N");
						this.arbadhdocDao.removeBlobFromOIDDokusi(arbdocTempDocumentoTratar);
					}

				} else {

					ArbadhtramServiceImpl.logger.debug("registrarDocumentosDokusi (SI OID). X5codocumento"
							+ arbdocTempDocumentoTratar.getX5codocumento() + ".");

					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					String tipoProc = "";
					if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
					} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
					} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
							|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
					}
					procedure.setIdProcedimiento(tipoProc);
					documento.setProcedure(procedure);
					// 2.Tipo Documental
					String serieDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					if (arbdocTempDocumentoTratar.getArbtipdoc().getTdid() != null) {
						arbtipdoc.setTdid(arbdocTempDocumentoTratar.getArbtipdoc().getTdid());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						if (arbtipdoc != null) {
							serieDocumental = (arbtipdoc.getIdTipodoc());
						} else {
							ArbadhtramServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
						}
					} else {
						ArbadhtramServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
					}
					documento.setTipoDocumental(serieDocumental);

					ArbadhtramServiceImpl.logger
							.debug("registrarDocumentosDokusi. TIPO DOCUMENTAL:" + serieDocumental + ".");

					documento.setIdDocumento(arbdocTempDocumentoTratar.getX5codocumento().toString());

					String nombreFichero = Y41bUtils.getNameFile(arbdocTempDocumentoTratar.getX5nofile());
					documento.setNombre(nombreFichero);
					documento.setDescripcion(arbdocTempDocumentoTratar.getX5tedesfile());

					String extensionFichero = Y41bUtils.getExtensionFile(arbdocTempDocumentoTratar.getX5nofile());
					documento.setExtension(extensionFichero);

					ArbadhtramServiceImpl.logger.debug(
							"registrarDocumentosDokusi. FICHERO:" + nombreFichero + "." + extensionFichero + ".");

					// Recupero el [] byte
					Arbadhdoc sandocTempAux = new Arbadhdoc();
					sandocTempAux.setX5codocumento(arbdocTempDocumentoTratar.getX5codocumento());

					sandocTempAux = this.arbadhdocService.find(sandocTempAux);

					Blob contenido = sandocTempAux.getX5datafile();

					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
					documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO
							.equals(arbdocTempDocumentoTratar.getX5origen())
							|| Y41bConstantes.ORIGEN_ADH_APORTADO_OTROS.equals(arbdocTempDocumentoTratar.getX5origen())
									? Y41bConstantes.ORIGEN_CIUDADANIA : Y41bConstantes.ORIGEN_ADMINISTRACION);
					// COMPROBAR SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE
					// Obtener tramite
					if (arbdocTempDocumentoTratar != null && arbdocTempDocumentoTratar.getX5ptcodigo() != null
							&& !arbdocTempDocumentoTratar.getX5ptcodigo().equals("")) {

						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(arbdocTempDocumentoTratar.getX5ptcodigo());
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						} else {// No existe la
								// plantilla_tramite,
								// miramos en plantilla_decision
						}
					}

					ArbadhtramServiceImpl.logger
							.debug("registrarDocumentosDokusi.noLocalizable:" + documento.getNolocalizable() == null
									|| !"S".equals(documento.getNolocalizable()) ? "Localizable" : "No localizable");
					StringBuffer numeroExpedienteDokusi = new StringBuffer();
					numeroExpedienteDokusi.append(arbadhsol.getNumExpediente());

					documento.setNumeroExpediente(numeroExpedienteDokusi.toString());

					documento.setOidDokusi(arbdocTempDocumentoTratar.getX5iddocumentum());

				}
				listDocumentos.add(documento);
			}
		}
		return listDocumentos;
	}

	private Arbadhdoc limpiarOidSiErrorLocalizacion(Arbadhdoc documentoHecho, Arbadhsol arbadhsol) {
		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - Eliminamos documentos con error de localizacion.");
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		if (documentoHecho.getX5fechasollocalizador() != null) {
			if (documentoHecho != null && documentoHecho.getX5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
					.getExtensionFile(documentoHecho.getX5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

				int minutos = 0;
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

				Date d1 = null;
				Date d2 = null;
				long diffMinutes = 0;
				try {
					d1 = format.parse(format.format(documentoHecho.getX5fechasollocalizador()));

					d2 = format.parse(format.format(new Date()));

					long diff = d2.getTime() - d1.getTime();

					diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
				} catch (ParseException e) {
					diffMinutes = 0;
				}

				if (diffMinutes > minutos) {
					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					String tipoProc = "";
					if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
					} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
					} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
							|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
					}
					procedure.setIdProcedimiento(tipoProc);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getX5iddocumentum());
					documento.setBoolAllVersions("true");

					try {
						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					} catch (Exception e) {
					}

					documentoHecho.setX5fechasollocalizador(null);
					documentoHecho.setX5iddocumentum(null);
				}
			}
		}
		return documentoHecho;
	}

	/**
	 * Metodo que manda un email con la información de comunicacion recibida
	 * por parámetro.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param tramiteComun
	 *            tramiteComun
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 * @throws Exception
	 */
	private boolean envioEmailComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			List<Adjuntardocs> listadjuntardocs, CensoMonitor censoMonitor) throws Exception {

		try {
			// 1. Calculo FROM + TO del email
			String from = tramiteComunicacion.getMailorigen();
			String destinatariosMail = tramiteComunicacion.getMaildestino();
			// Recuperamos la solicitud
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);

			if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}
			StringBuffer destinatarios = new StringBuffer();
			destinatarios.append(destinatariosMail);

			StringBuffer copiaoculta = new StringBuffer();
			copiaoculta.append(censoMonitor.getMocoem());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			String numeroExpediente = arbadhsol.getNumExpediente();

			StringBuffer asunto = new StringBuffer();
			if (Y41bUtils.isFilled(tramiteComunicacion.getAsuntoComunicacion())) {
				asunto.append(tramiteComunicacion.getAsuntoComunicacion());
			} else {
				// Castellano
				asunto.append(this.appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
			}

			// 3. Creo el contenido del mail
			StringBuffer texto = new StringBuffer();
			texto.append("<B>").append(this.appMessageSource.getMessage("comunicacion.mail.texto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" / ").append(this.appMessageSource.getMessage("comunicacion.mail.texto", null,
					new Locale(Y41bConstantes.EUSKERA))).append("</B><BR><BR>");
			texto.append(tramiteComunicacion.getTextoComunicacion().replaceAll("\n", "<BR>"));

			// 4. Creo attachments del mail
			List<AttachFile> attachments = new ArrayList<AttachFile>();

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					Documento documento = new Documento();
					if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
							&& !adjuntardocs.getPtcodigo().equals("")) {
						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						}
					}

					if (Y41bUtils.isDocumentoLocalizable(adjuntardocs) && (documento.getNolocalizable() == null
							|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {
						if (Y41bUtils.interactuarConDokusi()) {
							if (!StringUtils.isBlank(adjuntardocs.getThiddocumentum())) {
								// 1.User
								User user = new User();
								user.setNombre(Y41bConstantes.COD_APLICACION);
								user.setDni(Y41bConstantes.COD_APLICACION);
								documento.setUser(user);
								Procedure procedure = new Procedure();
								String tipoProc = "";
								if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
									tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
								} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
									tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
								} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
										|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
									tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
								}
								procedure.setIdProcedimiento(tipoProc);
								documento.setProcedure(procedure);
								documento.setOidDokusi(adjuntardocs.getThiddocumentum());
								Formato formato = this.y41bDokusiAdapterService
										.recuperarFormatosDocumentosDokusi(documento);

								if (formato != null && formato.getName().equalsIgnoreCase(Y41bConstantes.PDFA)) {
									if (adjuntardocs != null && adjuntardocs.getThnofile() != null
											&& !com.ejie.y41b.utils.Y41bUtils
													.getExtensionFile(adjuntardocs.getThnofile())
													.equalsIgnoreCase(Y41bConstantes.PDF)) {
										throw new Y41bUDAException("error.documentos.sinlocalizador", true,
												new Exception());
									}
								} else {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						}
					}
					AttachFile fileattach = new AttachFile();
					Arbadhdoc arbadhdocObj = new Arbadhdoc();
					arbadhdocObj.setX5codocumento(adjuntardocs.getThcodocumento());

					Arbadhdoc documentoHechoAux = (Arbadhdoc) this.arbadhdocService.find(arbadhdocObj);

					fileattach.setContentType(adjuntardocs.getThcontenttypefile());
					fileattach.setNombre(adjuntardocs.getThnofile());
					fileattach.setAdjunto(documentoHechoAux.getX5datafile());

					attachments.add(fileattach);

				}
			}

			// 5. Envio mail
			boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), copiaoculta.toString(), attachments);

			return envio;
		} finally {
			/*
			 * ELIMINAMOS TODOS LOS DOCUMENTOS DE ADJUNTAR DOCS PARA ESE
			 * TRAMITE, EXPEDIENTE Y PROCEDIMIENTO
			 */
			this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		}
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo
	 * 
	 * @param idEspera
	 *            String
	 * @param tramiteNotificacion
	 *            Arbadhtram
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Arbadhtram
	 * @throws Exception
	 *             Exception
	 */

	public Arbadhtram generarTramiteAcuseReciboAutomatico(String idEspera, Arbadhtram tramiteNotificacion,
			TramiteComun tramiteComun) throws Exception {
		try {
			// Generar el tramite de acuse de recibo vinculado al tramite de
			// notificacion
			// Creacion de tramite de registro de solicitud tramitado
			Arbadhtram arbadhtramAcuse = new Arbadhtram();
			arbadhtramAcuse.setTrid(this.getNewPK().toString());
			arbadhtramAcuse.setArbadhsol(new Arbadhsol(tramiteComun.getIdExpediente()));
			arbadhtramAcuse.setTrexcodigo(tramiteComun.getIdExpediente());

			// Recuperamos la solicitud
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);

			String tipoTramite = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				tipoTramite = Y41bConstantes.TRAMITE_ADHESION_ACUSE_ALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				tipoTramite = Y41bConstantes.TRAMITE_ADHESION_ACUSE_MOD;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				tipoTramite = Y41bConstantes.TRAMITE_ADHESION_ACUSE_BAJA;
			}
			arbadhtramAcuse.setTrcodigo(tipoTramite);
			// La fase del acuse es la fase del tramite de notificacion que lo
			// genera
			Fase fase = ((Arbadhtram) this.arbadhtramDao.find(tramiteNotificacion)).getFase();
			arbadhtramAcuse.setFase(fase);

			// Incidencia 74956 - Ponemos en la fecha de inicio la fecha del dia
			// de hoy, que coincide con la fecha de fin de la notificacion
			arbadhtramAcuse.setTrfecini(Y41bUtils.obtenerFechaHoy());

			arbadhtramAcuse.setCensoMonitor((tramiteNotificacion.getCensoMonitor()));
			arbadhtramAcuse.setTrcodigorel(tramiteNotificacion.getTrcodigo());
			arbadhtramAcuse.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			arbadhtramAcuse.setTrcodigorel(tramiteComun.getIdTipoTramite());
			arbadhtramAcuse.setTrtridrel(tramiteNotificacion.getTrid());
			arbadhtramAcuse.setTruaidinterv(tramiteNotificacion.getTruaidinterv());
			// tratamos el idEspera pasado por parametro
			if (Y41bUtils.isFilled(idEspera)) {
				arbadhtramAcuse.setTridesperaplatea(idEspera);
				arbadhtramAcuse.setTrmatarespera(Y41bConstantes.NO);
			}

			// Se inserta el tramite
			this.arbadhtramDao.add(arbadhtramAcuse);
			return arbadhtramAcuse;
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComunicacion.getIdTramite());

		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		TramiteComunicacion tramiteComunicacionAux = new TramiteComunicacion();
		tramiteComunicacionAux.setIdTramite(arbadhtram.getTrid().toString());

		tramiteComunicacionAux.setFechaInicio(arbadhtram.getTrfecini());
		tramiteComunicacionAux.setFechaFin(arbadhtram.getTrfecfin());

		tramiteComunicacionAux.setInstructorAsignado(arbadhtram.getCensoMonitor());

		tramiteComunicacionAux.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());

		tramiteComunicacionAux.setEstadoTramite(arbadhtram.getTrestado());

		tramiteComunicacionAux.setFechaComunicacion(arbadhtram.getTrfecnotif());

		if (arbadhtram.getTruaidinterv() != null) {
			tramiteComunicacionAux.setDestinatario(arbadhtram.getTruaidinterv() + "");
		} else {
			tramiteComunicacionAux.setDestinatario("");
		}
		tramiteComunicacionAux.setSede(arbadhtram.getTrsede());

		tramiteComunicacionAux.setTipoComunicacion(arbadhtram.getTrtipocom());

		tramiteComunicacionAux.setAsuntoComunicacion(arbadhtram.getTrasuntocomunicacion());

		tramiteComunicacionAux.setFechasalida(arbadhtram.getTrfecregs());

		tramiteComunicacionAux.setNumregistrosalida(arbadhtram.getTrnumregs());

		tramiteComunicacionAux.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));
		tramiteComunicacionAux.setTextoComunicacion(Y41bUtils.clobToString(arbadhtram.getTrtexto()));

		if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		if (arbadhtram.getTrtridrel() != null) {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		// Remesas Ini
		tramiteComunicacionAux.setEnvRemesaComunicacion(arbadhtram.getTrenvrem());
		if (arbadhtram.getTrcodrem() != null && !"".equals(arbadhtram.getTrcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(arbadhtram.getTrcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteComunicacionAux.setIdRemesaComunicacion(remesa.getRmcodigo());
			tramiteComunicacionAux.setFechaRemesaComunicacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		tramiteComunicacionAux.setIdmailorigen(arbadhtram.getTridmailorigen());
		tramiteComunicacionAux.setMailorigen(arbadhtram.getTrmailorigen());
		tramiteComunicacionAux.setIdmaildestino(arbadhtram.getTridmaildestino());
		tramiteComunicacionAux.setMaildestino(arbadhtram.getTrmaildestino());

		return tramiteComunicacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion, CensoMonitor monitor)
			throws SQLException, IOException {

		CensoMonitor censoMonitor = new CensoMonitor();
		if (monitor != null && !Y41bUtils.esNullOCadenaVacia(monitor.getMocodigo())) {
			censoMonitor = this.censoMonitorDao.find(monitor);
		}

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteNotificacion.getIdTramite());

		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		TramiteNotificacion tramiteNotificacionAux = new TramiteNotificacion();
		tramiteNotificacionAux.setIdTramite(arbadhtram.getTrid().toString());

		tramiteNotificacionAux.setFechaInicio(arbadhtram.getTrfecini());
		tramiteNotificacionAux.setFechaFin(arbadhtram.getTrfecfin());

		tramiteNotificacionAux.setInstructorAsignado(arbadhtram.getCensoMonitor());

		tramiteNotificacionAux.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());

		tramiteNotificacionAux.setEstadoTramite(arbadhtram.getTrestado());

		tramiteNotificacionAux.setFechaComunicacion(arbadhtram.getTrfecnotif());

		tramiteNotificacionAux.setDestinatario(arbadhtram.getTruaidinterv() + "");

		tramiteNotificacionAux.setSede(arbadhtram.getTrsede());

		tramiteNotificacionAux.setTipoNotificacion(arbadhtram.getTrtiponot());

		tramiteNotificacionAux.setTipoNotificacionPlatea(arbadhtram.getTrtiponotplatea());

		tramiteNotificacionAux.setFechasalida(arbadhtram.getTrfecregs());

		tramiteNotificacionAux.setNumregistrosalida(arbadhtram.getTrnumregs());

		if ((arbadhtram != null && arbadhtram.getTrtridrel() != null)
				|| Y41bConstantes.VALOR_SI.equals(arbadhtram.getTrautomatico())) {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		tramiteNotificacionAux.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));
		tramiteNotificacionAux.setTextoComunicacion(Y41bUtils.clobToString(arbadhtram.getTrtexto()));

		if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		tramiteNotificacionAux.setIdnotificacionplatea(arbadhtram.getTridnotifplatea());

		// Remesas Ini
		tramiteNotificacionAux.setEnvRemesaNotificacion(arbadhtram.getTrenvrem());
		if (arbadhtram.getTrcodrem() != null && !"".equals(arbadhtram.getTrcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(arbadhtram.getTrcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteNotificacionAux.setIdRemesaNotificacion(remesa.getRmcodigo());
			tramiteNotificacionAux.setFechaRemesaNotificacion(remesa.getRmfechageneracion());
		}

		// Remesas Fin

		return tramiteNotificacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = new CensoMonitor();
		if (monitor != null && !Y41bUtils.esNullOCadenaVacia(monitor.getMocodigo())) {
			censoMonitor = this.censoMonitorDao.find(monitor);
		}
		Arbadhtram arbadhtram = new Arbadhtram();
		ArbadhtramServiceImpl.logger.info("Id del tramite:" + tramiteAcuseRecibo.getIdTramite() + "-");
		arbadhtram.setTrid(tramiteAcuseRecibo.getIdTramite());
		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		TramiteAcuseRecibo tramiteAcuserRecibo = new TramiteAcuseRecibo();
		tramiteAcuserRecibo.setIdTramite(arbadhtram.getTrid().toString());
		tramiteAcuserRecibo.setFechaInicio(arbadhtram.getTrfecini());
		tramiteAcuserRecibo.setFechaFin(arbadhtram.getTrfecfin());

		tramiteAcuserRecibo.setInstructorAsignado(arbadhtram.getCensoMonitor());

		tramiteAcuserRecibo.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());

		tramiteAcuserRecibo.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));

		tramiteAcuserRecibo.setEstadoTramite(arbadhtram.getTrestado());

		tramiteAcuserRecibo.setAcusereintentado(arbadhtram.getTracusereintentado());

		// Info de Acuse recibo ini
		tramiteAcuserRecibo.setFechaacuse(arbadhtram.getTrfecacuse());
		tramiteAcuserRecibo.setSituacionacuse(arbadhtram.getTrestadoacuse());

		// Info de Acuse recibo fin

		TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
		tramiteNotificacionWhere.setIdTramite(arbadhtram.getTrtridrel().toString());
		TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
				censoMonitor);

		// Recupero el tramite de notificacion relacionado ini
		tramiteAcuserRecibo.setTramiteNotificacion(tramiteNotificacionRelacionado);
		// Recupero el tramite de notificacion relacionado fin

		if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
			tramiteAcuserRecibo.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAcuserRecibo.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAcuserRecibo;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	public TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs,
			CensoMonitor censoMonitor) {
		Arbadhtram arbadhtram = new Arbadhtram();
		String trid = new String(tramiteAdjuntarDocs.getIdTramite());
		arbadhtram.setTrid(trid);
		arbadhtram = this.arbadhtramDao.find(arbadhtram);

		TramiteAdjuntarDocs tramiteAux = new TramiteAdjuntarDocs();
		tramiteAux.setIdTramite(arbadhtram.getTrcodigo());
		tramiteAux.setFechaInicio(arbadhtram.getTrfecini());
		tramiteAux.setFechaFin(arbadhtram.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbadhtram.getCensoMonitor() != null && !arbadhtram.getCensoMonitor().equals("")) {
			instructorAsignado = arbadhtram.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		tramiteAux.setInstructorEjecucion(arbadhtram.getCensoMonitorEj());
		tramiteAux.setEstadoTramite(arbadhtram.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(arbadhtram.getTrobserves()));

		if (this.tratamientoSeguridad(arbadhtram, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception {
		return this.createEJGVDocumentNotificacion0(tramiteNotificacion, tramiteComun, censoMonitor, tipoProcedimiento);
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion0(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;
		try {

			ArbadhtramServiceImpl.logger.info("Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 1/8");

			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();

			procedure.setIdProcedimiento(
					Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProcedimiento));
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setTextoNotificacion(tramiteNotificacion.getTextoComunicacion());

			crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

			ArbadhtramServiceImpl.logger.info("Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 2/8");

			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);

			DatosPersona datosPersonaSolicitante = new DatosPersona();
			Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (datosEstablecimientoValidado != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				datosPersonaSolicitante.setDni(datosEstablecimientoValidado.getAdhnif().trim().toUpperCase());
				datosPersonaSolicitante.setNombre(datosEstablecimientoValidado.getAdhesnom());
				datosPersonaSolicitante.setMail(datosEstablecimientoValidado.getAdhescoem());
				datosPersonaSolicitante.setTelefono(datosEstablecimientoValidado.getAdhesnrtel());
			} else {
				datosPersonaSolicitante.setDni(arbadhsol.getAdhnif().trim().toUpperCase());
				datosPersonaSolicitante.setNombre(arbadhsol.getAdhesnom());
				datosPersonaSolicitante.setMail(arbadhsol.getAdhescoem());
				datosPersonaSolicitante.setTelefono(arbadhsol.getAdhesnrtel());
			}
			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
			datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());
			crearNotifEJGV.setSender(datosPersonaSender);

			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			// Obtener tramite
			Arbadhtram arbadhtram = new Arbadhtram();
			arbadhtram.setTrid(tramiteComun.getIdTramite());
			arbadhtram = this.arbadhtramDao.find(arbadhtram);

			crearNotifEJGV.setNumeroExpediente(arbadhsol.getNumExpediente());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Indicar la serie documental que corresponde al expediente

			ArbadhtramServiceImpl.logger.info(
					"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			String tipoProc = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
			}

			String serieDocumental = prop.getProperty(
					tipoProc + ".serie." + Y41bDokusiHelper.getProvSerieFromNumExp(arbadhsol.getNumExpediente()));

			crearNotifEJGV.setSerieDocumental(serieDocumental);

			crearNotifEJGV.setIdTipoNotificacion(tramiteNotificacion.getTipoNotificacionPlatea());

			// Recupero de la tabla temporal la lista de documentos del
			// expediente

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);
			ArbadhtramServiceImpl.logger.info(
					"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 4/8" + tramiteComun.getIdTramite() + ".");
			List<Documento> listDocumentos = new ArrayList<Documento>();
			Documento documento = null;

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {

				ArbadhtramServiceImpl.logger.info(
						"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 5/8" + listadjuntardocs.size() + ".");
				int i = 0;
				for (Adjuntardocs adjuntardocsAuxAntiguo : listadjuntardocs) {

					// obtener los datos del documento
					Adjuntardocs adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAuxAntiguo);
					ArbadhtramServiceImpl.logger.info("Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".");

					documento = new Documento();

					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);

					documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());

					// SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE NO LO MANDO A
					// LOCALIZAR
					if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
							&& !adjuntardocs.getPtcodigo().equals("")) {
						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						} else {// No existe la
								// plantilla_tramite,
								// miramos en plantilla_decision
							PlantillaDecision plantillaDecision = new PlantillaDecision();
							plantillaDecision.setPdcodigo(adjuntardocs.getPtcodigo());
							// Obtener la plantilla decision
							long cont = this.plantillaDecisionDao.findAllCount(plantillaDecision);
							if (cont > 0) {// En esta tabla las
											// plantillas son
											// localizables
											// siempre
								documento.setNolocalizable(Y41bConstantes.VALOR_NO);
							}
						}
					}

					// Si no tiene tipo documental, metemos por defecto
					// ejgv_d_archivo
					String tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					if (adjuntardocsAux.getTipoDocumento().getIdTipodoc() != null) {
						arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:" + i + " ."
										+ adjuntardocsAux.getThcodocumento() + ".5.");
						if (arbtipdoc != null) {
							tipoDocumental = (arbtipdoc.getIdTipodoc());
							if (Y41bUtils.isFilled(arbtipdoc.getTdnombre())) {
								documento.setTipoDocumento(arbtipdoc.getTdnombre());
							} else {
								documento.setTipoDocumento(".");
							}
						}
					}
					documento.setTipoDocumental(tipoDocumental);

					documento.setIdDocumento(adjuntardocsAux.getThcodocumento().toString());

					// Para que sepa PLATEA que es un RTF (obligatorio)
					documento.setNombre(adjuntardocsAux.getThnofile());
					documento.setDescripcion(adjuntardocsAux.getThtedesfile());
					documento.setExtension(Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile()));

					Blob contenido = adjuntardocsAux.getThdatafile();
					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
					// Calculo el origen de DOKUSI del documento ini
					String origenDocumentoDokusi = null;
					if (Y41bUtils.isFilled(adjuntardocsAux.getThorigen())) {
						if (Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO.equals(adjuntardocsAux.getThorigen())) {
							origenDocumentoDokusi = Y41bConstantes.ORIGEN_CIUDADANIA;
						} else if (Y41bConstantes.ORIGEN_ADH_APORTADO_OTROS.equals(adjuntardocsAux.getThorigen())) {
							origenDocumentoDokusi = Y41bConstantes.ORIGEN_ORGANISMO_EXTERNO;
						} else {
							origenDocumentoDokusi = Y41bConstantes.ORIGEN_ADMINISTRACION;
						}
					} else {
						origenDocumentoDokusi = Y41bConstantes.ORIGEN_ADMINISTRACION;
					}
					documento.setOrigenDocumento(origenDocumentoDokusi);
					// Calculo el origen de DOKUSI del documento fin
					documento.setProcedure(procedure);

					// Expediente DOKUSI
					documento.setNumeroExpediente(arbadhsol.getNumExpediente().toString());

					if (!Y41bUtils.isFilled(adjuntardocsAux.getThiddocumentum())) {
						ArbadhtramServiceImpl.logger.info(
								"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: Registramos en dokusi.");

						String idDocumento = "";
						String oidDocumento = "";

						if (Y41bUtils.interactuarConDokusi()) {
							documento = this.y41bDokusiAdapterService.registrarDocumentoDokusi(documento);
							idDocumento = documento.getIdDocumento();
							oidDocumento = documento.getOidDokusi();
						} else {
							idDocumento = documento.getIdDocumento();
							oidDocumento = "oidficticio";
						}

						ArbadhtramServiceImpl.logger.info(
								"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: DOOID." + oidDocumento + ".");
						Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

						adjuntardocsAuxUpdateOID.setThcodocumento(idDocumento);
						adjuntardocsAuxUpdateOID.setThiddocumentum(oidDocumento);
						this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

						if (Y41bUtils.isDocumentoTransformable(documento)) {
							this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
						} else {
							this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
						}

						Arbadhdoc arbadhdoc = new Arbadhdoc();
						arbadhdoc.setX5codocumento(documento.getIdDocumento());
						arbadhdoc.setX5iddocumentum(documento.getOidDokusi());

						this.arbadhdocDao.updateOIDDokusi(arbadhdoc);

						if (Y41bUtils.isDocumentoTransformable(documento)) {
							this.arbadhdocDao.updateFechaLocalizacion(arbadhdoc);
						} else {
							this.arbadhdocDao.removeBlobFromOIDDokusi(arbadhdoc);
						}
					}

					listDocumentos.add(documento);
					i++;
				}
			}

			if (listDocumentos != null) {
				ArbadhtramServiceImpl.logger.info(
						"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 6/8" + listDocumentos.size() + ".");
			}

			crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

			if (Y41bUtils.interactuarConDokusi()) {
				ArbadhtramServiceImpl.logger
						.info("Arbadhtram2ServiceImpl. - crearEJGVDocumentNotificacion. Inicio Llamada a Platea");
				respuestaEjgv = this.y41bPlateaAdapterService.crearEJGVDocumentNotificacion(crearNotifEJGV);
				ArbadhtramServiceImpl.logger
						.info("Arbadhtram2ServiceImpl. - crearEJGVDocumentNotificacion. Fin Llamada a Platea");

				// actualizar los oid document en bbdd
				List<Documento> listDocumento = respuestaEjgv.getDocumentosAdjuntos();

				if (listDocumento != null && listDocumento.size() > 0) {

					ArbadhtramServiceImpl.logger.info("Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 7/8"
							+ listDocumento.size() + ".");

					for (Documento documentoAux : listDocumento) {
						// obtener los datos del documento
						Arbadhdoc documentoHecho = new Arbadhdoc();

						documentoHecho.setX5codocumento(documentoAux.getIdDocumento());
						ArbadhtramServiceImpl.logger
								.info("Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion:OID.DOKUSI "
										+ documentoAux.getOidDokusi() + ".");
						documentoHecho.setX5iddocumentum(documentoAux.getOidDokusi());

						// Update oid de documentum
						this.arbadhdocDao.updateOIDDokusi(documentoHecho);
						this.arbadhdocDao.removeBlobFromOIDDokusi(documentoHecho);

						// Actualizo OID Dokusi en tabla documentos
						// intermedia
						Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

						adjuntardocsAuxUpdateOID.setThcodocumento(documentoAux.getIdDocumento());
						adjuntardocsAuxUpdateOID.setThiddocumentum(documentoAux.getOidDokusi());
						this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}
				}

			} else {
				// en odei
				ArbadhtramServiceImpl.logger.info(
						"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 7b/8. en odei no mandamos a platea");
				respuestaEjgv = new RespuestaCrearEJGVDocumentNotificacion();
				respuestaEjgv.setTextoPlano("Notificacion en local");
				respuestaEjgv.setEjgvDocument("EGJV. Notificacion en local");
			}

			ArbadhtramServiceImpl.logger.info("Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 8/8.");

		} catch (Y41bUDAException e) {
			e.printStackTrace();
			ArbadhtramServiceImpl.logger.info("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			ArbadhtramServiceImpl.logger.error("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			throw e;
		} catch (Exception e) {

			ArbadhtramServiceImpl.logger.info("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			ArbadhtramServiceImpl.logger.error("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}

		return respuestaEjgv;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Arbadhtram3Service#createEJGVDocumentComunicacion
	 * (com.ejie.y41b.model.TramiteComunicacion,
	 * com.ejie.y41b.model.TramiteComun, com.ejie.y41b.model.CensoMonitor,
	 * java.lang.String)
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String pcodigo) throws Exception {

		return this.createEJGVDocumentComunicacion0(tramiteComunicacion, tramiteComun, censoMonitor, pcodigo);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Arbadhtram3Service#createEJGVDocumentComunicacion
	 * (com.ejie.y41b.model.TramiteComunicacion,
	 * com.ejie.y41b.model.TramiteComun, com.ejie.y41b.model.CensoMonitor,
	 * java.lang.String)
	 */
	@Override
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion0(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String pcodigo) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;
		try {
			ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl. - Inicio createEJGVDocumentComunicacion");

			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(pcodigo));
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setTextoNotificacion(tramiteComunicacion.getTextoComunicacion());

			crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 1/8");
			// buscar el interviniente

			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 2/8");
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);

			DatosPersona datosPersonaSolicitante = new DatosPersona();
			Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (datosEstablecimientoValidado != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				datosPersonaSolicitante.setDni(datosEstablecimientoValidado.getAdhnif().trim().toUpperCase());
				datosPersonaSolicitante.setNombre(datosEstablecimientoValidado.getAdhesnom());
				datosPersonaSolicitante.setMail(datosEstablecimientoValidado.getAdhescoem());
				datosPersonaSolicitante.setTelefono(datosEstablecimientoValidado.getAdhesnrtel());
			} else {
				datosPersonaSolicitante.setDni(arbadhsol.getAdhnif().trim().toUpperCase());
				datosPersonaSolicitante.setNombre(arbadhsol.getAdhesnom());
				datosPersonaSolicitante.setMail(arbadhsol.getAdhescoem());
				datosPersonaSolicitante.setTelefono(arbadhsol.getAdhesnrtel());
			}
			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
			datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());
			crearNotifEJGV.setSender(datosPersonaSender);

			ArbadhtramServiceImpl.logger.info(
					"ArbadhtramServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			// Obtener tramite
			Arbadhtram arbadhtram = new Arbadhtram();
			arbadhtram.setTrid(tramiteComun.getIdTramite());
			arbadhtram = this.arbadhtramDao.find(arbadhtram);

			crearNotifEJGV.setNumeroExpediente(arbadhsol.getNumExpediente());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Indicar la serie documental que corresponde al expediente

			ArbadhtramServiceImpl.logger.info(
					"Arbadhtram2ServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			String tipoProc = "";
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
			}

			String serieDocumental = prop.getProperty(
					tipoProc + ".serie." + Y41bDokusiHelper.getProvSerieFromNumExp(arbadhsol.getNumExpediente()));
			crearNotifEJGV.setSerieDocumental(serieDocumental);

			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 6/8");
			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

			List<Documento> listDocumentos = new ArrayList<Documento>();
			Documento documento = null;
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 7/8");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				int i = 0;
				for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
					// obtener los datos del documento
					adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".");

					documento = new Documento();
					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".2.");
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);

					documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());
					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".3."
							+ adjuntardocsAux.getThiddocumentum() + ".");
					// SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE NO LO MANDO A
					// LOCALIZAR
					if (adjuntardocsAux != null && adjuntardocsAux.getPtcodigo() != null
							&& !adjuntardocsAux.getPtcodigo().equals("")) {
						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						} else {// No existe la
								// plantilla_tramite,
								// miramos en plantilla_decision
							PlantillaDecision plantillaDecision = new PlantillaDecision();
							plantillaDecision.setPdcodigo(adjuntardocs.getPtcodigo());
							// Obtener la plantilla decision
							long cont = this.plantillaDecisionDao.findAllCount(plantillaDecision);
							if (cont > 0) {// En esta tabla las
											// plantillas son
											// localizables
											// siempre
								documento.setNolocalizable(Y41bConstantes.VALOR_NO);
							}
						}
					}
					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".4.");
					// Si no tiene tipo documental, metemos por defecto
					// ejgv_d_archivo
					String tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					if (adjuntardocsAux.getTipoDocumento().getIdTipodoc() != null) {
						arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:" + i + " ."
										+ adjuntardocsAux.getThcodocumento() + ".5.");
						if (arbtipdoc != null) {
							tipoDocumental = (arbtipdoc.getIdTipodoc());
							if (Y41bUtils.isFilled(arbtipdoc.getTdnombre())) {
								documento.setTipoDocumento(arbtipdoc.getTdnombre());
							} else {
								documento.setTipoDocumento(".");
							}
						}
					}
					documento.setTipoDocumental(tipoDocumental);

					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".6.");
					documento.setIdDocumento(adjuntardocsAux.getThcodocumento().toString());

					// Para que sepa PLATEA que es un RTF (obligatorio)
					documento.setNombre(adjuntardocsAux.getThnofile());
					documento.setDescripcion(adjuntardocsAux.getThtedesfile());
					documento.setExtension(Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile()));
					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".7.");
					Blob contenido = adjuntardocsAux.getThdatafile();
					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".8.");
					// Calculo el origen de DOKUSI del documento ini
					String origenDocumentoDokusi = null;
					if (Y41bUtils.isFilled(adjuntardocsAux.getThorigen())) {
						if (Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO.equals(adjuntardocsAux.getThorigen())) {
							origenDocumentoDokusi = Y41bConstantes.ORIGEN_CIUDADANIA;
						} else if (Y41bConstantes.ORIGEN_ADH_APORTADO_OTROS.equals(adjuntardocsAux.getThorigen())) {
							origenDocumentoDokusi = Y41bConstantes.ORIGEN_ORGANISMO_EXTERNO;
						} else {
							origenDocumentoDokusi = Y41bConstantes.ORIGEN_ADMINISTRACION;
						}
					} else {
						origenDocumentoDokusi = Y41bConstantes.ORIGEN_ADMINISTRACION;
					}
					ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:"
							+ i + " ." + adjuntardocsAux.getThcodocumento() + ".9.");

					documento.setOrigenDocumento(origenDocumentoDokusi);
					// Calculo el origen de DOKUSI del documento fin
					documento.setProcedure(procedure);

					// Expediente DOKUSI
					documento.setNumeroExpediente(arbadhsol.getNumExpediente().toString());

					if (!Y41bUtils.isFilled(adjuntardocsAux.getThiddocumentum())) {
						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: Registramos en dokusi.");
						documento = this.y41bDokusiAdapterService.registrarDocumentoDokusi(documento);

						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: DOOID."
										+ documento.getOidDokusi() + ".");
						Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:" + i + " ."
										+ adjuntardocsAux.getThcodocumento() + ".10.");

						adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
						adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
						this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

						if (Y41bUtils.isDocumentoTransformable(documento)) {
							this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
						} else {
							this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
						}
						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:" + i + " ."
										+ adjuntardocsAux.getThcodocumento() + ".11.");
						Arbadhdoc arbadhdoc = new Arbadhdoc();
						arbadhdoc.setX5codocumento(documento.getIdDocumento());
						arbadhdoc.setX5iddocumentum(documento.getOidDokusi());
						this.arbadhdocDao.updateOIDDokusi(arbadhdoc);
						ArbadhtramServiceImpl.logger
								.info("ArbadhtramServiceImpl - createEJGVDocumentComunicacion: bucle:" + i + " ."
										+ adjuntardocsAux.getThcodocumento() + ".12.");

						if (Y41bUtils.isDocumentoTransformable(documento)) {
							this.arbadhdocDao.updateFechaLocalizacion(arbadhdoc);
						} else {
							this.arbadhdocDao.removeBlobFromOIDDokusi(arbadhdoc);
						}
					}

					listDocumentos.add(documento);
					i++;
				}
			}

			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 8/8");

			crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - createEJGVDocumentComunicacion. Inicio Llamada a Platea");
			if (Y41bUtils.interactuarConDokusi()) {
				respuestaEjgv = this.y41bPlateaAdapterService.crearEJGVDocumentComunicacion(crearNotifEJGV);
			} else {
				// en odei
				ArbadhtramServiceImpl.logger.info(
						"ArbadhtramServiceImpl - createEJGVDocumentComunicacion: 8/8. en odei no mandamos a platea");
				respuestaEjgv = new RespuestaCrearEJGVDocumentNotificacion();
				respuestaEjgv.setTextoPlano("Notificacion en local");
				respuestaEjgv.setEjgvDocument("EGJV. Notificacion en local");
			}
			ArbadhtramServiceImpl.logger
					.info("ArbadhtramServiceImpl. - createEJGVDocumentComunicacion. Fin Llamada a Platea");

		} catch (Y41bUDAException e) {
			e.printStackTrace();
			ArbadhtramServiceImpl.logger.info("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			ArbadhtramServiceImpl.logger.error("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhtramServiceImpl.logger.info("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			ArbadhtramServiceImpl.logger.error("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			throw e;
		} finally {
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
					// obtener los datos del documento
					Arbadhdoc documentoHecho = new Arbadhdoc();

					documentoHecho.setX5codocumento(adjuntardocsAux.getThcodocumento());

				}
			}
		}
		return respuestaEjgv;
	}

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun) {
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			Arbadhdoc documentoHechoAux = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoHechoAux = new Arbadhdoc();
				documentoHechoAux.setX5codocumento(documentoExpediente.getCodocumento());
				documentoHechoAux.setX5pcodigo(documentoExpediente.getPcodigo());
				try {
					this.arbadhdocDao.addAdjuntarDoc(documentoHechoAux, tramiteComun);
				} catch (DuplicateKeyException duplicateKeyException) {
					throw new Y41bUDAException("error.adjuntardocstramite.duplicateException", true, new Exception());
				}
			}
		}
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
				pagination.setSort("X5FECHA");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("X5TEDESFILE");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
				pagination.setSort("X5NOFILE");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
				pagination.setSort("X5ORIGEN");
			}
		}
		List<DocumentoExpediente> listDocumentoExpediente = (List<DocumentoExpediente>) this.arbadhdocDao
				.findAllDocumentosHechoComunicacion(tramiteComun, pagination);

		List<Arbadhdoc> listDocumentoHecho = this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoExpediente.setIncluidoComunicacion(Y41bConstantes.NO);
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (Arbadhdoc documentoHecho : listDocumentoHecho) {
						if (documentoExpediente.getCodocumento().equals(documentoHecho.getX5codocumento())) {
							documentoExpediente.setIncluidoComunicacion(Y41bConstantes.SI);
						}
					}
				}
			}
		}

		return listDocumentoExpediente;
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		return this.arbadhdocDao.findAllDocumentosHechoComunicacionCount(tramiteComun);
	}

	/**
	 * Tramitar cierre.
	 * 
	 * @param tramiteCierre
	 *            the tramite cierre
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhtram addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl - addTramiteCierre.EXPEIDENTE:"
				+ tramiteComun.getIdExpediente() + ".IDTRAMITE: " + tramiteComun.getIdTramite() + ".");

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		if (tramitar) {
			arbadhtram.setTrfecfin(tramiteCierre.getFechaFin());
			arbadhtram.setCensoMonitorEj(tramiteCierre.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		arbadhtram.setTrobserves(Y41bUtils.stringToClob(tramiteCierre.getComentario()));

		arbadhtram.setTrfeccierre(tramiteCierre.getFechaCierre());

		arbadhtram = this.setArbadhtram(arbadhtram);

		if (tramitar) {
			Arbadhtram resolucion = new Arbadhtram();
			resolucion.setTrexcodigo(arbadhtram.getTrexcodigo());
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
			}
			List<Arbadhtram> ltramites = arbadhtramDao.findAll(resolucion, null);
			if (ltramites != null && ltramites.size() > 0) {
				arbadhsol.setAdhestado(ltramites.get(0).getTrresotipo());
			}
			this.arbadhsolDao.update(arbadhsol);

			// 5. Cerramos el expediente en PLATEA
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(arbadhsol.getNumExpediente());
			CierreExpediente cierreExpediente = new CierreExpediente();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea
					.devuelveCodigoProcedimientoPlatea(tramiteComun.getTipoProcedimiento().getPcodigo()));
			cierreExpediente.setProcedure(procedure);
			cierreExpediente.setNumeroExpediente(numeroExpediente.toString());
			cierreExpediente.setEjercicio(arbadhsol.getAdhsolnran().toString());
			ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl. - cerrarExpediente. Inicio Llamada a Platea");
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
			}
			ArbadhtramServiceImpl.logger.info("ArbadhtramServiceImpl. - cerrarExpediente. Fin Llamada a Platea");
		}

		return arbadhtram;
	}

	/**
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List<NotificacionesComunicacionesBusqueda>
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination) {
		filterNotifComuni.setCompatibleAA66(this.compatibleConAA66(filterNotifComuni));

		List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.arbadhtramDao
				.findAllNotifiComuni(filterNotifComuni, pagination);

		for (NotificacionesComunicacionesBusqueda notifcomun : listNotifiComuniBusqueda) {

			notifcomun.setRmtipoExpediente(filterNotifComuni.getRmtipoExpediente());

			notifcomun.setNumExpediente(notifcomun.getNumExpediente());

			// En caso de que sea el destino Sede fijar la direcci�n de la
			// misma
			if (notifcomun.getEhsede() != null && notifcomun.getEhsede().equals("S")) {

				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEsnif(notifcomun.getNif());

				establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);
				// Para las sedes adhesiones y arbitraje se usa lo mismo
				if (establecimiento != null) {
					Sede sede = new Sede();
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

					sede = this.establecimientoService.findEstablecimientoSede(sede);
					if (sede != null) {
						notifcomun.setNombre_CP(sede.getNombreCp());
						if (sede.getNombreMunicipio() != null) {
							notifcomun.setNombre_Municipio(sede.getNombreMunicipio());
						}
						if (sede.getNombreLocalidad() != null) {
							notifcomun.setNombre_Localidad(sede.getNombreLocalidad());
						}
						if (sede.getNombreProvincia() != null) {
							notifcomun.setNombre_Provincia(sede.getNombreProvincia());
						}

						if (sede.getNombreCalle() != null) {
							notifcomun.setNombre_Calle(sede.getNombreCalle());

							notifcomun.setNombre_Portal(sede.getNombrePortal());
							notifcomun.setNombre_Piso(sede.getNombrePiso());

						} else if (sede.getDireccionNocapv() != null) {
							notifcomun.setNombre_Calle("");
							notifcomun.setNombre_Portal("");
							notifcomun.setNombre_Piso("");
							if (sede.getNoraPaisNombre() != null && !sede.getNoraPaisNombre().equals("")) {
								notifcomun.setNombre_Pais(sede.getNoraPaisNombre());
							}
							notifcomun.setExtranjero(sede.getExtranjero());
							notifcomun.setDireccionNocapv(sede.getDireccionNocapv());
						}
					} else {
						this.ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
					}
				} else {
					this.ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
				}
			}
			// PREPARO LAS DIRECCIONES DESTINO
			StringBuffer direccion2 = new StringBuffer();
			if (notifcomun.getNombre_CP() != null && !notifcomun.getNombre_CP().equals("")) {
				direccion2.append(notifcomun.getNombre_CP());
			} else {
				direccion2.append("");
				notifcomun.setNombre_CP("");
			}
			if (notifcomun.getExtranjero() != null && notifcomun.getExtranjero().equals("S")) {
				notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				direccion2.append(" ").append(notifcomun.getNombre_Pais());
				notifcomun.setDireccion2(direccion2.toString());

			} else {
				if (notifcomun.getNombre_Calle() != null && !notifcomun.getNombre_Calle().equals("")) {
					StringBuffer direccionCapv = new StringBuffer();
					direccionCapv.append(notifcomun.getNombre_Calle());
					if (notifcomun.getNombre_Portal() != null && !notifcomun.getNombre_Portal().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Portal());
					}
					if (notifcomun.getNombre_Piso() != null && !notifcomun.getNombre_Piso().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Piso());
					}
					notifcomun.setDireccion1(direccionCapv.toString());
				} else {
					notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				}

				direccion2.append(" ").append(notifcomun.getNombre_Municipio());
				notifcomun.setDireccion2(direccion2.toString());

			}

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (notifcomun.getNombreCalle() != null && !notifcomun.getNombreCalle().equals("")) {
				direccionCompleta.append(notifcomun.getNombreCalle());

				if (notifcomun.getNombrePortal() != null && !notifcomun.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(notifcomun.getNombrePortal());
				}
			}

			notifcomun.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (notifcomun.getNombreCp() != null && !notifcomun.getNombreCp().equals("")) {
				cpMunicipio.append(notifcomun.getNombreCp());

				if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(notifcomun.getNombreMunicipio());
				}
			} else if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
				cpMunicipio.append(notifcomun.getNombreMunicipio());
			}

			notifcomun.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer(Y41bConstantes.NUM_20);

			piepagina_linea1.append(notifcomun.getDireccionOrganismo()).append(" - ")
					.append(notifcomun.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(notifcomun.getTelefonoOrganismo());

			notifcomun.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(notifcomun.getEmailOrganismo()).append(" / ")
					.append(notifcomun.getWebOrganismo());

			notifcomun.setPiePaginaLinea2(piepagina_linea2.toString());
		}

		return listNotifiComuniBusqueda;
	}

	/**
	 * Counts rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni) {
		return this.arbadhtramDao.findAllNotifiComuniCount(filterNotifComuni);
	}

	/**
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return boolean
	 */
	private boolean compatibleConAA66(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosDao.find(parametros);
		if (null != parametros && null != parametros.getValor()) {
			String integracion = parametros.getValor();
			return integracion.equalsIgnoreCase(Y41bConstantes.VALOR_SI);
		}
		return false;
	}

	/**
	 * 
	 * @param notifcomun
	 *            NotificacionesComunicacionesBusqueda
	 */
	private void ponerVaciaLaSedeEnLaNotificaComunica(NotificacionesComunicacionesBusqueda notifcomun) {
		notifcomun.setNombre_CP("");
		notifcomun.setNombre_Municipio("");
		notifcomun.setNombre_Provincia("");
		notifcomun.setNombre_Calle("");
		notifcomun.setNombre_Portal("");
		notifcomun.setNombre_Piso("");
		notifcomun.setNombre_Pais("");
		notifcomun.setExtranjero("");
		notifcomun.setDireccionNocapv("");
	}

	/**
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws Exception {

		List<NotificacionesComunicacionesBusqueda> listaClobsNotifiComuni = this.arbadhtramDao
				.findBlobTablaDocumentosHecho(filterNotifiComuni);
		if (listaClobsNotifiComuni != null) {

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listaClobsNotifiComuni) {

				// si est en dokusi, descargar de dokusi
				if (notificacionesComunicacionesBusquedaAux != null
						&& notificacionesComunicacionesBusquedaAux.getQ5iddocumentum() != null
						&& !notificacionesComunicacionesBusquedaAux.getQ5iddocumentum().equals("")) {
					// descargar de dokusi
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea
							.devuelveCodigoProcedimientoPlatea(filterNotifiComuni.getRmtipoExpediente()));
					documento.setProcedure(procedure);
					documento.setOidDokusi(notificacionesComunicacionesBusquedaAux.getQ5iddocumentum());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					notificacionesComunicacionesBusquedaAux.setQ5datafile(blob);
				} else {
					// si no est en dokusi descargar de base de datos
				}
			}
		}
		return listaClobsNotifiComuni;
	}

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 * @param remesaEmitida
	 * @param envio
	 * @param fechaSituacion
	 * @param situacionCorreos
	 * @param envcestado
	 * @param documentoZipByte
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoZipByte, String filename) {

		// "Salir si no est respondido por Correos"
		if (!Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)
				&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
			return;
		}

		TramiteComun tramiteComun = null;
		TramiteAcuseRecibo tramiteAcuseRecibo = null;

		if (envio.getIdTramiteAcuseRelacionado() != null) {
			try {
				// Buscar el trmite de Acuse relacionado con el envio
				tramiteAcuseRecibo = new TramiteAcuseRecibo();
				tramiteAcuseRecibo.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				tramiteAcuseRecibo = this.findTramiteAcuseRecibo(tramiteAcuseRecibo, censoMonitor);

				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(envio.getHdcodigo());
				tramiteComun.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(remesaEmitida.getRmtipoproc());
				tramiteComun.setTipoProcedimiento(tipoProcedimiento);

				// "Crear el documento hecho del PEE para asociar al tramite"
				Arbadhdoc docHechoPEE_Aux = new Arbadhdoc();
				docHechoPEE_Aux.setX5codocumento(this.arbadhdocDao.getNewPK().toString());

				docHechoPEE_Aux.setX5origen(Y41bConstantes.ORIGEN_ADH_APORTADO_OTROS);
				docHechoPEE_Aux.setArbtipdoc(new Arbtipdoc(Y41bConstantes.TIPO_DOC_ARB_ACUSE));

				Blob blob = new SerialBlob(documentoZipByte);
				docHechoPEE_Aux.setX5datafile(blob);
				docHechoPEE_Aux.setX5conttype(Y41bConstantes.CONTENT_TYPE_PDF);
				docHechoPEE_Aux.setX5nofile(filename);
				docHechoPEE_Aux.setX5tedesfile(Y41bConstantes.PRUEBA_ENTREGA_ENVIO);
				docHechoPEE_Aux.setX5sizefile((int) documentoZipByte.length);

				Arbadhsol expAux = new Arbadhsol();
				expAux.setAdhid(tramiteComun.getIdExpediente());

				docHechoPEE_Aux.setX5excodigo(tramiteComun.getIdExpediente());

				Arbadhtram tramiteAux = new Arbadhtram();
				tramiteAux.setTrid(tramiteComun.getIdTramite());
				docHechoPEE_Aux.setArbadhtram(tramiteAux);

				docHechoPEE_Aux.setX5fecha(new Date());

				// "Actualizar tramite de acuse de recibo asociado al envio"
				Date fecha;
				fecha = Y41bUtils.convertFromSQLDateToJAVADate(
						Y41bUtils.formatearStringToDateFormato(fechaSituacion, Y41bConstantes.FORMATO_FECHA_ES));
				tramiteAcuseRecibo.setFechaacuse(fecha);

				if (situacionCorreos != null) {
					tramiteAcuseRecibo.setSituacionacuse(situacionCorreos);
				}

				// "Si el trmite ya estaba TRAMITADO, entonces SOLO se aade el
				// documeto PEE al trmite"
				if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteAcuseRecibo.getEstadoTramite())) {

					// "Solo si ha sido respondido por Correos"
					if (Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)) {

						this.arbadhdocDao.add(docHechoPEE_Aux);
						this.arbadhdocDao.insertArbDocTramite(tramiteComun.getIdTramite(),
								docHechoPEE_Aux.getX5codocumento(), remesaEmitida.getRmtipoproc());
					}
					// "ELSE: Si el envo viene erroneo; entonces NO se hace
					// nada, se queda a la espera de que venga el documento PEE"

				} else {

					// "Si la situacin devuelta por Correos es convertida a
					// ACUSE ACEPTADO, entonces hay que tramitar el trmite de
					// Acuese e informar al responsable."
					// "Aunque solo en el caso de que NO se haya producido un
					// error (el de no existe PEE, ya que el resto lanzan
					// excepcin y no pasan por aqu)"
					String idioma = LocaleContextHolder.getLocale().getLanguage();
					if (situacionCorreos != null
							&& situacionCorreos.equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)
							&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {

						// "Aceptado y NO erroneo >>> Tramita acuse y envia
						// email al responsable."
						this.addTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, idioma, true,
								docHechoPEE_Aux);
						this.envioMailAcuseRecibo(tramiteComun, fecha);

					} else {
						// "Guarda acuse."
						this.addTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, idioma, false,
								docHechoPEE_Aux);
					}
				}
			} catch (ParseException e) {
				logger.error("error ParseException", e);
				throw new Y41bUDAException("error.generico", true, e);
			} catch (Exception e) {
				logger.error("error genrico", e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	private TramiteAcuseRecibo addTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, String idioma, boolean tramitar, Arbadhdoc docHechoPEE) throws Exception {
		return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma, tramitar, docHechoPEE, true, false);
	}

	/**
	 * Envio mail acuse de recibo aceptado
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param fecha
	 *            Date
	 */
	private void envioMailAcuseRecibo(TramiteComun tramiteComun, Date fecha) {
		// Enviar mail
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = arbadhsolDao.find(arbadhsol);

		CensoMonitor responsableExpediente = new CensoMonitor();
		if (arbadhsol.getAdhusumodif() != null) {
			responsableExpediente.setMocodigo(arbadhsol.getAdhusumodif());

			if (responsableExpediente.getMocodigo() != null && !responsableExpediente.getMocodigo().equals("")) {
				responsableExpediente = this.censoMonitorDao.find(responsableExpediente);
			}

			String from = "";
			if (responsableExpediente != null && responsableExpediente.getOrganismo() != null) {
				from = responsableExpediente.getOrganismo().getEmail();
			}

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			StringBuffer asunto = new StringBuffer();
			asunto.append(appMessageSource.getMessage("acuserecibido.mail.asunto", null,
					new Locale(Y41bConstantes.CASTELLANO)));

			asunto.append(" ").append(arbadhsol.getNumExpediente()).append(" / ");

			asunto.append(
					appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.EUSKERA)));
			asunto.append(" ").append(arbadhsol.getNumExpediente());

			StringBuffer texto = new StringBuffer();
			texto.append("<B>").append(appMessageSource.getMessage("acuserecibido.mail.texto", null,
					new Locale(Y41bConstantes.CASTELLANO))).append("</B>");
			texto.append(" ").append(arbadhsol.getNumExpediente()).append("<BR>");
			texto.append("<B>").append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
					new Locale(Y41bConstantes.CASTELLANO))).append("</B>");
			texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.CASTELLANO)).append("<BR><BR>");

			texto.append("<B>").append(
					appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.EUSKERA)))
					.append("</B>");
			texto.append(" ").append(arbadhsol.getNumExpediente()).append("<BR>");
			texto.append("<B>").append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
					new Locale(Y41bConstantes.EUSKERA))).append("</B>");
			texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.EUSKERA)).append("<BR><BR>");

			String destinatariosMail = responsableExpediente.getMocoem();

			ArrayList attachments = new ArrayList();

			// Envio mail
			Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatariosMail, "", attachments);
		}
	}

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni) {

		return this.arbadhtramDao.findSumSizeBlobNotifiComuni(filterNotifiComuni);
	}

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramiteAcuseAdh
	 *            Arbadhtram
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(Arbadhtram tramiteAcuseAdh, Documento justificanteAcuse,
			String tipoProcedimiento) {
		DocumentoHecho docHechoJustificanteAcuse = new DocumentoHecho();
		docHechoJustificanteAcuse.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

		docHechoJustificanteAcuse.setQ5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
		if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equalsIgnoreCase(tipoProcedimiento)) {
			docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ADH_ALTA_ACUSE_RECIBO);
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equalsIgnoreCase(tipoProcedimiento)) {
			docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ADH_BAJA_ACUSE_RECIBO);
		} else {
			docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ADH_MOD_ACUSE_RECIBO);
		}
		docHechoJustificanteAcuse.setQ5iddocumentum(justificanteAcuse.getOidDokusi());
		docHechoJustificanteAcuse.setQ5contenttypefile(justificanteAcuse.getContentType());
		docHechoJustificanteAcuse.setQ5nofile(justificanteAcuse.getNombre());
		docHechoJustificanteAcuse.setQ5tedesfile(Y41bConstantes.JUSTIFICANTE_NOTIFICACION_ELECTRONICA);
		docHechoJustificanteAcuse.setQ5sizefile((int) justificanteAcuse.getLength());
		docHechoJustificanteAcuse.setQ5hdcodigo(tramiteAcuseAdh.getTrexcodigo());
		docHechoJustificanteAcuse.setQ5tramite(tramiteAcuseAdh.getTrid());
		docHechoJustificanteAcuse.setQ5fecha(new Date());

		this.documentoHechoDao.add(docHechoJustificanteAcuse);

		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramiteAcuseAdh.getTrid());
		documentoTramiteHecho.setCodocumento(docHechoJustificanteAcuse.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(tipoProcedimiento);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

	}

}
