package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.TramiteADHApertura;
import com.ejie.y41b.model.TramiteADHResolucion;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;

/**
 * ArbadhtramService  
 * 
 *  
 */

public interface ArbadhtramService {

	/**
	 * Inserts a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram add(Arbadhtram arbadhtram);

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram update(Arbadhtram arbadhtram);

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram find(Arbadhtram arbadhtram);

	/**
	 * Finds a Single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param codocumento
	 *            String
	 * @return Long
	 */
	Long findByExpediente(Arbadhtram arbadhtram, String codocumento);

	/**
	 * Finds a List of rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhtram> findAll(Arbadhtram arbadhtram, Pagination pagination);

	/**
	 * Counts rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Long
	 */
	Long findAllCount(Arbadhtram arbadhtram);

	/**
	 * Finds rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhtram> findAllLike(Arbadhtram arbadhtram, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhtram arbadhtram, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return
	 */
	void remove(Arbadhtram arbadhtram);

	/**
	 * Deletes multiple rows in the Arbadhtram table.
	 * 
	 * @param arbadhtramList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbadhtram> arbadhtramList);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param expedienAux
	 *            Solarb
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	void generarTramiteAportacionDocumentacion(Arbadhsol expedienAux,
			MensajeAportacionDocumentacion mensajeAportacionDoc)
			throws Exception;

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun);

	/**
	 * findTramiteApertura
	 * 
	 * @param tramite
	 *            TramiteADHApertura
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteADHApertura
	 */
	TramiteADHApertura findTramiteApertura(TramiteADHApertura tramite,
			CensoMonitor censoMonitor);

	/**
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * findTramiteResolucion
	 * 
	 * @param tramite
	 *            TramiteADHResolucion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteADHResolucion
	 */
	TramiteADHResolucion findTramiteResolucion(TramiteADHResolucion tramite,
			CensoMonitor censoMonitor);

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	TramiteAcuseRecibo addTramiteAcuseRecibo(
			TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, boolean reintento)
			throws Exception;

	/**
	 * 
	 * @param arbadhtram
	 *            arbadhtram
	 * @param listDocumentos
	 *            Arbadhdoc
	 * @throws SQLException
	 *             excepcion
	 */
	void actualizarMisGestionesNotificacion(Arbadhtram arbadhtram,
			List<Arbadhdoc> listDocumentos) throws SQLException;

	/**
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param listDocumentos
	 *            List<Arbadhsolcomdoc>
	 * @throws SQLException
	 *             excepcion
	 */
	void actualizarMisGestionesComunicacion(Arbadhtram arbadhtram,
			List<Arbadhdoc> listDocumentos) throws SQLException;

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esNotificacionTipoElectronica
	 *            the electronica no ordinaria
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteNotificacion(TramiteNotificacion tramiteNotificacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar, boolean esNotificacionTipoElectronica,
			String idZipFile, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esNotificacionTipoElectronica
	 *            the electronica no ordinaria
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteNotificacion0(TramiteNotificacion tramiteNotificacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar, boolean esNotificacionTipoElectronica,
			String idZipFile, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            boolean
	 * @param esComunicacionOrdinaria
	 *            boolean
	 * @param esComunicacionElectronica
	 *            boolean
	 * @param idZipFile
	 *            boolean
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbadhtram
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteComunicacion(TramiteComunicacion tramiteComunicacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            boolean
	 * @param esComunicacionOrdinaria
	 *            boolean
	 * @param esComunicacionElectronica
	 *            boolean
	 * @param idZipFile
	 *            boolean
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbadhtram
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteComunicacion0(TramiteComunicacion tramiteComunicacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteComunicacionMail(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteComunicacionMail0(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Inserts a single row in the Arbadhtram table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbadhtram
	 * @throws Exception
	 *             Exception
	 */
	Arbadhtram addTramiteGenerico(TramiteGenerico tramiteGenerico,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param monitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico,
			CensoMonitor monitor);

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre,
			CensoMonitor monitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteComunicacion findTramiteComunicacion(
			TramiteComunicacion tramiteComunicacion, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteNotificacion findTramiteNotificacion(
			TramiteNotificacion tramiteNotificacion, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	TramiteAcuseRecibo findTramiteAcuseRecibo(
			TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * createEJGVDocumentComunicacion
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pcodigo
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             excepcion
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, String pcodigo) throws Exception;

	/**
	 * createEJGVDocumentComunicacion0
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pcodigo
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             excepcion
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion0(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, String pcodigo) throws Exception;

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, String tipoProcedimiento)
			throws Exception;

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion0(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, String tipoProcedimiento)
			throws Exception;

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocumentosTableTemporal(
			List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun);

	/**
	 * Finds registro entrada document.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterv
	 *            String
	 * @param esNotificacion
	 *            boolean
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	RegistroSalida getRegistroSalida(TramiteComun tramiteComun,
			String idInterv, boolean esNotificacion) throws Exception;

	/**
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram updateRegistroSalidaPlatea(Arbadhtram arbadhtram);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosHechoComunicacion(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 */
	boolean tratarTramitacionAcuse(Arbadhtram arbadhtram) throws Exception;

	/**
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List<NotificacionesComunicacionesBusqueda>
	 */
	List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni,
			Pagination pagination);

	/**
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 *             excepcion
	 */
	List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni)
			throws Exception;

	/**
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	Long findAllNotifiComuniCount(
			NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	TramiteAdjuntarDocs findTramiteAdjuntarDocs(
			TramiteAdjuntarDocs tramiteAdjuntarDocs, CensoMonitor censoMonitor);

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param remesaEmitida
	 *            Remesa
	 * @param envio
	 *            NotificacionesComunicacionesBusqueda
	 * @param fechaSituacion
	 *            String
	 * @param situacionCorreos
	 *            String
	 * @param estadoDelEnvio
	 *            String
	 * @param documentoZipByte
	 *            byte[]
	 * @param filename
	 *            String
	 */
	void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor,
			Remesa remesaEmitida, NotificacionesComunicacionesBusqueda envio,
			String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoZipByte, String filename);

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni);

	void aportarJustificanteAcuseRecibo(Arbadhtram tramiteAcuseAdh,
			Documento justificanteAcuse, String tipoProcedimiento);
}
