package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadhsolDao;
import com.ejie.y41b.dao.ArbadhsolcomdocDao;

import java.sql.Blob;
import java.util.List;

import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhsolcomdoc;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * ArbadhsolcomdocServiceImpl  
 * 
 *  
 */

@Service(value = "arbadhsolcomdocService")
public class ArbadhsolcomdocServiceImpl implements ArbadhsolcomdocService {

	@Autowired
	private ArbadhsolcomdocDao arbadhsolcomdocDao;
	@Autowired
	private ArbadhsolDao arbadhsolDao;
	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	/**
	 * Inserts a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsolcomdoc add(Arbadhsolcomdoc arbadhsolcomdoc) {
		return this.arbadhsolcomdocDao.add(arbadhsolcomdoc);
	}

	/**
	 * Updates a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsolcomdoc update(Arbadhsolcomdoc arbadhsolcomdoc) {
		return this.arbadhsolcomdocDao.update(arbadhsolcomdoc);
	}

	/**
	 * Finds a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public Arbadhsolcomdoc find(Arbadhsolcomdoc arbadhsolcomdoc)
			throws Exception {
		arbadhsolcomdoc = this.arbadhsolcomdocDao.find(arbadhsolcomdoc);
		String tipoProcedimientoPlatea = "";
		Arbadhsol arbadhsol = this.arbadhsolDao.find(new Arbadhsol(
				arbadhsolcomdoc.getXmexcodigo()));
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoProcedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoProcedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol
						.getAdhtipo())) {
			tipoProcedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}

		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmiddocumentum() != null
				&& !arbadhsolcomdoc.getXmiddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(tipoProcedimientoPlatea);
			documento.setProcedure(procedure);
			documento.setOidDokusi(arbadhsolcomdoc.getXmiddocumentum());

			Documento docDokusi = y41bDokusiAdapterService
					.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			arbadhsolcomdoc.setXmdatafile(blob);
			arbadhsolcomdoc.setXmconttype(docDokusi.getContentType());
			arbadhsolcomdoc.setXmnofile(Y41bUtils.getNameFileDokusi(docDokusi
					.getNombre()));
			arbadhsolcomdoc.setXmsizefile(Integer.valueOf((int) docDokusi
					.getLength()));
		}
		return arbadhsolcomdoc;
	}

	/**
	 * Finds a List of rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbadhsolcomdoc> findAll(Arbadhsolcomdoc arbadhsolcomdoc,
			Pagination pagination) {
		return (List<Arbadhsolcomdoc>) this.arbadhsolcomdocDao.findAll(
				arbadhsolcomdoc, pagination);
	}

	/**
	 * Counts rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Long
	 */
	public Long findAllCount(Arbadhsolcomdoc arbadhsolcomdoc) {
		return this.arbadhsolcomdocDao.findAllCount(arbadhsolcomdoc);
	}

	/**
	 * Finds rows in the Arbadhsolcomdoc table using like.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbadhsolcomdoc> findAllLike(Arbadhsolcomdoc arbadhsolcomdoc,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbadhsolcomdoc>) this.arbadhsolcomdocDao.findAllLike(
				arbadhsolcomdoc, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbadhsolcomdoc table using like.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbadhsolcomdoc arbadhsolcomdoc,
			Boolean startsWith) {
		return this.arbadhsolcomdocDao.findAllLikeCount(arbadhsolcomdoc,
				startsWith);
	}

	/**
	 * Deletes a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbadhsolcomdoc arbadhsolcomdoc) {
		this.arbadhsolcomdocDao.remove(arbadhsolcomdoc);
	}

	/**
	 * Deletes multiple rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdocList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbadhsolcomdoc> arbadhsolcomdocList) {
		for (Arbadhsolcomdoc arbadhsolcomdocAux : arbadhsolcomdocList) {
			this.arbadhsolcomdocDao.remove(arbadhsolcomdocAux);
		}
	}

}
