package com.ejie.y41b.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdhesionTeleDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbadhdocDao;
import com.ejie.y41b.dao.ArbadhintervDao;
import com.ejie.y41b.dao.ArbadhsolDao;
import com.ejie.y41b.dao.ArbadhsolcomdocDao;
import com.ejie.y41b.dao.ArbadhtramDao;
import com.ejie.y41b.dao.ArbnumadhreuDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import com.ejie.y41b.dao.DatosMailSedeDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.SectorDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PaisDao;
import com.ejie.y41b.dao.T17ProvinciaDao;

import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.AdhesionTele;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhsolcomdoc;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.Arbnumadhreu;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Docadhtele;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteARBDetalle;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteNotificacion;

import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.dokusi.TransformarDocumento;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.SolicitudOficio;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * ArbadhsolServiceImpl  
 * 
 *  
 */

@Service(value = "arbadhsolService")
public class ArbadhsolServiceImpl implements ArbadhsolService {

	@Autowired()
	private ArbadhsolDao arbadhsolDao;
	@Autowired()
	private ArbnumadhreuDao arbnumadhreuDao;
	@Autowired()
	private AdhesionTeleDao adhesionTeleDao;
	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired()
	private ArbadhsolcomdocDao arbadhsolcomdocDao;
	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;
	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private EstablecimientoService establecimientoService;
	@Autowired()
	private SedeService sedeService;
	@Autowired()
	private T17CalleDao t17CalleDao;
	@Autowired()
	private T17PortalService t17PortalService;
	@Autowired()
	private T17LocalidadDao t17LocalidadDao;
	@Autowired()
	private T17MunicipioDao t17MunicipioDao;
	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;
	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;
	@Autowired()
	private EstablecimientoDao establecimientoDao;
	@Autowired()
	private EstablecimSectorDao establecimSectorDao;
	@Autowired()
	private T17PaisDao t17PaisDao;
	@Autowired()
	private EstablecimArbitraDao establecimArbitraDao;
	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private ArbadhtramDao arbadhtramDao;
	@Autowired()
	private ArbadhdocDao arbadhdocDao;
	@Autowired()
	private ArbadhtramService arbadhtramService;
	@Autowired()
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;
	@Autowired()
	private DatosMailSedeDao datosMailSedeDao;
	@Autowired()
	private ArbadhintervDao arbadhintervDao;
	@Autowired()
	private ArbadhintervService arbadhintervService;
	@Autowired()
	private ArbadhsolcomdocDao arbadhcomdocDao;
	@Autowired()
	private ArbtipdocDao arbtipdocDao;
	@Autowired()
	private SectorDao sectorDao;
	@Autowired()
	private SedeDao sedeDao;
	@Autowired()
	private DocumentoHechoDao documentoHechoDao;
	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;
	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;
	@Autowired()
	private ArbadhsolcomdocService arbadhsolcomdocService;
	@Autowired()
	private DenunciaService denunciaService;

	private static final Logger logger = LoggerFactory.getLogger(ArbadhsolServiceImpl.class);

	/**
	 * Inserts a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol add(Arbadhsol arbadhsol) {
		return this.arbadhsolDao.add(arbadhsol);
	}

	/**
	 * Updates a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol update(Arbadhsol arbadhsol) throws Exception {
		Arbadhsol arbadhsolBD = this.arbadhsolDao.find(arbadhsol);
		arbadhsolBD.setAdhlimitaciones(arbadhsol.getAdhlimitaciones());
		String tipoProcedimiento = "";
		TramiteComun tramiteComun = new TramiteComun();
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			tipoProcedimiento = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;

			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
		}
		// el campo ADHSOLTIPNOTIF ahora es modificable.
		arbadhsolBD.setAdhsoltipnotif(arbadhsol.getAdhsoltipnotif());

		this.arbadhsolDao.update(arbadhsolBD);
		this.arbadhsolDao.guardarDatosComunicacion(arbadhsol);

		tramiteComun.setIdTramite(arbadhsol.getAdhid().toString());
		tramiteComun.setIdExpediente(arbadhsol.getAdhid().toString());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProcedimiento));

		List<Arbadhsolcomdoc> listArbadhdocEliminados = this.arbadhsolcomdocDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.arbadhsolcomdocDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
		this.arbadhsolcomdocDao.addDocumentosHechoAdjuntarDocs(tramiteComun);

		// Borramos y volcamos de nuevo
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		this.addTramiteAdjuntarDocsComTableTemporal(arbadhsol.getAdhid().toString());

		List<Arbadhsolcomdoc> listDocumentoHecho = this.arbadhsolcomdocDao.findAllDocumentosRespuesta(tramiteComun,
				null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);
		if (isDocPendienteFirma) {
			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
					tramiteComun.getIdTipoTramite());
		} else {
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			bandejaFirma.setPcodigo(tipoProcedimiento);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}

		this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);

		this.eliminarDocumentosDokusi(listArbadhdocEliminados, tramiteComun.getTipoProcedimiento().getPcodigo());

		return arbadhsol;
	}

	/**
	 * Finds a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	public Arbadhsol find(Arbadhsol arbadhsol) {
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		if (!Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())
				&& !Y41bUtils.esNullOCadenaVacia(arbadhsol.getAdhescodigo())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(arbadhsol.getAdhescodigo());
			establecimiento = this.establecimientoDao.find(establecimiento);
			arbadhsol.setEsfeadar(establecimiento.getEsfeadar());
		}

		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			arbadhsol.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			arbadhsol.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			arbadhsol.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD);
		}
		Arbadhsol arbadhsolAux = (Arbadhsol) this.arbadhsolDao.find(arbadhsol);
		arbadhsol.setAdhlimitaciones(arbadhsolAux.getAdhlimitaciones());

		// Datos del establecimiento validado
		Arbadhsol arbadhsolValidacion = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		if (arbadhsolValidacion != null && arbadhsolValidacion.getAdhid() != null) {
			arbadhsol.setValidacionOK(Y41bConstantes.SI);
		} else {
			arbadhsol.setValidacionOK(Y41bConstantes.NO);
		}

		// Respuesta pendiente (Notificacion o Comunicacion por remesa)
		Pagination pagination = new Pagination();
		pagination.setSidx("TRID");
		pagination.setSord("DESC");
		Arbadhtram resolucion = new Arbadhtram();
		resolucion.setTrexcodigo(arbadhsol.getAdhid());
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
		}
		List<Arbadhtram> lresolucion = this.arbadhtramDao.findAll(resolucion, pagination);
		if (lresolucion != null && lresolucion.size() > 0) {
			Arbadhtram notificacion = new Arbadhtram();
			notificacion.setTrexcodigo(arbadhsol.getAdhid());
			notificacion.setTrtridrel(lresolucion.get(0).getTrid());
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				notificacion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				notificacion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				notificacion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD);
			}
			List<Arbadhtram> lnotificacion = this.arbadhtramDao.findAll(notificacion, pagination);
			if (lnotificacion != null && lnotificacion.size() > 0) {
				Arbadhtram acuse = new Arbadhtram();
				acuse.setTrexcodigo(arbadhsol.getAdhid());
				acuse.setTrtridrel(lnotificacion.get(0).getTrid());
				if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
					acuse.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_ACUSE_ALTA);
				} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
						|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
					acuse.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_ACUSE_BAJA);
				} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
					acuse.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_ACUSE_MOD);
				}
				List<Arbadhtram> lacuse = this.arbadhtramDao.findAll(acuse, pagination);
				if (lacuse != null && lacuse.size() > 0) {
					if (Y41bUtils.esNullOCadenaVacia(lacuse.get(0).getTrestadoacuse())
							|| !Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(lacuse.get(0).getTrestado())) {
						arbadhsol.setAdhrespuesta(Y41bConstantes.VALOR_SI);
					}
				}
			} else {
				Arbadhtram comunicacion = new Arbadhtram();
				comunicacion.setTrexcodigo(arbadhsol.getAdhid());
				comunicacion.setTrtridrel(lresolucion.get(0).getTrid());
				if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
					comunicacion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA);
				} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
						|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
					comunicacion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA);
				} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
					comunicacion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD);
				}
				List<Arbadhtram> lcomunicacion = this.arbadhtramDao.findAll(comunicacion, pagination);
				if (lcomunicacion != null && lcomunicacion.size() > 0) {
					if (Y41bConstantes.VALOR_SI.equals(lcomunicacion.get(0).getTrenvrem())
							&& Y41bUtils.esNullOCadenaVacia(lcomunicacion.get(0).getTrcodrem())) {
						arbadhsol.setAdhrespuesta(Y41bConstantes.VALOR_SI);
					}
				}
			}
		}
		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(arbadhsol.getAdhid());
			this.denunciaService.actualizarDocumentosLocalizados(solicitudDetalle);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
		return arbadhsol;
	}

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbadhsol> findAll(Arbadhsol arbadhsol, Pagination pagination) {
		return this.arbadhsolDao.findAll(arbadhsol, pagination);
	}

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Long
	 */
	public Long findAllCount(Arbadhsol arbadhsol) {
		return this.arbadhsolDao.findAllCount(arbadhsol);
	}

	/**
	 * Finds rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbadhsol> findAllLike(Arbadhsol arbadhsol, Pagination pagination, Boolean startsWith) {
		return (List<Arbadhsol>) this.arbadhsolDao.findAllLike(arbadhsol, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbadhsol arbadhsol, Boolean startsWith) {
		return this.arbadhsolDao.findAllLikeCount(arbadhsol, startsWith);
	}

	/**
	 * Deletes a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbadhsol arbadhsol) {
		this.arbadhsolDao.remove(arbadhsol);
	}

	/**
	 * Deletes multiple rows in the Arbadhsol table.
	 * 
	 * @param arbadhsolList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbadhsol> arbadhsolList) {
		for (Arbadhsol arbadhsolAux : arbadhsolList) {
			this.arbadhsolDao.remove(arbadhsolAux);
		}
	}

	/**
	 * proceso la recepcin de una solicitud telemtica de adhesin..
	 * 
	 * @param solicitud
	 *            AdhesionTele
	 * @param listDocumento
	 *            List<Documento>
	 * @return Arbadhsol
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol recibirSolicitudTelematica(AdhesionTele solicitud, List<Documento> listDocumento)
			throws Exception {

		AdhesionTele solicitudDetalleAux = new AdhesionTele();
		try {
			// obtenemos la solicitud de la tabla temporal de solicitudes
			// telematicas
			// con el numero de registro que hemos recibido en el JMS
			solicitudDetalleAux = this.adhesionTeleDao.findPorRegistroEntrada(solicitud);

		} catch (EmptyResultDataAccessException e) {
			// Si la solicitud no existe devolvemos la solicitud vacía
			return new Arbadhsol();
		}

		// SIGUIENTE APARTADO COMENTADO, se solicita modificar para que el
		// nmero de expediente lo de en el alta.

		/************** inicio alta numero expediente *******************/
		// String anyo = Y41bUtils.fncObtenerAnnoFecha(solicitudDetalleAux
		// .getAdhfecregen());

		// LE DAMOS A NUESTRA SOLICITUD UN NUMERO DE EXPEDIENTE
		// Arbadhsol solicitudFiltroCorrelativo = new Arbadhsol();
		// // cdigo de organimos. en prinicipio es fijo, pero se ha puesto por
		// si
		// // acaso.
		// solicitudFiltroCorrelativo
		// .setAdhsolcoor(Y41bConstantes.ID_ORGANISMO_SOLICITUD_ADH);
		// solicitudFiltroCorrelativo.setAdhtipo(solicitudDetalleAux.getAdhtipo());
		// solicitudFiltroCorrelativo.setAdhsolnran(new BigDecimal(anyo));
		//
		// // TODO - reintentar si hay un falla al obtener el contador de las
		// // solicitudes
		// long correlativoSolicitud = this.arbadhsolDao
		// .findCorrelativoSig(solicitudFiltroCorrelativo);
		/************** fin alta numero de expediente *******************/
		Arbadhsol nuevaSolicitud = new Arbadhsol();
		nuevaSolicitud.setAdhsolcoor(solicitudDetalleAux.getAdhsolcoor());
		nuevaSolicitud.setAdhsolnran(solicitudDetalleAux.getAdhsolnran());
		nuevaSolicitud.setAdhsolnror(solicitudDetalleAux.getAdhsolnror());
		nuevaSolicitud.setAdhestado(Y41bConstantes.ID_ESTADO_SOL_ADH_PENDIENTE);
		nuevaSolicitud.setAdhsoltipnotif(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
		nuevaSolicitud = this.arbadhsolDao.addDesdeTelematica(nuevaSolicitud, solicitudDetalleAux);

		// actualizamos la solicitud con el valor de la secuencia obtenido.
		nuevaSolicitud.setAdhid(this.arbadhsolDao.currentValue());
		// rellenamos con otros valores necesarios para ms adelante
		nuevaSolicitud.setAdhtipo(solicitudDetalleAux.getAdhtipo());
		// insertar los documentos de la solicitud telematica en documentos de
		// solicitudes
		// this.documentoHechoDao.enviarDocumentosSolicitudTelematica(solicitudDetalleAux);

		StringBuffer numeroExpediente = new StringBuffer();
		String tipoProc = "";
		String idProc = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(nuevaSolicitud.getAdhtipo())) {
			numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_ALTA);
			tipoProc = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
			idProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(nuevaSolicitud.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(nuevaSolicitud.getAdhtipo())) {
			numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_BAJA);
			tipoProc = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;
			idProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(nuevaSolicitud.getAdhtipo())) {
			numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_MOD);
			tipoProc = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
			idProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		}
		numeroExpediente.append("-").append(Y41bConstantes.ID_ORGANISMO_SOLICITUD_ADH).append("-")
				.append(nuevaSolicitud.getAdhsolnror()).append("-").append(nuevaSolicitud.getAdhsolnran());
		nuevaSolicitud.setNumExpediente(numeroExpediente.toString());
		ArbadhsolServiceImpl.logger.debug("FIN RECIBIR SOLICITUD TELEMTICA");

		Arbadhtram tramiteApertura = this.crearApertura(nuevaSolicitud);
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(tramiteApertura.getTrexcodigo().toString());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProc));
		tramiteComun.setIdTramite(tramiteApertura.getTrid().toString());

		// solicitud telemtica para buscar los documentos con el id de la
		// solicitud telemtica
		// y los datos del registro de entrada
		Docadhtele solicitudFiltradocumentos = new Docadhtele();
		solicitudFiltradocumentos.setXbadhid(solicitudDetalleAux.getAdhid());
		solicitudFiltradocumentos.setXbfechaentrada(solicitudDetalleAux.getAdhfecregen());
		solicitudFiltradocumentos.setXbnumregistroentrada(solicitudDetalleAux.getAdhsolregen());

		Arbadhdoc documentoTele = new Arbadhdoc();

		for (Documento documentoAux : listDocumento) {

			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(idProc);
			documento.setProcedure(procedure);
			documento.setOidDokusi(documentoAux.getOidDokusi());

			Documento docDokusi = this.y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			documentoTele = new Arbadhdoc();

			documentoTele.setX5codocumento(String.valueOf(this.documentoHechoDao.getNewPK()));
			documentoTele.setX5excodigo(tramiteComun.getIdExpediente());
			documentoTele.setX5nofile(documentoAux.getNombre());
			documentoTele.setX5sizefile((int) docDokusi.getLength());
			documentoTele.setX5origen(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
			documentoTele.setX5tedesfile(documentoAux.getDescripcion());
			documentoTele.setX5iddocumentum(documentoAux.getOidDokusi());
			documentoTele.setX5conttype(docDokusi.getContentType());
			documentoTele.setX5fecha(new Date());
			documentoTele.setX5fechaaportacion(solicitudDetalleAux.getAdhfecregen());

			documentoTele.setArbadhtram(tramiteApertura);

			documentoTele.setArbtipdoc(new Arbtipdoc(Y41bConstantes.TIPO_DOC_ARB_OTROS));

			documentoTele.setX5fechaentrada(new Date());
			documentoTele.setX5numregistroentrada(solicitudDetalleAux.getAdhsolregen());
			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			documentoTele.setX5datafile(blob);
			this.arbadhdocDao.add(documentoTele);

			// insertar en la tabla de relacion
			this.arbadhdocDao.insertArbDocTramite(tramiteApertura.getTrid(), documentoTele.getX5codocumento(),
					tipoProc);

		}

		// borrar los documentos telemticos
		this.arbadhdocDao.removeTelematicos(solicitudFiltradocumentos);

		// borrar la solicitud telemtica
		this.adhesionTeleDao.remove(solicitudDetalleAux);

		// devolver la solicitud
		return nuevaSolicitud;
	}

	/**
	 * eliminar las solicitudes telemticas que se quedan en BBDD pero que no se
	 * llegan a recibir porque no se han registrado Eliminamos aquellas que
	 * hayan pasado ms de una semana.
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void limpiarTemporalesTelematicasAntiguas() throws Exception {

		// se podran borrar todos los documentos "muertos" de dokusi... pero en
		// reclamaciones no se hace, ni siquiera eliminan las muertas...
		this.arbadhdocDao.removeTelematicosAntiguas();

		this.adhesionTeleDao.removeTelematicosAntiguas();
	}

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbadhsol> findBandeja(Arbadhsol arbadhsol, CensoMonitor censoMonitor, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setAscDsc(" ");
				pagination.setSort(" ADHTIPOAUX ASC, ADHSOLCOOR ASC,  ADHSOLNRAN ASC, TO_NUMBER(ADHSOLNROR) ASC ");
			} else if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& "numExpediente".equals(pagination.getSort())) {
				pagination.setAscDsc(" ");
				pagination.setSort(" ADHTIPOAUX DESC, ADHSOLCOOR DESC, ADHSOLNRAN DESC, TO_NUMBER(ADHSOLNROR) DESC ");
			}
		}

		List<Arbadhsol> listaBandeja = (List<Arbadhsol>) this.arbadhsolDao.findBandeja(arbadhsol, censoMonitor,
				pagination);

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);
		int minutos = 0;

		if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
			minutos = Integer.parseInt(parametros.getValor());
		}

		for (Arbadhsol registroBandeja : listaBandeja) {
			// Batrid es el id del tramite en cuestin o del tramite relacionado
			// con el aviso
			if (registroBandeja.getAdhid() != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(registroBandeja.getAdhestado())
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(registroBandeja.getAdhestado())) {

				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdTramite(registroBandeja.getAdhid().toString());
				tramiteComun.setIdExpediente(registroBandeja.getAdhid().toString());
				List<Arbadhsolcomdoc> listDocumentoHecho = this.arbadhcomdocDao.findAllDocumentosRespuesta(tramiteComun,
						null);

				// Formatear estado del tramite segun sus documentos
				if (listDocumentoHecho != null) {
					boolean error = false;
					boolean sinLocalizarPorTiempo = false;
					boolean localizado = false;
					boolean firmado = false;
					boolean pendienteFirma = false;
					boolean firmaDenegada = false;
					for (Arbadhsolcomdoc arbadhsolcomdoc : listDocumentoHecho) {
						if (arbadhsolcomdoc.getXmfechasollocalizador() != null) {
							if (arbadhsolcomdoc.getXmnofile() != null
									&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(arbadhsolcomdoc.getXmnofile())
											.equalsIgnoreCase(Y41bConstantes.PDF)) {
								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(arbadhsolcomdoc.getXmfechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}

								if (diffMinutes > minutos) {

									error = true;
								} else {

									sinLocalizarPorTiempo = true;
								}
							} else {
								if (arbadhsolcomdoc.getXmestadodocumento() != null && arbadhsolcomdoc
										.getXmestadodocumento().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									firmado = true;
								} else if (arbadhsolcomdoc.getXmestadodocumento() != null && arbadhsolcomdoc
										.getXmestadodocumento().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)) {
									pendienteFirma = true;
								} else if (arbadhsolcomdoc.getXmestadodocumento() != null && arbadhsolcomdoc
										.getXmestadodocumento().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
									firmaDenegada = true;
								} else {
									localizado = true;
								}
							}
						} else {
							if (arbadhsolcomdoc.getXmestadodocumento() != null && arbadhsolcomdoc.getXmestadodocumento()
									.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								firmado = true;
							} else if (arbadhsolcomdoc.getXmestadodocumento() != null && arbadhsolcomdoc
									.getXmestadodocumento().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)) {
								pendienteFirma = true;
							} else if (arbadhsolcomdoc.getXmestadodocumento() != null && arbadhsolcomdoc
									.getXmestadodocumento().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
								firmaDenegada = true;
							}
						}
					}
					if (error) {
						registroBandeja.setAdhestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
					} else if (sinLocalizarPorTiempo) {
						registroBandeja.setAdhestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
					} else if (firmado) {
						registroBandeja.setAdhestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else if (firmaDenegada) {
						registroBandeja.setAdhestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
					} else if (pendienteFirma) {
						registroBandeja.setAdhestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					} else if (localizado) {
						registroBandeja.setAdhestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
					} else {
						registroBandeja.setAdhestado("");
					}

				}
			}

			// Consulta si hay documentos pendiente de firma
			DocumentoHecho documentoHechoAux = new DocumentoHecho();
			documentoHechoAux.setQ5hdcodigo(registroBandeja.getAdhid());
			documentoHechoAux.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.documentoHechoDao.findAllCount(documentoHechoAux);
			if (numDocumentosPendienteFirma > 0) {
				registroBandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}

		}
		return listaBandeja;
	}

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @return Long
	 */
	public Long findBandejaCount(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {
		return this.arbadhsolDao.findBandejaCount(arbadhsol, censoMonitor);
	}

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol guardarDatosValidacion(Arbadhsol arbadhsol) {
		arbadhsol = this.arbadhsolDao.guardarDatosValidacion(arbadhsol);
		arbadhsol.setDireccionCompleta(this.dameLineaDireccionCompleta(arbadhsol));
		return arbadhsol;
	}

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	public Arbadhsol findDatosValidacion(Arbadhsol arbadhsol) {
		return this.arbadhsolDao.findDatosValidacion(arbadhsol);
	}

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol guardarDatosComunicacion(Arbadhsol arbadhsol) throws Exception {
		return this.arbadhsolDao.guardarDatosComunicacion(arbadhsol);
	}

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	public Arbadhsol findDatosComunicacion(Arbadhsol arbadhsol) {

		// Recuperamos la solicitud
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		// Recuperamos datos de la comunicacion
		Arbadhsol arbadhsolAux = this.arbadhsolDao.findDatosComunicacion(arbadhsol);

		// Recuperamos datos del establacimiento validado
		Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		if (!Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())
				&& datosEstablecimientoValidado != null) {
			arbadhsol.setDireccionCompleta(this.dameLineaDireccionCompleta(datosEstablecimientoValidado));
			arbadhsol.setAdhesnom(datosEstablecimientoValidado.getAdhesnom());
			if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhescoem())) {
				arbadhsol.setAdhmaildestino(datosEstablecimientoValidado.getAdhescoem());
			} else {
				arbadhsol.setAdhmaildestino(arbadhsol.getAdhescoem());
			}
		} else {
			arbadhsol.setDireccionCompleta(this.dameLineaDireccionCompleta(arbadhsol));
			arbadhsol.setAdhmaildestino(arbadhsol.getAdhescoem());
		}

		// Si existe comunicacion, cargamos datos en el objeto
		if (arbadhsolAux != null) {
			arbadhsol.setAdhtipocom(arbadhsolAux.getAdhtipocom());
			arbadhsol.setAdhasunto(arbadhsolAux.getAdhasunto());
			arbadhsol.setAdhenvrem(arbadhsolAux.getAdhenvrem());
			arbadhsol.setAdhcodrem(arbadhsolAux.getAdhcodrem());
			arbadhsol.setAdhfechacom(arbadhsolAux.getAdhfechacom());
			arbadhsol.setAdhnumregs(arbadhsolAux.getAdhnumregs());
			arbadhsol.setAdhfecregs(arbadhsolAux.getAdhfecregs());
			arbadhsol.setAdhtexto(arbadhsolAux.getAdhtexto());
			arbadhsol.setAdhmailorigen(arbadhsolAux.getAdhmailorigen());
			arbadhsol.setAdhidmailorigen(arbadhsolAux.getAdhidmailorigen());
			arbadhsol.setAdhsede(arbadhsolAux.getAdhsede());
			arbadhsol.setAdhcommail(arbadhsolAux.getAdhcommail());
		}

		return arbadhsol;
	}

	/**
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idZipFile
	 *            String
	 * @return Arbadhsol
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol finalizarSolicitudAdhesion(Arbadhsol arbadhsol, CensoMonitor censoMonitor, String idZipFile)
			throws Exception {

		Arbadhsol arbadhsolBD = this.arbadhsolDao.find(arbadhsol);
		BigDecimal numAdh = arbadhsolBD.getAdhnrdi();
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			arbadhsolBD.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			arbadhsolBD.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			arbadhsolBD.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD);
		}

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(arbadhsol.getAdhid().toString());
		adjuntardocs.setTrpcodigo(arbadhsolBD.getTipoProcedimiento());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);
		if (Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(arbadhsol.getAdhestado())) {
			if (listadjuntardocs != null && listadjuntardocs.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
		}

		arbadhsolBD.setAdhlimitaciones(arbadhsol.getAdhlimitaciones());

		if (Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(arbadhsol.getAdhestado())) {
			arbadhsolBD.setAdhfecnrdi(Y41bUtils.hoy());
			if (arbadhsolBD.getAdhnrdi() == null && Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
				throw new Y41bUDAException("error.solicitud.adhesionException", true, new Exception());
			}
		} else if (Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
			// Si es un rechazo de un alta que ya tiene un numero de adhesion
			// reutilizamos el numero y lo borramos de la solicitud
			if (numAdh != null && Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
				arbadhsolBD.setAdhnrdi(null);
				this.arbnumadhreuDao.add(new Arbnumadhreu(numAdh));
			}
		}
		// Guardar datos de la respuesta
		this.arbadhsolDao.guardarDatosComunicacion(arbadhsol);
		// Actualizar el estado de la solicitud
		Arbadhsol datosComunicacion = this.arbadhsolDao.findDatosComunicacion(arbadhsol);
		if (Y41bConstantes.COMUNICACION.equals(datosComunicacion.getAdhtipocom())
				&& !Y41bConstantes.VALOR_SI.equals(arbadhsol.getAdhenvrem())) {
			arbadhsolBD.setAdhestado(arbadhsol.getAdhestado());
		} else {
			arbadhsolBD.setAdhestado(Y41bConstantes.ESTADO_ARBADHSOL_PENDIENTE);
		}
		this.arbadhsolDao.update(arbadhsolBD);
		arbadhsolBD.setAdhusumodif(censoMonitor.getMocodigo());

		// Guardar documentos de la respuesta
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(arbadhsol.getAdhid().toString());
		tramiteComun.setIdExpediente(arbadhsol.getAdhid().toString());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(arbadhsolBD.getTipoProcedimiento()));
		List<Arbadhsolcomdoc> listArbadhdocEliminados = this.arbadhsolcomdocDao
				.findAllDocumentosEliminados(tramiteComun, null);
		this.arbadhsolcomdocDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
		this.arbadhsolcomdocDao.addDocumentosHechoAdjuntarDocs(tramiteComun);
		List<Arbadhsolcomdoc> listDocumentoHecho = this.arbadhsolcomdocDao.findAllDocumentosRespuesta(tramiteComun,
				null);

		// Miramos si hay algun documento pendiente de firma o denegada
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);
		if (isDocPendienteFirma) {
			// No se puede tramitar el tramite si tiene algun documento
			// pendiente de firma
			throw new Y41bUDAException("error.documentos.nofirmados", true, null);
		} else {
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			bandejaFirma.setPcodigo(arbadhsolBD.getTipoProcedimiento());
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}

		// Guardar los datos del establecimiento en el censo si es aceptada
		String codigoEstablecimiento = null;
		if (Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(arbadhsol.getAdhestado())) {
			codigoEstablecimiento = this.adhesionEstablecimiento(arbadhsolBD);
		} else if (Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
			this.arbadhsolDao.removeDatosValidacion(arbadhsolBD);
		}

		// Guardar tramites
		Arbadhtram resolucion = this.crearResolucion(arbadhsol, censoMonitor);
		// Guardar los documentos en el tramite de comunicacion
		tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(resolucion.getTrid().toString());
		tramiteComun.setIdExpediente(arbadhsol.getAdhid().toString());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(arbadhsolBD.getTipoProcedimiento()));
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		// List<Arbadhdoc> listArbadhdocEliminados =
		this.tratarDocumentosTemporal(tramiteComun, Y41bConstantes.VALOR_NO);
		if (Y41bConstantes.NOTIFICACION.equals(datosComunicacion.getAdhtipocom())) {
			this.crearNotificacion(arbadhsol, resolucion, censoMonitor, idZipFile);
		} else {
			this.crearComunicacion(arbadhsol, resolucion, censoMonitor, idZipFile);
		}

		this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);

		this.eliminarDocumentosDokusi(listArbadhdocEliminados, tramiteComun.getTipoProcedimiento().getPcodigo());

		// Eliminamos los documentos de la tabla temporal
		this.arbadhsolcomdocDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);

		if (Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(arbadhsol.getAdhestado())
				&& null != codigoEstablecimiento) {
			// findall de todos los documentos pasandole el id del
			// expediente(solicitud)
			// solo con los de ciudadania (mirar campo origen en el docuemnto)
			Arbadhsolcomdoc documentoAux = new Arbadhsolcomdoc();
			documentoAux.setXmexcodigo(arbadhsolBD.getAdhid());
			// Marca identificativa del origen del documento: CO=Reclamante;
			// ES=Reclamado, L=Omic; C=Asociacin; A=Administracin; O-Otros;
			// RC: Representante reclamante; RE: Representante reclamado
			documentoAux.setXmorigen(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
			List<Arbadhsolcomdoc> listDocumentoHechoACopiar = this.arbadhsolcomdocService.findAllLike(documentoAux,
					null, false);

			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			// 2.Tipo Documental
			documento.setTipoDocumental("ejgv_d_resolucion_inscrip");
			documento.setTipoDocumento("Documento generico de Archivo");

			Procedure procedure = new Procedure();

			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ESTABLECIMIENTOS);

			for (Arbadhsolcomdoc documentoCopia : listDocumentoHechoACopiar) {
				if (!Y41bUtils.esNullOCadenaVacia(documentoCopia.getXmiddocumentum())) {
					documento.setIdDocumento(documentoCopia.getXmcodocumento().toString());
					documento.setNombre(Y41bUtils.getNameFile(documentoCopia.getXmnofile()));
					documento.setExtension(Y41bUtils.getExtensionFile(documentoCopia.getXmnofile()));
					documento.setDescripcion(documentoCopia.getXmtedesfile());

					// Hacemos uso del origen del documento que se esta copiando
					Documento documentoAux2 = new Documento();
					documentoAux2.setUser(user);
					documentoAux2.setProcedure(procedure);
					documentoAux2.setOidDokusi(documentoCopia.getXmiddocumentum());
					// Recuperar datos del documento de dokusi
					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documentoAux2);
					documento.setOrigenDocumento(docDokusi.getOrigenDocumento());
					// documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);

					documento.setProcedure(procedure);
					documento.setRegistryNumber(arbadhsolBD.getAdhsolregen());
					documento.setRegistryTimestamp(Y41bUtils.formatearDateToString(arbadhsolBD.getAdhfecregen(),
							Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
					documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);
					documento.setNumeroExpediente(codigoEstablecimiento);
					documento.setOidDokusi(documentoCopia.getXmiddocumentum());

					// hago shareDocumentContents para que duplique los
					// documentos en
					// docuki
					documento = y41bDokusiAdapterService.shareDocumentContents(documento);

					DocumentoHecho documentoInsertar = new DocumentoHecho();

					documentoInsertar.setQ5hdcodigo(codigoEstablecimiento);
					documentoInsertar.setQ5tramite(codigoEstablecimiento);
					documentoInsertar.setQ5nofile(documentoCopia.getXmnofile());
					documentoInsertar.setQ5codocumento(this.arbadhdocDao.getNewPK().toString());
					documentoInsertar.setQ5tedesfile(documentoCopia.getXmtedesfile());
					documentoInsertar.setQ5sizefile(documentoCopia.getXmsizefile());
					documentoInsertar.setQ5origen(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
					documentoInsertar.setQ5numregistroentrada(documentoCopia.getXmnumregistroentrada());
					documentoInsertar.setQ5FechaRegistroOrigen(new Date());
					documentoInsertar.setQ5numExpediente(documentoCopia.getXmexcodigo());
					documentoInsertar.setQ5iddocumentum(documento.getOidDokusi());
					documentoInsertar.setQ5fecha(new Date());

					// se lo inserto al q5 con los datos del establecimiento
					this.documentoHechoDao.add(documentoInsertar);

				}

			}

		}

		return arbadhsolBD;
	}

	/**
	 * 
	 * @param listDocumentoHecho
	 *            List<Arbadhdoc>
	 * @return tramite
	 */
	public boolean hayDocsPendienteFirma(List<Arbadhsolcomdoc> listDocumentoHecho) {

		// Miramos si hay algun documento pendiente de firma o denegada
		boolean isDocPendienteFirma = false;

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Arbadhsolcomdoc documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getXmestadodocumento())
						|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA
								.equals(documentoHecho.getXmestadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		}
		// Miramos si hay algun documento pendiente de firma
		return isDocPendienteFirma;
	}

	/**
	 * 
	 * @param tramiteComun
	 *            tramiteComun TramiteComun
	 * @param anyadirPlantilla
	 *            String
	 * @return List<Arbdoctemp>
	 */
	private List<Arbadhdoc> tratarDocumentosTemporal(TramiteComun tramiteComun, String anyadirPlantilla) {
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());
		tramiteComunAux.setIdExpediente(tramiteComun.getIdExpediente());
		tramiteComunAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

		List<Arbadhdoc> listArbdoctempEliminados = this.arbadhdocDao.findAllDocumentosEliminados(tramiteComunAux, null);

		this.arbadhdocDao.removeAdhDocTramite(tramiteComunAux);
		// INICIO Codigo sustituido
		// this.arbadhdocDao.removeDocumentosHechoAdjuntarDocs(tramiteComunAux);
		// FIN Codigo sustituido
		// INICIO Se sustituye por
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			try {
				this.documentoHechoDao.remove(documentoHechoAux);
			} catch (DataIntegrityViolationException dataIntegrityViolationException) {
				throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
			}
		}
		// FIN Se sustituye por
		this.arbadhdocDao.addDocsComAdjuntarDocs(tramiteComun);
		this.arbadhdocDao.addDocsComAdjuntarDocsTramite(tramiteComun);

		// borrar temporal
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);

		return listArbdoctempEliminados;

	}

	/**
	 * crearResolucion
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbadhtram
	 */
	private Arbadhtram crearResolucion(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {
		Arbadhsol arbadhsolBD = this.arbadhsolDao.find(arbadhsol);
		Arbadhtram tramite = new Arbadhtram();
		tramite.setTrid((this.arbadhtramDao.getNewPK()).toString());
		tramite.setTrexcodigo(arbadhsol.getAdhid());
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
		}
		tramite.setTrfecini(Y41bUtils.hoy());
		tramite.setTrfecfin(Y41bUtils.hoy());
		tramite.setCensoMonitor(null);
		tramite.setCensoMonitorEj(censoMonitor);
		tramite.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		tramite.setTrresofecha(Y41bUtils.hoy());
		tramite.setTrresotipo(arbadhsol.getAdhestado());
		this.arbadhtramDao.add(tramite);
		return tramite;
	}

	/**
	 * crearComunicacion
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param resolucion
	 *            Arbadhtram
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idZipFile
	 *            String
	 * @return Arbadhtram
	 * @throws Exception
	 *             excepcion
	 */
	private Arbadhtram crearComunicacion(Arbadhsol arbadhsol, Arbadhtram resolucion, CensoMonitor censoMonitor,
			String idZipFile) throws Exception {

		Arbadhsol arbadhsolBD = this.findDatosComunicacion(arbadhsol);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(this.arbadhtramDao.getNewPK().toString());
		tramiteComun.setIdExpediente(arbadhsolBD.getAdhid().toString());
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA);
			tramiteComun.setTipoProcedimiento(
					new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA, null, null, null));
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA);
			tramiteComun.setTipoProcedimiento(
					new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA, null, null, null));
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD);
			tramiteComun.setTipoProcedimiento(
					new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD, null, null, null));
		}

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		arbadhtram.setTrexcodigo(arbadhsol.getAdhid());
		arbadhtram.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbadhtram.setTrfecini(Y41bUtils.hoy());
		arbadhtram.setTrfecfin(Y41bUtils.hoy());
		arbadhtram.setCensoMonitor(null);
		arbadhtram.setCensoMonitorEj(censoMonitor);
		arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		arbadhtram.setTrtridrel(resolucion.getTrid());
		this.arbadhtramDao.add(arbadhtram);

		TramiteComunicacion tramite = new TramiteComunicacion();
		tramite.setIdTramite(tramiteComun.getIdTramite());
		tramite.setIdExpediente(arbadhsolBD.getAdhid().toString());

		// Copiamos el documento de la resolucion a la comunicacion
		this.arbadhdocDao.copiaArbAdhDocTramite(tramiteComun, resolucion.getTrid().toString());

		tramite.setFechaInicio(Y41bUtils.hoy());
		tramite.setFechaFin(Y41bUtils.hoy());
		tramite.setInstructorAsignado(null);
		tramite.setInstructorEjecucion(censoMonitor);
		tramite.setFechaComunicacion(arbadhsolBD.getAdhfechacom());
		tramite.setSede(arbadhsolBD.getAdhsede());
		tramite.setTipoComunicacion(arbadhsolBD.getAdhtipocom());
		tramite.setFechasalida(arbadhsolBD.getAdhfecregs());
		tramite.setNumregistrosalida(arbadhsolBD.getAdhnumregs());
		tramite.setAsuntoComunicacion(arbadhsolBD.getAdhasunto());
		tramite.setTextoComunicacion(arbadhsolBD.getAdhtexto());
		tramite.setIdmailorigen(arbadhsolBD.getAdhidmailorigen());
		tramite.setMailorigen(arbadhsolBD.getAdhmailorigen());
		tramite.setIdmaildestino(arbadhsolBD.getAdhidmaildestino());
		tramite.setMaildestino(arbadhsolBD.getAdhmaildestino());
		tramite.setEnvRemesaComunicacion(arbadhsolBD.getAdhenvrem());
		tramite.setIdRemesaComunicacion(arbadhsolBD.getAdhcodrem());
		tramite.setAnyadirPlantilla(Y41bConstantes.VALOR_SI);
		if (Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(resolucion.getTrresotipo())) {
			tramite.setDestinatario(String.valueOf(this.arbadhintervDao.volcarDatosValidacion(arbadhsol.getAdhid())));
		} else {
			tramite.setDestinatario(String.valueOf(this.arbadhintervDao.volcarDatosSolicitud(arbadhsol.getAdhid())));
		}
		if (Y41bConstantes.VALOR_SI.equals(arbadhsol.getAdhcommail())) {

			arbadhtram = this.arbadhtramService.addTramiteComunicacionMail0(tramite, tramiteComun,
					Y41bConstantes.MODO_POPUP_MODIFICACION, censoMonitor);
			this.crearCierre(arbadhsol, censoMonitor);
		} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO.equals(arbadhsolBD.getAdhsoltipnotif())) {
			arbadhtram = this.arbadhtramService.addTramiteComunicacion0(tramite, tramiteComun, null, true,
					Y41bConstantes.MODO_POPUP_MODIFICACION, true, false, idZipFile, censoMonitor);
			if (!Y41bConstantes.VALOR_SI.equals(arbadhsolBD.getAdhenvrem())) {
				// Obtener registro salida si no viene de pantalla
				/*
				 * Sobra porque se hace dentro de la comunicacin
				 * 
				 * if (arbadhsolBD.getAdhcommail().equals(Y41bConstantes.NO)) {
				 * if (arbadhsolBD.getAdhenvrem() == null ||
				 * arbadhsolBD.getAdhenvrem().equals( Y41bConstantes.NO)) { if
				 * (arbadhsolBD.getAdhnumregs() == null ||
				 * arbadhsolBD.getAdhnumregs().equals("")) {
				 * ArbadhtramServiceImpl v1 = new ArbadhtramServiceImpl();
				 * RegistroSalida registroSalida = v1
				 * .getRegistroSalida(tramiteComun,
				 * arbadhtram.getTruadidinterv(), false);
				 * arbadhtram.setTrnumregs(registroSalida .getRegistryNumber());
				 * arbadhtram.setTrfecregs(registroSalida .getRegistryDate()); }
				 * } }
				 */

				this.crearCierre(arbadhsol, censoMonitor);
			}
		} else {
			RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = this.arbadhtramService
					.createEJGVDocumentComunicacion0(tramite, tramiteComun, censoMonitor,
							arbadhsol.getTipoProcedimiento());
			tramite.setTextoPlano(respuestaEjgv.getTextoPlano());
			tramite.setEjgvDocument(respuestaEjgv.getEjgvDocument());
			arbadhtram = this.arbadhtramService.addTramiteComunicacion0(tramite, tramiteComun, null, true,
					Y41bConstantes.MODO_POPUP_MODIFICACION, false, true, idZipFile, censoMonitor);
			this.crearCierre(arbadhsol, censoMonitor);
		}
		arbadhsolBD.setAdhnumregs(arbadhtram.getTrnumregs());
		arbadhsolBD.setAdhfecregs(arbadhtram.getTrfecregs());
		this.arbadhsolDao.updateComRegistroSalidaPlatea(arbadhsolBD);
		return arbadhtram;
	}

	/**
	 * crearNotificacion
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param resolucion
	 *            Arbadhtram
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idZipFile
	 *            String
	 * @return Arbadhtram
	 * @throws Exception
	 *             excepcion
	 */
	private Arbadhtram crearNotificacion(Arbadhsol arbadhsol, Arbadhtram resolucion, CensoMonitor censoMonitor,
			String idZipFile) throws Exception {

		Arbadhsol arbadhsolBD = this.findDatosComunicacion(arbadhsol);

		TramiteNotificacion tramite = new TramiteNotificacion();
		tramite.setIdTramite(this.arbadhtramDao.getNewPK().toString());
		tramite.setIdExpediente(arbadhsol.getAdhid().toString());
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(tramite.getIdTramite());
		tramiteComun.setIdExpediente(arbadhsol.getAdhid().toString());
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA);
			tramiteComun.setTipoProcedimiento(
					new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA, null, null, null));
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA);
			tramiteComun.setTipoProcedimiento(
					new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA, null, null, null));
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD);
			tramiteComun.setTipoProcedimiento(
					new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD, null, null, null));
		}

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		arbadhtram.setTrexcodigo(arbadhsol.getAdhid());
		arbadhtram.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbadhtram.setTrfecini(Y41bUtils.hoy());
		arbadhtram.setTrfecfin(Y41bUtils.hoy());
		arbadhtram.setCensoMonitor(null);
		arbadhtram.setCensoMonitorEj(censoMonitor);
		arbadhtram.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		arbadhtram.setTrtridrel(resolucion.getTrid());
		this.arbadhtramDao.add(arbadhtram);

		// Copiamos el documento de la resolucion a la comunicacion
		this.arbadhdocDao.copiaArbAdhDocTramite(tramiteComun, resolucion.getTrid().toString());

		tramite.setFechaInicio(Y41bUtils.hoy());
		tramite.setFechaFin(Y41bUtils.hoy());
		tramite.setInstructorAsignado(null);
		tramite.setInstructorEjecucion(censoMonitor);
		tramite.setFechaComunicacion(arbadhsolBD.getAdhfechacom());
		tramite.setSede(arbadhsolBD.getAdhsede());
		tramite.setTipoNotificacion(arbadhsolBD.getAdhtipocom());
		tramite.setFechasalida(arbadhsolBD.getAdhfecregs());
		tramite.setNumregistrosalida(arbadhsolBD.getAdhnumregs());
		tramite.setTextoComunicacion(arbadhsolBD.getAdhtexto());
		tramite.setTipoNotificacionPlatea(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESOLUCION);
		tramite.setEnvRemesaNotificacion(arbadhsolBD.getAdhenvrem());
		tramite.setIdRemesaNotificacion(arbadhsolBD.getAdhcodrem());
		tramite.setAnyadirPlantilla(Y41bConstantes.VALOR_SI);
		if (Y41bConstantes.ESTADO_ARBADHSOL_ACEPTADA.equals(resolucion.getTrresotipo())) {
			tramite.setDestinatario(String.valueOf(this.arbadhintervDao.volcarDatosValidacion(arbadhsol.getAdhid())));
		} else {
			tramite.setDestinatario(String.valueOf(this.arbadhintervDao.volcarDatosSolicitud(arbadhsol.getAdhid())));
		}

		if (Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA.equals(arbadhsolBD.getAdhsoltipnotif())) {
			arbadhtram = this.arbadhtramService.addTramiteNotificacion0(tramite, tramiteComun, "", true,
					Y41bConstantes.MODO_POPUP_MODIFICACION, false, idZipFile, censoMonitor);
			/*
			 * Sobra porque se hace dentro de la comunicacin
			 * 
			 * // Obtener registro salida si no viene de pantalla if
			 * (arbadhsolBD.getAdhcommail().equals(Y41bConstantes.NO)) { if
			 * (arbadhsolBD.getAdhenvrem() == null ||
			 * arbadhsolBD.getAdhenvrem().equals(Y41bConstantes.NO)) { if
			 * (arbadhsolBD.getAdhnumregs() == null ||
			 * arbadhsolBD.getAdhnumregs().equals("")) { ArbadhtramServiceImpl
			 * v1 = new ArbadhtramServiceImpl(); RegistroSalida registroSalida =
			 * v1.getRegistroSalida( tramiteComun, arbadhsol.getTruaidinterv(),
			 * false); arbadhtram.setTrnumregs(registroSalida
			 * .getRegistryNumber()); arbadhtram.setTrfecregs(registroSalida
			 * .getRegistryDate()); } } }
			 */
		} else {
			RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = this.arbadhtramService
					.createEJGVDocumentNotificacion0(tramite, tramiteComun, censoMonitor,
							arbadhsol.getTipoProcedimiento());
			tramite.setTextoPlano(respuestaEjgv.getTextoPlano());
			tramite.setEjgvDocument(respuestaEjgv.getEjgvDocument());
			arbadhtram = this.arbadhtramService.addTramiteNotificacion0(tramite, tramiteComun, "", true,
					Y41bConstantes.MODO_POPUP_MODIFICACION, true, idZipFile, censoMonitor);
		}
		arbadhsolBD.setAdhnumregs(arbadhtram.getTrnumregs());
		arbadhsolBD.setAdhfecregs(arbadhtram.getTrfecregs());
		this.arbadhsolDao.updateComRegistroSalidaPlatea(arbadhsolBD);
		return arbadhtram;
	}

	/**
	 * crearCierre
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbadhtram
	 */
	private Arbadhtram crearCierre(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {

		Arbadhsol arbadhsolBD = this.arbadhsolDao.find(arbadhsol);

		Arbadhtram tramite = new Arbadhtram();
		tramite.setTrid((this.arbadhtramDao.getNewPK()).toString());
		tramite.setTrexcodigo(arbadhsol.getAdhid());
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_MOD);
		}
		tramite.setTrfecini(Y41bUtils.hoy());
		tramite.setTrfecfin(Y41bUtils.hoy());
		tramite.setCensoMonitor(null);
		tramite.setCensoMonitorEj(censoMonitor);
		tramite.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		tramite.setTrfeccierre(Y41bUtils.hoy());
		this.arbadhtramDao.add(tramite);

		return tramite;
	}

	/**
	 * crearApertura
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhtram
	 */
	private Arbadhtram crearApertura(Arbadhsol arbadhsol) {

		Arbadhsol arbadhsolBD = this.arbadhsolDao.find(arbadhsol);

		Arbadhtram tramite = new Arbadhtram();
		tramite.setTrid((this.arbadhtramDao.getNewPK()).toString());
		tramite.setTrexcodigo(arbadhsol.getAdhid());
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_APERTURA_ALTA);
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsolBD.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_APERTURA_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsolBD.getAdhtipo())) {
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_APERTURA_MOD);
		}
		tramite.setTrfecini(Y41bUtils.hoy());
		tramite.setTrfecfin(Y41bUtils.hoy());
		tramite.setCensoMonitor(null);
		tramite.setCensoMonitorEj(null);
		tramite.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		if (!Y41bUtils.esNullOCadenaVacia(arbadhsol.getAdhtexto())) {
			try {
				tramite.setTrobserves(Y41bUtils.stringToClob(arbadhsol.getAdhtexto()));
			} catch (Exception e) {
				// Error al convertir a clob. Registramos log y seguimos
				// adelante
				logger.info("Error al convertir String a Clob", e);
			}
		}
		this.arbadhtramDao.add(tramite);

		return tramite;
	}

	/**
	 * adhesionEstablecimiento
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 */
	private String adhesionEstablecimiento(Arbadhsol arbadhsol) {

		String resultado = null;
		Arbadhsol validacionEstablecimiento = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		if (validacionEstablecimiento != null) {
			Establecimiento establecimiento = new Establecimiento();
			if (Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhescodigo())) {
				establecimiento.setEscodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			} else {
				establecimiento.setEscodigo(validacionEstablecimiento.getAdhescodigo());
				establecimiento = this.establecimientoDao.find(establecimiento);
			}
			resultado = establecimiento.getEscodigo();
			establecimiento.setEsfemod(Y41bUtils.parseDateToString(Y41bUtils.hoy(), Y41bConstantes.CASTELLANO));
			establecimiento.setCensoMonitor(new CensoMonitor(arbadhsol.getAdhusumodif(), null));
			establecimiento.setEsnombre(validacionEstablecimiento.getAdhesnom());
			establecimiento.setEsnoco(validacionEstablecimiento.getAdhesnoco());
			establecimiento.setEscoidco(validacionEstablecimiento.getAdhescoidco());
			establecimiento.setEsteurl(validacionEstablecimiento.getAdhesurl());
			establecimiento.setEscooe(validacionEstablecimiento.getAdhorgemp());
			establecimiento.setEsnrtel(validacionEstablecimiento.getAdhesnrtel());
			establecimiento.setEsnrtel2(validacionEstablecimiento.getAdhesnrtel2());
			establecimiento.setEscoem(validacionEstablecimiento.getAdhescoem());
			establecimiento.setEsnopeco(validacionEstablecimiento.getAdhesnopeco());
			establecimiento.setEsnifrep(validacionEstablecimiento.getAdhesnifrep());
			establecimiento.setEsnorep(validacionEstablecimiento.getAdhesnorep());
			establecimiento.setEsnoraProvinciaId(validacionEstablecimiento.getAdhesprovin());
			establecimiento.setEsnombreProvincia(this.dameProvincia(validacionEstablecimiento));
			establecimiento.setEsnoraMunicipioId(validacionEstablecimiento.getAdhesmunici());
			establecimiento.setEsnombreMunicipio(this.dameMunicipio(validacionEstablecimiento));
			establecimiento.setEsnoraLocalidadId(validacionEstablecimiento.getAdheslocali());
			establecimiento.setEsnombreLocalidad(this.dameLocalidad(validacionEstablecimiento));
			establecimiento.setEsnoraCalleId(validacionEstablecimiento.getAdhescalle());
			establecimiento.setEsnombreCalle(this.dameCalle(validacionEstablecimiento));
			establecimiento.setEsnoraPortalId(validacionEstablecimiento.getAdhesportal());
			T17Portal t17portal = this.damePortal(validacionEstablecimiento);
			establecimiento.setEsnombrePortal(t17portal != null ? String.valueOf(t17portal.getNumero()) : "");
			establecimiento.setEsnombreCp(validacionEstablecimiento.getAdhesnombrecp());
			establecimiento.setEsnombrePiso(validacionEstablecimiento.getAdhespiso());
			establecimiento.setEsextranjero(validacionEstablecimiento.getAdhesextranjero());
			establecimiento.setEsnoraPaisId(validacionEstablecimiento.getAdhespaisid());
			establecimiento.setEsnoraPaisNombre(this.damePais(validacionEstablecimiento));
			establecimiento.setEsdireccion_nocapv(validacionEstablecimiento.getAdhesdirecnocapv());
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
				establecimiento.setEsintiar(arbadhsol.getAdhesintiar());
				establecimiento.setEsfeadar(arbadhsol.getAdhfecalta());
				establecimiento.setEsinadar(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
				establecimiento.setEsintiar(arbadhsol.getAdhesintiar());
				establecimiento.setEsinadar(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())) {
				establecimiento.setEsinadar(Y41bConstantes.VALOR_NO);
			} else if (Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				establecimiento.setEsinadar(Y41bConstantes.VALOR_NO);
				establecimiento.setEsfeba(Y41bUtils.hoy());
			}
			if (Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhescodigo())) {
				establecimiento.setEscolo(Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdheslocali()) ? "0"
						: validacionEstablecimiento.getAdheslocali());
				establecimiento.setEsnif(validacionEstablecimiento.getAdhnif());
				this.establecimientoDao.add(establecimiento);
				// Una vez creado el establecimiento, actualizamos el escodigo
				// de la validacion
				validacionEstablecimiento.setAdhescodigo(establecimiento.getEscodigo());
				this.arbadhsolDao.guardarDatosValidacion(validacionEstablecimiento);
			} else {
				this.establecimientoDao.update(establecimiento);
			}

			// Sector
			if (!Y41bUtils.esNullOCadenaVacia(validacionEstablecimiento.getAdhsectorid())) {
				Sector sector = new Sector();
				sector.setSecodigo(validacionEstablecimiento.getAdhsectorid());
				Actividad actividad = new Actividad();
				String avCodigo = "";
				if (sector.getSecodigo().length() >= Y41bConstantes.NUM_3) {
					avCodigo = sector.getSecodigo().substring(0, Y41bConstantes.NUM_3);
				}
				actividad.setAvcodigo(avCodigo);
				EstablecimSector establecimSector = new EstablecimSector(null,
						Y41bConstantes.ACTIVIDAD_SECTOR_INDICADOR, establecimiento, actividad, sector);
				EstablecimSector establecSectorAux = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);
				if (Y41bUtils.isFilled(establecSectorAux.getEacodigo())) {
					this.establecimSectorDao.update(establecimSector);
				} else {
					establecimSector.setEacodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					this.establecimSectorDao.add(establecimSector);
				}
			}
			// Arbitraje
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(establecimiento);
			List<EstablecimArbitra> lestablecimArbitra = this.establecimArbitraDao.findAll(establecimArbitra, null);
			if (lestablecimArbitra != null && lestablecimArbitra.size() > 0) {
				establecimArbitra = lestablecimArbitra.get(0);
			}
			establecimArbitra.setAhcoja(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
			establecimArbitra.setAhtelimi(arbadhsol.getAdhlimitaciones());
			establecimArbitra.setAhmedia(arbadhsol.getAdhesmedia());
			establecimArbitra.setAhindef(arbadhsol.getAdhindef());
			if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())) {
				establecimArbitra.setAhfere(arbadhsol.getAdhfecalta());
				establecimArbitra.setAhfeba(Y41bUtils.addDays(arbadhsol.getAdhfecalta(), Y41bConstantes.NUM_30));
			} else if (Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
				establecimArbitra.setAhfere(Y41bUtils.hoy());
				establecimArbitra.setAhfeba(Y41bUtils.addDays(Y41bUtils.hoy(), Y41bConstantes.NUM_30));
			} else {
				if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
					establecimArbitra.setAhnrdi(Integer.valueOf(arbadhsol.getAdhnrdi().toString()));
					establecimArbitra.setAhfecodi(arbadhsol.getAdhfecnrdi());
				}
				if (arbadhsol.getAdhfecfin() != null && Y41bConstantes.VALOR_NO.equals(arbadhsol.getAdhindef())) {
					establecimArbitra.setAhfere(arbadhsol.getAdhfecfin());
					establecimArbitra.setAhfeba(Y41bUtils.addDays(arbadhsol.getAdhfecfin(), Y41bConstantes.NUM_30));
				} else {
					establecimArbitra.setAhfere(null);
					establecimArbitra.setAhfeba(null);
				}
			}

			if (lestablecimArbitra != null && lestablecimArbitra.size() > 0) {
				this.establecimArbitraDao.update(establecimArbitra);
			} else {
				this.establecimArbitraDao.add(establecimArbitra);
			}
		}
		return resultado;
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            the tipodocumento
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		Arbadhsol arbadhsol = new Arbadhsol(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			arbadhsol.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
			// Obtener numero adhesion
			if (arbadhsol.getAdhnrdi() == null) {
				arbadhsol.setAdhnrdi(new BigDecimal(this.arbnumadhreuDao.obtenerNumeroAdhesion()[0]));
				// Clob
				Arbadhsol arbadhsolAux = (Arbadhsol) this.arbadhsolDao.find(arbadhsol);
				arbadhsol.setAdhlimitaciones(arbadhsolAux.getAdhlimitaciones());
				this.arbadhsolDao.update(arbadhsol);
			}
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			arbadhsol.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA);
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			arbadhsol.setTipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD);
		}
		// Previamente hemos guardado el tramite y vaciado adjuntarDocs
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(arbadhsol.getTipoProcedimiento()));

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
		String plantilla = "";
		String nombreDocumento = "";

		adjuntardocs.setThcodocumento(this.arbadhdocDao.getNewPK().toString());

		plantilla = this.findPlantilla(plantillaTramite, arbadhsol);
		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
		nombreDocumento = new StringBuffer(plantillaTramite.getPtnombre()).append(".rtf").toString();

		String codigoExpediente = arbadhsol.getNumExpediente();
		nombreDocumento = codigoExpediente.concat("-").concat(nombreDocumento);

		adjuntardocs.setThcodocumento(this.arbadhdocDao.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");
		adjuntardocs.setThnofile(nombreDocumento);
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTipoProcedimiento(new TipoProcedimiento(arbadhsol.getTipoProcedimiento()));
		adjuntardocs.setThfecha(new Date());

		if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
			adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
			adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
		}
		adjuntardocs.setTrpcodigo(arbadhsol.getTipoProcedimiento());
		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantilla(PlantillaTramite plantillaTramite, Arbadhsol arbadhsol) throws Exception {

		// Obtener la plantilla del tramite
		PlantillaTramite plantillaTramite2 = this.plantillaTramiteDao.find(plantillaTramite);

		// Obtener los datos de la sancion
		PlantillaTramiteARBDetalle plantillaTramiteARBDetalle = new PlantillaTramiteARBDetalle();
		plantillaTramiteARBDetalle.setSacodigo(arbadhsol.getAdhid().toString());

		plantillaTramiteARBDetalle.setArbadhsol(arbadhsol);

		String ficheroGenerado = "";
		if (plantillaTramite2.getPtplantilla() != null) {
			plantillaTramiteARBDetalle = this.completeInfoplantillaAdhesionDetalle(plantillaTramiteARBDetalle);

			// Transformar el documento en castellano
			String plantilla = Y41bUtils.blobToString(plantillaTramite2.getPtplantilla());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

			rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_ARB_CASTELLANO);

			ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
					plantillaTramiteARBDetalle, plantilla);
		}

		return ficheroGenerado;
	}

	/**
	 * Complete information of the object plantillaTramiteARBDetalle.
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            PlantillaTramiteARBDetalle
	 * @return PlantillaTramiteARBDetalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private PlantillaTramiteARBDetalle completeInfoplantillaAdhesionDetalle(
			PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) throws ParseException {

		try {
			// Expediente
			// Incidencia 74262 - Con Caracter general todos los impresos deben
			// incluir el cdigo de procedimiento en el cdigo de expediente
			plantillaTramiteARBDetalle.setNumExpediente(plantillaTramiteARBDetalle.getArbadhsol().getNumExpediente());
			plantillaTramiteARBDetalle
					.setNumExpedienteCompleto(plantillaTramiteARBDetalle.getArbadhsol().getNumExpediente());

			if (plantillaTramiteARBDetalle.getArbadhsol().getAdhnrdi() != null) {
				plantillaTramiteARBDetalle
						.setNumAdhesion(plantillaTramiteARBDetalle.getArbadhsol().getAdhnrdi().toString());
			}

			// Fecha
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				plantillaTramiteARBDetalle.setFechaTexto(Y41bUtils.formatearDateToStringEuskera(new Date(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			} else {
				plantillaTramiteARBDetalle.setFechaTexto(Y41bUtils.formatearDateToString(new Date(),
						Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			}
			plantillaTramiteARBDetalle.setFechaTextoCas(Y41bUtils.formatearDateToString(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaTextoEus(Y41bUtils.formatearDateToStringEuskera(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			plantillaTramiteARBDetalle.setFecha(Y41bUtils.parseDateToString(new Date(), idioma));
			plantillaTramiteARBDetalle.setFechaCas(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaEus(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.EUSKERA));

			// Pie y organismo
			this.rellenaJuntaArbitralConsumoEuskadi(plantillaTramiteARBDetalle);

			// 0154940: Actualizacin de datos explcitos en plantillas a uso de
			// campos
			// combinados
			this.rellenaCentralPieOficina(plantillaTramiteARBDetalle);
			// 0154940

			// Coordinador (Secretario Junta Arbitral)
			this.rellenaCoordinador(plantillaTramiteARBDetalle);

			// SI NOTIFICO A SEDE
			// Destinatario
			if (plantillaTramiteARBDetalle.getArbadhsol().getAdhsede() != null) {
				if (plantillaTramiteARBDetalle.getArbadhsol().getAdhsede().equals(Y41bConstantes.SI)) {
					this.rellenaSedeDestinatario(plantillaTramiteARBDetalle);
				} else {
					this.rellenaDestinatario(plantillaTramiteARBDetalle);
				}
			} else {
				this.rellenaDestinatario(plantillaTramiteARBDetalle);
			}
			// Fecha solicitud
			plantillaTramiteARBDetalle.setFechaAdhSolCas(
					Y41bUtils.formatearDateToString(plantillaTramiteARBDetalle.getArbadhsol().getAdhfecalta(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteARBDetalle.setFechaAdhSolEus(
					Y41bUtils.formatearDateToStringEuskera(plantillaTramiteARBDetalle.getArbadhsol().getAdhfecalta(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.EUSKERA));
			if (Y41bConstantes.ADH_TIPO_BAJA.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhtipo())
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO
							.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhtipo())) {
				Date fechaBajaEfectiva = Y41bUtils.addDays(plantillaTramiteARBDetalle.getArbadhsol().getAdhfecalta(),
						Y41bConstantes.NUM_30);
				plantillaTramiteARBDetalle.setFechaAdhBajaCas(Y41bUtils.formatearDateToString(fechaBajaEfectiva,
						Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteARBDetalle.setFechaAdhBajaEus(Y41bUtils.formatearDateToStringEuskera(fechaBajaEfectiva,
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			} else {
				if (plantillaTramiteARBDetalle.getArbadhsol().getAdhfecfin() != null
						&& Y41bConstantes.VALOR_NO.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhindef())) {
					Date fechaBajaEfectiva = Y41bUtils.addDays(plantillaTramiteARBDetalle.getArbadhsol().getAdhfecfin(),
							Y41bConstantes.NUM_30);
					plantillaTramiteARBDetalle.setFechaAdhBajaCas(Y41bUtils.formatearDateToString(fechaBajaEfectiva,
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle.setFechaAdhBajaEus(Y41bUtils.formatearDateToStringEuskera(
							fechaBajaEfectiva, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
				}
			}

			// Alta
			if ("E".equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhesintiar())) {
				plantillaTramiteARBDetalle.setEquidadDerechoCas(this.appMessageSource
						.getMessage("plantilla.adhesion.equidad", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setEquidadDerechoEus(this.appMessageSource
						.getMessage("plantilla.adhesion.equidad", null, new Locale(Y41bConstantes.EUSKERA)));
			} else if ("D".equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhesintiar())) {
				plantillaTramiteARBDetalle.setEquidadDerechoCas(this.appMessageSource
						.getMessage("plantilla.adhesion.derecho", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setEquidadDerechoEus(this.appMessageSource
						.getMessage("plantilla.adhesion.derecho", null, new Locale(Y41bConstantes.EUSKERA)));
			} else {
				plantillaTramiteARBDetalle.setEquidadDerechoCas("");
				plantillaTramiteARBDetalle.setEquidadDerechoEus("");
			}
			// Mediacion
			if (Y41bConstantes.VALOR_SI.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhesmedia())) {
				plantillaTramiteARBDetalle.setMediacionCas(this.appMessageSource
						.getMessage("plantilla.adhesion.mediacionSi", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setMediacionEus(this.appMessageSource
						.getMessage("plantilla.adhesion.mediacionSi", null, new Locale(Y41bConstantes.EUSKERA)));
			} else if (Y41bConstantes.VALOR_NO.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhesmedia())) {
				plantillaTramiteARBDetalle.setMediacionCas(this.appMessageSource
						.getMessage("plantilla.adhesion.mediacionNo", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setMediacionEus(this.appMessageSource
						.getMessage("plantilla.adhesion.mediacionNo", null, new Locale(Y41bConstantes.EUSKERA)));
			} else {
				plantillaTramiteARBDetalle.setMediacionCas("");
				plantillaTramiteARBDetalle.setMediacionEus("");
			}
			// Indefinido
			if (Y41bConstantes.VALOR_SI.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhindef())) {
				plantillaTramiteARBDetalle.setIndefinidoCas(this.appMessageSource
						.getMessage("plantilla.adhesion.indefinidoSi", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setIndefinidoEus(this.appMessageSource
						.getMessage("plantilla.adhesion.indefinidoSi", null, new Locale(Y41bConstantes.EUSKERA)));
			} else if (Y41bConstantes.VALOR_NO.equals(plantillaTramiteARBDetalle.getArbadhsol().getAdhindef())) {
				plantillaTramiteARBDetalle.setIndefinidoCas(this.appMessageSource
						.getMessage("plantilla.adhesion.indefinidoNo", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteARBDetalle.setIndefinidoEus(this.appMessageSource
						.getMessage("plantilla.adhesion.indefinidoNo", null, new Locale(Y41bConstantes.EUSKERA)));
			} else {
				plantillaTramiteARBDetalle.setIndefinidoCas("");
				plantillaTramiteARBDetalle.setIndefinidoEus("");
			}

			return plantillaTramiteARBDetalle;
		} catch (ParseException e) {
			throw new Y41bUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaJuntaArbitralConsumoEuskadi(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		// Rellenamos el pie dependiendo de la oficiona de la provincia
		// correspondiente
		Organismo organismo = new Organismo();
		organismo.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		List<Organismo> listaoficinaProvincia = this.organismoDao.findAll(organismo, null);
		if (listaoficinaProvincia != null) {
			organismo = listaoficinaProvincia.get(0);
			if (organismo != null && organismo.getEntidadId() != null) {
				plantillaTramiteARBDetalle.setDireccionOficina(organismo.getAdressCallePortal());
				plantillaTramiteARBDetalle.setCpOficina(organismo.getAdressCP());
				plantillaTramiteARBDetalle.setTelefonoOficina(organismo.getTelefono());
				plantillaTramiteARBDetalle.setFaxOficina(organismo.getFax());
				/* cogemos solo el municipio */
				plantillaTramiteARBDetalle.setLocalidadOficina(organismo.getNombreMunicipio());

				plantillaTramiteARBDetalle.setNombreOficina(organismo.getNombreEs());
				plantillaTramiteARBDetalle.setLugarOficina(organismo.getNombreLocalidad());
				plantillaTramiteARBDetalle
						.setDireccionOficina(organismo.getNombreCalle() + " " + organismo.getNombrePortal());
				plantillaTramiteARBDetalle.setCpOficina(organismo.getNombreCp());
				plantillaTramiteARBDetalle.setProvinciaOficina(organismo.getNombreProvincia());
				plantillaTramiteARBDetalle.setTelefonoOficina(organismo.getTelefono());
				plantillaTramiteARBDetalle.setFaxOficina(organismo.getFax());

				// Creamos el campo pie pagina linea1
				StringBuffer piepagina_linea1 = new StringBuffer();

				piepagina_linea1.append(plantillaTramiteARBDetalle.getDireccionOficina()).append(" - ")
						.append(plantillaTramiteARBDetalle.getCpOficina()).append(" / ").append(" Tl. ")
						.append(plantillaTramiteARBDetalle.getTelefonoOficina());

				plantillaTramiteARBDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

				// Creamos el campo pie pagina linea2
				StringBuffer piepagina_linea2 = new StringBuffer();

				piepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
						.append(organismo.getUrl());

				plantillaTramiteARBDetalle.setPiePaginaLinea2(piepagina_linea2.toString());
			}
		}

	}

	// 0154940: Actualizacin de datos explcitos en plantillas a uso de campos
	// combinados
	/**
	 * Rellena el pie de la oficina central .
	 * 
	 * @param solarb
	 *            the solarb
	 * @param PlantillaTramiteARBDetalle
	 *            the plantilla tramite arb detalle
	 */

	private void rellenaCentralPieOficina(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {

		Organismo organismo = new Organismo();
		// organismo.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		organismo.setCodOrg(Y41bConstantes.OFICINA_CENTRAL);
		organismo = this.organismoDao.findOrganismo(organismo);

		if (organismo != null && organismo.getEntidadId() != null) {
			// Creamos el campo central pie pagina linea1
			StringBuffer centralpiepagina_linea1 = new StringBuffer();

			centralpiepagina_linea1.append(organismo.getNombreCalle()).append(" ").append(organismo.getNombrePortal())
					.append(" - ").append(organismo.getNombreCp()).append(" / ").append(" Tl. ")
					.append(organismo.getTelefono());

			plantillaTramiteARBDetalle.setCentralPiePaginaLinea1(centralpiepagina_linea1.toString());

			// Creamos el campo central pie pagina linea2
			StringBuffer centralpiepagina_linea2 = new StringBuffer();

			centralpiepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
					.append(organismo.getUrl());

			plantillaTramiteARBDetalle.setCentralPiePaginaLinea2(centralpiepagina_linea2.toString());

			plantillaTramiteARBDetalle.setCentralMail(organismo.getEmail());

			plantillaTramiteARBDetalle.setCentralTelefono(organismo.getTelefono());
		}

	}

	// 0154940

	/**
	 * Rellena destinatario.
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaCoordinador(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) {
		// Coordinador
		CensoMonitor coordinador = this.censoMonitorDao.findCoordinadorArbitraje();
		if (coordinador == null || (coordinador != null && coordinador.getMonombre() == null)) {
			throw new Y41bUDAException("error.tramite.nocoordinador", true, new Exception());
		} else {
			plantillaTramiteARBDetalle
					.setCoordinador((coordinador.getMonombre() == null) ? "" : coordinador.getMonombre());
		}

		// recuperar texto de properties
		plantillaTramiteARBDetalle.setTextoPuestoCoordinadorCas(this.appMessageSource
				.getMessage("plantilla.puestosecretarioJJAA", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteARBDetalle.setTextoPuestoCoordinadorEus(this.appMessageSource
				.getMessage("plantilla.puestosecretarioJJAA", null, new Locale(Y41bConstantes.EUSKERA)));
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaSedeDestinatario(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) throws ParseException {
		Establecimiento establecimientoAux = new Establecimiento();
		Establecimiento establecimientoSede = new Establecimiento();

		Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao
				.findDatosValidacion(plantillaTramiteARBDetalle.getArbadhsol());
		// Si no se han validado los datos, generamos la plantilla con los datos
		// de la solicitud
		if (datosEstablecimientoValidado == null) {
			datosEstablecimientoValidado = plantillaTramiteARBDetalle.getArbadhsol();
		} else {
			// Datos de arbitraje
			if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhescodigo())) {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra
						.setEstablecimiento(new Establecimiento(datosEstablecimientoValidado.getAdhescodigo()));
				List<EstablecimArbitra> lestablecimArbitra = this.establecimArbitraDao.findAll(establecimArbitra, null);
				if (lestablecimArbitra != null && lestablecimArbitra.size() > 0) {
					establecimArbitra = lestablecimArbitra.get(0);
					plantillaTramiteARBDetalle
							.setFechaAdhesionCas(Y41bUtils.formatearDateToString(establecimArbitra.getAhfecodi(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle
							.setFechaAdhesionEus(Y41bUtils.formatearDateToStringEuskera(establecimArbitra.getAhfecodi(),
									Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
					plantillaTramiteARBDetalle
							.setFechaAdhBajaCas(Y41bUtils.formatearDateToString(establecimArbitra.getAhfeba(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle
							.setFechaAdhBajaEus(Y41bUtils.formatearDateToStringEuskera(establecimArbitra.getAhfeba(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.EUSKERA));
				}
			}
		}
		plantillaTramiteARBDetalle.setNombreRepresentante(datosEstablecimientoValidado.getAdhesnorep());
		plantillaTramiteARBDetalle.setCifRepresentante(datosEstablecimientoValidado.getAdhesnifrep());

		establecimientoAux.setEsnif(datosEstablecimientoValidado.getAdhnif());
		establecimientoSede = this.establecimientoService.obtenerEstablecimientoSede(establecimientoAux);

		if (establecimientoSede != null) {
			Sede sedeAux = new Sede();
			sedeAux.setEscodigo(establecimientoSede.getEscodigo());
			sedeAux.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			Sede sede = this.establecimientoService.findEstablecimientoSede(sedeAux);

			plantillaTramiteARBDetalle.setCifDestinatario(datosEstablecimientoValidado.getAdhnif());

			plantillaTramiteARBDetalle.setNombreDestinatario(datosEstablecimientoValidado.getAdhesnom());

			plantillaTramiteARBDetalle.setDirDestinatario(this.sedeService.dameLineaDireccion(sede));

			if (sede.getNombreCp() != null) {
				plantillaTramiteARBDetalle.setCpDestinatario(sede.getNombreCp());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteARBDetalle.setCpDestinatario(this.sedeService.dameCodigoPostal(sede));
			}

			plantillaTramiteARBDetalle.setProvDestinatario(this.sedeService.dameProvincia(sede));
			plantillaTramiteARBDetalle.setMunDestinatario(this.sedeService.dameMunicipio(sede));
			plantillaTramiteARBDetalle.setLocDestinatario(this.sedeService.dameLocalidad(sede));

		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param plantillaTramiteARBDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaDestinatario(PlantillaTramiteARBDetalle plantillaTramiteARBDetalle) throws ParseException {

		Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao
				.findDatosValidacion(plantillaTramiteARBDetalle.getArbadhsol());
		// Si no se han validado los datos, generamos la plantilla con los datos
		// de la solicitud
		if (datosEstablecimientoValidado == null) {
			datosEstablecimientoValidado = plantillaTramiteARBDetalle.getArbadhsol();
		} else {
			// Datos de arbitraje
			if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhescodigo())) {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra
						.setEstablecimiento(new Establecimiento(datosEstablecimientoValidado.getAdhescodigo()));
				List<EstablecimArbitra> lestablecimArbitra = this.establecimArbitraDao.findAll(establecimArbitra, null);
				if (lestablecimArbitra != null && lestablecimArbitra.size() > 0) {
					establecimArbitra = lestablecimArbitra.get(0);
					plantillaTramiteARBDetalle
							.setFechaAdhesionCas(Y41bUtils.formatearDateToString(establecimArbitra.getAhfecodi(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle
							.setFechaAdhesionEus(Y41bUtils.formatearDateToStringEuskera(establecimArbitra.getAhfecodi(),
									Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
					plantillaTramiteARBDetalle
							.setFechaAdhBajaCas(Y41bUtils.formatearDateToString(establecimArbitra.getAhfeba(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteARBDetalle
							.setFechaAdhBajaCas(Y41bUtils.formatearDateToStringEuskera(establecimArbitra.getAhfeba(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.EUSKERA));
				}
			}
		}
		plantillaTramiteARBDetalle.setCifDestinatario(datosEstablecimientoValidado.getAdhnif());

		plantillaTramiteARBDetalle.setCpDestinatario(datosEstablecimientoValidado.getAdhesnombrecp());

		plantillaTramiteARBDetalle.setNombreDestinatario(datosEstablecimientoValidado.getAdhesnom());

		plantillaTramiteARBDetalle.setDirDestinatario(this.dameLineaDireccion(datosEstablecimientoValidado));

		plantillaTramiteARBDetalle.setProvDestinatario(this.dameProvincia(datosEstablecimientoValidado));

		plantillaTramiteARBDetalle.setMunDestinatario(this.dameMunicipio(datosEstablecimientoValidado));

		plantillaTramiteARBDetalle.setLocDestinatario(this.dameLocalidad(datosEstablecimientoValidado));
		plantillaTramiteARBDetalle.setNombreRepresentante(datosEstablecimientoValidado.getAdhesnorep());
		plantillaTramiteARBDetalle.setCifRepresentante(datosEstablecimientoValidado.getAdhesnifrep());
	}

	/**
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private String dameProvincia(Arbadhsol datosEstablecimientoValidado) {
		String provincia = "";
		/* localidad */
		if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesprovin())) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(datosEstablecimientoValidado.getAdhesprovin(), null, null)));
			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}
		}
		return provincia;
	}

	/**
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private String dameMunicipio(Arbadhsol datosEstablecimientoValidado) {
		String municipio = "";
		if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesmunici())
				&& !Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesprovin())) {
			T17Municipio municipiodVO = (this.t17MunicipioDao
					.find(new T17Municipio(datosEstablecimientoValidado.getAdhesmunici(),
							datosEstablecimientoValidado.getAdhesprovin(), null, null)));

			if (municipiodVO != null) {
				municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
			}
		}
		return municipio;
	}

	/**
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private String dameLocalidad(Arbadhsol datosEstablecimientoValidado) {
		String localidad = "";
		if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdheslocali())
				&& !Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesmunici())
				&& !Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesprovin())) {
			T17Localidad localidadVO = this.t17LocalidadDao.find(new T17Localidad(
					datosEstablecimientoValidado.getAdheslocali(), null, datosEstablecimientoValidado.getAdhesmunici(),
					datosEstablecimientoValidado.getAdhesprovin(), null));
			if (localidadVO != null) {
				localidad = localidadVO.getDsO() == null ? "" : localidadVO.getDsO();
			}
		}
		return localidad;
	}

	/**
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private String damePais(Arbadhsol datosEstablecimientoValidado) {
		String pais = "";
		if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespaisid())) {
			T17Pais paisVO = this.t17PaisDao.find(new T17Pais(datosEstablecimientoValidado.getAdhespaisid(), null));
			if (paisVO != null) {
				pais = paisVO.getDsO() == null ? "" : paisVO.getDsO();
			}
		}
		return pais;
	}

	/**
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private String dameCalle(Arbadhsol datosEstablecimientoValidado) {
		String calle = "";
		try {
			if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhescalle())) {
				calle = this.t17CalleDao
						.findCalleConTipoVia(
								new T17Calle(Long.parseLong(datosEstablecimientoValidado.getAdhescalle()), null))
						.getDsO();
			}
		} catch (Exception e) {

		}
		return calle;
	}

	/**
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private T17Portal damePortal(Arbadhsol datosEstablecimientoValidado) {
		T17Portal t17portal = new T17Portal();
		if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesportal())
				&& !Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhescalle())) {
			t17portal.setId(Long.parseLong(datosEstablecimientoValidado.getAdhesportal()));
			t17portal.setCalleId(Long.parseLong(datosEstablecimientoValidado.getAdhescalle()));
			List<T17Portal> list = this.t17PortalService.findAll(t17portal, null);
			if (list != null && list.size() > 0) {
				t17portal = list.get(0);
			} else {
				t17portal = null;
			}
		} else {
			t17portal = null;
		}
		return t17portal;
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return the string
	 */
	public String dameLineaDireccion(Arbadhsol datosEstablecimientoValidado) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhesdirecnocapv())) {
			direccion.append(datosEstablecimientoValidado.getAdhesdirecnocapv());
			if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespaisid())
					&& !Y41bConstantes.COD_PAIS_ESTADO.equals(datosEstablecimientoValidado.getAdhespaisid())) {
				direccion.append(" ").append(this.damePais(datosEstablecimientoValidado));
			}
		} else if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhescalle())) {
			String calle = this.dameCalle(datosEstablecimientoValidado);

			if (Y41bUtils.esNullOCadenaVacia(calle)) {
				if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespiso())) {
					direccion.append(datosEstablecimientoValidado.getAdhespiso());
				}
			} else {
				if (datosEstablecimientoValidado.getAdhesportal() != null) {
					t17portal = this.damePortal(datosEstablecimientoValidado);
					if (t17portal != null) {
						if (t17portal != null && t17portal.getPortal() != null) {
							direccion.append(" ").append(Y41bUtils.componerDireccion(calle, t17portal.getBloque(),
									t17portal.getPortal(), 0, null, datosEstablecimientoValidado.getAdhespiso(), null));
						} else if (t17portal != null && t17portal.getNumero() != 0) {
							direccion.append(calle);
							direccion.append(" ");
							direccion.append(t17portal.getNumero());
							if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespiso())) {
								direccion.append(" ").append(datosEstablecimientoValidado.getAdhespiso());
							}
						} else {
							direccion.append(calle);
							if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespiso())) {
								direccion.append(" ").append(datosEstablecimientoValidado.getAdhespiso());
							}
						}
					} else {
						direccion.append(calle);
						if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespiso())) {
							direccion.append(" ").append(datosEstablecimientoValidado.getAdhespiso());
						}
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespiso())) {
						direccion.append(" ").append(datosEstablecimientoValidado.getAdhespiso());
					}
				}
			}
		} else {
			if (!Y41bUtils.esNullOCadenaVacia(datosEstablecimientoValidado.getAdhespiso())) {
				direccion.append(" ").append(datosEstablecimientoValidado.getAdhespiso());
			}
		}
		return (direccion.toString());

	}

	/**
	 * dameLineaDireccionCompleta
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return String
	 */
	private String dameLineaDireccionCompleta(Arbadhsol datosEstablecimientoValidado) {
		StringBuffer direccion = new StringBuffer("");
		direccion.append(this.dameLineaDireccion(datosEstablecimientoValidado));
		String municipio = "";
		if ((datosEstablecimientoValidado.getAdhesmunici() != null)
				&& (datosEstablecimientoValidado.getAdhesprovin() != null)) {
			T17Municipio municipiodVO = (this.t17MunicipioDao
					.find(new T17Municipio(datosEstablecimientoValidado.getAdhesmunici(),
							datosEstablecimientoValidado.getAdhesprovin(), null, null)));

			if (municipiodVO != null) {
				municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
			}
		}
		direccion.append(" ").append(municipio);

		String provincia = "";
		/* localidad */
		if (datosEstablecimientoValidado.getAdhesprovin() != null) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(datosEstablecimientoValidado.getAdhesprovin(), null, null)));
			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}
		}
		direccion.append(" ").append(provincia);
		return direccion.toString();
	}

	/**
	 * tieneDireccionCompleta
	 * 
	 * @param datosEstablecimientoValidado
	 *            Arbadhsol
	 * @return boolean
	 */
	private boolean tieneDireccionCompleta(Arbadhsol datosEstablecimientoValidado) {
		// tiene direccion completa (como esta en el js)
		// 0193046: FAC. Direccin de notificacin completa

		boolean resultado = true;

		if (Y41bConstantes.SI.equalsIgnoreCase(datosEstablecimientoValidado.getAdhesextranjero())) {
			if (datosEstablecimientoValidado.getAdhespaisid() != null
					&& !("".equalsIgnoreCase(datosEstablecimientoValidado.getAdhespaisid()))
					&& datosEstablecimientoValidado.getAdhescalle() != null
					&& !("".equalsIgnoreCase(datosEstablecimientoValidado.getAdhescalle()))) {
				resultado = true;
			} else {
				resultado = false;
			}
		} else {
			if (datosEstablecimientoValidado.getAdhesprovin() != null
					&& !("".equalsIgnoreCase(datosEstablecimientoValidado.getAdhesprovin()))
					&& datosEstablecimientoValidado.getAdhesmunici() != null
					&& !("".equalsIgnoreCase(datosEstablecimientoValidado.getAdhesmunici()))
					&& datosEstablecimientoValidado.getAdhescalle() != null
					&& !("".equalsIgnoreCase(datosEstablecimientoValidado.getAdhescalle()))) {
				resultado = true;
				// si NO es de capv
			} else if (datosEstablecimientoValidado.getAdhesdirecnocapv() != null
					&& !("".equalsIgnoreCase(datosEstablecimientoValidado.getAdhesdirecnocapv()))) {
				resultado = true;
			} else {
				resultado = false;
			}
		}
		return resultado;
	}

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param adhid
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsComTableTemporal(String adhid) {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(adhid);
		arbadhsol = this.arbadhsolDao.find(arbadhsol);
		TramiteComun tramiteComun = new TramiteComun();
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA));
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA));
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD));
		}
		tramiteComun.setIdExpediente(adhid.toString());
		tramiteComun.setIdTramite(adhid.toString());
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		if (Y41bConstantes.ESTADO_ARBADHSOL_PENDIENTE.equals(arbadhsol.getAdhestado())) {
			this.arbadhsolcomdocDao.addArbAdhAdjuntarDocs(tramiteComun);
		} else {
			this.arbadhdocDao.addArbAdhAdjuntarDocs(tramiteComun);
		}
	}

	/**
	 * findDetalleEstablecimiento
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findDetalleEstablecimiento(Arbadhsol arbadhsol) {
		EstablecimientoDetalle establecimientoDetalle = new EstablecimientoDetalle();
		arbadhsol = this.arbadhsolDao.find(arbadhsol);
		Arbadhsol datosValidacion = this.arbadhsolDao.findDatosValidacion(arbadhsol);

		if (datosValidacion != null) {
			arbadhsol = datosValidacion;
		}
		establecimientoDetalle.setEsnombre(arbadhsol.getAdhesnom());
		establecimientoDetalle.setEsnif(arbadhsol.getAdhnif());
		establecimientoDetalle.setEsnrtel(arbadhsol.getAdhesnrtel());
		establecimientoDetalle.setEsnrtel2(arbadhsol.getAdhesnrtel2());
		establecimientoDetalle.setEscoem(arbadhsol.getAdhescoem());
		establecimientoDetalle.setEsnoraPaisId(arbadhsol.getAdhespaisid());
		establecimientoDetalle.setProvinciaId(arbadhsol.getAdhesprovin());
		establecimientoDetalle.setMunicipioId(arbadhsol.getAdhesmunici());
		establecimientoDetalle.setLocalidadId(arbadhsol.getAdheslocali());
		establecimientoDetalle.setCalleId(arbadhsol.getAdhescalle());
		establecimientoDetalle.setCpId(arbadhsol.getAdhesnombrecp());
		establecimientoDetalle.setEsnombreCp(arbadhsol.getAdhesnombrecp());
		establecimientoDetalle.setPortalId(arbadhsol.getAdhesportal());
		establecimientoDetalle.setEsnombrePiso(arbadhsol.getAdhespiso());
		establecimientoDetalle.setEsdireccion_nocapv(arbadhsol.getAdhesdirecnocapv());
		establecimientoDetalle.setEsfemod("");
		establecimientoDetalle.setMocodigo("");
		establecimientoDetalle.setMousu("");
		establecimientoDetalle.setEsnopeco(arbadhsol.getAdhesnopeco());
		establecimientoDetalle.setEsnoco(arbadhsol.getAdhesnoco());
		establecimientoDetalle.setEsteurl(arbadhsol.getAdhesurl());
		establecimientoDetalle.setSecodigo(arbadhsol.getAdhsectorid());
		if (!Y41bUtils.esNullOCadenaVacia(arbadhsol.getAdhsectorid())) {
			Sector sector = new Sector(arbadhsol.getAdhsectorid());
			if (this.sectorDao.findAllCount(sector) > 0L) {
				sector = this.sectorDao.find(sector);
				establecimientoDetalle.setSenombre(sector.getSenombre());
				establecimientoDetalle.setSenombree(sector.getSenombree());
			}
		}
		establecimientoDetalle.setEscoidco(arbadhsol.getAdhsolidioma());

		establecimientoDetalle.setEscooe(arbadhsol.getAdhorgemp());
		establecimientoDetalle.setEsnorep(arbadhsol.getAdhesnorep());
		establecimientoDetalle.setEsnifrep(arbadhsol.getAdhesnifrep());

		String calle = "";
		if (!Y41bUtils.esNullOCadenaVacia(establecimientoDetalle.getCalleId())) {
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(establecimientoDetalle.getCalleId()), null))
						.getDsO();
			} catch (Exception e) {

			}
			establecimientoDetalle.setCalleId_label(calle);
		}

		establecimientoDetalle.setEsdireccionCompleta(this.dameLineaDireccionCompleta(arbadhsol));

		if (!Y41bUtils.esNullOCadenaVacia(arbadhsol.getAdhescodigo())) {
			Establecimiento estableci = (Establecimiento) this.establecimientoDao
					.find(new Establecimiento(arbadhsol.getAdhescodigo()));

			establecimientoDetalle.setDireccionAntiguaCompleta(this.dameDireccionAntigua(estableci));

			establecimientoDetalle.setEssede(estableci.getEssede());
			establecimientoDetalle.setEsfeadar(estableci.getEsfeadar());
			establecimientoDetalle.setEsintiar(estableci.getEsintiar());
			establecimientoDetalle.setEsfeerd(estableci.getEsfeerd());
			establecimientoDetalle.setEscooe(estableci.getEscooe());
			establecimientoDetalle.setEsnorep(estableci.getEsnorep());
			establecimientoDetalle.setEsnifrep(estableci.getEsnifrep());
			establecimientoDetalle.setEsfeba(estableci.getEsfeba());
			establecimientoDetalle.setEsteco(estableci.getEsteco());

			// Mail de avisos
			establecimientoDetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
				establecimientoDetalle.setAhcodigo(establecimArbitra.getAhcodigo());
				establecimientoDetalle.setAhfeba(establecimArbitra.getAhfeba());
				establecimientoDetalle.setAhfere(establecimArbitra.getAhfere());
				establecimientoDetalle.setAhtelimi(establecimArbitra.getAhtelimi());
				establecimientoDetalle.setAhcoja(establecimArbitra.getAhcoja());
				establecimientoDetalle.setEsinadar(estableci.getEsinadar());
				establecimientoDetalle.setAhindef(establecimArbitra.getAhindef());
				establecimientoDetalle.setAhmedia(establecimArbitra.getAhmedia());
				establecimientoDetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
				if ("A".equals(estableci.getEsinadar())) {
					if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
						establecimientoDetalle.setEsinadar("L");
					}
				}
			} catch (Exception e) {

			}
			// buscar sedes
			if (estableci.getEssede() != null && estableci.getEssede().equals(Y41bConstantes.SI)) {
				Sede sede = new Sede();
				sede.setEscodigo(estableci.getEscodigo());

				List<Sede> listSede = this.sedeDao.findAll(sede, null);
				establecimientoDetalle.setSedes(listSede);
			}

			List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

			StringBuffer strIdsDescriptores = new StringBuffer();
			StringBuffer strDescsDescriptores = new StringBuffer();

			strDescsDescriptores.append("[");

			boolean firstElement = true;

			// se recorre para obtener los ids de etiquetas
			for (Descriptor descriptor : listDescriptor) {
				if (firstElement) {
					strIdsDescriptores.append(descriptor.getIdDescriptor());
					strDescsDescriptores.append(descriptor.getNombre());
					firstElement = false;
				} else {
					strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
					strDescsDescriptores.append(",").append(descriptor.getNombre());
				}
			}
			strDescsDescriptores.append("]");

			establecimientoDetalle.setIdsDescriptores(strIdsDescriptores.toString());
			establecimientoDetalle.setDescsDescriptores(strDescsDescriptores.toString());

		}

		return establecimientoDetalle;
	}

	/**
	 * 
	 * @param estableci
	 *            Establecimiento
	 * @return String
	 */
	private String dameDireccionAntigua(Establecimiento estableci) {
		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String escomapv = (estableci.getEscomapv() == null) ? "" : estableci.getEscomapv();
		String esnomu = (estableci.getEsnomu() == null) ? "" : estableci.getEsnomu();
		String esnolo = (estableci.getEsnolo() == null) ? "" : estableci.getEsnolo();
		String esnodir = (estableci.getEsnodir() == null) ? "" : estableci.getEsnodir();
		String esnrcopo = (estableci.getEsnrcopo() == null) ? "" : estableci.getEsnrcopo();

		direccionAntiguaCompleta.append(escomapv).append(" ").append(esnomu).append(" ").append(esnolo).append(" ")
				.append(esnodir).append(" ").append(esnrcopo);
		return direccionAntiguaCompleta.toString();
	}

	// /**
	// * actualizarDocumentoLocalizadorBBDD
	// *
	// * @param documentoX5
	// * Arbadhdoc
	// * @return Long
	// * @throws Exception
	// * excepcion
	// */
	// @Transactional(rollbackFor = Throwable.class)
	// public Long actualizarDocumentoLocalizadorBBDD(Arbadhdoc documentoX5)
	// throws Exception {
	// try {
	// String tipoProc = "";
	// int numRowsUpdated1 = 0;
	// int numRowsUpdated2 = 0;
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 1");
	// List<Arbadhdoc> ldocumentoX5 = this.arbadhdocDao.findAll(
	// documentoX5, null);
	// if (ldocumentoX5 != null && ldocumentoX5.size() > 0) {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 3
	// Numero de documentos: "
	// + ldocumentoX5.size());
	// Arbadhsol arbadhsol = new Arbadhsol();
	// arbadhsol.setAdhid(ldocumentoX5.get(0).getX5excodigo());
	// List<Arbadhsol> larbadhsol = this.arbadhsolDao.findAll(
	// arbadhsol, null);
	// if (larbadhsol != null && larbadhsol.size() > 0) {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 4
	// Numero de solicitudes: "
	// + larbadhsol.size());
	// if (Y41bConstantes.ADH_TIPO_ALTA.equals(larbadhsol.get(0)
	// .getAdhtipo())) {
	// tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
	// } else if (Y41bConstantes.ADH_TIPO_MODIF.equals(larbadhsol
	// .get(0).getAdhtipo())) {
	// tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
	// } else if (Y41bConstantes.ADH_TIPO_BAJA.equals(larbadhsol
	// .get(0).getAdhtipo())
	// || Y41bConstantes.ADH_TIPO_BAJA_OFICIO
	// .equals(larbadhsol.get(0).getAdhtipo())) {
	// tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
	// }
	// }
	// }
	// Arbadhsolcomdoc documentoXM = new Arbadhsolcomdoc();
	// documentoXM.setXmiddocumentum(documentoX5.getX5iddocumentum());
	// List<Arbadhsolcomdoc> ldocumentoXM = this.arbadhsolcomdocDao
	// .findAll(documentoXM, null);
	// if (ldocumentoXM != null && ldocumentoXM.size() > 0) {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 3
	// Numero de documentos: "
	// + ldocumentoXM.size());
	// Arbadhsol arbadhsol = new Arbadhsol();
	// arbadhsol.setAdhid(ldocumentoXM.get(0).getXmexcodigo());
	// List<Arbadhsol> larbadhsol = this.arbadhsolDao.findAll(
	// arbadhsol, null);
	// if (larbadhsol != null && larbadhsol.size() > 0) {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 4
	// Numero de solicitudes: "
	// + larbadhsol.size());
	// if (Y41bConstantes.ADH_TIPO_ALTA.equals(larbadhsol.get(0)
	// .getAdhtipo())) {
	// tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
	// } else if (Y41bConstantes.ADH_TIPO_MODIF.equals(larbadhsol
	// .get(0).getAdhtipo())) {
	// tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
	// } else if (Y41bConstantes.ADH_TIPO_BAJA.equals(larbadhsol
	// .get(0).getAdhtipo())
	// || Y41bConstantes.ADH_TIPO_BAJA_OFICIO
	// .equals(larbadhsol.get(0).getAdhtipo())) {
	// tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
	// }
	// }
	// }
	//
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 5
	// Tipo procedimiento: "
	// + tipoProc);
	// Documento documento = new Documento();
	// User user = new User();
	// user.setNombre(Y41bConstantes.COD_APLICACION);
	// user.setDni(Y41bConstantes.COD_APLICACION);
	// documento.setUser(user);
	// Procedure procedure = new Procedure();
	// procedure.setIdProcedimiento(tipoProc);
	// documento.setProcedure(procedure);
	// documento.setOidDokusi(documentoX5.getX5iddocumentum());
	//
	// Documento docDokusi = this.y41bDokusiAdapterService
	// .descargarDocumentoDokusi(documento);
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 6
	// Dokusi nombre: "
	// + docDokusi.getNombre());
	//
	// if (ldocumentoX5 != null && ldocumentoX5.size() > 0) {
	// Arbadhdoc documentohechoAux = new Arbadhdoc();
	// documentohechoAux.setX5nofile(docDokusi.getNombre());
	// documentohechoAux.setX5iddocumentum(documentoX5
	// .getX5iddocumentum());
	// documentohechoAux.setX5sizefile((int) docDokusi.getLength());
	// Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi
	// .getBytes()));
	// documentohechoAux.setX5datafile(blob);
	// documentohechoAux.setX5conttype(docDokusi.getContentType());
	//
	// numRowsUpdated1 = this.arbadhdocDao
	// .updateArbAdhDoc(documentohechoAux);
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 7
	// numRowsUpdated: "
	// + numRowsUpdated1);
	//
	// this.adjuntardocsDao.updateArbAdhDoc(documentohechoAux);
	//
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 8
	// DOID: ["
	// + ldocumentoX5.get(0).getX5codocumento() + "]");
	// } else {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Numero de
	// solicitudes: 0");
	// }
	//
	// if (ldocumentoXM != null && ldocumentoXM.size() > 0) {
	// Arbadhsolcomdoc documentohechoAux = new Arbadhsolcomdoc();
	// documentohechoAux.setXmnofile(docDokusi.getNombre());
	// documentohechoAux.setXmiddocumentum(documentoXM
	// .getXmiddocumentum());
	// documentohechoAux.setXmsizefile((int) docDokusi.getLength());
	// Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi
	// .getBytes()));
	// documentohechoAux.setXmdatafile(blob);
	// documentohechoAux.setXmconttype(docDokusi.getContentType());
	//
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 7
	// DOID: ["
	// + ldocumentoXM.get(0).getXmcodocumento() + "]");
	//
	// numRowsUpdated2 = this.arbadhsolcomdocDao
	// .updateArbAdhSolComDoc(documentohechoAux);
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 8
	// numRowsUpdated: "
	// + numRowsUpdated2);
	//
	// } else {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Numero de
	// solicitudes: 0");
	// }
	//
	// int numRowsUpdated = numRowsUpdated1 + numRowsUpdated2;
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD Paso 9
	// numRowsUpdated ["
	// + numRowsUpdated + "]");
	// if (numRowsUpdated > 0) {
	// return new Long(1);
	// } else {
	// return new Long(0);
	// }
	// } catch (Exception e) {
	// ArbadhsolServiceImpl.logger
	// .debug("ArbadhsolServiceImpl.actualizarDocumentoLocalizadorBBDD
	// Excepcion: "
	// + e.getMessage());
	// e.printStackTrace();
	// return new Long(0);
	// }
	// }

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Arbadhdoc>
	 */
	public List<Arbadhdoc> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination) {
		return this.arbadhdocDao.findAllDocumentosTramite(tramiteComun, pagination);
	}

	/**
	 * @param tramiteComun
	 *            tramiteComun
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientes(TramiteComun tramiteComun) {
		List<Intervinientes> listIntervinientes = new ArrayList<Intervinientes>();
		Intervinientes interviniente = new Intervinientes();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (this.arbadhtramDao.findAllCount(arbadhtram) > 0L) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}
		if (arbadhtram != null && arbadhtram.getTruaidinterv() != null
				&& !"-1".equals(arbadhtram.getTruaidinterv().toString())) {
			Arbadhinterv arbadhinterv = new Arbadhinterv();
			arbadhinterv.setUaidinterv(arbadhtram.getTruaidinterv());
			arbadhinterv = this.arbadhintervDao.find(arbadhinterv);
			interviniente.setNombre(arbadhinterv.getUanombre());
			interviniente.setApellido1("");
			interviniente.setApellido2("");
			interviniente.setIdinterviniente(arbadhinterv.getUaidinterv().toString());
			interviniente.setEscodigo(arbadhinterv.getUaescodigo());
		} else {
			Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (datosEstablecimientoValidado != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				interviniente.setNombre(datosEstablecimientoValidado.getAdhesnom());
				interviniente.setApellido1("");
				interviniente.setApellido2("");
				interviniente.setIdinterviniente("-1");
				interviniente.setEscodigo(datosEstablecimientoValidado.getAdhescodigo());
			} else {
				interviniente.setNombre(arbadhsol.getAdhesnom());
				interviniente.setApellido1("");
				interviniente.setApellido2("");
				interviniente.setIdinterviniente("-1");
				interviniente.setEscodigo(arbadhsol.getAdhescodigo());
			}
		}
		listIntervinientes.add(interviniente);
		return listIntervinientes;
	}

	/**
	 * @param tramiteComun
	 *            tramiteComun
	 * @return Intervinientes
	 */
	public Intervinientes findInterviniente(TramiteComun tramiteComun) {
		Intervinientes interviniente = new Intervinientes();

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (this.arbadhtramDao.findAllCount(arbadhtram) > 0L) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}
		if (arbadhtram != null && arbadhtram.getTruaidinterv() != null
				&& !"-1".equals(arbadhtram.getTruaidinterv().toString())) {
			Arbadhinterv arbadhinterv = new Arbadhinterv();
			arbadhinterv.setUaidinterv(arbadhtram.getTruaidinterv());
			arbadhinterv = this.arbadhintervDao.find(arbadhinterv);
			interviniente.setNombre(arbadhinterv.getUanombre());
			interviniente.setApellido1("");
			interviniente.setApellido2("");
			interviniente.setIdinterviniente(arbadhinterv.getUaidinterv().toString());
			interviniente.setEscodigo(arbadhinterv.getUaescodigo());
			interviniente.setCoem(arbadhinterv.getUacoem());
			interviniente.setDireccionCompleta(this.arbadhintervService.dameDireccionCompleta(arbadhinterv));
			interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO);
			interviniente.setNif(arbadhinterv.getUanif());
			interviniente.setArbFormanotificacion(arbadhsol.getAdhsoltipnotif());
			interviniente.setTieneDireccionCompleta(arbadhinterv.getTieneDireccionCompleta());
		} else {
			Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (datosEstablecimientoValidado != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				interviniente.setNombre(datosEstablecimientoValidado.getAdhesnom());
				interviniente.setApellido1("");
				interviniente.setApellido2("");
				interviniente.setIdinterviniente("-1");
				interviniente.setEscodigo(datosEstablecimientoValidado.getAdhescodigo());
				interviniente.setCoem(datosEstablecimientoValidado.getAdhescoem());
				interviniente.setDireccionCompleta(this.dameLineaDireccionCompleta(datosEstablecimientoValidado));
				interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO);
				interviniente.setNif(datosEstablecimientoValidado.getAdhnif());
				interviniente.setArbFormanotificacion(arbadhsol.getAdhsoltipnotif());
				interviniente.setTieneDireccionCompleta(this.tieneDireccionCompleta(datosEstablecimientoValidado));
			} else {
				interviniente.setNombre(arbadhsol.getAdhesnom());
				interviniente.setApellido1("");
				interviniente.setApellido2("");
				interviniente.setIdinterviniente("-1");
				interviniente.setEscodigo(arbadhsol.getAdhescodigo());
				interviniente.setDireccionCompleta(this.dameLineaDireccionCompleta(arbadhsol));
				interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO);
				interviniente.setNif(arbadhsol.getAdhnif());
				interviniente.setArbFormanotificacion(arbadhsol.getAdhsoltipnotif());
				interviniente.setTieneDireccionCompleta(this.tieneDireccionCompleta(arbadhsol));
			}
		}

		return interviniente;
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @return List<DatosMailOrigen>
	 */
	public List<DatosMailOrigen> findAllMailOrigen(String idExpediente) {
		DatosMailOrigen datosMailOrigen = new DatosMailOrigen();
		List<DatosMailOrigen> listDatosMailOrigen = new ArrayList<DatosMailOrigen>();

		// Buscar el monitor
		CensoMonitor remitente = new CensoMonitor();
		if (idExpediente != null) {

			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(idExpediente);

			arbadhsol = this.arbadhsolDao.find(arbadhsol);
			remitente.setMocodigo(arbadhsol.getAdhusumodif());

			remitente = this.censoMonitorDao.find(remitente);

			datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
			datosMailOrigen.setEmail(remitente.getMocoem());
			datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
			datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

			listDatosMailOrigen.add(datosMailOrigen);
		}

		// Buscar el organismo
		Organismo organismo = new Organismo();
		organismo.setCodOrg("01J001");

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
		datosMailOrigen.setEmail(organismo.getEmail());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		return listDatosMailOrigen;
	}

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @param mocodigoActual
	 *            String
	 * @return DatosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(String idExpediente, DatosMailOrigen datosMailOrigen, String mocodigoActual) {

		DatosMailOrigen datosMailOrigenAux = new DatosMailOrigen();

		if (Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el monitor
			CensoMonitor remitente = new CensoMonitor();
			if (idExpediente == null) {
				remitente.setOrganismo(new Organismo("01J001"));
				List<CensoMonitor> lremitente = this.censoMonitorDao.findAll(remitente, null);
				if (lremitente != null && lremitente.size() > 0) {
					datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
					datosMailOrigen.setEmail(lremitente.get(0).getMocoem());
					datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
					datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

				}
			} else {
				Arbadhsol arbadhsol = new Arbadhsol();
				arbadhsol.setAdhid(idExpediente);

				arbadhsol = this.arbadhsolDao.find(arbadhsol);
				remitente.setMocodigo(mocodigoActual);

				remitente = this.censoMonitorDao.find(remitente);

				datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
				datosMailOrigenAux.setEmail(remitente.getMocoem());
				datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
				datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);
			}

		} else if (Y41bConstantes.ID_MAIL_ORIGEN_GENERICO.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg("01J001");

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
			datosMailOrigenAux.setEmail(organismo.getEmail());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);
		}

		return datosMailOrigenAux;
	}

	/**
	 * findAllMailEstablecimiento
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List<DatosMailEstablecimiento>
	 */
	public List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun, String idInterviniente,
			Pagination pagination) {
		List<DatosMailEstablecimiento> listDatosMailEstablecimiento = new ArrayList<DatosMailEstablecimiento>();
		DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();
		// buscar todos los mails del establecimiento
		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();

		datosMailEstablecimiento.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		Arbadhtram arbadhtram = new Arbadhtram();
		arbadhtram.setTrid(tramiteComun.getIdTramite());
		if (this.arbadhtramDao.findAllCount(arbadhtram) > 0L) {
			arbadhtram = this.arbadhtramDao.find(arbadhtram);
		}
		if (arbadhtram != null && arbadhtram.getTruaidinterv() != null
				&& !"-1".equals(arbadhtram.getTruaidinterv().toString())) {
			Arbadhinterv arbadhinterv = new Arbadhinterv();
			arbadhinterv.setUaidinterv(arbadhtram.getTruaidinterv());
			arbadhinterv = this.arbadhintervDao.find(arbadhinterv);
			datosMailEstablecimiento.setEmail(arbadhinterv.getUacoem());
			datosMailEstablecimientoAux.setEscodigo(arbadhinterv.getUaescodigo());
		} else {
			Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
			if (datosEstablecimientoValidado != null
					&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
				datosMailEstablecimiento.setEmail(datosEstablecimientoValidado.getAdhescoem());
				datosMailEstablecimientoAux.setEscodigo(datosEstablecimientoValidado.getAdhescodigo());
			} else {
				datosMailEstablecimiento.setEmail(arbadhsol.getAdhescoem());
				datosMailEstablecimientoAux.setEscodigo(arbadhsol.getAdhescodigo());
			}
		}

		datosMailEstablecimiento.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailEstablecimiento.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);
		listDatosMailEstablecimiento.add(datosMailEstablecimiento);

		if (!Y41bUtils.esNullOCadenaVacia(datosMailEstablecimientoAux.getEscodigo())) {
			List<DatosMailEstablecimiento> listDatosMailEstablecimientoAux = this.datosMailEstablecimientoDao
					.findAll(datosMailEstablecimientoAux, null);

			for (DatosMailEstablecimiento datosMailEstablecimientoAux2 : listDatosMailEstablecimientoAux) {
				// aadirlo a la lista
				listDatosMailEstablecimiento.add(datosMailEstablecimientoAux2);
			}
		}

		return listDatosMailEstablecimiento;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento) {

		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailEstablecimiento.getIdDatomail())) {
			datosMailEstablecimientoAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolDao.find(arbadhsol);

			Arbadhtram arbadhtram = new Arbadhtram();
			arbadhtram.setTrid(tramiteComun.getIdTramite());
			if (this.arbadhtramDao.findAllCount(arbadhtram) > 0L) {
				arbadhtram = this.arbadhtramDao.find(arbadhtram);
			}
			if (arbadhtram != null && arbadhtram.getTruaidinterv() != null
					&& !"-1".equals(arbadhtram.getTruaidinterv().toString())) {
				Arbadhinterv arbadhinterv = new Arbadhinterv();
				arbadhinterv.setUaidinterv(arbadhtram.getTruaidinterv());
				arbadhinterv = this.arbadhintervDao.find(arbadhinterv);
				datosMailEstablecimientoAux.setEmail(arbadhinterv.getUacoem());
			} else {
				Arbadhsol datosEstablecimientoValidado = this.arbadhsolDao.findDatosValidacion(arbadhsol);
				if (datosEstablecimientoValidado != null
						&& !Y41bConstantes.ESTADO_ARBADHSOL_RECHAZADA.equals(arbadhsol.getAdhestado())) {
					datosMailEstablecimientoAux.setEmail(datosEstablecimientoValidado.getAdhescoem());
				} else {
					datosMailEstablecimientoAux.setEmail(arbadhsol.getAdhescoem());
				}
			}
			datosMailEstablecimientoAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
			datosMailEstablecimientoAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		} else {
			datosMailEstablecimientoAux = this.datosMailEstablecimientoDao.find(datosMailEstablecimiento);
		}

		return datosMailEstablecimientoAux;
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param escodigo
	 *            escodigo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, String escodigo,
			Pagination pagination) {

		List<DatosMailSede> listDatosMailSede = new ArrayList<DatosMailSede>();

		Sede sede = new Sede();
		sede.setEscodigo(escodigo);
		sede.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		sede = this.establecimientoService.findEstablecimientoSede(sede);

		DatosMailSede datosMailSede = new DatosMailSede();

		datosMailSede.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailSede.setEmail(sede.getEmail());
		datosMailSede.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailSede.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailSede.add(datosMailSede);

		// buscar todos los mails del establecimiento
		DatosMailSede datosMailSedeAux = new DatosMailSede();
		datosMailSedeAux.setEscodigo(escodigo);
		datosMailSedeAux.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

		List<DatosMailSede> listDatosMailSedeAux = this.datosMailSedeDao.findAll(datosMailSedeAux, null);

		for (DatosMailSede datosMailSedeAux2 : listDatosMailSedeAux) {
			// aadirlo a la lista
			listDatosMailSede.add(datosMailSedeAux2);
		}

		return listDatosMailSede;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede) {

		DatosMailSede datosMailSedeAux = new DatosMailSede();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailSede.getIdDatomail())) {

			Sede sede = new Sede();
			sede.setEscodigo(datosMailSede.getEscodigo());
			sede.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

			sede = this.establecimientoService.findEstablecimientoSede(sede);

			datosMailSedeAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
			datosMailSedeAux.setEmail(sede.getEmail());
			datosMailSedeAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
			datosMailSedeAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		} else {
			datosMailSedeAux = this.datosMailSedeDao.find(datosMailSede);
		}

		return datosMailSedeAux;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listArbadhsolcomdoc
	 *            List<Arbadhsolcomdoc>
	 * @param procedimiento
	 *            String
	 * @throws SQLException
	 *             SQLException
	 */
	private void eliminarDocumentosDokusi(List<Arbadhsolcomdoc> listArbadhsolcomdoc, String procedimiento)
			throws SQLException {
		// Eliminamos los documentos de dokusi
		if (listArbadhsolcomdoc != null && listArbadhsolcomdoc.size() > 0) {
			for (Arbadhsolcomdoc arbadhsolcomdoc : listArbadhsolcomdoc) {
				if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmiddocumentum() != null
						&& !arbadhsolcomdoc.getXmiddocumentum().equals("")) {

					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(
							Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(procedimiento));
					documento.setProcedure(procedure);
					documento.setOidDokusi(arbadhsolcomdoc.getXmiddocumentum());
					documento.setBoolAllVersions("true");

					this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);

				}
			}
		}
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentosTramite
	 *            List<Arbadhsolcomdoc>
	 * @param tramiteComun
	 *            ramiteComun
	 * @throws SQLException
	 *             SQLException
	 */
	private void registrarDocumentosDokusi(List<Arbadhsolcomdoc> listDocumentosTramite, TramiteComun tramiteComun)
			throws SQLException {

		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(tramiteComun.getIdExpediente());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		ArbadhsolServiceImpl.logger.debug("Inicio registrarDocumentosDokusi()");

		if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			Arbadhsolcomdoc arbdocTempDocumentoTratar = null;
			Arbtipdoc arbtipdoc = new Arbtipdoc();
			for (int i = 0; i < listDocumentosTramite.size(); i++) {
				arbdocTempDocumentoTratar = listDocumentosTramite.get(i);
				arbdocTempDocumentoTratar = this.limpiarOidSiErrorLocalizacion(arbdocTempDocumentoTratar, arbadhsol);
				if (!Y41bUtils.isFilled(arbdocTempDocumentoTratar.getXmiddocumentum())) {

					ArbadhsolServiceImpl.logger.debug("registrarDocumentosDokusi. X5codocumento"
							+ arbdocTempDocumentoTratar.getXmcodocumento() + ".");

					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					String tipoProc = "";
					if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
					} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
					} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
							|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
					}
					procedure.setIdProcedimiento(tipoProc);
					documento.setProcedure(procedure);
					// 2.Tipo Documental
					String serieDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					if (arbdocTempDocumentoTratar.getXmtipodocumento() != null) {
						arbtipdoc.setTdid(arbdocTempDocumentoTratar.getXmtipodocumento());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						if (arbtipdoc != null) {
							serieDocumental = (arbtipdoc.getIdTipodoc());
						} else {
							ArbadhsolServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
						}
					} else {
						ArbadhsolServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
					}
					documento.setTipoDocumental(serieDocumental);

					ArbadhsolServiceImpl.logger
							.debug("registrarDocumentosDokusi. TIPO DOCUMENTAL:" + serieDocumental + ".");

					documento.setIdDocumento(arbdocTempDocumentoTratar.getXmcodocumento().toString());

					String nombreFichero = Y41bUtils.getNameFile(arbdocTempDocumentoTratar.getXmnofile());
					documento.setNombre(nombreFichero);
					documento.setDescripcion(arbdocTempDocumentoTratar.getXmtedesfile());

					String extensionFichero = Y41bUtils.getExtensionFile(arbdocTempDocumentoTratar.getXmnofile());
					documento.setExtension(extensionFichero);

					ArbadhsolServiceImpl.logger.debug(
							"registrarDocumentosDokusi. FICHERO:" + nombreFichero + "." + extensionFichero + ".");

					// Recupero el [] byte
					Arbadhsolcomdoc arbadhsolcomdocAux = new Arbadhsolcomdoc();
					arbadhsolcomdocAux.setXmcodocumento(arbdocTempDocumentoTratar.getXmcodocumento());

					arbadhsolcomdocAux = this.arbadhsolcomdocDao.find(arbadhsolcomdocAux);

					Blob contenido = arbadhsolcomdocAux.getXmdatafile();

					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
					documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
					// COMPROBAR SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE
					// Obtener tramite
					if (arbdocTempDocumentoTratar != null && arbdocTempDocumentoTratar.getXmptcodigo() != null
							&& !arbdocTempDocumentoTratar.getXmptcodigo().equals("")) {

						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(arbdocTempDocumentoTratar.getXmptcodigo());
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
							// } else {
							// No existe la
							// plantilla_tramite,
							// miramos en plantilla_decision
						}
					}

					ArbadhsolServiceImpl.logger
							.debug("registrarDocumentosDokusi.noLocalizable:" + documento.getNolocalizable() == null
									|| !"S".equals(documento.getNolocalizable()) ? "Localizable" : "No localizable");
					StringBuffer numeroExpedienteDokusi = new StringBuffer();
					numeroExpedienteDokusi.append(arbadhsol.getNumExpediente());

					documento.setNumeroExpediente(numeroExpedienteDokusi.toString());

					// Actualizo OID Dokusi en tabla documentos intermedia
					Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();
					adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());

					if (Y41bUtils.interactuarConDokusi()) {
						Documento documentoRdo = this.y41bDokusiAdapterService.registrarDocumentoDokusi(documento);
						ArbadhsolServiceImpl.logger
								.debug("registrarDocumentosDokusi. OidDokusi:" + documentoRdo.getOidDokusi() + ".");
						arbdocTempDocumentoTratar.setXmiddocumentum(documentoRdo.getOidDokusi());
						adjuntardocsAuxUpdateOID.setThiddocumentum(documentoRdo.getOidDokusi());

					}

					// Actualizo OID Dokusi en tabla documentos intermedia
					this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);
					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
					} else {
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}

					// Actualizo OID Dokusi en tabla documentos
					this.arbadhsolcomdocDao.updateOIDDokusi(arbdocTempDocumentoTratar);
					if (Y41bUtils.isDocumentoTransformable(documento)) {
						ArbadhsolServiceImpl.logger.debug("registrarDocumentosDokusi. Es Transformable: S");
						this.arbadhsolcomdocDao.updateFechaLocalizacion(arbdocTempDocumentoTratar);
					} else {
						ArbadhsolServiceImpl.logger.debug("registrarDocumentosDokusi. Es Transformable: N");
						this.arbadhsolcomdocDao.removeBlobFromOIDDokusi(arbdocTempDocumentoTratar);
					}

				}
			}
		}
	}

	/**
	 * limpiarOidSiErrorLocalizacion
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsolcomdoc
	 */
	private Arbadhsolcomdoc limpiarOidSiErrorLocalizacion(Arbadhsolcomdoc documentoHecho, Arbadhsol arbadhsol) {
		ArbadhsolServiceImpl.logger.info("ArbadhtramServiceImpl - Eliminamos documentos con error de localizacion.");
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		if (documentoHecho.getXmfechasollocalizador() != null) {
			if (documentoHecho != null && documentoHecho.getXmnofile() != null && !com.ejie.y41b.utils.Y41bUtils
					.getExtensionFile(documentoHecho.getXmnofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

				int minutos = 0;
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

				Date d1 = null;
				Date d2 = null;
				long diffMinutes = 0;
				try {
					d1 = format.parse(format.format(documentoHecho.getXmfechasollocalizador()));

					d2 = format.parse(format.format(new Date()));

					long diff = d2.getTime() - d1.getTime();

					diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
				} catch (ParseException e) {
					diffMinutes = 0;
				}

				if (diffMinutes > minutos) {
					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					String tipoProc = "";
					if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
					} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
					} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
							|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
						tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
					}
					procedure.setIdProcedimiento(tipoProc);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getXmiddocumentum());
					documento.setBoolAllVersions("true");

					try {
						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					} catch (Exception e) {
					}

					documentoHecho.setXmfechasollocalizador(null);
					documentoHecho.setXmiddocumentum(null);
				}
			}
		}
		return documentoHecho;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.ArbadhsolService#updateConEstablecimiento(com.ejie
	 * .y41b.model.Arbadhsol, com.ejie .y41b.model.censoMonitor)
	 */
	@Override()
	public EstablecimientoDetalle bajaOficioValidacion(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {
		Arbadhsol arbadhsolBD = this.arbadhsolDao.find(arbadhsol);
		arbadhsolBD.setAdhescodigo(arbadhsol.getAdhescodigo());
		arbadhsolBD.setAdhnif(arbadhsol.getAdhnif());
		arbadhsolBD.setAdhesnom(arbadhsol.getAdhesnom());
		arbadhsolBD.setAdhesnoco(arbadhsol.getAdhesnoco());
		arbadhsolBD.setAdhescoidco(arbadhsol.getAdhescoidco());
		arbadhsolBD.setAdhorgemp(arbadhsol.getAdhorgemp());
		arbadhsolBD.setAdhesurl(arbadhsol.getAdhesurl());
		arbadhsolBD.setAdhesnopeco(arbadhsol.getAdhesnopeco());
		arbadhsolBD.setAdhescoem(arbadhsol.getAdhescoem());
		arbadhsolBD.setAdhesnrtel(arbadhsol.getAdhesnrtel());
		arbadhsolBD.setAdhesnrtel2(arbadhsol.getAdhesnrtel2());
		arbadhsolBD.setAdhesextranjero(arbadhsol.getAdhesextranjero());
		arbadhsolBD.setAdhesnombrecp(arbadhsol.getAdhesnombrecp());
		arbadhsolBD.setAdhesprovin(arbadhsol.getAdhesprovin());
		arbadhsolBD.setAdhesmunici(arbadhsol.getAdhesmunici());
		arbadhsolBD.setAdheslocali(arbadhsol.getAdheslocali());
		arbadhsolBD.setAdhescalle(arbadhsol.getAdhescalle());
		arbadhsolBD.setAdhesportal(arbadhsol.getAdhesportal());
		arbadhsolBD.setAdhespiso(arbadhsol.getAdhespiso());
		arbadhsolBD.setAdhesdirecnocapv(arbadhsol.getAdhesdirecnocapv());
		arbadhsolBD.setAdhesnorep(arbadhsol.getAdhesnorep());
		arbadhsolBD.setAdhesnifrep(arbadhsol.getAdhesnifrep());
		arbadhsolBD.setAdhsectorid(arbadhsol.getAdhsectorid());

		Establecimiento estableci = new Establecimiento(arbadhsol.getAdhescodigo());
		EstablecimientoDetalle establecimiento = this.establecimientoService.findEstablecimiento(estableci);
		establecimiento.setEsnombre(arbadhsol.getAdhesnom());
		establecimiento.setEsnoco(arbadhsol.getAdhesnoco());

		arbadhsolBD.setAdhesintiar(establecimiento.getEsintiar());
		arbadhsolBD.setAdhesmedia(establecimiento.getAhmedia());
		arbadhsolBD.setAdhindef(establecimiento.getAhindef());
		if (establecimiento.getAhfeba() != null) {
			arbadhsolBD.setAdhfecfin(Y41bUtils.addDays(establecimiento.getAhfeba(), -Y41bConstantes.NUM_30));
		}
		// arbadhsolBD.setAdhsectorid();
		arbadhsolBD.setAdhespaisid(establecimiento.getEsnoraPaisId());
		this.arbadhsolDao.update(arbadhsolBD);

		this.arbadhsolDao.guardarDatosValidacion(arbadhsolBD);

		this.abrirSolicitudOficioPlatea(arbadhsolBD, censoMonitor);
		return establecimiento;
	}

	/**
	 * abrirSolicitudOficioPlatea
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	private void abrirSolicitudOficioPlatea(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {
		ArbadhsolServiceImpl.logger.info("ExpedienteServiceImpl. - Add. Preparar Llamada a Platea");
		SolicitudOficio solicitudOficio = new SolicitudOficio();

		Procedure procedure = new Procedure();
		String tipoProc = "";
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
			tipoProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}
		procedure.setIdProcedimiento(tipoProc);
		solicitudOficio.setProcedure(procedure);
		DatosPersona datosPersona = new DatosPersona();
		CensoMonitor censoMonitorSender = new CensoMonitor();
		censoMonitorSender.setMocodigo(censoMonitor.getMocodigo());
		censoMonitorSender = this.censoMonitorDao.find(censoMonitorSender);
		datosPersona.setDni(censoMonitorSender.getModni().trim().toUpperCase());
		datosPersona.setNombre(censoMonitorSender.getMonombre());
		solicitudOficio.setSender(datosPersona);

		/* SANCIONADO */
		Arbadhsol datosValidacion = this.arbadhsolDao.findDatosValidacion(arbadhsol);
		DatosPersona datosEstablecimientoSancionado = new DatosPersona();
		datosEstablecimientoSancionado.setDni(datosValidacion.getAdhnif().trim().toUpperCase());
		datosEstablecimientoSancionado.setNombre(datosValidacion.getAdhesnom());
		datosEstablecimientoSancionado.setTelefono(datosValidacion.getAdhesnrtel());
		datosEstablecimientoSancionado.setMail(datosValidacion.getAdhescoem());

		solicitudOficio.setSancionado(datosEstablecimientoSancionado);
		solicitudOficio.setNumeroExpediente(arbadhsol.damecodCompletoPlatea());
		solicitudOficio.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		ArbadhsolServiceImpl.logger.info("ExpedienteServiceImpl. - Add. Inicio Llamada a Platea");
		if (Y41bUtils.interactuarConDokusi()) {
			this.y41bPlateaAdapterService.crearSolicitudOficio(solicitudOficio);

		}

		ArbadhsolServiceImpl.logger.info("ExpedienteServiceImpl. - Add. Fin Llamada a Platea");
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarBandejaFirma(List<Arbadhsolcomdoc> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception {
		try {
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				// Elimino de la Bandeja de Firma los documentos del tramite
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				// Calculo el numero del expediente para Dokusi
				Arbadhsol arbadhsol = new Arbadhsol();
				arbadhsol.setAdhid(tramiteComun.getIdExpediente());
				arbadhsol = this.arbadhsolDao.find(arbadhsol);

				StringBuffer numeroExpediente = new StringBuffer();
				numeroExpediente.append(tramiteComun.getTipoProcedimiento().getPcodigo()).append("-")
						.append(Y41bConstantes.ID_ORGANISMO_SOLICITUD_ADH).append("-").append(arbadhsol.getAdhsolnror())
						.append("-").append(arbadhsol.getAdhsolnran());

				// Recorro los documentos del tramite buscando aquel documento
				// que
				// este pendiente de firma
				Arbadhsolcomdoc documentoHecho = null;
				Arbadhsolcomdoc documentoHechoDetalleAux = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getXmestadodocumento())) {
						documentoHecho = this.limpiarOidSiErrorLocalizacion(documentoHecho);
						// Si esta pendiente de firma, lo primero lo meto en
						// Dokusi
						// si NO esta dado de alta ya
						if (!Y41bUtils.isFilled(documentoHecho.getXmiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure
									.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(
											tramiteComun.getTipoProcedimiento().getPcodigo()));
							documento.setProcedure(procedure);
							String tipoDocumental = "";
							if (Y41bUtils.isFilled(documentoHecho.getXmtipodocumento())) {
								Arbtipdoc arbtipdoc = new Arbtipdoc();
								arbtipdoc.setTdid(documentoHecho.getXmtipodocumento());
								arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
								tipoDocumental = arbtipdoc.getIdTipodoc();

							} else {
								tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
							}
							documento.setTipoDocumental(tipoDocumental);

							documento.setIdDocumento(documentoHecho.getXmcodocumento().toString());

							documento.setNombre(Y41bUtils.getNameFile(documentoHecho.getXmnofile()));
							documento.setDescripcion(documentoHecho.getXmtedesfile());
							documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getXmnofile()));
							// Recupero el [] byte
							documentoHechoDetalleAux = new Arbadhsolcomdoc();
							documentoHechoDetalleAux.setXmcodocumento(documentoHecho.getXmcodocumento());

							documentoHechoDetalleAux = this.arbadhsolcomdocService.find(documentoHechoDetalleAux);
							Blob contenido = documentoHechoDetalleAux.getXmdatafile();

							byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

							documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
							documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);

							documento.setNumeroExpediente(numeroExpediente.toString());

							if (Y41bUtils.interactuarConDokusi()) {
								Documento documentoRdo = this.y41bDokusiAdapterService
										.registrarDocumentoDokusi(documento);
								documentoHecho.setXmiddocumentum(documentoRdo.getOidDokusi());

								/**
								 * no tiene sentido actualizar lo del
								 * localizador en adjuntardocs porque para
								 * cuando se llama a esto ya se ha hecho el
								 * remove de todos los elementos de la tabla
								 * adjuntardocs
								 */
							}

							// Update oid de documentum
							this.arbadhsolcomdocDao.updateOIDDokusi(documentoHecho);

							if (Y41bUtils.isDocumentoTransformable(documento)) {
								this.arbadhsolcomdocDao.updateFechaLocalizacion(documentoHecho);
							} else {
								this.arbadhsolcomdocDao.removeBlobFromOIDDokusi(documentoHecho);
							}

						}
						// Lo segundo lo meto en la Bandeja de Firma
						bandejaFirma = new BandejaFirma();

						bandejaFirma
								.setIdbandejafirma(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						bandejaFirma.setIdexpediente(tramiteComun.getIdExpediente());
						bandejaFirma.setExpediente(numeroExpediente.toString());
						bandejaFirma.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
						bandejaFirma.setHccoor(Y41bConstantes.ID_ORGANISMO_SOLICITUD_ADH);
						bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
						bandejaFirma.setTrcodigo(tipoTramite);

						Fase fase = new Fase();
						fase.setFcodigo(faseTramite);
						bandejaFirma.setFase(fase);

						bandejaFirma.setCodocumento(documentoHecho.getXmcodocumento());
						bandejaFirma.setIddocumentum(documentoHecho.getXmiddocumentum());
						bandejaFirma.setNofile(documentoHecho.getXmnofile());
						bandejaFirma.setFechalimfirma(new Date());
						bandejaFirma.setIdperfilfirma(documentoHecho.getXmidPerfilfirma());
						bandejaFirma.setDesfile(documentoHecho.getXmtedesfile());

						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(tramiteComun.getTipoProcedimiento().getPcodigo());
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getXmiddocumentum());

						Documento documentoRdo = this.y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

						documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

						String hashDocumento = this.y41bPlateaAdapterService.generarHashDocumento(documento);
						bandejaFirma.setHashfile(hashDocumento);

						// En adhesiones no tenemos responsable del expediente
						// if (bandejaFirma.getIdperfilfirma() != null
						// && bandejaFirma.getIdperfilfirma().equals(
						// Y41bConstantes.PERFIL_INSTRUCTOR)) {
						//
						// }

						this.bandejaFirmaDao.add(bandejaFirma);
					}
				}
			}
		} catch (Exception e) {
			throw e;
		}

	}

	/**
	 * limpiarOidSiErrorLocalizacion
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	private Arbadhsolcomdoc limpiarOidSiErrorLocalizacion(Arbadhsolcomdoc documentoHecho) {
		Arbadhsol arbadhsol = new Arbadhsol();
		arbadhsol.setAdhid(documentoHecho.getXmexcodigo());
		arbadhsol = this.arbadhsolDao.find(arbadhsol);

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		if (documentoHecho.getXmfechasollocalizador() != null) {
			if (documentoHecho != null && documentoHecho.getXmnofile() != null && !com.ejie.y41b.utils.Y41bUtils
					.getExtensionFile(documentoHecho.getXmnofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

				int minutos = 0;
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

				Date d1 = null;
				Date d2 = null;
				long diffMinutes = 0;
				try {
					d1 = format.parse(format.format(documentoHecho.getXmfechasollocalizador()));

					d2 = format.parse(format.format(new Date()));

					long diff = d2.getTime() - d1.getTime();

					diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
				} catch (ParseException e) {
					diffMinutes = 0;
				}

				if (diffMinutes > minutos) {
					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea
							.devuelveCodigoProcedimientoPlatea(arbadhsol.getTipoProcedimiento()));
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getXmiddocumentum());
					documento.setBoolAllVersions("true");

					try {
						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					} catch (Exception e) {
					}

					documentoHecho.setXmfechasollocalizador(null);
					documentoHecho.setXmiddocumentum(null);
				}
			}
		}
		return documentoHecho;
	}

	@Transactional(rollbackFor = Throwable.class)
	public Arbadhsol registrarAdhFormulario(AdhesionTele solicitudDetalleAux, Adjuntardocs adjuntardocs)
			throws Exception {
		// TODO Auto-generated method stub

		// registrarlo en nuetro negocio

		Arbadhsol nuevaSolicitud = new Arbadhsol();

		nuevaSolicitud.setAdhesnom(solicitudDetalleAux.getAdhesnom());
		nuevaSolicitud.setAdhnif(solicitudDetalleAux.getAdhnif());
		nuevaSolicitud.setAdhesnoco(solicitudDetalleAux.getAdhesnoco());
		nuevaSolicitud.setAdhesnombrecp(solicitudDetalleAux.getAdhesnombrecp());
		nuevaSolicitud.setAdhespiso(solicitudDetalleAux.getAdhespiso());
		nuevaSolicitud.setAdhesnrtel(solicitudDetalleAux.getAdhesnrtel());
		nuevaSolicitud.setAdhesnrtel2(solicitudDetalleAux.getAdhesnrtel2());
		nuevaSolicitud.setAdhesurl(solicitudDetalleAux.getAdhesurl());
		nuevaSolicitud.setAdhescoem(solicitudDetalleAux.getAdhescoem());
		nuevaSolicitud.setAdhesnorep(solicitudDetalleAux.getAdhesnorep());
		nuevaSolicitud.setAdhesnifrep(solicitudDetalleAux.getAdhesnifrep());
		nuevaSolicitud.setAdhorgemp(solicitudDetalleAux.getAdhorgemp());
		nuevaSolicitud.setAdhesprovin(solicitudDetalleAux.getAdhesprovin());
		nuevaSolicitud.setAdhesextranjero(solicitudDetalleAux.getAdhesextranjero());
		nuevaSolicitud.setAdhesintiar(Y41bConstantes.ARBITRAJE_SAINTISO_EQUIDAD);
		nuevaSolicitud.setAdhesmedia(Y41bConstantes.SI);
		nuevaSolicitud.setAdhindef(Y41bConstantes.SI);
		// nuev campo sector campania
		nuevaSolicitud.setAdhSectorCampania(solicitudDetalleAux.getAdhSectorCampania());

		nuevaSolicitud.setAdhsolcoor(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		BigDecimal anyo = new BigDecimal(Y41bUtils.formatearDateToString(Y41bUtils.hoy(), "yyyy"));
		nuevaSolicitud.setAdhsolnran(anyo);
		// nuevaSolicitud.setAdhsolnror(new BigDecimal(correlativoSolicitud));
		nuevaSolicitud.setAdhestado(Y41bConstantes.ID_ESTADO_SOL_ADH_PENDIENTE);
		nuevaSolicitud.setAdhsoltipnotif(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
		nuevaSolicitud.setAdhtipo(solicitudDetalleAux.getAdhtipo());

		nuevaSolicitud.setAdhtexto(solicitudDetalleAux.getAdhtexto());
		// tengo que cargar todos los demas campos de nuevaSolicitud desde
		// solicitudDetalleAux

		StringBuffer numeroExpediente = new StringBuffer();
		String tipoProc = "";
		String idProc = "";

		numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_ALTA);
		tipoProc = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
		idProc = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;

		RegistroEntrada registroEntrada = new RegistroEntrada();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(idProc);

		// obtnemos un regNumber
		registroEntrada.setProcedure(procedure);

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(Y41bConstantes.COD_APLICACION);
		datosPersona.setNombre(Y41bConstantes.COD_APLICACION);

		registroEntrada.setSolicitante(datosPersona);

		registroEntrada.setIdioma(Y41bConstantes.CASTELLANO);

		registroEntrada = y41bPlateaAdapterService.obtenerRegistroEntrada(registroEntrada);
		ArbadhsolServiceImpl.logger.debug("FIN RECIBIR REGISTRO ENTRADA");
		// FIN obtnemos un regNumber

		nuevaSolicitud.setAdhsolregen(registroEntrada.getRegistryNumber());
		nuevaSolicitud.setAdhfecregen(Y41bUtils.formatearStringToDateFormato(registroEntrada.getRegistryTimestamp(),
				Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT));

		// creamos la solicitud
		nuevaSolicitud = this.add(nuevaSolicitud);

		numeroExpediente.append("-").append(Y41bConstantes.ID_ORGANISMO_SOLICITUD_ADH).append("-")
				.append(nuevaSolicitud.getAdhsolnror()).append("-").append(nuevaSolicitud.getAdhsolnran());
		nuevaSolicitud.setNumExpediente(numeroExpediente.toString());

		// creamos el tramite de apertura

		Arbadhtram tramiteApertura = this.crearApertura(nuevaSolicitud);
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(tramiteApertura.getTrexcodigo().toString());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(tipoProc));
		tramiteComun.setIdTramite(tramiteApertura.getTrid().toString());

		// insertamos el documento

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		adjuntardocs.setThcodocumento(this.arbadhdocDao.getNewPK().toString());
		adjuntardocs.setThidtipodoc(Y41bConstantes.TIPO_DOC_ADH_ALTA_APORTACIONDOCUMENTACION);
		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ADH_ALTA_APORTACIONDOCUMENTACION);
		adjuntardocs.setTipoDocumento(tipoDocumento);
		adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
		// preguntar
		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
		adjuntardocs = this.adjuntardocsDao.add(adjuntardocs);

		this.arbadhsolcomdocDao.addDocumentosHechoAdjuntarDocs(tramiteComun);

		this.arbadhdocDao.addAdjuntarDocsAdhDocTramite(tramiteComun);

		Arbadhsolcomdoc arbadhsolcomdocAux = new Arbadhsolcomdoc();
		arbadhsolcomdocAux.setXmexcodigo(tramiteComun.getIdExpediente());

		// abrirlo en platea
		SolicitudPresencial solicitudPresencial = new SolicitudPresencial();

		solicitudPresencial.setProcedure(procedure);

		solicitudPresencial.setIdParticipacion(solicitudDetalleAux.getAdhnif());

		datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalleAux.getAdhnif());
		datosPersona.setNombre(solicitudDetalleAux.getAdhesnom());

		datosPersona.setMail(solicitudDetalleAux.getAdhescoem());
		datosPersona.setTelefono(solicitudDetalleAux.getAdhesnrtel());
		datosPersona.setIdioma(Y41bConstantes.CASTELLANO);
		solicitudPresencial.setSolicitante(datosPersona);

		solicitudPresencial.setNumeroExpediente(numeroExpediente.toString());

		solicitudPresencial.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(registroEntrada.getRegistryNumber());
		datosRegistro.setRegistryTimestamp(Y41bUtils.formatearDateToString(solicitudDetalleAux.getAdhfecregen(),
				Y41bConstantes.FORMATO_FECHAHORALARGA_ES));

		solicitudPresencial.setDatosRegistro(datosRegistro);

		// 1.User
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);

		Documento documento = null;
		List<Documento> listDocumentos = new ArrayList<Documento>();
		documento = new Documento();

		documento.setUser(user);

		// 2.Tipo Documental
		Arbtipdoc arbtipdoc = new Arbtipdoc();
		String serieDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		if (adjuntardocs.getThidtipodoc() != null) {
			arbtipdoc.setTdid(adjuntardocs.getThidtipodoc());
			arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
			if (arbtipdoc != null) {
				serieDocumental = (arbtipdoc.getIdTipodoc());
			} else {
				ArbadhsolServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
			}
		} else {
			ArbadhsolServiceImpl.logger.debug("ERROR. TIPO DOCUMENTAL VACIO. SE PONE EL POR DEFECTO.");
		}
		documento.setTipoDocumental(serieDocumental);

		documento.setIdDocumento(adjuntardocs.getThcodocumento().toString());
		documento.setNombre(adjuntardocs.getThnofile());
		documento.setExtension(Y41bUtils.getExtensionFile(adjuntardocs.getThnofile()));
		documento.setDescripcion(adjuntardocs.getThtedesfile());

		if (Y41bUtils.isFilled(adjuntardocs.getThiddocumentum())) {
			documento.setOidDokusi(adjuntardocs.getThiddocumentum());
		} else {
			Blob contenido = adjuntardocs.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
		}

		documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		documento.setProcedure(procedure);

		documento.setRegistryNumber(registroEntrada.getRegistryNumber());
		documento.setRegistryTimestamp(Y41bUtils.formatearDateToString(solicitudDetalleAux.getAdhfecregen(),
				Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
		documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);

		listDocumentos.add(documento);

		solicitudPresencial.setDocumentosAdjuntos(listDocumentos);

		solicitudPresencial = this.y41bPlateaAdapterService.crearSolicitudPresencial(solicitudPresencial);

		// recoger el oid
		if (null != solicitudPresencial.getDocumentosAdjuntos()
				&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
			for (Documento documentoAux : solicitudPresencial.getDocumentosAdjuntos()) {
				// Actualizo OID Dokusi en tabla documentos hecho
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documentoAux.getIdDocumento());
				documentoHechoAux.setQ5iddocumentum(documentoAux.getOidDokusi());
				// Update oid de documentum
				this.documentoHechoDao.updateOIDDokusi(documentoHechoAux);

				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHechoAux);

				// tranformamos el doccumento
				TransformarDocumento transformarDocumento = new TransformarDocumento();
				transformarDocumento.setProcedure(procedure);
				User sender = new User();
				sender.setNombre(Y41bConstantes.COD_APLICACION);
				sender.setDni(Y41bConstantes.COD_APLICACION);
				transformarDocumento.setUser(sender);
				transformarDocumento.setOidDocumento(documentoAux.getOidDokusi());

				y41bDokusiAdapterService.transformarDocumentoDokusi(transformarDocumento);
			}
		}

		// borrar los documentos telemticos
		// this.arbadhdocDao.removeTelematicos(solicitudFiltradocumentos);

		// borrar la solicitud telemtica
		// this.adhesionTeleDao.remove(solicitudDetalleAux);

		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);

		// devolver la solicitud
		return nuevaSolicitud;
	}
}
