package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.AdhesionTele;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.TramiteComun;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * ArbadhsolService  
 * 
 *  
 */

public interface ArbadhsolService {

	/**
	 * Inserts a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol add(Arbadhsol arbadhsol);

	/**
	 * Updates a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 *             excepcion
	 */
	Arbadhsol update(Arbadhsol arbadhsol) throws Exception;

	/**
	 * Finds a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol find(Arbadhsol arbadhsol);

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhsol> findAll(Arbadhsol arbadhsol, Pagination pagination);

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Long
	 */
	Long findAllCount(Arbadhsol arbadhsol);

	/**
	 * Finds rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhsol> findAllLike(Arbadhsol arbadhsol, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhsol arbadhsol, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return
	 */
	void remove(Arbadhsol arbadhsol);

	/**
	 * Deletes multiple rows in the Arbadhsol table.
	 * 
	 * @param arbadhsolList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbadhsol> arbadhsolList);

	/**
	 * proceso la recepcin de una solicitud telemtica de adhesin..
	 * 
	 * @param solicitud
	 *            AdhesionTele
	 * @param listDocumento
	 *            List<Documento>
	 * @return Arbadhsol
	 * @throws Exception
	 *             Exception
	 */
	Arbadhsol recibirSolicitudTelematica(AdhesionTele solicitud, List<Documento> listDocumento) throws Exception;

	/**
	 * proceso la recepcin de una solicitud telemtica de adhesin..
	 * 
	 * 
	 * @throws Exception
	 *             Exception
	 */
	void limpiarTemporalesTelematicasAntiguas() throws Exception;

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhsol> findBandeja(Arbadhsol arbadhsol, CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @return Long
	 */
	Long findBandejaCount(Arbadhsol arbadhsol, CensoMonitor censoMonitor);

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol guardarDatosValidacion(Arbadhsol arbadhsol);

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol findDatosValidacion(Arbadhsol arbadhsol);

	/**
	 * guardarDatosComunicacion
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 * @throws Exception
	 *             excepcion
	 */
	Arbadhsol guardarDatosComunicacion(Arbadhsol arbadhsol) throws Exception;

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol findDatosComunicacion(Arbadhsol arbadhsol);

	/**
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idZip
	 *            String
	 * @return Arbadhsol
	 * @throws Exception
	 *             Exception
	 */
	Arbadhsol finalizarSolicitudAdhesion(Arbadhsol arbadhsol, CensoMonitor censoMonitor, String idZip) throws Exception;

	/**
	 * @param adjuntardocs
	 *            Exception
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoDocArbComunicacion
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipoDocArbComunicacion)
			throws Exception;

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param adhid
	 *            String
	 */
	void addTramiteAdjuntarDocsComTableTemporal(String adhid);

	/**
	 * findDetalleEstablecimiento
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return EstablecimientoDetalle
	 */
	EstablecimientoDetalle findDetalleEstablecimiento(Arbadhsol arbadhsol);

	// /**
	// * actualizarDocumentoLocalizadorBBDD
	// *
	// * @param documentoXM
	// * Arbadhdoc
	// * @return Long
	// * @throws Exception
	// * excepcion
	// */
	// Long actualizarDocumentoLocalizadorBBDD(Arbadhdoc documentoXM)
	// throws Exception;

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Arbadhdoc>
	 */
	List<Arbadhdoc> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * findAllIntervinientes
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List
	 */
	List<Intervinientes> findAllIntervinientes(TramiteComun tramiteComun);

	/**
	 * @param tramiteComun
	 *            tramiteComun
	 * @return Intervinientes
	 */
	public Intervinientes findInterviniente(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @return List
	 */
	List<DatosMailOrigen> findAllMailOrigen(String idExpediente);

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param idExpediente
	 *            String
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @param mocodigoActual
	 *            String
	 * @return DatosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(String idExpediente, DatosMailOrigen datosMailOrigen, String mocodigoActual);

	/**
	 * findAllMailEstablecimiento
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun, String idInterviniente,
			Pagination pagination);

	/**
	 * findMailEstablecimiento
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento);

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param escodigo
	 *            escodigo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, String escodigo,
			Pagination pagination);

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede);

	/**
	 * bajaOficioValidacion
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return EstablecimientoDetalle
	 */
	EstablecimientoDetalle bajaOficioValidacion(Arbadhsol arbadhsol, CensoMonitor censoMonitor);

	/**
	 * registrarAdhFormulario
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param adjuntardocs
	 *            Adjuntardocs          
	 * @return Arbadhsol
	 */
	Arbadhsol registrarAdhFormulario(AdhesionTele adhesiontele, Adjuntardocs adjuntardocs) throws Exception;

}