package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadhintervDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.SectorDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbadhintervServiceImpl  
 * 
 *  
 */

@Service(value = "arbadhintervService")
public class ArbadhintervServiceImpl implements ArbadhintervService {

	@Autowired
	private ArbadhintervDao arbadhintervDao;

	@Autowired()
	private T17CalleDao t17CalleDao;

	@Autowired()
	private T17PortalDao t17PortalDao;

	@Autowired()
	private T17LocalidadDao t17LocalidadDao;

	@Autowired()
	private T17MunicipioDao t17MunicipioDao;

	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;

	@Autowired()
	private T17PortalService t17PortalService;

	@Autowired
	private EstablecimientoDao establecimientoDao;

	@Autowired
	private SedeDao sedeDao;
	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;
	@Autowired
	private SectorDao sectorDao;

	/**
	 * Inserts a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhinterv add(Arbadhinterv arbadhinterv) {
		return this.arbadhintervDao.add(arbadhinterv);
	}

	/**
	 * Updates a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhinterv update(Arbadhinterv arbadhinterv) {
		return this.arbadhintervDao.update(arbadhinterv);
	}

	/**
	 * Finds a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	public Arbadhinterv find(Arbadhinterv arbadhinterv) {
		arbadhinterv = this.arbadhintervDao.find(arbadhinterv);
		arbadhinterv.setDireccionCompleta(this.dameDireccionCompleta(arbadhinterv));
		return arbadhinterv;
	}

	/**
	 * Finds a List of rows in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbadhinterv> findAll(Arbadhinterv arbadhinterv, Pagination pagination) {
		List<Arbadhinterv> listaIntervinientes = this.arbadhintervDao.findAll(arbadhinterv, pagination);
		for (Arbadhinterv arbadhinterv2 : listaIntervinientes) {
			arbadhinterv2.setDireccionCompleta(this.dameDireccionCompleta(arbadhinterv2));
			arbadhinterv2.setCodTipointerv(arbadhinterv2.getUatipointerv());
		}
		return listaIntervinientes;
	}

	/**
	 * Counts rows in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @return Long
	 */
	public Long findAllCount(Arbadhinterv arbadhinterv) {
		return this.arbadhintervDao.findAllCount(arbadhinterv);
	}

	/**
	 * Finds rows in the Arbadhinterv table using like.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbadhinterv> findAllLike(Arbadhinterv arbadhinterv, Pagination pagination, Boolean startsWith) {
		return (List<Arbadhinterv>) this.arbadhintervDao.findAllLike(arbadhinterv, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbadhinterv table using like.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbadhinterv arbadhinterv, Boolean startsWith) {
		return this.arbadhintervDao.findAllLikeCount(arbadhinterv, startsWith);
	}

	/**
	 * Deletes a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbadhinterv arbadhinterv) {
		this.arbadhintervDao.remove(arbadhinterv);
	}

	/**
	 * Deletes multiple rows in the Arbadhinterv table.
	 * 
	 * @param arbadhintervList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbadhinterv> arbadhintervList) {
		for (Arbadhinterv arbadhintervAux : arbadhintervList) {
			this.arbadhintervDao.remove(arbadhintervAux);
		}
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameDireccionCompleta(Arbadhinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");
		direccion.append(this.dameLineaDireccion(arbinterb));

		/*
		 * if ((arbinterb.getUalocId() != null) && (arbinterb.getUamunId() !=
		 * null) && (arbinterb.getUaprovId() != null)) {
		 * direccion.append(dameLocalidad(arbinterb)); }
		 */

		if ((arbinterb.getUamunId() != null) && (arbinterb.getUaprovId() != null)) {
			direccion.append(this.dameMunicipio(arbinterb));
		}

		if (arbinterb.getUaprovId() != null) {
			direccion.append(this.dameProvincia(arbinterb));
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameLineaDireccion(Arbadhinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUadireNocapv())) {
			direccion.append(arbinterb.getUadireNocapv());
		} else if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUacalleId())) {
			String calle = "";
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(arbinterb.getUacalleId()), null)).getDsO();
			} catch (Exception e) {

			}
			if (Y41bUtils.esNullOCadenaVacia(calle)) {
				if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
					direccion.append(arbinterb.getUanodir());
				}
			} else {
				if (arbinterb.getUaportalId() != null) {
					t17portal.setId(Long.parseLong(arbinterb.getUaportalId()));
					t17portal.setCalleId(Long.parseLong(arbinterb.getUacalleId()));
					List<T17Portal> list = this.t17PortalService.findAll(t17portal, null);
					if (list != null && list.size() > 0) {
						t17portal = list.get(0);
						if (t17portal != null && t17portal.getPortal() != null) {
							direccion.append(" ")
									.append(Y41bUtils.componerDireccion(calle, t17portal.getBloque(),
											t17portal.getPortal(), 0, null, arbinterb.getUanombrePiso(),
											arbinterb.getUanodir()));
						} else if (t17portal != null && t17portal.getNumero() != 0) {
							direccion.append(calle);
							direccion.append(" ");
							direccion.append(t17portal.getNumero());
							if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
								direccion.append(" ").append(arbinterb.getUanodir());
							}
						} else {
							direccion.append(calle);
							if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
								direccion.append(" ").append(arbinterb.getUanodir());
							}
						}
					} else {
						direccion.append(calle);
						if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
							direccion.append(" ").append(arbinterb.getUanodir());
						}
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
						direccion.append(" ").append(arbinterb.getUanodir());
					}
				}
			}
		} else {
			if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUanodir())) {
				direccion.append(" ").append(arbinterb.getUanodir());
			}
		}
		return (direccion.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameCodigoPostal(Arbadhinterv arbinterb) {
		StringBuffer cp = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(arbinterb.getUaportalId())) {
			t17portal.setId(Long.parseLong(arbinterb.getUaportalId()));
			List<T17Portal> listat17portal = this.t17PortalDao.findAll(t17portal, null);

			if (listat17portal != null && listat17portal.size() > 0) {
				t17portal = listat17portal.get(0);
				return t17portal.getCodigoPostal();
			}

		}

		return (cp.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameLocalidad(Arbadhinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");
		String localidad = "";

		/* localidad */
		if ((arbinterb.getUalocId() != null) && (arbinterb.getUamunId() != null) && (arbinterb.getUaprovId() != null)) {
			T17Localidad localidadVO = this.t17LocalidadDao.find(new T17Localidad(arbinterb.getUalocId(), null,
					arbinterb.getUamunId(), arbinterb.getUaprovId(), null));
			if (localidadVO != null) {
				localidad = localidadVO.getDsO() == null ? "" : localidadVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(localidad);
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameMunicipio(Arbadhinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");

		String municipio = "";

		/* localidad */

		if ((arbinterb.getUamunId() != null) && (arbinterb.getUaprovId() != null)) {
			T17Municipio municipiodVO = (this.t17MunicipioDao
					.find(new T17Municipio(arbinterb.getUamunId(), arbinterb.getUaprovId(), null, null)));

			if (municipiodVO != null) {
				municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(municipio);
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbinterb
	 *            the arbinterb
	 * @return the string
	 */
	public String dameProvincia(Arbadhinterv arbinterb) {
		StringBuffer direccion = new StringBuffer("");

		String provincia = "";
		/* localidad */
		if (arbinterb.getUaprovId() != null) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(arbinterb.getUaprovId(), null, null)));

			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(provincia);

		}
		return (direccion.toString());
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public EstablecimientoDetalle findEstablecimiento(Arbadhinterv interviniente) {
		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle();
		Establecimiento estableci = null;
		Arbadhinterv arbadhinterv = null;
		if (interviniente.getUaidinterv() != null && this.arbadhintervDao.findAllCount(interviniente) > 0) {
			arbadhinterv = (Arbadhinterv) this.arbadhintervDao.find(interviniente);
			establecidetalle.setEscodigo(arbadhinterv.getUaescodigo());
			StringBuffer nombre = new StringBuffer("");
			nombre.append(arbadhinterv.getUanombre());
			if (!Y41bUtils.esNullOCadenaVacia(arbadhinterv.getUaapellido1())) {
				nombre.append(" ").append(arbadhinterv.getUaapellido1());
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbadhinterv.getUaapellido2())) {
				nombre.append(" ").append(arbadhinterv.getUaapellido2());
			}
			establecidetalle.setEsnombre(nombre.toString());
			establecidetalle.setEsnif(arbadhinterv.getUanif());
			establecidetalle.setEsnrtel(arbadhinterv.getUanrtel());
			establecidetalle.setEsnrtel2(arbadhinterv.getUanrtel2());
			establecidetalle.setEscoem(arbadhinterv.getUacoem());
			establecidetalle.setEsnoraPaisId(arbadhinterv.getUapaisId());
			establecidetalle.setProvinciaId(arbadhinterv.getUaprovId());
			establecidetalle.setMunicipioId(arbadhinterv.getUamunId());
			establecidetalle.setLocalidadId(arbadhinterv.getUalocId());
			establecidetalle.setCalleId(arbadhinterv.getUacalleId());
			establecidetalle.setCpId(arbadhinterv.getUacpId());
			establecidetalle.setEsnombreCp(this.dameCodigoPostal(arbadhinterv));
			establecidetalle.setPortalId(arbadhinterv.getUaportalId());
			establecidetalle.setEsnombrePiso(arbadhinterv.getUanombrePiso());
			establecidetalle.setEsdireccion_nocapv(arbadhinterv.getUadireNocapv());
			establecidetalle.setEsfemod(arbadhinterv.getUafecultmod());
			establecidetalle.setMocodigo(arbadhinterv.getUausuultmod());
			establecidetalle.setMousu(arbadhinterv.getUsuarioxlnet());
			establecidetalle.setEsnopeco(arbadhinterv.getUanopeco());
			establecidetalle.setEsnoco(arbadhinterv.getUanoco());
			establecidetalle.setEsteurl(arbadhinterv.getUaurl());
			establecidetalle.setSecodigo(arbadhinterv.getUasecodigo());
			if (!Y41bUtils.esNullOCadenaVacia(arbadhinterv.getUasecodigo())) {
				Sector sector = new Sector(arbadhinterv.getUasecodigo());
				if (this.sectorDao.findAllCount(sector) > 0L) {
					sector = this.sectorDao.find(sector);
					establecidetalle.setSenombre(sector.getSenombre());
					establecidetalle.setSenombree(sector.getSenombree());
				}
			}
			establecidetalle.setEscoidco(arbadhinterv.getUaidioma());
			establecidetalle.setEsdireccionCompleta(this.dameDireccionCompleta(arbadhinterv));

			String calle = "";
			if (!Y41bUtils.esNullOCadenaVacia(establecidetalle.getCalleId())) {
				try {
					calle = this.t17CalleDao
							.findCalleConTipoVia(new T17Calle(Long.parseLong(establecidetalle.getCalleId()), null))
							.getDsO();
				} catch (Exception e) {

				}
				establecidetalle.setCalleId_label(calle);
			}

		}

		if (!Y41bUtils.esNullOCadenaVacia(establecidetalle.getEscodigo())) {
			estableci = (Establecimiento) this.establecimientoDao
					.find(new Establecimiento(arbadhinterv.getUaescodigo()));
			establecidetalle.setDireccionAntiguaCompleta(this.dameDireccionAntigua(estableci));
			establecidetalle.setEssede(estableci.getEssede());
			establecidetalle.setEsfeadar(estableci.getEsfeadar());
			establecidetalle.setEsintiar(estableci.getEsintiar());

			establecidetalle.setEscooe(estableci.getEscooe());
			establecidetalle.setEsnorep(estableci.getEsnorep());
			establecidetalle.setEsnifrep(estableci.getEsnifrep());
			establecidetalle.setEsfeerd(estableci.getEsfeerd());
			establecidetalle.setEsfeba(estableci.getEsfeba());
			establecidetalle.setEsteco(estableci.getEsteco());

			// Mail de avisos
			establecidetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
				establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
				establecidetalle.setAhfere(establecimArbitra.getAhfere());
				establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
				establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
				establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
				establecidetalle.setEsinadar(estableci.getEsinadar());
				establecidetalle.setAhindef(establecimArbitra.getAhindef());
				establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
				establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
				if ("A".equals(estableci.getEsinadar())) {
					if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
						establecidetalle.setEsinadar("L");
					}
				}
			} catch (Exception e) {

			}
			// buscar sedes
			if (estableci.getEssede() != null && estableci.getEssede().equals(Y41bConstantes.SI)) {
				Sede sede = new Sede();
				sede.setEscodigo(estableci.getEscodigo());

				List<Sede> listSede = this.sedeDao.findAll(sede, null);
				establecidetalle.setSedes(listSede);
			}
			List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

			StringBuffer strIdsDescriptores = new StringBuffer();
			StringBuffer strDescsDescriptores = new StringBuffer();

			strDescsDescriptores.append("[");

			boolean firstElement = true;

			// se recorre para obtener los ids de etiquetas
			for (Descriptor descriptor : listDescriptor) {
				if (firstElement) {
					strIdsDescriptores.append(descriptor.getIdDescriptor());
					strDescsDescriptores.append(descriptor.getNombre());
					firstElement = false;
				} else {
					strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
					strDescsDescriptores.append(",").append(descriptor.getNombre());
				}
			}
			strDescsDescriptores.append("]");

			establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
			establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());
		}

		return establecidetalle;
	}

	/**
	 * 
	 * @param estableci
	 *            Establecimiento
	 * @return String
	 */
	public String dameDireccionAntigua(Establecimiento estableci) {
		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String escomapv = (estableci.getEscomapv() == null) ? "" : estableci.getEscomapv();
		String esnomu = (estableci.getEsnomu() == null) ? "" : estableci.getEsnomu();
		String esnolo = (estableci.getEsnolo() == null) ? "" : estableci.getEsnolo();
		String esnodir = (estableci.getEsnodir() == null) ? "" : estableci.getEsnodir();
		String esnrcopo = (estableci.getEsnrcopo() == null) ? "" : estableci.getEsnrcopo();

		direccionAntiguaCompleta.append(escomapv).append(" ").append(esnomu).append(" ").append(esnolo).append(" ")
				.append(esnodir).append(" ").append(esnrcopo);
		return direccionAntiguaCompleta.toString();
	}

	/**
	 * Dame reclamado.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbadhinterv
	 */
	public Arbadhinterv dameInterviniente(String sacodigo, String tipo) {
		Arbadhinterv arbadhinterv = this.arbadhintervDao.dameInterviniente(sacodigo, tipo);
		if (arbadhinterv != null) {
			arbadhinterv.setDireccionCompleta(this.dameDireccionCompleta(arbadhinterv));

		}
		return arbadhinterv;
	}

	/**
	 * @param intervinientes
	 * @param pagination
	 * @return
	 */
	public List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes, Pagination pagination) {
		return (List<Intervinientes>) this.arbadhintervDao.findAllIntervinientes(intervinientes, pagination);
	}
}
