package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;

/**
 * ArbadhintervService  
 * 
 *  
 */

public interface ArbadhintervService {

	/**
	 * Inserts a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv add(Arbadhinterv arbinterv);

	/**
	 * Updates a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv update(Arbadhinterv arbinterv);

	/**
	 * Finds a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv find(Arbadhinterv arbinterv);

	/**
	 * Finds a List of rows in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhinterv> findAll(Arbadhinterv arbinterv, Pagination pagination);

	/**
	 * Counts rows in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Long
	 */
	Long findAllCount(Arbadhinterv arbinterv);

	/**
	 * Finds rows in the Arbadhinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhinterv> findAllLike(Arbadhinterv arbinterv,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbadhinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhinterv arbinterv, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return
	 */
	void remove(Arbadhinterv arbinterv);

	/**
	 * Deletes multiple rows in the Arbadhinterv table.
	 * 
	 * @param arbintervList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbadhinterv> arbintervList);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	EstablecimientoDetalle findEstablecimiento(Arbadhinterv intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbadhinterv
	 */
	Arbadhinterv dameInterviniente(String sacodigo, String tipo);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbadhinterv
	 *            the arbadhinterv
	 * @return the string
	 */
	String dameDireccionCompleta(Arbadhinterv arbadhinterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbadhinterv
	 *            the arbadhinterv
	 * @return the string
	 */
	String dameLineaDireccion(Arbadhinterv arbadhinterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbadhinterv
	 *            the arbadhinterv
	 * @return the string
	 */
	String dameCodigoPostal(Arbadhinterv arbadhinterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbadhinterv
	 *            the arbadhinterv
	 * @return the string
	 */
	String dameLocalidad(Arbadhinterv arbadhinterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbadhinterv
	 *            the arbadhinterv
	 * @return the string
	 */
	String dameMunicipio(Arbadhinterv arbadhinterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbadhinterv
	 *            the arbadhinterv
	 * @return the string
	 */
	String dameProvincia(Arbadhinterv arbadhinterv);

	/**
	 * @param intervinientes
	 * @param object
	 * @return
	 */
	List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes,
			Pagination pagination);

}
