package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadhdocDao;
import com.ejie.y41b.dao.ArbadhsolDao;

import java.sql.Blob;
import java.util.List;

import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * ArbadhdocServiceImpl  
 * 
 *  
 */

@Service(value = "arbadhdocService")
public class ArbadhdocServiceImpl implements ArbadhdocService {

	@Autowired
	private ArbadhdocDao arbadhdocDao;
	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;
	@Autowired
	private ArbadhsolDao arbadhsolDao;

	/**
	 * Inserts a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhdoc add(Arbadhdoc arbadhdoc) {
		return this.arbadhdocDao.add(arbadhdoc);
	}

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbadhdoc update(Arbadhdoc arbadhdoc) {
		return this.arbadhdocDao.update(arbadhdoc);
	}

	/**
	 * Finds a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public Arbadhdoc find(Arbadhdoc arbadhdoc) throws Exception {
		arbadhdoc = (Arbadhdoc) this.arbadhdocDao.find(arbadhdoc);
		String tipoProcedimientoPlatea = "";
		Arbadhsol arbadhsol = this.arbadhsolDao.find(new Arbadhsol(arbadhdoc
				.getX5excodigo()));
		if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
			tipoProcedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
			tipoProcedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
				|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol
						.getAdhtipo())) {
			tipoProcedimientoPlatea = Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		}

		if (arbadhdoc != null && arbadhdoc.getX5iddocumentum() != null
				&& !arbadhdoc.getX5iddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(tipoProcedimientoPlatea);
			documento.setProcedure(procedure);
			documento.setOidDokusi(arbadhdoc.getX5iddocumentum());

			Documento docDokusi = y41bDokusiAdapterService
					.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			arbadhdoc.setX5datafile(blob);
			arbadhdoc.setX5conttype(docDokusi.getContentType());
			arbadhdoc.setX5nofile(Y41bUtils.getNameFileDokusi(docDokusi
					.getNombre()));
			arbadhdoc
					.setX5sizefile(Integer.valueOf((int) docDokusi.getLength()));
		}
		return arbadhdoc;
	}

	/**
	 * Finds a List of rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbadhdoc> findAll(Arbadhdoc arbadhdoc, Pagination pagination) {
		return (List<Arbadhdoc>) this.arbadhdocDao.findAll(arbadhdoc,
				pagination);
	}

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Long
	 */
	public Long findAllCount(Arbadhdoc arbadhdoc) {
		return this.arbadhdocDao.findAllCount(arbadhdoc);
	}

	/**
	 * Finds rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbadhdoc> findAllLike(Arbadhdoc arbadhdoc,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbadhdoc>) this.arbadhdocDao.findAllLike(arbadhdoc,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbadhdoc arbadhdoc, Boolean startsWith) {
		return this.arbadhdocDao.findAllLikeCount(arbadhdoc, startsWith);
	}

	/**
	 * Deletes a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbadhdoc arbadhdoc) {
		this.arbadhdocDao.remove(arbadhdoc);
	}

	/**
	 * Deletes multiple rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdocList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbadhdoc> arbadhdocList) {
		for (Arbadhdoc arbadhdocAux : arbadhdocList) {
			this.arbadhdocDao.remove(arbadhdocAux);
		}
	}

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Arbadhdoc>
	 */
	public List<Arbadhdoc> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("arbtipdoc.tdnombree")) {
				pagination.setSort("arbtipdoctdnombre");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("arbtipdoc.tdnombre")) {
				pagination.setSort("arbtipdoctdnombre");
			}
		}
		return this.arbadhdocDao.findAllDocumentosTramite(tramiteComun,
				pagination);
	}

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		return this.arbadhdocDao.findAllDocumentosTramiteCount(tramiteComun);
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addArbAdhAdjuntarDocs(TramiteComun tramiteComun) {
		this.arbadhdocDao.addArbAdhAdjuntarDocs(tramiteComun);
	}

	/**
	 * 
	 * @return Integer
	 */
	public Long getNewPK() {
		return this.arbadhdocDao.getNewPK();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.ArbadhdocService#findAllDocsSolicitud(java.lang
	 * .String, java.lang.String, java.lang.Object)
	 */
	@Override
	public List<Arbadhdoc> findAllDocsSolicitud(String tipo, String adhid,
			Pagination pagination) {
		return this.arbadhdocDao.findAllDocumentosSolicitud(tipo, adhid,
				pagination);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.ArbadhdocService#findAllDocsSolicitudCount(java
	 * .lang.String, java.lang.String, java.lang.Object)
	 */
	@Override
	public Long findAllDocsSolicitudCount(String tipo, String adhid) {
		// TODO Auto-generated method stub
		return this.arbadhdocDao.findAllDocumentosSolicitudCount(tipo, adhid);
	}
}
