package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbadhdocService  
 * 
 *  
 */

public interface ArbadhdocService {

	/**
	 * Inserts a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoco
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc add(Arbadhdoc arbadhdoc);

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc update(Arbadhdoc arbadhdoc);

	/**
	 * Finds a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc find(Arbadhdoc arbadhdoc) throws Exception;

	/**
	 * Finds a List of rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhdoc> findAll(Arbadhdoc arbadhdoc, Pagination pagination);

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Long
	 */
	Long findAllCount(Arbadhdoc arbadhdoc);

	/**
	 * Finds rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhdoc> findAllLike(Arbadhdoc arbadhdoc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhdoc arbadhdoc, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return
	 */
	void remove(Arbadhdoc arbadhdoc);

	/**
	 * Deletes multiple rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdocList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbadhdoc> arbadhdocList);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Arbdoctemp>
	 */
	List<Arbadhdoc> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addArbAdhAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * @param tipo
	 * @param adhid
	 * @param pagination
	 * @return
	 */
	List<Arbadhdoc> findAllDocsSolicitud(String tipo, String adhid,
			Pagination pagination);

	/**
	 * @param tipo
	 * @param adhid
	 * @return
	 */
	Long findAllDocsSolicitudCount(String tipo, String adhid);
}
