// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.io.StringReader;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjuntarAlertaprograDao;
import com.ejie.y41b.dao.AdjuntarDistribuidorDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.AlertaDao;
import com.ejie.y41b.dao.AlertaProgramacionDao;
import com.ejie.y41b.dao.BandejaAlertaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DistribuidorDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.HistorialAlertaDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.NaturalezaPeligroDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.T17AutonomiaDao;
import com.ejie.y41b.dao.T17PaisDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarAlertaprogra;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Distribuidor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NaturalezaPeligro;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteINSDetalle;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.T17Autonomia;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AlertaServiceImpl  
 * 
 *  
 */

@Service(value = "alertaService")
public class AlertaServiceImpl implements AlertaService {

	private static final Logger logger = LoggerFactory.getLogger(AlertaServiceImpl.class);

	@Autowired
	private AlertaDao alertaDao;
	@Autowired
	private DistribuidorDao distribuidorDao;
	@Autowired
	private AdjuntarDistribuidorDao adjuntarDistribuidorDao;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired
	private AlertaProgramacionDao alertaProgramacionDao;
	@Autowired
	private AdjuntarAlertaprograDao adjuntarAlertaprograDao;
	@Autowired
	private IntervinientesDao intervinientesDao;
	@Autowired
	private EstablecimientoDao establecimientoDao;
	@Autowired
	private EstablecimSectorDao establecimSectorDao;
	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;
	@Autowired
	private HistorialAlertaDao historialAlertaDao;
	@Autowired
	private T17AutonomiaDao t17AutonomiaDao;
	@Autowired
	private T17PaisDao t17PaisDao;
	@Autowired
	private BandejaAlertaDao bandejaAlertaDao;
	@Autowired
	private NaturalezaPeligroDao naturalezaPeligroDao;
	@Autowired
	private InspeccionService inspeccionService;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;
	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private CensoMonitorDao censoMonitorDao;
	@Autowired
	private OrganismoDao organismoDao;
	@Autowired
	private InstramexpService instramexpService;
	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta add(Alerta alerta) {
		return this.alertaDao.add(alerta);
	}

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codAlertaAlta
	 *            String
	 * @return Campanha
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta addAlerta(Alerta alerta, String codAlertaAlta) throws Exception {
		try {

			if (alerta.getAlorigenproducto() != null
					&& alerta.getAlorigenproducto().equals(Y41bConstantes.ORIGEN_PRODUCTO_CCAA)) {
				alerta.setAlpaisproducto(Y41bConstantes.COD_PAIS_ESTADO);
			}
			this.alertaDao.add(alerta);

			HistorialAlerta historialAlerta = new HistorialAlerta();
			historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			historialAlerta.setCodigo(alerta.getAlcodigo());
			historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
			historialAlerta.setOrganismodestino(null);
			historialAlerta.setDescripcion(Y41bConstantes.CREACION_ALERTA);
			historialAlerta.setGenerado(Y41bConstantes.SI);
			historialAlerta.setFecha(new Date());

			this.historialAlertaDao.add(historialAlerta);

			if (alerta.getAlanulada() != null && alerta.getAlanulada().equals(Y41bConstantes.SI)) {
				historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(alerta.getAlcodigo());
				historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setOrganismodestino(null);
				historialAlerta.setDescripcion(Y41bConstantes.ANULACION_ALERTA);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(new Date());

				this.historialAlertaDao.add(historialAlerta);
			}

			if (alerta.getAlerta() != null && Y41bUtils.isFilled(alerta.getAlerta().getAlcodigo())) {
				Alerta alertaRelacionada = new Alerta();
				alertaRelacionada.setAlerta(alerta);
				alertaRelacionada.setAlcodigo(alerta.getAlerta().getAlcodigo());
				this.alertaDao.updateAlertaRelacionada(alertaRelacionada);
			}

			if (alerta.getAnyadirPlantilla() == null) {
				// buscar los distribuidores de la tabla temporal
				AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor();
				adjuntarDistribuidor.setRdcoal(codAlertaAlta);
				List<AdjuntarDistribuidor> listAdjuntarDistribuidor = this.adjuntarDistribuidorDao
						.findAll(adjuntarDistribuidor, null);

				for (AdjuntarDistribuidor adjuntarDistribuidorAux : listAdjuntarDistribuidor) {
					Establecimiento establecimiento = new Establecimiento();
					establecimiento.setEscodigo(adjuntarDistribuidorAux.getRdcoes());

					establecimiento = this.establecimientoDao.find(establecimiento);

					EstablecimSector establecimSector = new EstablecimSector();
					establecimSector.setEstablecimiento(establecimiento);

					EstablecimSector establecSector = new EstablecimSector();
					Actividad actividad = new Actividad();
					Sector sector = new Sector();
					establecSector.setActividad(actividad);
					establecSector.setSector(sector);

					establecSector = (EstablecimSector) this.establecimSectorDao
							.findSectorEstablecimiento(establecimSector);

					try {
						EstablecimArbitra establecimArbitra = new EstablecimArbitra();
						establecimArbitra.setEstablecimiento(new Establecimiento());
						establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
						establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
						if (establecimArbitra != null) {
							if ("A".equals(establecimiento.getEsinadar())) {
								if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
									establecimiento.setEsinadar("L");
								}
							}
						}
					} catch (Exception e) {

					}

					Intervinientes intervinientes = new Intervinientes(
							Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTE_DISTRIBUIDOR, alerta.getAlcodigo(), null,
							establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					// por cada uno insertar el interviniente
					this.intervinientesDao.add(intervinientes);

					// por cada uno actualizar el campo RDIDINTERVINIENTE de la
					// tabla temporal
					adjuntarDistribuidorAux.setRdidinterviniente(intervinientes.getIdinterviniente());
					this.adjuntarDistribuidorDao.update(adjuntarDistribuidorAux);
				}

				this.distribuidorDao.addAllAlertaDistribuidor(alerta, codAlertaAlta);

				this.documentoHechoDao.addAllDocumentosAdjuntarDocs(alerta.getAlcodigo(), codAlertaAlta);

				this.alertaProgramacionDao.addAllAlertaProgramacion(alerta, codAlertaAlta);

				// buscar las programaciones de la alerta
				AlertaProgramacion alertaProgramacion = new AlertaProgramacion();
				Alerta alertaAux = new Alerta();
				alertaAux.setAlcodigo(alerta.getAlcodigo());
				alertaProgramacion.setAlerta(alertaAux);
				List<AlertaProgramacion> listAlertaProgramacion = this.alertaProgramacionDao.findAll(alertaProgramacion,
						null);

				Locale locale = LocaleContextHolder.getLocale();
				Date today = new Date();
				Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

				if (listAlertaProgramacion != null && listAlertaProgramacion.size() > 0) {
					BandejaAlerta bandejaAlerta = null;
					Integer totalNumInspecciones = 0;
					Date fechaComunicacion = null;
					for (AlertaProgramacion alertaProgramacionAux : listAlertaProgramacion) {

						if (alertaProgramacionAux.getCracuerdoinicio() != null
								&& alertaProgramacionAux.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
							// Insertar los documentos de as programaciones
							this.documentoHechoDao.addAllDocumentosAdjuntarDocs(alertaProgramacionAux.getCrcodigo(),
									alertaProgramacionAux.getCrcodigo());
						}

						this.adjuntardocsDao.removeAllDocsTableTemporal(alertaProgramacionAux.getCrcodigo());

						// Insertar historial
						historialAlerta = new HistorialAlerta();
						historialAlerta
								.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						historialAlerta.setCodigo(alerta.getAlcodigo());
						historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
						historialAlerta.setOrganismodestino(alertaProgramacionAux.getCrcoor());
						historialAlerta.setDescripcion(Y41bConstantes.ENVIO_PROGRAMACION);
						historialAlerta.setGenerado(Y41bConstantes.SI);
						historialAlerta.setFecha(new Date());

						this.historialAlertaDao.add(historialAlerta);

						// insertar la programacin en la bandeja de alertas
						bandejaAlerta = new BandejaAlerta();
						bandejaAlerta.setV5codigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						bandejaAlerta.setAlcodigo(alertaProgramacionAux.getAlerta().getAlcodigo());
						bandejaAlerta.setCrcodigo(alertaProgramacionAux.getCrcodigo());
						bandejaAlerta.setCrcodigodistribuidor(alertaProgramacionAux.getDistribuidor().getRdcodigo());
						bandejaAlerta.setCrcoor(alertaProgramacionAux.getCrcoor());
						bandejaAlerta.setCrfechacomunicacion(alertaProgramacionAux.getCrfechacomunicacion());
						bandejaAlerta.setCrcnactu(alertaProgramacionAux.getCrcnactu());

						this.bandejaAlertaDao.add(bandejaAlerta);

						totalNumInspecciones += alertaProgramacionAux.getCrcnactu();

						if (fechaComunicacion == null) {
							fechaComunicacion = alertaProgramacionAux.getCrfechacomunicacion();
						} else if (fechaComunicacion.before(alertaProgramacionAux.getCrfechacomunicacion())) {
							fechaComunicacion = alertaProgramacionAux.getCrfechacomunicacion();
						}

						// Generar las inspecciones
						if (alertaProgramacionAux.getCrcnactu() > 0) {
							for (int i = 0; i < alertaProgramacionAux.getCrcnactu(); i++) {
								InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
								inspeccionDetalle.setAcfere(todayWithZeroTime);
								inspeccionDetalle.setAtcoal(alertaProgramacionAux.getAlerta().getAlcodigo());
								inspeccionDetalle.setAtcocr(alertaProgramacionAux.getCrcodigo());
								inspeccionDetalle.setAdcoor(alertaProgramacionAux.getCrcoor());
								inspeccionDetalle.setAccoor(alertaProgramacionAux.getCrcoor());
								inspeccionDetalle.setAtcoes(alertaProgramacionAux.getDistribuidor().getRdcoes());

								inspeccionDetalle
										.setAtinspeccionsolicitada(alertaProgramacionAux.getCrinspeccionsolicitada());

								inspeccionDetalle.setAtcops(alerta.getAlcops());
								inspeccionDetalle.setAtnoprse(alerta.getAlnoprse());
								inspeccionDetalle.setAtnomaps(alerta.getAlnomaps());
								inspeccionDetalle.setAtnomops(alerta.getAlnomops());
								inspeccionDetalle.setAtnrlops(alerta.getAlnrlops());
								inspeccionDetalle.setAtcodigobarras(alerta.getAlcodigobarras());
								inspeccionDetalle.setAtfedumi(alerta.getAlfedumi());

								if (alertaProgramacionAux.getCracuerdoinicio() != null
										&& alertaProgramacionAux.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
									inspeccionDetalle.setAtacuerdoinicio(Y41bConstantes.VALOR_SI);
									inspeccionDetalle.setAccoes(alertaProgramacionAux.getDistribuidor().getRdcoes());
									inspeccionDetalle.setAtformanotifestablecimientovi(
											Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
								}

								this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
							}
						}
					}

					// Insertar la bandeja de alertas para SSCC
					bandejaAlerta = new BandejaAlerta();
					bandejaAlerta.setV5codigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					bandejaAlerta.setAlcodigo(alerta.getAlcodigo());

					bandejaAlerta.setCrcodigo(null);
					bandejaAlerta.setCrcodigodistribuidor(null);
					bandejaAlerta.setCrcoor(null);

					bandejaAlerta.setCrfechacomunicacion(fechaComunicacion);
					bandejaAlerta.setCrcnactu(totalNumInspecciones);

					this.bandejaAlertaDao.add(bandejaAlerta);
				}

				this.adjuntarAlertaprograDao.removeAllAlertaprogra(alertaAux);
				this.adjuntarDistribuidorDao.removeAllAlertaDistribuidor(alertaAux);
				this.adjuntardocsDao.removeAllDocsTableTemporal(codAlertaAlta);
			}

			return alerta;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.alerta.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta update(Alerta alerta) {
		return this.alertaDao.update(alerta);
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta updateAlerta(Alerta alerta) throws Exception {

		try {
			// Si tiene expedientes abiertos se lanza error
			if (alerta != null && alerta.getAlerta() != null
					&& alerta.getAlcodigo().equals(alerta.getAlerta().getAlcodigo())) {
				throw new Y41bUDAException("error.alerta.AlertaRelacionadaException", true, new Exception());
			}

			// Buscar alerta
			Alerta alertaBBDD = this.alertaDao.find(alerta);

			if (!alertaBBDD.getAlnror().equals(alerta.getAlnror())
					|| !alertaBBDD.getAlnran().equals(alerta.getAlnran())) {
				HistorialAlerta historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(alerta.getAlcodigo());
				historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setOrganismodestino(null);
				historialAlerta.setDescripcion(Y41bConstantes.RECALIFICACION_ALERTA);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(new Date());

				this.historialAlertaDao.add(historialAlerta);
			}

			if ((alertaBBDD.getAlanulada() == null || alertaBBDD.getAlanulada().equals(Y41bConstantes.NO))
					&& alerta.getAlanulada() != null && alerta.getAlanulada().equals(Y41bConstantes.SI)) {

				this.procesarAnulacionAlerta(alerta);
			}

			if ((alertaBBDD.getAlactiva() != null && alertaBBDD.getAlactiva().equals(Y41bConstantes.SI))
					&& alerta.getAlactiva() != null && alerta.getAlactiva().equals(Y41bConstantes.NO)) {

				AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
				adjuntarAlertaprogra.setCrcoal(alerta.getAlcodigo());

				List<AdjuntarAlertaprogra> listAdjuntarAlertaprogra = this.adjuntarAlertaprograDao
						.findAll(adjuntarAlertaprogra, null);

				for (AdjuntarAlertaprogra adjuntarAlertaprograAux : listAdjuntarAlertaprogra) {
					if (adjuntarAlertaprograAux.getCrfechacierre() == null) {
						throw new Y41bUDAException("error.alerta.CierreException", true, new Exception());
					}
				}

				HistorialAlerta historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(alerta.getAlcodigo());
				historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setOrganismodestino(null);
				historialAlerta.setDescripcion(Y41bConstantes.CIERRE_ALERTA);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(new Date());

				this.historialAlertaDao.add(historialAlerta);
			}

			if ((alertaBBDD.getAlactiva() == null || alertaBBDD.getAlactiva().equals(Y41bConstantes.NO))
					&& alerta.getAlactiva() != null && alerta.getAlactiva().equals(Y41bConstantes.SI)) {
				HistorialAlerta historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(alerta.getAlcodigo());
				historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setOrganismodestino(null);
				historialAlerta.setDescripcion(Y41bConstantes.REAPERTURA_ALERTA);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(new Date());

				this.historialAlertaDao.add(historialAlerta);
			}

			if (alerta.getAlorigenproducto() != null
					&& alerta.getAlorigenproducto().equals(Y41bConstantes.ORIGEN_PRODUCTO_CCAA)) {
				alerta.setAlpaisproducto(Y41bConstantes.COD_PAIS_ESTADO);
			}

			this.alertaDao.update(alerta);

			if (alerta.getAlerta() != null && Y41bUtils.isFilled(alerta.getAlerta().getAlcodigo())) {
				Alerta alertaRelacionada = new Alerta();
				alertaRelacionada.setAlerta(alerta);
				alertaRelacionada.setAlcodigo(alerta.getAlerta().getAlcodigo());
				this.alertaDao.updateAlertaRelacionada(alertaRelacionada);
			}

			/**************************************************************************/

			if (alerta.getAnyadirPlantilla() == null) {
				// obtener las programaciones eliminadas
				List<AlertaProgramacion> listAlertaProgramacionEliminadas = this.alertaProgramacionDao
						.findAllAlertaProgramacionEliminadas(alerta, null);

				Actuacion actuacion = null;
				InspeccionDetalle inspeccionDetalleAux = null;
				BandejaAlerta bandejaAlertaAux = null;
				DocumentoHecho documentoHechoAux = null;
				for (AlertaProgramacion alertaProgramacionAux : listAlertaProgramacionEliminadas) {
					documentoHechoAux = new DocumentoHecho();
					documentoHechoAux.setQ5hdcodigo(alertaProgramacionAux.getCrcodigo());
					this.documentoHechoDao.removeDocsExpediente(documentoHechoAux);

					// buscar la programacion
					actuacion = new Actuacion();
					actuacion.setAtcocr(alertaProgramacionAux.getCrcodigo());
					Long numInspeccionesIniciada = this.tramiteInspeccionDao
							.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);

					// Si tiene expedientes abiertos se lanza error
					if (numInspeccionesIniciada > 0) {
						throw new Y41bUDAException("error.alerta.InspeccionesAbiertasException", true, new Exception());
					}

					// eliminar las inspeccion si no est iniciada
					// buscar las inspecciones de la programacion
					List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacion, null);

					for (Actuacion actuacionAux : listActuacion) {
						inspeccionDetalleAux = new InspeccionDetalle();
						inspeccionDetalleAux.setAtcodigo(actuacionAux.getAtcodigo());
						inspeccionDetalleAux.setAccodigo(actuacionAux.getActa().getAccodigo());
						this.inspeccionService.removeInspeccion(inspeccionDetalleAux);
					}

					// eliminar de la bandeja
					bandejaAlertaAux = new BandejaAlerta();
					bandejaAlertaAux.setCrcodigo(alertaProgramacionAux.getCrcodigo());

					this.bandejaAlertaDao.removeBandejaAlertaProgramacion(bandejaAlertaAux);
				}

				// Busca programaciones en la temporal que no estan en la
				// definitiva para guardarlas luego en la bandeja.
				AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
				adjuntarAlertaprogra.setCrcoal(alerta.getAlcodigo());
				List<AdjuntarAlertaprogra> listAdjuntarAlertaprograNuevas = this.adjuntarAlertaprograDao
						.findAllAlertaProgramacionNuevas(adjuntarAlertaprogra, null);

				// Busca programaciones en la temporal que estan en la
				// definitiva para actualizarlas.
				List<AdjuntarAlertaprogra> listAdjuntarAlertaprograExistentes = this.adjuntarAlertaprograDao
						.findAllAlertaProgramacionExistentes(adjuntarAlertaprogra, null);

				// Borra las programaciones definitivas que no estan en la tabla
				// temporal.
				// Si casca, es que estan tienen relaciones (siempre falla
				// porque
				// estan en la bandeja).
				try {
					this.alertaProgramacionDao.removeAlertaprograNoAdjunta(alerta);
				} catch (Exception e) {
					throw new Y41bUDAException("error.alerta.DataIntegrityViolationExceptionProgDel", true, e);
				}

				List<Distribuidor> listDistribuidorEliminados = this.distribuidorDao
						.findAllDistribuidoresEliminados(alerta, null);

				// Borra los distribuidores que esten en la definitiva pero no
				// esten
				// en la temporal.
				try {
					this.distribuidorDao.removeAllAlertaDistribuidor(alerta);
				} catch (Exception e) {
					throw new Y41bUDAException("error.alerta.DataIntegrityViolationExceptionDistDel", true, e);
				}

				// buscar los distribuidores que estan en la definitiva y no en
				// la temporal
				// y eliminar el interviniente
				Intervinientes intervinientes = null;
				for (Distribuidor distribuidorAux : listDistribuidorEliminados) {
					intervinientes = new Intervinientes();
					intervinientes.setIdinterviniente(distribuidorAux.getRdidinterviniente());
					this.intervinientesDao.remove(intervinientes);
				}

				// Inserta los distribuidores de la temporal a la definitiva.
				try {
					this.distribuidorDao.addAllAlertaDistribuidor(alerta, alerta.getAlcodigo());
				} catch (Exception e) {
					throw new Y41bUDAException("error.alerta.DataIntegrityViolationExceptionDistIns", true, e);
				}

				// Inserta las programaciones que estan en la temporal pero no
				// en la
				// definitiva.
				try {
					this.alertaProgramacionDao.addAllAlertaProgramacion(alerta, alerta.getAlcodigo());
				} catch (Exception e) {
					throw new Y41bUDAException("error.alerta.DataIntegrityViolationExceptionProgIns", true, e);
				}

				// Listar distribuidores de la tabla temporal
				AdjuntarDistribuidor adjuntarDistribuidor = new AdjuntarDistribuidor();
				adjuntarDistribuidor.setRdcoal(alerta.getAlcodigo());
				List<AdjuntarDistribuidor> listAdjuntarDistribuidor = this.adjuntarDistribuidorDao
						.findAll(adjuntarDistribuidor, null);

				// actualizar todos los distribuidores en la tabla definitiva a
				// Fabricante = 'N'
				this.distribuidorDao.updateRemoveAllFabricante(adjuntarDistribuidor);

				// for para buscar el distribuidor con Fabricante a 'S'.
				// actualizar el distribuidor en la tabla definitiva y ponerle
				// el
				// fabricante a 'S'.
				AdjuntarDistribuidor distribuidorFabricante = null;
				for (AdjuntarDistribuidor distribuidoresTemporal : listAdjuntarDistribuidor) {
					if (distribuidoresTemporal.getRdfabricante() != null
							&& Y41bConstantes.VALOR_SI.equals(distribuidoresTemporal.getRdfabricante())) {
						distribuidorFabricante = distribuidoresTemporal;
					}
				}

				if (distribuidorFabricante != null) {
					this.distribuidorDao.updateAlertaFabricanteDistribuidor(distribuidorFabricante);
				}

				/**************************************************************************/

				DocumentoHecho documentoHecho = new DocumentoHecho();
				documentoHecho.setQ5hdcodigo(alerta.getAlcodigo());
				this.documentoHechoDao.removeDocsExpediente(documentoHecho);

				this.documentoHechoDao.addAllDocumentosAdjuntarDocs(alerta.getAlcodigo(), alerta.getAlcodigo());

				this.adjuntardocsDao.removeAllDocsTableTemporal(alerta.getAlcodigo());

				// Busca los distribuidores de la tabla temporal y los aniade a
				// la
				for (AdjuntarDistribuidor adjuntarDistribuidorAux : listAdjuntarDistribuidor) {
					if (!Y41bUtils.isFilled(adjuntarDistribuidorAux.getRdidinterviniente())) {
						Establecimiento establecimiento = new Establecimiento();
						establecimiento.setEscodigo(adjuntarDistribuidorAux.getRdcoes());

						establecimiento = this.establecimientoDao.find(establecimiento);

						EstablecimSector establecimSector = new EstablecimSector();
						establecimSector.setEstablecimiento(establecimiento);

						EstablecimSector establecSector = new EstablecimSector();
						Actividad actividad = new Actividad();
						Sector sector = new Sector();
						establecSector.setActividad(actividad);
						establecSector.setSector(sector);

						establecSector = (EstablecimSector) this.establecimSectorDao
								.findSectorEstablecimiento(establecimSector);

						try {
							EstablecimArbitra establecimArbitra = new EstablecimArbitra();
							establecimArbitra.setEstablecimiento(new Establecimiento());
							establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
							establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
							if (establecimArbitra != null) {
								if ("A".equals(establecimiento.getEsinadar())) {
									if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
										establecimiento.setEsinadar("L");
									}
								}
							}
						} catch (Exception e) {

						}

						intervinientes = new Intervinientes(
								Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
								establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
								establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
								establecimiento.getEscoidco(), establecimiento.getEsteurl(),
								establecimiento.getEsnopeco(), establecimiento.getEsfeba(),
								establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
								establecimiento.getEscoem(), establecimiento.getEsextranjero(),
								establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
								establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
								establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
								establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
								establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
								establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
								establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
								establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
								establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
								establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
								Y41bConstantes.TIPO_INTERVINIENTE_DISTRIBUIDOR, alerta.getAlcodigo(), null,
								establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
								establecimiento.getCensoMonitor().getUsuarioxlnet());

						// por cada uno insertar el interviniente
						this.intervinientesDao.add(intervinientes);

						// por cada uno actualizar el campo RDIDINTERVINIENTE de
						// la
						// tabla temporal
						adjuntarDistribuidorAux.setRdidinterviniente(intervinientes.getIdinterviniente());
						this.distribuidorDao.updateAlertaFabricanteInterviniente(adjuntarDistribuidorAux);
					}
				}

				Locale locale = LocaleContextHolder.getLocale();
				Date today = new Date();
				Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

				// insertar la nueva programacion
				AlertaProgramacion alertaProgramacion = null;
				HistorialAlerta historialAlerta = null;
				BandejaAlerta bandejaAlerta = null;
				for (AdjuntarAlertaprogra adjuntarAlertaprograAux : listAdjuntarAlertaprograNuevas) {
					// buscar la programacion
					alertaProgramacion = new AlertaProgramacion();
					alertaProgramacion.setCrcodigo(adjuntarAlertaprograAux.getCrcodigo());
					alertaProgramacion = this.alertaProgramacionDao.find(alertaProgramacion);

					// Insertar historial
					historialAlerta = new HistorialAlerta();
					historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					historialAlerta.setCodigo(alerta.getAlcodigo());
					historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
					historialAlerta.setOrganismodestino(alertaProgramacion.getCrcoor());
					historialAlerta.setDescripcion(Y41bConstantes.ENVIO_PROGRAMACION);
					historialAlerta.setGenerado(Y41bConstantes.SI);
					historialAlerta.setFecha(new Date());

					this.historialAlertaDao.add(historialAlerta);

					// insertar la programacin en la bandeja de alertas
					bandejaAlerta = new BandejaAlerta();
					bandejaAlerta.setV5codigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					bandejaAlerta.setAlcodigo(alerta.getAlcodigo());
					bandejaAlerta.setCrcodigo(alertaProgramacion.getCrcodigo());
					bandejaAlerta.setCrcodigodistribuidor(alertaProgramacion.getDistribuidor().getRdcodigo());
					bandejaAlerta.setCrcoor(alertaProgramacion.getCrcoor());
					bandejaAlerta.setCrfechacomunicacion(alertaProgramacion.getCrfechacomunicacion());
					bandejaAlerta.setCrcnactu(alertaProgramacion.getCrcnactu());

					this.bandejaAlertaDao.add(bandejaAlerta);

					// Generar las inspecciones
					if (alertaProgramacion.getCrcnactu() > 0) {
						for (int i = 0; i < alertaProgramacion.getCrcnactu(); i++) {
							InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
							inspeccionDetalle.setAcfere(todayWithZeroTime);
							inspeccionDetalle.setAtcoal(alerta.getAlcodigo());
							inspeccionDetalle.setAtcocr(alertaProgramacion.getCrcodigo());
							inspeccionDetalle.setAdcoor(alertaProgramacion.getCrcoor());
							inspeccionDetalle.setAccoor(alertaProgramacion.getCrcoor());
							inspeccionDetalle.setAtcoes(alertaProgramacion.getDistribuidor().getRdcoes());

							inspeccionDetalle.setAtinspeccionsolicitada(alertaProgramacion.getCrinspeccionsolicitada());

							inspeccionDetalle.setAtcops(alerta.getAlcops());
							inspeccionDetalle.setAtnoprse(alerta.getAlnoprse());
							inspeccionDetalle.setAtnomaps(alerta.getAlnomaps());
							inspeccionDetalle.setAtnomops(alerta.getAlnomops());
							inspeccionDetalle.setAtnrlops(alerta.getAlnrlops());
							inspeccionDetalle.setAtcodigobarras(alerta.getAlcodigobarras());
							inspeccionDetalle.setAtfedumi(alerta.getAlfedumi());

							if (alertaProgramacion.getCracuerdoinicio() != null
									&& alertaProgramacion.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
								inspeccionDetalle.setAtacuerdoinicio(Y41bConstantes.VALOR_SI);
								inspeccionDetalle.setAccoes(alertaProgramacion.getDistribuidor().getRdcoes());
								inspeccionDetalle
										.setAtformanotifestablecimientovi(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
							}

							this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
						}
					}
				}

				for (AdjuntarAlertaprogra adjuntarAlertaprograAux : listAdjuntarAlertaprograExistentes) {
					// buscar la programacion
					alertaProgramacion = new AlertaProgramacion();
					alertaProgramacion.setCrcodigo(adjuntarAlertaprograAux.getCrcodigo());
					alertaProgramacion = this.alertaProgramacionDao.find(alertaProgramacion);

					adjuntarAlertaprograAux = this.adjuntarAlertaprograDao.find(adjuntarAlertaprograAux);

					// Actualizar las programaciones
					alertaProgramacion.setCrcnactu(adjuntarAlertaprograAux.getCrcnactu());
					this.alertaProgramacionDao.updateNumActuaciones(alertaProgramacion);

					// Actualizar la bandeja
					bandejaAlerta = new BandejaAlerta();

					bandejaAlerta.setCrcodigo(alertaProgramacion.getCrcodigo());
					bandejaAlerta.setCrcnactu(adjuntarAlertaprograAux.getCrcnactu());

					this.bandejaAlertaDao.updateNumInspecciones(bandejaAlerta);

					// buscar las inspecciones de la alerta programacin
					actuacion = new Actuacion();
					actuacion.setAtcocr(alertaProgramacion.getCrcodigo());

					// eliminar las inspeccion si no est iniciada
					// buscar las inspecciones de la programacion
					Long numInspecciones = this.actuacionDao.findAllCount(actuacion);

					// restar las inepcciones solicitadas con las inspecciones
					// existentes
					Long numInspeccionesGenerar = alertaProgramacion.getCrcnactu() - numInspecciones;

					// generar las inspecciones (resultado de la resta)
					if (numInspeccionesGenerar > 0) {
						for (int i = 0; i < numInspeccionesGenerar; i++) {
							InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
							inspeccionDetalle.setAcfere(todayWithZeroTime);
							inspeccionDetalle.setAtcoal(alerta.getAlcodigo());
							inspeccionDetalle.setAtcocr(alertaProgramacion.getCrcodigo());
							inspeccionDetalle.setAdcoor(alertaProgramacion.getCrcoor());
							inspeccionDetalle.setAccoor(alertaProgramacion.getCrcoor());
							inspeccionDetalle.setAtcoes(alertaProgramacion.getDistribuidor().getRdcoes());

							inspeccionDetalle.setAtinspeccionsolicitada(alertaProgramacion.getCrinspeccionsolicitada());

							inspeccionDetalle.setAtcops(alerta.getAlcops());
							inspeccionDetalle.setAtnoprse(alerta.getAlnoprse());
							inspeccionDetalle.setAtnomaps(alerta.getAlnomaps());
							inspeccionDetalle.setAtnomops(alerta.getAlnomops());
							inspeccionDetalle.setAtnrlops(alerta.getAlnrlops());
							inspeccionDetalle.setAtcodigobarras(alerta.getAlcodigobarras());
							inspeccionDetalle.setAtfedumi(alerta.getAlfedumi());

							if (alertaProgramacion.getCracuerdoinicio() != null
									&& alertaProgramacion.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
								inspeccionDetalle.setAtacuerdoinicio(Y41bConstantes.VALOR_SI);
								inspeccionDetalle.setAccoes(alertaProgramacion.getDistribuidor().getRdcoes());
								inspeccionDetalle
										.setAtformanotifestablecimientovi(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
							}

							this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
						}
					}
				}

				// Actualizar la bandeja de alertas para SSCC
				bandejaAlerta = new BandejaAlerta();
				bandejaAlerta.setAlcodigo(alerta.getAlcodigo());

				// borrar la alerta de SSCC
				this.bandejaAlertaDao.removeBandejaAlertaSSCC(bandejaAlerta);

				// Insertar la bandeja de alertas para SSCC
				// buscar las programaciones de la alerta
				alertaProgramacion = new AlertaProgramacion();
				Alerta alertaAux = new Alerta();
				alertaAux.setAlcodigo(alerta.getAlcodigo());
				alertaProgramacion.setAlerta(alertaAux);
				List<AlertaProgramacion> listAlertaProgramacion = this.alertaProgramacionDao.findAll(alertaProgramacion,
						null);

				Integer totalNumInspecciones = 0;
				Date fechaComunicacion = null;
				for (AlertaProgramacion alertaProgramacionAux : listAlertaProgramacion) {
					totalNumInspecciones += alertaProgramacionAux.getCrcnactu();

					if (fechaComunicacion == null) {
						fechaComunicacion = alertaProgramacionAux.getCrfechacomunicacion();
					} else if (fechaComunicacion.before(alertaProgramacionAux.getCrfechacomunicacion())) {
						fechaComunicacion = alertaProgramacionAux.getCrfechacomunicacion();
					}
				}

				// Insertar la bandeja de alertas para SSCC
				bandejaAlerta = new BandejaAlerta();
				bandejaAlerta.setV5codigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				bandejaAlerta.setAlcodigo(alerta.getAlcodigo());

				bandejaAlerta.setCrcodigo(null);
				bandejaAlerta.setCrcodigodistribuidor(null);
				bandejaAlerta.setCrcoor(null);

				bandejaAlerta.setCrfechacomunicacion(fechaComunicacion);
				bandejaAlerta.setCrcnactu(totalNumInspecciones);

				this.bandejaAlertaDao.add(bandejaAlerta);

				if (alerta.getAlanulada() != null && alerta.getAlanulada().equals(Y41bConstantes.SI)) {

					// eliminar de la bandeja de alertas
					BandejaAlerta bandejaalerta = new BandejaAlerta();
					bandejaalerta.setAlcodigo(alerta.getAlcodigo());
					this.bandejaAlertaDao.removeBandejaAlertaAlerta(bandejaalerta);
				}

				// Insertar los documentos de as programaciones
				// buscar las programaciones de la alerta
				alertaProgramacion = new AlertaProgramacion();
				alertaAux = new Alerta();
				alertaAux.setAlcodigo(alerta.getAlcodigo());
				alertaProgramacion.setAlerta(alertaAux);
				listAlertaProgramacion = this.alertaProgramacionDao.findAll(alertaProgramacion, null);

				for (AlertaProgramacion alertaProgramacionAux : listAlertaProgramacion) {
					documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5hdcodigo(alertaProgramacionAux.getCrcodigo());
					this.documentoHechoDao.removeDocsExpediente(documentoHecho);

					if (alertaProgramacionAux.getCracuerdoinicio() != null
							&& alertaProgramacionAux.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
						this.documentoHechoDao.addAllDocumentosAdjuntarDocs(alertaProgramacionAux.getCrcodigo(),
								alertaProgramacionAux.getCrcodigo());
					}

					this.adjuntardocsDao.removeAllDocsTableTemporal(alertaProgramacionAux.getCrcodigo());
				}
			}

			return alerta;
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.alerta.DataIntegrityViolationExceptionMod", true, e);
		}
	}

	/**
	 * Realiza el proceso de anulacin de la alerta
	 * 
	 * @param alerta
	 *            Alerta
	 */
	private void procesarAnulacionAlerta(Alerta alerta) {
		HistorialAlerta historialAlerta = new HistorialAlerta();
		historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		historialAlerta.setCodigo(alerta.getAlcodigo());
		historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
		historialAlerta.setOrganismodestino(null);
		historialAlerta.setDescripcion(Y41bConstantes.ANULACION_ALERTA);
		historialAlerta.setGenerado(Y41bConstantes.SI);
		historialAlerta.setFecha(new Date());

		this.historialAlertaDao.add(historialAlerta);

		AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
		adjuntarAlertaprogra.setCrcoal(alerta.getAlcodigo());

		Long numProgramaciones = this.adjuntarAlertaprograDao.findAllCount(adjuntarAlertaprogra);

		// Si no existe ninguna programacin: se anula directamente
		if (numProgramaciones > 0) {

			// Si existe programaciones
			List<AdjuntarAlertaprogra> listAdjuntarAlertaprogra = this.adjuntarAlertaprograDao
					.findAll(adjuntarAlertaprogra, null);

			Actuacion actuacionAux = null;
			for (AdjuntarAlertaprogra adjuntarAlertaprograAux : listAdjuntarAlertaprogra) {

				actuacionAux = new Actuacion();
				actuacionAux.setAtcocr(adjuntarAlertaprograAux.getCrcodigo());
				Long numInspeccionesIniciada = this.tramiteInspeccionDao
						.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacionAux);

				// Si tiene expedientes abiertos se lanza error
				if (numInspeccionesIniciada > 0) {
					// buscar las inspecciones de la programacion
					List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacionAux, null);

					InspeccionDetalle inspeccionDetalleAux = null;
					for (Actuacion actuacionDetalleAux : listActuacion) {
						if (actuacionDetalleAux != null && actuacionDetalleAux.getActa() != null
								&& actuacionDetalleAux.getActa().getAcnror() != null && !actuacionDetalleAux.getActa()
										.getAcnror().equals(Y41bConstantes.INSPECCIONES_NUM_EXPEDIENTE_INICIAL)) {
							// Si la lnea de programacin tiene
							// inspecciones asignadas
							// (apertura realizada), en aquellas que
							// estn asignadas, se
							// genera un trmite genrico avisando que
							// se ha anulado la
							// red de alerta, para que el inspector
							// responsable proceda
							// a realizar la actuacin necesarias(por
							// ejemplo si tiene
							// que desinmovilizaretc.) y cerrar-decidir
							// la inspeccin,

							// Si la lnea de programacin tienes
							// inspecciona asignadas
							// y cerradas se le incluir un trmite
							// genrico informando
							// de la anulacin de la red de alerta..

							// Generar tramite generico
							try {
								TramiteGenerico tramiteGenerico = new TramiteGenerico();
								tramiteGenerico.setIdExpediente(actuacionDetalleAux.getAtcodigo());
								tramiteGenerico.setFechaInicio(new Date());
								String literalNombreTramite = "alerta.anulada";
								this.instramexpService.addTramiteGenericoAutomatico(tramiteGenerico,
										literalNombreTramite);
							} catch (Exception e) {
								throw new Y41bUDAException("error.generico", true, e);
							}
						} else {
							// y las que no est asignadas las elimina
							// reduciendo el
							// nmero de inspecciones solicitadas.
							inspeccionDetalleAux = new InspeccionDetalle();
							inspeccionDetalleAux.setAtcodigo(actuacionDetalleAux.getAtcodigo());
							inspeccionDetalleAux.setAccodigo(actuacionDetalleAux.getActa().getAccodigo());
							this.inspeccionService.removeInspeccion(inspeccionDetalleAux);

							// actualizar la programacin
							AdjuntarAlertaprogra adjuntaralertaprogra = new AdjuntarAlertaprogra();
							adjuntaralertaprogra.setCrcodigo(adjuntarAlertaprograAux.getCrcodigo());
							adjuntaralertaprogra.setCrcnactu(this.actuacionDao.findAllCount(actuacionAux).intValue());
							this.adjuntarAlertaprograDao.updateNumActuaciones(adjuntaralertaprogra);

							AlertaProgramacion alertaprogramacion = new AlertaProgramacion();
							alertaprogramacion.setCrcodigo(adjuntaralertaprogra.getCrcodigo());
							alertaprogramacion.setCrcnactu(adjuntaralertaprogra.getCrcnactu());

							this.alertaProgramacionDao.updateNumActuaciones(alertaprogramacion);
						}
					}
				} else {
					// Si lnea de programacin no tiene inspeccin
					// asignadas
					// (apertura no realizada) por parte de SSTT, se
					// eliminan la
					// pre-inspecciones y se deja la programacin no
					// cerradas
					// con 0 solicitud de inspeccin

					// eliminar las inspeccion si no est iniciada
					// buscar las inspecciones de la programacion
					List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacionAux, null);

					InspeccionDetalle inspeccionDetalleAux = null;
					for (Actuacion actuacionDetalleAux : listActuacion) {
						inspeccionDetalleAux = new InspeccionDetalle();
						inspeccionDetalleAux.setAtcodigo(actuacionDetalleAux.getAtcodigo());
						inspeccionDetalleAux.setAccodigo(actuacionDetalleAux.getActa().getAccodigo());
						this.inspeccionService.removeInspeccion(inspeccionDetalleAux);
					}

					// actualizar la programacin a 0
					AdjuntarAlertaprogra adjuntaralertaprogra = new AdjuntarAlertaprogra();
					adjuntaralertaprogra.setCrcodigo(adjuntarAlertaprograAux.getCrcodigo());
					adjuntaralertaprogra.setCrcnactu(0);
					this.adjuntarAlertaprograDao.updateNumActuaciones(adjuntaralertaprogra);

					AlertaProgramacion alertaprogramacion = new AlertaProgramacion();
					alertaprogramacion.setCrcodigo(adjuntaralertaprogra.getCrcodigo());
					alertaprogramacion.setCrcnactu(0);

					this.alertaProgramacionDao.updateNumActuaciones(alertaprogramacion);
				}
			}
		}

		// eliminar de la bandeja de alertas
		BandejaAlerta bandejaalerta = new BandejaAlerta();
		bandejaalerta.setAlcodigo(alerta.getAlcodigo());
		this.bandejaAlertaDao.removeBandejaAlertaAlerta(bandejaalerta);
	}

	/**
	 * Procesa el fichero tanto de la UE como de CCAA
	 * 
	 * @param fileBytes
	 *            byte[]
	 * @return Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Alerta procesarFichero(byte[] fileBytes) {
		try {
			AlertaServiceImpl.logger.debug("########################AlertaServiceImpl.procesarFichero - CCAA");

			// Parseo del XML mediante JAXB
			JAXBContext jaxbContext;
			com.ejie.y41b.model.ficheroalerta.Notificacion objetoALERTA = null;

			jaxbContext = JAXBContext.newInstance(com.ejie.y41b.model.ficheroalerta.Notificacion.class);

			String fichero = new String(fileBytes, "UTF-8");
			fichero = fichero.trim().replaceFirst("^([\\W]+)<", "<");

			Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
			StringReader reader = new StringReader(fichero);
			objetoALERTA = (com.ejie.y41b.model.ficheroalerta.Notificacion) jaxbUnmarshaller.unmarshal(reader);

			Alerta alerta = new Alerta();
			alerta.setAlcoor(Y41bConstantes.ORIGEN_ALERTA_CCAA);

			// buscar la comunidad autonoma
			if (objetoALERTA.getOrganoActuante() != null && objetoALERTA.getOrganoActuante().getNombre() != null
					&& objetoALERTA.getOrganoActuante().getNombre().equals(Y41bConstantes.ORIGEN_ALERTA_INC)) {
				alerta.setAlcoor(Y41bConstantes.ORIGEN_ALERTA_INC);
				alerta.setAlaecosan(Y41bConstantes.EMISOR_ALERTA_INC);
			} else {
				T17Autonomia t17autonomia = new T17Autonomia();
				t17autonomia.setDsO(objetoALERTA.getOrganoActuante().getNombre());
				List<T17Autonomia> listT17Autonomia = this.t17AutonomiaDao.findAllLike(t17autonomia, null, false);

				if (listT17Autonomia != null && listT17Autonomia.size() > 0) {
					alerta.setAlcoca(listT17Autonomia.get(0).getId());
				}
			}

			if (objetoALERTA.getOrganoActuante() != null && objetoALERTA.getOrganoActuante().getNombre() != null
					&& objetoALERTA.getOrganoActuante().getNombre().equals(Y41bConstantes.ORIGEN_ALERTA_INC)
					|| Y41bUtils.isFilled(alerta.getAlcoca())) {

				AlertaServiceImpl.logger
						.debug("AlertaServiceImpl.procesarFichero - CCAA: alertaDocument " + objetoALERTA.toString());

				AlertaServiceImpl.logger
						.debug("AlertaServiceImpl.procesarFichero - CCAA: " + objetoALERTA.getIdentificador());

				alerta.setAlnror(
						objetoALERTA.getIdentificador().substring(0, objetoALERTA.getIdentificador().lastIndexOf("/")));
				alerta.setAlnran(new Long(objetoALERTA.getIdentificador()
						.substring(objetoALERTA.getIdentificador().lastIndexOf("/") + 1)));

				alerta.setAlnoprse(Y41bUtils.trataNull(StringEscapeUtils.unescapeHtml(objetoALERTA.getNombreProducto()))
						.toUpperCase());
				alerta.setAlnomaps(Y41bUtils.trataNull(StringEscapeUtils.unescapeHtml(objetoALERTA.getMarcaProducto()))
						.toUpperCase());
				alerta.setAlnomops(StringEscapeUtils.unescapeHtml(objetoALERTA.getModeloRefProducto()));
				// alerta.setAlnrlops(objetoALERTACCAA.getModeloRefProducto());
				if (objetoALERTA.getCodigosBarras() != null
						&& Y41bUtils.isFilled(objetoALERTA.getCodigosBarras().getCodigoBarra())) {
					alerta.setAlcodigobarras(objetoALERTA.getCodigosBarras().getCodigoBarra());
				}
				// buscar la correspondencia con la tabla de naturaleza de
				// peligros
				NaturalezaPeligro naturalezaPeligro = new NaturalezaPeligro();

				if (objetoALERTA.getPeligros() != null && objetoALERTA.getPeligros().getPeligro() != null
						&& objetoALERTA.getPeligros().getPeligro().size() > 0) {
					String naturalezaPeligroFichero = objetoALERTA.getPeligros().getPeligro().get(0).getNombre();
					if (naturalezaPeligroFichero.indexOf(".") > 0) {
						naturalezaPeligroFichero = naturalezaPeligroFichero.substring(0,
								naturalezaPeligroFichero.indexOf("."));
					}
					naturalezaPeligro.setNaturalezapeligro(naturalezaPeligroFichero.replaceAll("DE", "").trim());
					List<NaturalezaPeligro> listNaturalezaPeligro = this.naturalezaPeligroDao
							.findAllLike(naturalezaPeligro, null, false);

					if (listNaturalezaPeligro != null && listNaturalezaPeligro.size() > 0) {
						alerta.setNaturalezaPeligro(listNaturalezaPeligro.get(0));
					}
				}

				alerta.setAlorigenproducto(Y41bConstantes.ORIGEN_PRODUCTO_PAIS);

				if (objetoALERTA.getPaisProdInicial() != null
						&& Y41bUtils.isFilled(objetoALERTA.getPaisProdInicial().getNombre())) {
					T17Pais t17Pais = new T17Pais();
					t17Pais.setDsO(objetoALERTA.getPaisProdInicial().getNombre());

					List<T17Pais> listT17Pais = this.t17PaisDao.findAllLike(t17Pais, null, false);

					if (listT17Pais != null && listT17Pais.size() > 0) {
						alerta.setAlpaisproducto(listT17Pais.get(0).getId());
					} else {
						alerta.setAlpaisproducto("-");
					}
				} else {
					alerta.setAlpaisproducto("-");
				}

				alerta.setAlindicaciones(StringEscapeUtils.unescapeHtml(objetoALERTA.getInformacionPertinente()));

				return alerta;
			} else {

				AlertaServiceImpl.logger.debug("AlertaServiceImpl.procesarFichero - UE: " + objetoALERTA.toString());

				AlertaServiceImpl.logger
						.debug("AlertaServiceImpl.procesarFichero - UE: " + objetoALERTA.getIdentificador());

				alerta = new Alerta();
				alerta.setAlcoor(Y41bConstantes.ORIGEN_ALERTA_CE);

				// buscar el pais
				if (objetoALERTA.getOrganoActuante() != null
						&& Y41bUtils.isFilled(objetoALERTA.getOrganoActuante().getNombre())) {
					T17Pais t17Pais = new T17Pais();
					t17Pais.setDsO(objetoALERTA.getOrganoActuante().getNombre());

					List<T17Pais> listT17Pais = this.t17PaisDao.findAllLike(t17Pais, null, false);

					if (listT17Pais != null && listT17Pais.size() > 0) {
						alerta.setAlcopa(listT17Pais.get(0).getId());
					}
				} else {
					alerta.setAlcopa("-");
				}

				alerta.setAlnror(
						objetoALERTA.getIdentificador().substring(0, objetoALERTA.getIdentificador().lastIndexOf("/")));
				alerta.setAlnran(new Long(objetoALERTA.getIdentificador()
						.substring(objetoALERTA.getIdentificador().lastIndexOf("/") + 1)));

				alerta.setAlnoprse(StringEscapeUtils.unescapeHtml(objetoALERTA.getNombre()));

				if (objetoALERTA.getCodigosBarras() != null
						&& Y41bUtils.isFilled(objetoALERTA.getCodigosBarras().getCodigoBarra())) {
					alerta.setAlcodigobarras(objetoALERTA.getCodigosBarras().getCodigoBarra());
				}

				// buscar la correspondencia con la tabla de naturaleza de
				// peligros
				NaturalezaPeligro naturalezaPeligro = new NaturalezaPeligro();

				if (objetoALERTA.getPeligros() != null && objetoALERTA.getPeligros().getPeligro() != null
						&& objetoALERTA.getPeligros().getPeligro().size() > 0) {
					naturalezaPeligro.setNaturalezapeligro(objetoALERTA.getPeligros().getPeligro().get(0).getNombre());

					List<NaturalezaPeligro> listNaturalezaPeligro = this.naturalezaPeligroDao
							.findAllLike(naturalezaPeligro, null, false);

					if (listNaturalezaPeligro != null && listNaturalezaPeligro.size() > 0) {
						alerta.setNaturalezaPeligro(listNaturalezaPeligro.get(0));
					}
				}

				alerta.setAlorigenproducto(Y41bConstantes.ORIGEN_PRODUCTO_PAIS);

				// buscar el pais
				if (objetoALERTA.getPaisProdInicial() != null
						&& Y41bUtils.isFilled(objetoALERTA.getPaisProdInicial().getNombre())) {
					T17Pais t17Pais = new T17Pais();
					t17Pais.setDsO(objetoALERTA.getPaisProdInicial().getNombre());

					List<T17Pais> listT17Pais = this.t17PaisDao.findAllLike(t17Pais, null, false);

					if (listT17Pais != null && listT17Pais.size() > 0) {
						alerta.setAlpaisproducto(listT17Pais.get(0).getId());
					} else {
						alerta.setAlpaisproducto("-");
					}
				} else {
					alerta.setAlpaisproducto("-");
				}

				StringBuffer indicaciones = new StringBuffer();
				if (Y41bUtils.isFilled(objetoALERTA.getObservacion())) {
					indicaciones.append(StringEscapeUtils.unescapeHtml(objetoALERTA.getObservacion()));
					indicaciones.append("\r\n");
				}
				indicaciones.append(StringEscapeUtils.unescapeHtml(objetoALERTA.getMotivo()));
				alerta.setAlindicaciones(indicaciones.toString());

				return alerta;
			}

		} catch (Throwable e) {
			throw new Y41bUDAException("error.alerta.FicheroXMLException", true, e);
		}
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	public Alerta find(Alerta alerta) {
		return (Alerta) this.alertaDao.find(alerta);
	}

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Alerta> findAll(Alerta alerta, Pagination pagination) {
		return (List<Alerta>) this.alertaDao.findAll(alerta, pagination);
	}

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	public Long findAllCount(Alerta alerta) {
		return this.alertaDao.findAllCount(alerta);
	}

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Alerta> findAllLike(Alerta alerta, Pagination pagination, Boolean startsWith) {

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSord().equals("asc")
					&& pagination.getSidx().startsWith("alorigen")) {
				pagination.setSidx("Alcopa, Alcoca, alaecosan ");
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSord().equals("desc")
					&& pagination.getSidx().startsWith("alorigen")) {
				pagination.setSidx("Alcopa desc, Alcoca desc, alaecosan ");
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("alproducto")) {
				pagination.setSidx("Alnoprse");
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("almaxfechaplazo")) {
				pagination.setSidx("MAXFECHAPLAZO");
			}
		}

		List<Alerta> listAlerta = (List<Alerta>) this.alertaDao.findAllLike(alerta, pagination, startsWith);

		for (Alerta alertaAux : listAlerta) {
			if (alertaAux.getAlcoor() != null && alertaAux.getAlcoor().equals(Y41bConstantes.ORIGEN_ALERTA_CE)) {
				// buscar el pais por el codigo
				T17Pais t17pais = new T17Pais();
				t17pais.setId(alertaAux.getAlcopa());
				t17pais = this.t17PaisDao.find(t17pais);
				alertaAux.setAlorigen(t17pais.getDsO());
			} else if (alertaAux.getAlcoor() != null
					&& alertaAux.getAlcoor().equals(Y41bConstantes.ORIGEN_ALERTA_CCAA)) {
				// buscar la comunidad por el codigo
				T17Autonomia t17autonomia = new T17Autonomia();
				t17autonomia.setId(alertaAux.getAlcoca());
				t17autonomia = this.t17AutonomiaDao.find(t17autonomia);
				alertaAux.setAlorigen(t17autonomia.getDsO());
			} else if (alertaAux.getAlcoor() != null
					&& alertaAux.getAlcoor().equals(Y41bConstantes.ORIGEN_ALERTA_INC)) {
				alertaAux.setAlorigen(Y41bConstantes.EMISOR_ALERTA_INC);
			}

			if (Y41bUtils.isFilled(alertaAux.getAlnoprse()) || Y41bUtils.isFilled(alertaAux.getAlnomaps())
					|| Y41bUtils.isFilled(alertaAux.getAlnomops()) || Y41bUtils.isFilled(alertaAux.getAlnrlops())) {
				StringBuffer producto = new StringBuffer();
				producto.append(Y41bUtils.filtroDB(alertaAux.getAlnoprse())).append(" ")
						.append(Y41bUtils.filtroDB(alertaAux.getAlnomaps())).append(" ")
						.append(Y41bUtils.filtroDB(alertaAux.getAlnomops())).append(" ")
						.append(Y41bUtils.filtroDB(alertaAux.getAlnrlops()));
				alertaAux.setAlproducto(producto.toString());
			} else {
				Locale locale = LocaleContextHolder.getLocale();
				if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
					alertaAux.setAlproducto(alertaAux.getPsnombre());
				} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
					alertaAux.setAlproducto(alertaAux.getPsnombree());
				}
			}
		}

		return listAlerta;
	}

	/**
	 * Counts rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Alerta alerta, Boolean startsWith) {
		return this.alertaDao.findAllLikeCount(alerta, startsWith);
	}

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Alerta alerta) {
		this.alertaDao.remove(alerta);
	}

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAlerta(Alerta alerta) {
		try {
			// buscar las programaciones de la alerta
			AlertaProgramacion alertaProgramacion = new AlertaProgramacion();
			Alerta alertaAux = new Alerta();
			alertaAux.setAlcodigo(alerta.getAlcodigo());
			alertaProgramacion.setAlerta(alertaAux);
			List<AlertaProgramacion> listAlertaProgramacion = this.alertaProgramacionDao.findAll(alertaProgramacion,
					null);

			Actuacion actuacion = null;
			InspeccionDetalle inspeccionDetalleAux = null;
			BandejaAlerta bandejaAlertaAux = null;
			DocumentoHecho documentoHechoAux = null;
			for (AlertaProgramacion alertaProgramacionAux : listAlertaProgramacion) {

				documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5hdcodigo(alertaProgramacionAux.getCrcodigo());
				this.documentoHechoDao.removeDocsExpediente(documentoHechoAux);

				// buscar la programacion
				actuacion = new Actuacion();
				actuacion.setAtcocr(alertaProgramacionAux.getCrcodigo());
				Long numInspeccionesIniciada = this.tramiteInspeccionDao
						.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);

				// Si tiene expedientes abiertos se lanza error
				if (numInspeccionesIniciada > 0) {
					throw new Y41bUDAException("error.alerta.AlertaInspeccionesAbiertasException", true,
							new Exception());
				}

				// eliminar las inspeccion si no est iniciada
				// buscar las inspecciones de la programacion
				List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacion, null);

				for (Actuacion actuacionAux : listActuacion) {
					inspeccionDetalleAux = new InspeccionDetalle();
					inspeccionDetalleAux.setAtcodigo(actuacionAux.getAtcodigo());
					inspeccionDetalleAux.setAccodigo(actuacionAux.getActa().getAccodigo());
					this.inspeccionService.removeInspeccion(inspeccionDetalleAux);
				}
			}

			// eliminar de la bandeja
			bandejaAlertaAux = new BandejaAlerta();
			bandejaAlertaAux.setAlcodigo(alerta.getAlcodigo());

			this.bandejaAlertaDao.removeBandejaAlertaAlerta(bandejaAlertaAux);

			this.alertaProgramacionDao.removeAllAlertaProgramacion(alerta);

			this.distribuidorDao.removeAlertaDistribuidor(alerta);

			// eliminar los intervinientes de la alerta
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(alerta.getAlcodigo());
			this.intervinientesDao.removeIntervinientesExpediente(intervinientes);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(alerta.getAlcodigo());
			this.documentoHechoDao.removeDocsExpediente(documentoHecho);

			// eliminar historial
			HistorialAlerta historialalerta = new HistorialAlerta();
			historialalerta.setCodigo(alerta.getAlcodigo());
			this.historialAlertaDao.removeAllExpediente(historialalerta);

			this.alertaDao.remove(alerta);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.alerta.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Alerta table.
	 * 
	 * @param alertaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Alerta> alertaList) {
		for (Alerta alertaAux : alertaList) {
			this.alertaDao.remove(alertaAux);
		}
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, AlertaProgramacion alertaProgramacion, String tipodocumento)
			throws Exception {

		// En la lista de documentos asociados solo podr haber un mximo de 1
		// documento de tipo acuerdo de inicio de procedimiento.
		Adjuntardocs adjuntardocsAux = new Adjuntardocs();
		TipoDocumento tipoDocumentoAux = new TipoDocumento();
		tipoDocumentoAux.setIdTipodoc(tipodocumento);

		adjuntardocsAux.setTipoDocumento(tipoDocumentoAux);
		adjuntardocsAux.setThidExpediente(alertaProgramacion.getCrcodigo());

		Long numAcuerdoInicioProcedimiento = this.adjuntardocsDao.findAllCount(adjuntardocsAux);

		if (numAcuerdoInicioProcedimiento > 0) {
			throw new Y41bUDAException("error.comunicacionsoivre.AcuerdoInicioProcedimientoException", true, null);
		}

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());

		String plantilla = this.findPlantilla(plantillaTramite, alertaProgramacion);

		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		adjuntardocs.setThcodocumento(this.documentoHechoDao.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");

		// buscar la solicitud
		SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
		solicitudDetalleAux.setHdcodigo(alertaProgramacion.getCrcodigo());

		adjuntardocs.setThnofile(new StringBuffer(plantillaTramite.getPtnombre()).append(".rtf").toString());
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(alertaProgramacion.getCrcodigo());
		adjuntardocs.setThidTramite(alertaProgramacion.getCrcodigo());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		adjuntardocs.setTipoProcedimiento(tipoProcedimiento);

		adjuntardocs.setThfecha(new Date());

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantilla(PlantillaTramite plantillaTramite, AlertaProgramacion alertaProgramacion)
			throws Exception {

		// Obtener la plantilla del tramite
		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		// Obtener los datos de la comunicacion soivre
		Alerta alerta = (Alerta) this.alertaDao.find(alertaProgramacion.getAlerta());

		PlantillaTramiteINSDetalle plantillaTramiteINSDetalle = new PlantillaTramiteINSDetalle();

		// Producto
		plantillaTramiteINSDetalle.setNombreProducto(alerta.getAlnoprse());
		plantillaTramiteINSDetalle.setMarcaProducto(alerta.getAlnomaps());
		plantillaTramiteINSDetalle.setModeloProducto(alerta.getAlnomops());
		plantillaTramiteINSDetalle.setLoteProducto(alerta.getAlnrlops());
		plantillaTramiteINSDetalle.setCodigoBarrasProducto(alerta.getAlcodigobarras());

		AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
		adjuntarAlertaprogra.setCrcodigo(alertaProgramacion.getCrcodigo());
		adjuntarAlertaprogra = (AdjuntarAlertaprogra) this.adjuntarAlertaprograDao.find(adjuntarAlertaprogra);

		AdjuntarDistribuidor adjuntardistribuidor = new AdjuntarDistribuidor();
		adjuntardistribuidor.setRdcodigo(adjuntarAlertaprogra.getCrcodigodistribuidor());
		adjuntardistribuidor = this.adjuntarDistribuidorDao.find(adjuntardistribuidor);

		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(adjuntardistribuidor.getRdcoes());

		establecimiento = this.establecimientoDao.find(establecimiento);

		// ResponsableProducto
		plantillaTramiteINSDetalle.setEsnombreResponsableProducto(establecimiento.getEsnombre());
		plantillaTramiteINSDetalle.setEsnombreMunicipioResponsableProducto(establecimiento.getEsnombreMunicipio());

		// Creamos el campo direccion del establecimiento
		StringBuffer direccionCompleta = new StringBuffer();

		if (establecimiento != null && establecimiento.getEsnombreCalle() != null
				&& !establecimiento.getEsnombreCalle().equals("")) {
			direccionCompleta.append(establecimiento.getEsnombreCalle());

			if (establecimiento.getEsnombrePortal() != null && !establecimiento.getEsnombrePortal().equals("")) {
				direccionCompleta.append(", ").append(establecimiento.getEsnombrePortal());
			}
			if (establecimiento.getEsnombrePiso() != null && !establecimiento.getEsnombrePiso().equals("")) {
				direccionCompleta.append(" ").append(establecimiento.getEsnombrePiso());
			}
		} else {
			if (establecimiento.getEsdireccion_nocapv() != null
					&& !establecimiento.getEsdireccion_nocapv().equals("")) {
				direccionCompleta.append(establecimiento.getEsdireccion_nocapv());
			} else {
				direccionCompleta.append(Y41bUtils.trataNull(establecimiento.getEsnodir()));
			}
		}

		plantillaTramiteINSDetalle.setEsdireccionResponsableProducto(Y41bUtils.trataNull(direccionCompleta.toString()));

		// fecha de hoy
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		// Formateamos las fecha a castellano e euskera
		// fecha de hoy texto
		plantillaTramiteINSDetalle.setFechaHoyCas(Y41bUtils.formatearDateToString(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteINSDetalle.setFechaHoyEus(Y41bUtils.formatearDateToStringEuskera(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

		// Director
		CensoMonitor censoMonitorDirector = new CensoMonitor();

		try {
			censoMonitorDirector = this.censoMonitorDao.findDirectorInspecciones();
			if (censoMonitorDirector.getMonombre() == null) {
				throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
			}
		} catch (Exception e) {
			censoMonitorDirector = new CensoMonitor();
			throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
		}

		plantillaTramiteINSDetalle.setDirector(censoMonitorDirector.getMonombre());
		// recuperar texto de properties
		plantillaTramiteINSDetalle.setTextoPuestoDirectorCas(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteINSDetalle.setTextoPuestoDirectorEus(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));

		Organismo organismo = new Organismo();
		organismo.setCodOrg(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
		plantillaTramiteINSDetalle.setCodOrg(organismo.getCodOrg());
		plantillaTramiteINSDetalle.setNombreEu(organismo.getNombreEu());
		plantillaTramiteINSDetalle.setNombreEs(organismo.getNombreEs());
		plantillaTramiteINSDetalle.setNombreCalle(organismo.getNombreCalle());
		plantillaTramiteINSDetalle.setNoraCpId(organismo.getNoraCpId());
		plantillaTramiteINSDetalle.setNombreMunicipio(organismo.getNombreMunicipio());
		plantillaTramiteINSDetalle.setNombrePortal(organismo.getNombrePortal());
		plantillaTramiteINSDetalle.setNombrePiso(organismo.getCompleDirec());

		plantillaTramiteINSDetalle.setTelefonoOrganismo(organismo.getTelefono());
		plantillaTramiteINSDetalle.setFaxOrganismo(organismo.getFax());
		plantillaTramiteINSDetalle.setEmailOrganismo(organismo.getEmail());
		plantillaTramiteINSDetalle.setWebOrganismo(organismo.getUrl());

		// Creamos el campo direccion del organismo conectado
		direccionCompleta = new StringBuffer();

		if (plantillaTramiteINSDetalle.getNombreCalle() != null
				&& !plantillaTramiteINSDetalle.getNombreCalle().equals("")) {
			direccionCompleta.append(plantillaTramiteINSDetalle.getNombreCalle());

			if (plantillaTramiteINSDetalle.getNombrePortal() != null
					&& !plantillaTramiteINSDetalle.getNombrePortal().equals("")) {
				direccionCompleta.append(", ").append(plantillaTramiteINSDetalle.getNombrePortal());
			}
		}

		plantillaTramiteINSDetalle.setDireccionOrganismo(Y41bUtils.trataNull(direccionCompleta.toString()));

		// Creamos el campo codigo postal y municipio del organismo
		// conectado
		StringBuffer cpMunicipio = new StringBuffer();

		if (plantillaTramiteINSDetalle.getNombreCp() != null && !plantillaTramiteINSDetalle.getNombreCp().equals("")) {
			cpMunicipio.append(plantillaTramiteINSDetalle.getNombreCp());

			if (plantillaTramiteINSDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteINSDetalle.getNombreMunicipio().equals("")) {
				cpMunicipio.append(" ").append(plantillaTramiteINSDetalle.getNombreMunicipio());
			}
		} else if (plantillaTramiteINSDetalle.getNombreMunicipio() != null
				&& !plantillaTramiteINSDetalle.getNombreMunicipio().equals("")) {
			cpMunicipio.append(plantillaTramiteINSDetalle.getNombreMunicipio());
		}

		plantillaTramiteINSDetalle.setCpMunicipioOrganismo(Y41bUtils.trataNull(cpMunicipio.toString()));

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea1 = new StringBuffer();

		piepagina_linea1.append(plantillaTramiteINSDetalle.getDireccionOrganismo()).append(" - ")
				.append(plantillaTramiteINSDetalle.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
				.append(plantillaTramiteINSDetalle.getTelefonoOrganismo());

		plantillaTramiteINSDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea2 = new StringBuffer();

		piepagina_linea2.append("e-mail: ").append(plantillaTramiteINSDetalle.getEmailOrganismo()).append(" / ")
				.append(plantillaTramiteINSDetalle.getWebOrganismo());

		plantillaTramiteINSDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

		// Transformar el documento en castellano
		String plantilla = Y41bUtils.blobToString(plantillaTramite.getPtplantilla());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

		rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_INSPECCIONES_XML_TRAMITE_CASTELLANO);

		String ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
				plantillaTramiteINSDetalle, plantilla);

		return ficheroGenerado;
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return PlantillaControlMercadoDetalle
	 */
	public PlantillaControlMercadoDetalle findPlantillaControlMercadoDetalle(Alerta alerta) {

		alerta = this.alertaDao.find(alerta);

		PlantillaControlMercadoDetalle plantillaControlMercadoDetalle = new PlantillaControlMercadoDetalle();

		plantillaControlMercadoDetalle.setTipoOrigen(
				this.appMessageSource.getMessage("excel.inspecciones.alerta", null, LocaleContextHolder.getLocale()));

		StringBuffer codigoOrigen = new StringBuffer().append(alerta.getAlnror()).append("-")
				.append(alerta.getAlnran());
		plantillaControlMercadoDetalle.setCodigoOrigen(codigoOrigen.toString());

		// Producto/Servicio
		plantillaControlMercadoDetalle.setNombreProducto(alerta.getAlnoprse());
		plantillaControlMercadoDetalle.setMarcaProducto(alerta.getAlnomaps());
		plantillaControlMercadoDetalle.setModeloProducto(alerta.getAlnomops());
		plantillaControlMercadoDetalle.setCodigoBarrasProducto(alerta.getAlcodigobarras());

		// Devolvemos el objeto
		return plantillaControlMercadoDetalle;

	}
}
