package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;

/**
 * AlertaService  
 * 
 *  
 */

public interface AlertaService {

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta add(Alerta alerta);

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codAlertaAlta
	 *            String
	 * @return Campanha
	 * @throws Exception
	 *             Exception
	 */
	public Alerta addAlerta(Alerta alerta, String codAlertaAlta)
			throws Exception;

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta update(Alerta alerta);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 * @throws Exception
	 *             Exception
	 */
	public Alerta updateAlerta(Alerta alerta) throws Exception;

	/**
	 * Procesa el fichero tanto de la UE como de CCAA
	 * 
	 * @param fileBytes
	 *            byte[]
	 * @return Alerta
	 */
	public Alerta procesarFichero(byte[] fileBytes);

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta find(Alerta alerta);

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Alerta> findAll(Alerta alerta, Pagination pagination);

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	Long findAllCount(Alerta alerta);

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Alerta alerta, Boolean startsWith);

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	void remove(Alerta alerta);

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAlerta(Alerta alerta);

	/**
	 * Deletes multiple rows in the Alerta table.
	 * 
	 * @param alertaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Alerta> alertaList);

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void addPlantilla(Adjuntardocs adjuntardocs,
			AlertaProgramacion alertaProgramacion, String tipodocumento)
			throws Exception;

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return PlantillaControlMercadoDetalle
	 */
	public PlantillaControlMercadoDetalle findPlantillaControlMercadoDetalle(
			Alerta alerta);
}
