package com.ejie.y41b.service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AlertaProgramacionDao;
import com.ejie.y41b.dao.BandejaAlertaDao;
import com.ejie.y41b.dao.HistorialAlertaDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AlertaProgramacionServiceImpl  
 * 
 *  
 */

@Service(value = "alertaProgramacionService")
public class AlertaProgramacionServiceImpl implements AlertaProgramacionService {

	@Autowired
	private AlertaProgramacionDao alertaProgramacionDao;
	@Autowired
	private HistorialAlertaDao historialAlertaDao;
	@Autowired
	private BandejaAlertaDao bandejaAlertaDao;
	@Autowired
	private InspeccionService inspeccionService;
	@Autowired
	private ParametrosDao parametrosDao;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlertaProgramacion add(AlertaProgramacion alertaProgramacion) {
		return this.alertaProgramacionDao.add(alertaProgramacion);
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlertaProgramacion update(AlertaProgramacion alertaProgramacion) {
		return this.alertaProgramacionDao.update(alertaProgramacion);
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlertaProgramacion finalizarProgramacion(
			AlertaProgramacion alertaProgramacion) throws Exception {
		alertaProgramacion.setCrfechacierre(new Date());
		this.alertaProgramacionDao.updateFechaCierre(alertaProgramacion);

		alertaProgramacion = this.alertaProgramacionDao
				.find(alertaProgramacion);

		// incluir en el historial Fin de actuaciones de la alerta en orgnico
		HistorialAlerta historialAlerta = new HistorialAlerta();
		historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		historialAlerta.setCodigo(alertaProgramacion.getAlerta().getAlcodigo());
		historialAlerta.setOrganismoorigen(alertaProgramacion.getCrcoor());
		historialAlerta.setOrganismodestino(null);
		historialAlerta
				.setDescripcion(Y41bConstantes.FIN_ACTUACIONES_ALERTA_ORGANICO);
		historialAlerta.setGenerado(Y41bConstantes.SI);
		historialAlerta.setFecha(new Date());

		this.historialAlertaDao.add(historialAlerta);

		// eliminar la programacion de la bandeja
		BandejaAlerta bandejaalerta = new BandejaAlerta();
		bandejaalerta.setCrcodigo(alertaProgramacion.getCrcodigo());
		this.bandejaAlertaDao.removeBandejaAlertaProgramacion(bandejaalerta);

		// Enviar mail
		this.enviarEmailFinalizarProgramacion(alertaProgramacion);

		return alertaProgramacion;
	}

	/**
	 * Envia un mail al finalizar la programacion
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 */
	private void enviarEmailFinalizarProgramacion(
			AlertaProgramacion alertaProgramacion) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop
				.getProperty("y41bVistaWar.mail.ejie.smtp");

		// Remitente
		String from = "";
		Parametros parametros = new Parametros();

		parametros
				.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null
				&& (parametros.getValor() == null || parametros.getValor()
						.equals(""))) {
			throw new Y41bUDAException(
					"error.parametro.CONTROLMERCADO_FROMGENERICO_EMAIL", true,
					new Exception());
		} else {
			from = parametros.getValor();
		}

		// Destinatario
		StringBuffer destinatarios = new StringBuffer("");
		parametros = new Parametros();

		parametros
				.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_TOGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null
				&& (parametros.getValor() == null || parametros.getValor()
						.equals(""))) {
			throw new Y41bUDAException(
					"error.parametro.CONTROLMERCADO_TOGENERICO_EMAIL", true,
					new Exception());
		} else {
			destinatarios.append(parametros.getValor());
		}

		// 2. Asunto del mail
		StringBuffer asunto = new StringBuffer();
		String[] params1 = new String[Y41bConstantes.NUM_4];
		params1[Y41bConstantes.NUM_0] = alertaProgramacion.getAlerta()
				.getAlcoor();
		params1[Y41bConstantes.NUM_1] = alertaProgramacion.getAlerta()
				.getAlnror();
		params1[Y41bConstantes.NUM_2] = alertaProgramacion.getAlerta()
				.getAlnran().toString();
		params1[Y41bConstantes.NUM_3] = alertaProgramacion.getAlerta()
				.getAlnoprse();

		// Castellano
		asunto.append(this.appMessageSource.getMessage(
				"alerta.finalizarprogramacion.mail.asunto", params1,
				new Locale(Y41bConstantes.CASTELLANO)));
		// Euskera
		asunto.append(this.appMessageSource.getMessage(
				"alerta.finalizarprogramacion.mail.asunto", params1,
				new Locale(Y41bConstantes.EUSKERA)));

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params2 = new String[Y41bConstantes.NUM_6];
		params2[Y41bConstantes.NUM_0] = alertaProgramacion.getAlerta()
				.getAlcoor();
		params2[Y41bConstantes.NUM_1] = alertaProgramacion.getAlerta()
				.getAlnror();
		params2[Y41bConstantes.NUM_2] = alertaProgramacion.getAlerta()
				.getAlnran().toString();
		params2[Y41bConstantes.NUM_3] = alertaProgramacion.getAlerta()
				.getAlnoprse();
		params2[Y41bConstantes.NUM_4] = alertaProgramacion.getDistribuidor()
				.getInterviniente().getEsnoco();
		params2[Y41bConstantes.NUM_5] = alertaProgramacion.getCrcoor();

		texto.append("<B>").append(
				this.appMessageSource.getMessage(
						"alerta.finalizarprogramacion.mail.texto", params2,
						new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" / ")
				.append(this.appMessageSource.getMessage(
						"alerta.finalizarprogramacion.mail.texto", params2,
						new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");

		// ENLACE
		texto.append("<a href=\"");

		String urlDetalleAlerta = (String) prop
				.getProperty("URL_DETALLE_ALERTA");

		urlDetalleAlerta = urlDetalleAlerta.replace("XXX", alertaProgramacion
				.getAlerta().getAlcodigo());

		texto.append(new StringBuffer(urlDetalleAlerta).append("&locale=es")
				.toString());

		texto.append("\">");

		texto.append(this.appMessageSource.getMessage("comun.enlace", null,
				new Locale(Y41bConstantes.CASTELLANO)));

		texto.append("</a>");

		texto.append(" / ");

		texto.append("<a href=\"");

		texto.append(new StringBuffer(urlDetalleAlerta).append("&locale=eu")
				.toString());

		texto.append("\">");

		texto.append(this.appMessageSource.getMessage("comun.enlace", null,
				new Locale(Y41bConstantes.EUSKERA)));

		texto.append("</a>");

		texto.append("<BR>");

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(),
				texto.toString(), from, destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true,
					new Exception());
		}
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlertaProgramacion iniciarNuevaInspeccion(
			AlertaProgramacion alertaProgramacion) throws Exception {
		alertaProgramacion = this.alertaProgramacionDao
				.find(alertaProgramacion);

		if (alertaProgramacion != null
				&& alertaProgramacion.getCracuerdoinicio() != null
				&& alertaProgramacion.getCracuerdoinicio().equals(
						Y41bConstantes.VALOR_SI)) {
			throw new Y41bUDAException(
					"error.bandejaalerta.nuevaInspeccionException", true,
					new Exception());
		}

		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
		inspeccionDetalle.setAcfere(todayWithZeroTime);
		inspeccionDetalle.setAtcoal(alertaProgramacion.getAlerta()
				.getAlcodigo());
		inspeccionDetalle.setAtcocr(alertaProgramacion.getCrcodigo());
		inspeccionDetalle.setAdcoor(alertaProgramacion.getCrcoor());
		inspeccionDetalle.setAccoor(alertaProgramacion.getCrcoor());
		inspeccionDetalle.setAtcoes(alertaProgramacion.getDistribuidor()
				.getRdcoes());

		inspeccionDetalle.setAtcops(alertaProgramacion.getAlerta().getAlcops());
		inspeccionDetalle.setAtnoprse(alertaProgramacion.getAlerta()
				.getAlnoprse());
		inspeccionDetalle.setAtnomaps(alertaProgramacion.getAlerta()
				.getAlnomaps());
		inspeccionDetalle.setAtnomops(alertaProgramacion.getAlerta()
				.getAlnomops());
		inspeccionDetalle.setAtnrlops(alertaProgramacion.getAlerta()
				.getAlnrlops());
		inspeccionDetalle.setAtcodigobarras(alertaProgramacion.getAlerta()
				.getAlcodigobarras());
		inspeccionDetalle.setAtfedumi(alertaProgramacion.getAlerta()
				.getAlfedumi());
		inspeccionDetalle.setAtadicional(Y41bConstantes.VALOR_SI);

		this.inspeccionService.addInspeccion(inspeccionDetalle);

		return alertaProgramacion;
	}

	/**
	 * Finds a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion find(AlertaProgramacion alertaProgramacion) {
		return (AlertaProgramacion) this.alertaProgramacionDao
				.find(alertaProgramacion);
	}

	/**
	 * Finds a List of rows in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AlertaProgramacion> findAll(
			AlertaProgramacion alertaProgramacion, Pagination pagination) {
		List<AlertaProgramacion> listAlertaProgramacion = (List<AlertaProgramacion>) this.alertaProgramacionDao
				.findAll(alertaProgramacion, pagination);

		StringBuffer programaciondesc = new StringBuffer();
		StringBuffer programaciondesce = new StringBuffer();
		for (AlertaProgramacion alertaProgramacionAux : listAlertaProgramacion) {
			try {
				programaciondesc = new StringBuffer();
				programaciondesce = new StringBuffer();

				programaciondesc
						.append(alertaProgramacionAux.getCrcoor())
						.append(" - ")
						.append(Y41bUtils.formatearDateToString(
								alertaProgramacionAux.getCrfechacomunicacion(),
								Y41bConstantes.FORMATO_FECHA_ES,
								Y41bConstantes.CASTELLANO));

				if (alertaProgramacionAux.getCrfechaplazo() != null) {
					programaciondesc.append(" - ").append(
							Y41bUtils.formatearDateToString(
									alertaProgramacionAux.getCrfechaplazo(),
									Y41bConstantes.FORMATO_FECHA_ES,
									Y41bConstantes.CASTELLANO));
				}

				programaciondesce
						.append(alertaProgramacionAux.getCrcoor())
						.append(" - ")
						.append(Y41bUtils.formatearDateToString(
								alertaProgramacionAux.getCrfechacomunicacion(),
								Y41bConstantes.FORMATO_FECHA_EU,
								Y41bConstantes.EUSKERA));

				if (alertaProgramacionAux.getCrfechaplazo() != null) {
					programaciondesce.append(" - ").append(
							Y41bUtils.formatearDateToString(
									alertaProgramacionAux.getCrfechaplazo(),
									Y41bConstantes.FORMATO_FECHA_EU,
									Y41bConstantes.EUSKERA));
				}

			} catch (ParseException e) {
				programaciondesc = new StringBuffer();
				programaciondesce = new StringBuffer();
			}
			alertaProgramacionAux.setCrprogramaciondesc(programaciondesc
					.toString());
			alertaProgramacionAux.setCrprogramaciondesce(programaciondesce
					.toString());
		}

		return listAlertaProgramacion;
	}

	/**
	 * Counts rows in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return Long
	 */
	public Long findAllCount(AlertaProgramacion alertaProgramacion) {
		return this.alertaProgramacionDao.findAllCount(alertaProgramacion);
	}

	/**
	 * Finds rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AlertaProgramacion> findAllLike(
			AlertaProgramacion alertaProgramacion, Pagination pagination,
			Boolean startsWith) {
		return (List<AlertaProgramacion>) this.alertaProgramacionDao
				.findAllLike(alertaProgramacion, pagination, startsWith);
	}

	/**
	 * Counts rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AlertaProgramacion alertaProgramacion,
			Boolean startsWith) {
		return this.alertaProgramacionDao.findAllLikeCount(alertaProgramacion,
				startsWith);
	}

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AlertaProgramacion alertaProgramacion) {
		this.alertaProgramacionDao.remove(alertaProgramacion);
	}

	/**
	 * Deletes multiple rows in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AlertaProgramacion> alertaProgramacionList) {
		for (AlertaProgramacion alertaProgramacionAux : alertaProgramacionList) {
			this.alertaProgramacionDao.remove(alertaProgramacionAux);
		}
	}

}
