package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AlertaProgramacion;

/**
 * AlertaProgramacionService  
 * 
 *  
 */

public interface AlertaProgramacionService {

	/**
	 * Inserts a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	AlertaProgramacion add(AlertaProgramacion alertaProgramacion);

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	AlertaProgramacion update(AlertaProgramacion alertaProgramacion);

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 * @throws Exception
	 *             Exception
	 */
	public AlertaProgramacion finalizarProgramacion(
			AlertaProgramacion alertaProgramacion) throws Exception;

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 * @throws Exception
	 *             Exception
	 */
	public AlertaProgramacion iniciarNuevaInspeccion(
			AlertaProgramacion alertaProgramacion) throws Exception;

	/**
	 * Finds a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	AlertaProgramacion find(AlertaProgramacion alertaProgramacion);

	/**
	 * Finds a List of rows in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AlertaProgramacion> findAll(AlertaProgramacion alertaProgramacion,
			Pagination pagination);

	/**
	 * Counts rows in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return Long
	 */
	Long findAllCount(AlertaProgramacion alertaProgramacion);

	/**
	 * Finds rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AlertaProgramacion> findAllLike(AlertaProgramacion alertaProgramacion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AlertaProgramacion alertaProgramacion,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @return
	 */
	void remove(AlertaProgramacion alertaProgramacion);

	/**
	 * Deletes multiple rows in the AlertaProgramacion table.
	 * 
	 * @param alertaProgramacionList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AlertaProgramacion> alertaProgramacionList);

}
