package com.ejie.y41b.service;

import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActdecDao;
import com.ejie.y41b.dao.AdjuntartipPregProtocDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntartipPregProtoc;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PlantillaProtocoloDetalle;
import com.ejie.y41b.model.ProtocoloCabecera;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * AdjuntartipPregProtocServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntartipPregProtocService")
public class AdjuntartipPregProtocServiceImpl implements AdjuntartipPregProtocService {

	@Autowired
	private AdjuntartipPregProtocDao adjuntartipPregProtocDao;

	@Autowired
	private ProtocolService protocolService;

	@Autowired()
	private ActdecDao actdecDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private TipReqNormativoService tipReqNormativoService;

	@Autowired()
	private ActaService actaService;

	/**
	 * Inserta los documentos en la tabla temporal de tipos de preguntas
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTipPregProtocTableTemporal(TipProtocolo tipProtocolo) {
		this.adjuntartipPregProtocDao.removeAllTipPregProtoc(tipProtocolo);
		this.adjuntartipPregProtocDao.addTipPregProtoc(tipProtocolo);
	}

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param codTipoProtocoloAlta
	 *            String
	 * @return AdjuntartipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntartipPregProtoc addTipPregProtoc(AdjuntartipPregProtoc adjuntartipPregProtoc,
			String codTipoProtocoloAlta) {
		adjuntartipPregProtoc.setTrcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		adjuntartipPregProtoc.setTrcotp(codTipoProtocoloAlta);
		return this.adjuntartipPregProtocDao.add(adjuntartipPregProtoc);
	}

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntartipPregProtoc add(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		return this.adjuntartipPregProtocDao.add(adjuntartipPregProtoc);
	}

	/**
	 * Updates a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntartipPregProtoc update(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		return this.adjuntartipPregProtocDao.update(adjuntartipPregProtoc);
	}

	/**
	 * Updates a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntartipPregProtoc updateTipPregProtoc(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		return this.adjuntartipPregProtocDao.update(adjuntartipPregProtoc);
	}

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	public AdjuntartipPregProtoc find(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		return (AdjuntartipPregProtoc) this.adjuntartipPregProtocDao.find(adjuntartipPregProtoc);
	}

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return String
	 */
	public String findNumOrden(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		return (String) this.adjuntartipPregProtocDao.findNumOrden(adjuntartipPregProtoc);
	}

	/**
	 * Finds a List of rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntartipPregProtoc> findAll(AdjuntartipPregProtoc adjuntartipPregProtoc, Pagination pagination) {
		return (List<AdjuntartipPregProtoc>) this.adjuntartipPregProtocDao.findAll(adjuntartipPregProtoc, pagination);
	}

	/**
	 * Counts rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return Long
	 */
	public Long findAllCount(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		return this.adjuntartipPregProtocDao.findAllCount(adjuntartipPregProtoc);
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(TipPregProtoc tipPregProtoc) {
		return (List<TipPregProtoc>) this.adjuntartipPregProtocDao.findAllProtocoloOrdenado(tipPregProtoc);
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenadoInspeccion(TipPregProtoc tipPregProtoc) {
		return (List<TipPregProtoc>) this.adjuntartipPregProtocDao.findAllProtocoloOrdenadoInspeccion(tipPregProtoc);
	}

	/**
	 * Finds rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntartipPregProtoc> findAllLike(AdjuntartipPregProtoc adjuntartipPregProtoc, Pagination pagination,
			Boolean startsWith) {
		return (List<AdjuntartipPregProtoc>) this.adjuntartipPregProtocDao.findAllLike(adjuntartipPregProtoc,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjuntartipPregProtoc adjuntartipPregProtoc, Boolean startsWith) {
		return this.adjuntartipPregProtocDao.findAllLikeCount(adjuntartipPregProtoc, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntartipPregProtoc adjuntartipPregProtoc) {
		this.adjuntartipPregProtocDao.remove(adjuntartipPregProtoc);
	}

	/**
	 * Deletes multiple rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtocList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AdjuntartipPregProtoc> adjuntartipPregProtocList) {
		for (AdjuntartipPregProtoc adjuntartipPregProtocAux : adjuntartipPregProtocList) {
			this.adjuntartipPregProtocDao.remove(adjuntartipPregProtocAux);
		}
	}

	/**
	 * Recupera los datos de la plantilla del protocolo
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param descProtocolo
	 *            String
	 * @param conInfraccion
	 *            boolean
	 * @return PlantillaProtocoloDetalle
	 */
	public PlantillaProtocoloDetalle findPlantillaProtocolo(TipPregProtoc tipPregProtoc, String descProtocolo,
			boolean conInfraccion) {

		List<TipPregProtoc> listTipPregProtoc = (List<TipPregProtoc>) this.adjuntartipPregProtocDao
				.findAllProtocoloOrdenado(tipPregProtoc);

		listTipPregProtoc = this.concatenarLineasProtocolo(listTipPregProtoc);

		PlantillaProtocoloDetalle plantillaProtocoloDetalle = new PlantillaProtocoloDetalle();
		plantillaProtocoloDetalle.setTablaProtocolo(this.generarTablaProtocolo(listTipPregProtoc, conInfraccion, null));

		if (conInfraccion) {
			StringBuffer nombreProtocolo = new StringBuffer();
			nombreProtocolo.append(tipPregProtoc.getTipProtocolo().getTpcodigo());
			nombreProtocolo.append(" - ");
			nombreProtocolo.append(descProtocolo);
			plantillaProtocoloDetalle.setTipoProtocolo(nombreProtocolo.toString());
		} else {
			plantillaProtocoloDetalle.setTipoProtocolo(descProtocolo);
		}

		return plantillaProtocoloDetalle;
	}

	/**
	 * Generar tabla protocolo
	 * 
	 * @param listTipPregProtoc
	 *            List<TipPregProtoc>
	 * @return List<TipPregProtoc>
	 */
	private List<TipPregProtoc> concatenarLineasProtocolo(List<TipPregProtoc> listTipPregProtoc) {
		// Concatenamos las posibles lineas huerfanas.
		int index = 0;
		while (index < listTipPregProtoc.size()) {
			// Si la lnea no tiene infraccin, ni checkbox de respuesta, ni
			// ttulo, ni cdigo de pregunta, encadenarla con la anterior.
			if (index > 0 && listTipPregProtoc.get(index).getTrcotipp() == null
					&& listTipPregProtoc.get(index - 1).getTrinti().equals(listTipPregProtoc.get(index).getTrinti())) {
				listTipPregProtoc.get(index - 1)
						.setTrdetipp(new StringBuffer(listTipPregProtoc.get(index - 1).getTrdetipp()).append(" ")
								.append(listTipPregProtoc.get(index).getTrdetipp()).toString()); // Texto
																									// de
																									// la
																									// pregunta.
				listTipPregProtoc.get(index - 1).setTrcotti(listTipPregProtoc.get(index).getTrcotti()); // Infraccin.
				listTipPregProtoc.get(index - 1).setTrinti(listTipPregProtoc.get(index).getTrinti()); // Es
																										// titulo.
				listTipPregProtoc.get(index - 1).setTrinre(listTipPregProtoc.get(index).getTrinre()); // Tiene
																										// checkboxes.

				listTipPregProtoc.remove(index);
				index--;
			}
			index++;
		}

		return listTipPregProtoc;
	}

	/**
	 * Generar tabla protocolo
	 * 
	 * @param listTipPregProtoc
	 *            List<TipPregProtoc>
	 * @param conInfraccion
	 *            boolean
	 * @param codActuacion
	 *            String
	 * @return String
	 */
	private String generarTablaProtocolo(List<TipPregProtoc> listTipPregProtoc, boolean conInfraccion,
			String codActuacion) {
		StringBuffer stablaProtocolo = new StringBuffer(120);
		stablaProtocolo.append("{ ");

		// Tabla: línea inicial
		stablaProtocolo.append("\\\\trowd ");
		stablaProtocolo.append("\\\\trgaph0 ");

		// Bordes de la primera celda
		stablaProtocolo.append("\\\\clvertalt");
		if (conInfraccion) {

		} else {
			stablaProtocolo.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		}
		stablaProtocolo.append("\\\\cellx1000");

		if (conInfraccion) {
			// Bordes de la segunda celda
			stablaProtocolo.append("\\\\clvertalc");
			stablaProtocolo.append("\\\\cellx9750");
		} else {
			// Bordes de la segunda celda
			stablaProtocolo.append("\\\\clvertalc");
			stablaProtocolo.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
			stablaProtocolo.append("\\\\cellx8200");

			// Bordes de la tercera celda
			stablaProtocolo.append("\\\\clvertalc");
			stablaProtocolo.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
			stablaProtocolo.append("\\\\cellx9750");
		}

		// Fin de la definición de fila
		stablaProtocolo.append("\\\\pard ");

		// Inicio Resto filas
		for (TipPregProtoc tipPregProtocAux : listTipPregProtoc) {

			if (tipPregProtocAux.getTrinti() != null && tipPregProtocAux.getTrinti().equals("S")) {
				stablaProtocolo.append("\\\\line ");

				stablaProtocolo.append(" \\\\b");
				stablaProtocolo.append(" \\\\fs26");

				// stablaProtocolo.append(" \\\\sl480\\\\slmult1 ");
			} else {
				stablaProtocolo.append(" \\\\fs22");
				stablaProtocolo.append(" \\\\sb120");
				// stablaProtocolo.append(" \\\\sl360\\\\slmult1 ");
			}

			stablaProtocolo.append(" \\\\ql ");

			if (tipPregProtocAux.getTrcotipp() != null) {
				stablaProtocolo.append(tipPregProtocAux.getTrcotipp());
			}
			if (tipPregProtocAux.getTrinti() != null && tipPregProtocAux.getTrinti().equals("S")) {
				stablaProtocolo.append(" \\\\b0");
			}
			stablaProtocolo.append("  \\\\cell");

			if (tipPregProtocAux.getTrinti() != null && tipPregProtocAux.getTrinti().equals("S")) {
				stablaProtocolo.append("\\\\line ");
				stablaProtocolo.append(" \\\\b");
				stablaProtocolo.append(" \\\\fs26");
				// stablaProtocolo.append(" \\\\sl480\\\\slmult1 ");
			} else {
				stablaProtocolo.append(" \\\\fs22");
				stablaProtocolo.append(" \\\\sb120");
				// stablaProtocolo.append(" \\\\sl360\\\\slmult1 ");
			}
			stablaProtocolo.append(" \\\\ql ");
			if (tipPregProtocAux.getTrdetipp() != null) {
				stablaProtocolo
						.append(tipPregProtocAux.getTrdetipp().replaceAll("\u201C", "\"").replaceAll("\u201D", "\""));
			}
			if (tipPregProtocAux.getTrinti() != null && tipPregProtocAux.getTrinti().equals("S")) {
				stablaProtocolo.append(" \\\\b0");

				if (conInfraccion) {
					stablaProtocolo.append("\\\\line ");
				}
			} else {
				if (conInfraccion) {
					if (tipPregProtocAux.getTrrees() != null
							&& (tipPregProtocAux.getTrrees().equals(Y41bConstantes.VALOR_SI)
									|| tipPregProtocAux.getTrrees().equals(Y41bConstantes.VALOR_NO))) {
						stablaProtocolo.append(" \\\\i");
						stablaProtocolo.append("\\\\par ");
						stablaProtocolo.append(appMessageSource.getMessage("protocolo.respuestainfraccion", null,
								new Locale(Y41bConstantes.CASTELLANO))).append(": ");

						if (tipPregProtocAux.getTrrees() != null
								&& tipPregProtocAux.getTrrees().equals(Y41bConstantes.VALOR_SI)) {
							stablaProtocolo.append(appMessageSource.getMessage("excel.campanhas.no", null,
									new Locale(Y41bConstantes.CASTELLANO)));
						} else if (tipPregProtocAux.getTrrees() != null
								&& tipPregProtocAux.getTrrees().equals(Y41bConstantes.VALOR_NO)) {
							stablaProtocolo.append(appMessageSource.getMessage("excel.campanhas.si", null,
									new Locale(Y41bConstantes.CASTELLANO)));
						}

						if (Y41bUtils.isFilled(tipPregProtocAux.getTrcotti())) {
							stablaProtocolo.append(" - ");
							stablaProtocolo.append(tipPregProtocAux.getTrcotti());

							// buscar infraccion
							TipReqNormativo tipReqNormativo = new TipReqNormativo();
							tipReqNormativo.setTticodigo(tipPregProtocAux.getTrcotti());
							tipReqNormativo = this.tipReqNormativoService.find(tipReqNormativo);

							stablaProtocolo.append(" - ");
							stablaProtocolo.append(tipReqNormativo.getTtinombre());
						}

						stablaProtocolo.append(" \\\\i0");
						stablaProtocolo.append("\\\\line ");
					}
				}
			}
			stablaProtocolo.append("  \\\\cell  ");

			if (conInfraccion) {

			} else {
				stablaProtocolo.append(" \\\\qc ");
				if (tipPregProtocAux.getTrinti() != null && tipPregProtocAux.getTrinti().equals("N")
						&& tipPregProtocAux.getTrinre() != null && tipPregProtocAux.getTrinre().equals("S")) {
					if (Y41bUtils.isFilled(codActuacion)) {
						Actuacion actuacion = new Actuacion();
						actuacion.setAtcodigo(codActuacion);

						TipPregProtoc tipPregProtoc = new TipPregProtoc();
						tipPregProtoc.setTrcodigo(tipPregProtocAux.getTrcodigo());

						DetalleProtocolo detalleProtocolo = this.actaService.findRespuestaPreguntaProtocolo(actuacion,
								tipPregProtoc);

						if (detalleProtocolo != null && detalleProtocolo.getPtcoretp() != null
								&& detalleProtocolo.getPtcoretp().equals("S")) {
							stablaProtocolo.append("[X]    [   ]    [   ]");
						} else if (detalleProtocolo != null && detalleProtocolo.getPtcoretp() != null
								&& detalleProtocolo.getPtcoretp().equals("N")) {
							stablaProtocolo.append("[   ]    [X]    [   ]");
						} else if (detalleProtocolo != null && detalleProtocolo.getPtcoretp() != null
								&& detalleProtocolo.getPtcoretp().equals("-")) {
							stablaProtocolo.append("[   ]    [   ]    [X]");
						} else {
							stablaProtocolo.append("[   ]    [   ]    [   ]");
						}

					} else {
						stablaProtocolo.append("[   ]    [   ]    [   ]");
					}
					stablaProtocolo.append(" \\\\cell ");
				} else {
					stablaProtocolo.append("  \\\\cell  ");
				}
			}

			stablaProtocolo.append("  \\\\row  ");
		}

		// Fin resto filas
		stablaProtocolo.append(" \\\\pard\\\\par ");
		// Cierre final
		stablaProtocolo.append("}");

		return stablaProtocolo.toString();
	}

	/**
	 * Recupera los datos de la plantilla del protocolo
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param codActuacion
	 *            String
	 * @return PlantillaProtocoloDetalle
	 */
	public PlantillaProtocoloDetalle findPlantillaProtocoloInspeccion(TipPregProtoc tipPregProtoc,
			String codActuacion) {

		List<TipPregProtoc> listTipPregProtoc = (List<TipPregProtoc>) this.adjuntartipPregProtocDao
				.findAllProtocoloOrdenadoInspeccion(tipPregProtoc);

		listTipPregProtoc = this.concatenarLineasProtocolo(listTipPregProtoc);

		PlantillaProtocoloDetalle plantillaProtocoloDetalle = new PlantillaProtocoloDetalle();
		plantillaProtocoloDetalle.setTablaProtocolo(this.generarTablaProtocolo(listTipPregProtoc, false, codActuacion));

		ProtocoloCabecera protocoloCabecera = this.protocolService.findCabecera(codActuacion,
				tipPregProtoc.getTipProtocolo().getTpcodigo());

		plantillaProtocoloDetalle.setNumExpediente(protocoloCabecera.getInforme());

		// Establecimiento visitado
		plantillaProtocoloDetalle.setRazonSocialV(protocoloCabecera.getRazonSocialV());
		plantillaProtocoloDetalle.setNifV(protocoloCabecera.getNifV());
		plantillaProtocoloDetalle.setNombreComercialV(protocoloCabecera.getNombreComercialV());
		plantillaProtocoloDetalle.setTelefonoV(protocoloCabecera.getTelefonoV());
		plantillaProtocoloDetalle.setDireccionV(protocoloCabecera.getDireccionV());
		plantillaProtocoloDetalle.setMunicipioV(protocoloCabecera.getMunicipioV());

		// Producto/Servicio
		plantillaProtocoloDetalle.setDenominacion(protocoloCabecera.getDenominacion());
		plantillaProtocoloDetalle.setCodigoBarras(protocoloCabecera.getCodigoBarras());
		plantillaProtocoloDetalle.setMarcaComercial(protocoloCabecera.getMarcaComercial());
		plantillaProtocoloDetalle.setTipoLoteModelo(protocoloCabecera.getTipoLoteModelo());

		// Responsable producto
		plantillaProtocoloDetalle.setResponsableProducto(protocoloCabecera.getResponsableProducto());
		plantillaProtocoloDetalle.setNifR(protocoloCabecera.getNifR());
		plantillaProtocoloDetalle.setDireccionR(protocoloCabecera.getDireccionR());

		// Tipo Protocolo
		plantillaProtocoloDetalle.setTipoProtocolo(protocoloCabecera.getTipoProtocolo());

		// Fecha inspeccion
		plantillaProtocoloDetalle.setFechaProtocoloCas(protocoloCabecera.getFecha());

		// cod acta
		plantillaProtocoloDetalle.setCodActa(protocoloCabecera.getCodActa());

		// Pie de pagina
		Actdec actdec = new Actdec();
		actdec.setAdcoat(codActuacion);

		actdec = this.actdecDao.findDecisionInspeccion(actdec);

		Organismo organismo = new Organismo();
		// Creamos el campo direccion del organismo conectado
		StringBuffer direccionCompleta = new StringBuffer();
		// Creamos el campo codigo postal y municipio del organismo
		// conectado
		StringBuffer cpMunicipio = new StringBuffer();

		if (actdec != null) {
			organismo.setCodOrg(actdec.getAdcoor());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			if (organismo.getNombreCalle() != null && !organismo.getNombreCalle().equals("")) {
				direccionCompleta.append(organismo.getNombreCalle());

				if (organismo.getNombrePortal() != null && !organismo.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(organismo.getNombrePortal());
				}
			}

			if (organismo.getNombreCp() != null && !organismo.getNombreCp().equals("")) {
				cpMunicipio.append(organismo.getNombreCp());

				if (organismo.getNombreMunicipio() != null && !organismo.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(organismo.getNombreMunicipio());
				}
			} else if (organismo.getNombreMunicipio() != null && !organismo.getNombreMunicipio().equals("")) {
				cpMunicipio.append(organismo.getNombreMunicipio());
			}
		}

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea1 = new StringBuffer();

		piepagina_linea1.append(Y41bUtils.trataNull(direccionCompleta.toString())).append(" - ")
				.append(Y41bUtils.trataNull(cpMunicipio.toString())).append(" / ").append(" Tl. ")
				.append(organismo.getTelefono());

		plantillaProtocoloDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea2 = new StringBuffer();

		piepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ").append(organismo.getUrl());

		plantillaProtocoloDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

		return plantillaProtocoloDetalle;
	}

}
