package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntartipPregProtoc;
import com.ejie.y41b.model.PlantillaProtocoloDetalle;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;

/**
 * AdjuntartipPregProtocService  
 * 
 *  
 */

public interface AdjuntartipPregProtocService {

	/**
	 * Inserta los documentos en la tabla temporal de tipos de preguntas
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	public void addTipPregProtocTableTemporal(TipProtocolo tipProtocolo);

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param codTipoProtocoloAlta
	 *            String
	 * @return AdjuntartipPregProtoc
	 */
	public AdjuntartipPregProtoc addTipPregProtoc(AdjuntartipPregProtoc adjuntartipPregProtoc,
			String codTipoProtocoloAlta);

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	AdjuntartipPregProtoc add(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Updates a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	AdjuntartipPregProtoc update(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Updates a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	public AdjuntartipPregProtoc updateTipPregProtoc(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	AdjuntartipPregProtoc find(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return String
	 */
	String findNumOrden(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Finds a List of rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntartipPregProtoc> findAll(AdjuntartipPregProtoc adjuntartipPregProtoc, Pagination pagination);

	/**
	 * Counts rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return Long
	 */
	Long findAllCount(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(TipPregProtoc tipPregProtoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenadoInspeccion(TipPregProtoc tipPregProtoc);

	/**
	 * Finds rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntartipPregProtoc> findAllLike(AdjuntartipPregProtoc adjuntartipPregProtoc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntartipPregProtoc adjuntartipPregProtoc, Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtoc
	 *            AdjuntartipPregProtoc
	 * @return
	 */
	void remove(AdjuntartipPregProtoc adjuntartipPregProtoc);

	/**
	 * Deletes multiple rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartipPregProtocList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjuntartipPregProtoc> adjuntartipPregProtocList);

	/**
	 * Recupera los datos de la plantilla del protocolo
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param descProtocolo
	 *            String
	 * @param conInfraccion
	 *            boolean
	 * @return PlantillaProtocoloDetalle
	 */
	public PlantillaProtocoloDetalle findPlantillaProtocolo(TipPregProtoc tipPregProtoc, String descProtocolo,
			boolean conInfraccion);

	/**
	 * Recupera los datos de la plantilla del protocolo
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param codActuacion
	 *            String
	 * @return PlantillaProtocoloDetalle
	 */
	public PlantillaProtocoloDetalle findPlantillaProtocoloInspeccion(TipPregProtoc tipPregProtoc, String codActuacion);

}
