package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.AdjuntarprodagrupadoDao;
import com.ejie.y41b.model.Adjuntarprodagrupado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarprodagrupadoServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarprodagrupadoService")
public class AdjuntarprodagrupadoServiceImpl implements
		AdjuntarprodagrupadoService {

	@Autowired
	private AdjuntarprodagrupadoDao adjuntarprodagrupadoDao;

	/**
	 * Inserta los documentos en la tabla temporal de productos agrupados
	 * 
	 * @param motivo
	 *            Motivo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addProdAgrupadoTableTemporal(Motivo motivo) {
		this.adjuntarprodagrupadoDao.removeAllProdAgrupados(motivo);
		this.adjuntarprodagrupadoDao.addProdAgrupados(motivo);
	}

	/**
	 * Inserts a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Adjuntarprodagrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntarprodagrupado add(Adjuntarprodagrupado adjuntarprodagrupado) {
		try {
			return this.adjuntarprodagrupadoDao.add(adjuntarprodagrupado);
		} catch (DuplicateKeyException duplicateKeyException) {
			throw new Y41bUDAException(
					"error.adjuntarprodsagrupados.duplicateException", true,
					new Exception());
		}
	}

	/**
	 * Updates a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Adjuntarprodagrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntarprodagrupado update(Adjuntarprodagrupado adjuntarprodagrupado) {
		return this.adjuntarprodagrupadoDao.update(adjuntarprodagrupado);
	}

	/**
	 * Finds a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Adjuntarprodagrupado
	 */
	public Adjuntarprodagrupado find(Adjuntarprodagrupado adjuntarprodagrupado) {
		return (Adjuntarprodagrupado) this.adjuntarprodagrupadoDao
				.find(adjuntarprodagrupado);
	}

	/**
	 * Finds a List of rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjuntarprodagrupado> findAll(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination) {
		return (List<Adjuntarprodagrupado>) this.adjuntarprodagrupadoDao
				.findAll(adjuntarprodagrupado, pagination);
	}

	/**
	 * Counts rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Long
	 */
	public Long findAllCount(Adjuntarprodagrupado adjuntarprodagrupado) {
		return this.adjuntarprodagrupadoDao.findAllCount(adjuntarprodagrupado);
	}

	/**
	 * Finds a List of rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ProdAgrupado> findAllProdAgrupados(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination) {
		return (List<ProdAgrupado>) this.adjuntarprodagrupadoDao
				.findAllProdAgrupados(adjuntarprodagrupado, pagination);
	}

	/**
	 * Counts rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Long
	 */
	public Long findAllProdAgrupadosCount(
			Adjuntarprodagrupado adjuntarprodagrupado) {
		return this.adjuntarprodagrupadoDao
				.findAllProdAgrupadosCount(adjuntarprodagrupado);
	}

	/**
	 * Finds rows in the Adjuntarprodagrupado table using like.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Adjuntarprodagrupado> findAllLike(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination,
			Boolean startsWith) {
		return (List<Adjuntarprodagrupado>) this.adjuntarprodagrupadoDao
				.findAllLike(adjuntarprodagrupado, pagination, startsWith);
	}

	/**
	 * Counts rows in the Adjuntarprodagrupado table using like.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Adjuntarprodagrupado adjuntarprodagrupado,
			Boolean startsWith) {
		return this.adjuntarprodagrupadoDao.findAllLikeCount(
				adjuntarprodagrupado, startsWith);
	}

	/**
	 * Deletes a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Adjuntarprodagrupado adjuntarprodagrupado) {
		this.adjuntarprodagrupadoDao.remove(adjuntarprodagrupado);
	}

	/**
	 * Deletes multiple rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupadoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<Adjuntarprodagrupado> adjuntarprodagrupadoList) {
		for (Adjuntarprodagrupado adjuntarprodagrupadoAux : adjuntarprodagrupadoList) {
			this.adjuntarprodagrupadoDao.remove(adjuntarprodagrupadoAux);
		}
	}

}
