package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntarprodagrupado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.ProdAgrupado;

/**
 * AdjuntarprodagrupadoService  
 * 
 *  
 */

public interface AdjuntarprodagrupadoService {

	/**
	 * Inserta los documentos en la tabla temporal de productos agrupados
	 * 
	 * @param motivo
	 *            Motivo
	 */
	public void addProdAgrupadoTableTemporal(Motivo motivo);

	/**
	 * Inserts a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Adjuntarprodagrupado
	 */
	Adjuntarprodagrupado add(Adjuntarprodagrupado adjuntarprodagrupado);

	/**
	 * Updates a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Adjuntarprodagrupado
	 */
	Adjuntarprodagrupado update(Adjuntarprodagrupado adjuntarprodagrupado);

	/**
	 * Finds a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Adjuntarprodagrupado
	 */
	Adjuntarprodagrupado find(Adjuntarprodagrupado adjuntarprodagrupado);

	/**
	 * Finds a List of rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntarprodagrupado> findAll(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination);

	/**
	 * Counts rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Long
	 */
	Long findAllCount(Adjuntarprodagrupado adjuntarprodagrupado);

	/**
	 * Finds a List of rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ProdAgrupado> findAllProdAgrupados(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination);

	/**
	 * Counts rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Long
	 */
	public Long findAllProdAgrupadosCount(
			Adjuntarprodagrupado adjuntarprodagrupado);

	/**
	 * Finds rows in the Adjuntarprodagrupado table using like.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Adjuntarprodagrupado> findAllLike(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Adjuntarprodagrupado table using like.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Adjuntarprodagrupado adjuntarprodagrupado,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return
	 */
	void remove(Adjuntarprodagrupado adjuntarprodagrupado);

	/**
	 * Deletes multiple rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupadoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Adjuntarprodagrupado> adjuntarprodagrupadoList);

}
