package com.ejie.y41b.service;

import java.sql.Blob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.InspeccionesTipoDocumentoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.SantipdocDao;
import com.ejie.y41b.dao.TipoDocumentoDao;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * AdjuntardocsServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntardocsService")
public class AdjuntardocsServiceImpl implements AdjuntardocsService {

	@Autowired
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired
	private SolarbService solarbService;

	@Autowired
	private ArbadhsolService arbadhsolService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private ArbtipdocDao arbtipdocDao;

	@Autowired
	private SantipdocDao santipdocDao;

	@Autowired
	private TipoDocumentoDao tipoDocumentoDao;

	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	@Autowired
	private InspeccionesTipoDocumentoDao inspeccionesTipoDocumentoDao;

	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param claveTablaMaestra
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addDocsTableTemporal(String claveTablaMaestra) {
		this.adjuntardocsDao.removeAllDocsTableTemporal(claveTablaMaestra);
		this.documentoHechoDao.addAdjuntarDocs(claveTablaMaestra);
	}

	/**
	 * Inserts a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs add(Adjuntardocs adjuntardocs) {

		// Si el documento es un Acta comprobamos que no exista ya otro con el
		// mismo tipo.
		if (adjuntardocs.getTipoDocumento() != null && adjuntardocs.getTipoDocumento().getIdTipodoc() != null
				&& Y41bConstantes.TIPO_DOC_ACTA_INSP.equals(adjuntardocs.getTipoDocumento().getIdTipodoc())) {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(adjuntardocs.getThidExpediente());
			adjuntardocsAux.setThidTramite(adjuntardocs.getThidTramite());
			adjuntardocsAux.setTipoDocumento(adjuntardocs.getTipoDocumento());

			Long total = this.adjuntardocsDao.findAllCount(adjuntardocsAux);

			if (total > 0) {
				throw new Y41bUDAException("error.inspecciones.existeDocumentoActa", true, new Exception());
			}
		}

		return this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs update(Adjuntardocs adjuntardocs) {
		return this.adjuntardocsDao.update(adjuntardocs);
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs updateAdjuntarDocumentos(Adjuntardocs adjuntardocs) {
		Adjuntardocs adjuntarDocsAux = (Adjuntardocs) this.adjuntardocsDao.find(adjuntardocs);

		if (Y41bUtils.isFilled(adjuntarDocsAux.getThiddocumentum())) {
			this.adjuntardocsDao.updateTipoDocumento(adjuntardocs);
		} else {
			this.adjuntardocsDao.updateAdjuntarDocumentos(adjuntardocs);
		}
		return adjuntardocs;
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs find(Adjuntardocs adjuntardocs) {
		Adjuntardocs adjuntarDocs = (Adjuntardocs) this.adjuntardocsDao.find(adjuntardocs);

		if (adjuntarDocs.getPerfil() != null && adjuntarDocs.getPerfil().getIdPerfil() != null) {
			adjuntarDocs.setThrequierefirma(Y41bConstantes.VALOR_SI);
		}

		return adjuntarDocs;
	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjuntardocs> findAll(Adjuntardocs adjuntardocs, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("tipoDocumento.tdnombre")) {
				pagination.setSort("tipoDocumentotdnombre");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("perfil.nombreEs")) {
				pagination.setSort("PERFILNOMBREES");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("perfil.nombreEu")) {
				pagination.setSort("PERFILNOMBREEU");
			}
		}

		List<Adjuntardocs> listAdjuntardocs = (List<Adjuntardocs>) this.adjuntardocsDao.findAll(adjuntardocs,
				pagination);

		// obtener el numero de expediente del documento
		this.obtenerNumExpedienteDocumento(listAdjuntardocs);

		// obtener el tipo de documento
		this.obtenerTipoDocumento(listAdjuntardocs);

		this.tratarEstadoDocumentos(listAdjuntardocs);

		return listAdjuntardocs;

	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjuntardocs> findAllTipoDocInspecciones(Adjuntardocs adjuntardocs, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("tipodocumento.tdnombre")) {
				pagination.setSort("t4.TDNOMBRE");
			}
			if (pagination != null) {
				if (pagination.getSort() != null && pagination.getSort().equals("tipodocumento.tdnombre")) {
					pagination.setSort("t4.TDNOMBREE");
				}
			}
		}

		List<Adjuntardocs> listAdjuntardocs = (List<Adjuntardocs>) this.adjuntardocsDao
				.findAllTipoDocInspecciones(adjuntardocs, pagination);

		// obtener el numero de expediente del documento
		this.obtenerNumExpedienteDocumento(listAdjuntardocs);

		// obtener el tipo de documento
		// this.obtenerTipoDocumento(listAdjuntardocs);

		this.tratarEstadoDocumentos(listAdjuntardocs);

		return listAdjuntardocs;

	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjuntardocs> findAllTipoDocNuevo(Adjuntardocs adjuntardocs, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("tipoDocumento.tdnombre")) {
				pagination.setSort("tipoDocumentotdnombre");
			}
			if (pagination != null) {
				if (pagination.getSort() != null && pagination.getSort().equals("tipoDocumento.tdnombree")) {
					pagination.setSort("tipoDocumentotdnombre");
				}
			}
		}

		List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAllTipoDocNuevo(adjuntardocs, pagination);

		// obtener el numero de expediente del documento
		this.obtenerNumExpedienteDocumento(listAdjuntardocs);

		// obtener el tipo de documento
		this.obtenerTipoDocumento(listAdjuntardocs);

		this.tratarEstadoDocumentos(listAdjuntardocs);

		return listAdjuntardocs;
	}

	/**
	 * Counts rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Long
	 */
	public Long findAllCount(Adjuntardocs adjuntardocs) {
		return this.adjuntardocsDao.findAllCount(adjuntardocs);
	}

	/**
	 * Finds rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Adjuntardocs> findAllLike(Adjuntardocs adjuntardocs, Pagination pagination, Boolean startsWith) {
		return (List<Adjuntardocs>) this.adjuntardocsDao.findAllLike(adjuntardocs, pagination, startsWith);
	}

	/**
	 * Counts rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Adjuntardocs adjuntardocs, Boolean startsWith) {
		return this.adjuntardocsDao.findAllLikeCount(adjuntardocs, startsWith);
	}

	/**
	 * Deletes a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Adjuntardocs adjuntardocs) {
		this.adjuntardocsDao.remove(adjuntardocs);
	}

	/**
	 * Deletes multiple rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocsList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Adjuntardocs> adjuntardocsList) {
		for (Adjuntardocs adjuntardocsAux : adjuntardocsList) {
			this.adjuntardocsDao.remove(adjuntardocsAux);
		}
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs findAdjuntardocs(Adjuntardocs adjuntardocs) throws Exception {

		adjuntardocs = this.adjuntardocsDao.findAdjuntarDocs(adjuntardocs);

		// si est en dokusi, descargar de dokusi
		if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null
				&& !adjuntardocs.getThiddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(adjuntardocs.getTipoProcedimiento().getPcodigo());
			documento.setProcedure(procedure);
			documento.setOidDokusi(adjuntardocs.getThiddocumentum());

			Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			adjuntardocs.setThdatafile(blob);
			adjuntardocs.setThcontenttypefile(docDokusi.getContentType());
			adjuntardocs.setThnofile(Y41bUtils.getNameFileDokusi(docDokusi.getNombre()));
			adjuntardocs.setThsizefile(Integer.valueOf((int) docDokusi.getLength()));

		} else {
			// si no est en dokusi descargar de base de datos
		}

		return adjuntardocs;
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs findAdjuntardocsSinDocumento(Adjuntardocs adjuntardocs) throws Exception {

		adjuntardocs = this.adjuntardocsDao.findAdjuntarDocs(adjuntardocs);

		// si est en dokusi, descargar de dokusi
		if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null
				&& !adjuntardocs.getThiddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(adjuntardocs.getTipoProcedimiento().getPcodigo());
			documento.setProcedure(procedure);
			documento.setOidDokusi(adjuntardocs.getThiddocumentum());

			Documento docDokusi = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

			adjuntardocs.setThcontenttypefile(docDokusi.getContentType());
			adjuntardocs.setThnofile(Y41bUtils.getNameFileDokusi(docDokusi.getNombre()));
			adjuntardocs.setThsizefile(Integer.valueOf((int) docDokusi.getLength()));
			adjuntardocs.setRutaPif(docDokusi.getPifId());

		} else {
			// si no est en dokusi descargar de base de datos
		}

		return adjuntardocs;
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs findAdjuntardocsByExpediente(Adjuntardocs adjuntardocs) throws Exception {

		adjuntardocs = this.adjuntardocsDao.findAdjuntarDocsByExpediente(adjuntardocs);

		// si est en dokusi, descargar de dokusi
		if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null
				&& !adjuntardocs.getThiddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(adjuntardocs.getTipoProcedimiento().getPcodigo());
			documento.setProcedure(procedure);
			documento.setOidDokusi(adjuntardocs.getThiddocumentum());

			Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			adjuntardocs.setThdatafile(blob);
			adjuntardocs.setThcontenttypefile(docDokusi.getContentType());
			adjuntardocs.setThnofile(Y41bUtils.getNameFileDokusi(docDokusi.getNombre()));
			adjuntardocs.setThsizefile(Integer.valueOf((int) docDokusi.getLength()));

		} else {
			// si no est en dokusi descargar de base de datos
		}

		return adjuntardocs;
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjuntardocs findDocByPK(Adjuntardocs adjuntardocs) throws Exception {

		adjuntardocs = this.adjuntardocsDao.findDocByPK(adjuntardocs);

		// si est en dokusi, descargar de dokusi
		if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null
				&& !adjuntardocs.getThiddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(adjuntardocs.getTipoProcedimiento().getPcodigo());
			documento.setProcedure(procedure);
			documento.setOidDokusi(adjuntardocs.getThiddocumentum());

			Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			adjuntardocs.setThdatafile(blob);
			adjuntardocs.setThcontenttypefile(docDokusi.getContentType());
			adjuntardocs.setThnofile(Y41bUtils.getNameFileDokusi(docDokusi.getNombre()));
			adjuntardocs.setThsizefile(Integer.valueOf((int) docDokusi.getLength()));

		} else {
			// si no est en dokusi descargar de base de datos
		}

		return adjuntardocs;
	}

	/**
	 * Removes a single row in the Adjuntardocs table.
	 */
	public void removeAdjuntardocsAntiguos() {
		this.adjuntardocsDao.removeAdjuntardocsAntiguos();
	}

	/**
	 * Tratamiento para obtener el nmero de expediente
	 * 
	 * @param listAdjuntardocs
	 *            List<Adjuntardocs>
	 */
	private void obtenerNumExpedienteDocumento(List<Adjuntardocs> listAdjuntardocs) {
		if (listAdjuntardocs != null) {
			for (Adjuntardocs adjuntardocsAux : listAdjuntardocs) {
				if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(adjuntardocsAux.getThidExpediente());
					solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
					adjuntardocsAux.setThnumExpediente(solicitudDetalle.getNumExpediente());
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					Expedien expediente = new Expedien();
					expediente.setExcodigo(adjuntardocsAux.getThidExpediente());
					expediente = this.expedienService.find(expediente);
					adjuntardocsAux.setThnumExpediente(expediente.getCodCompletoConPrefijo());
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					Solarb solarb = new Solarb();
					solarb.setSacodigo(adjuntardocsAux.getThidExpediente());
					solarb = this.solarbService.find(solarb);
					if (solarb != null) {
						adjuntardocsAux.setThnumExpediente(solarb.getCodCompletoConPrefijo());
					}
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					String numExpediente = this.instramexpService
							.findNumExpedienteActuacion(adjuntardocsAux.getThidExpediente());
					adjuntardocsAux.setThnumExpediente(numExpediente);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
						&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					Arbadhsol arbadhsol = new Arbadhsol();
					arbadhsol.setAdhid(adjuntardocsAux.getThidExpediente());
					arbadhsol = this.arbadhsolService.find(arbadhsol);
					if (arbadhsol != null) {
						adjuntardocsAux.setThnumExpediente(arbadhsol.getNumExpediente());
					}
				}
			}
		}
	}

	/**
	 * Tratamiento para obtener el tipo de documento
	 * 
	 * @param listAdjuntardocs
	 *            List<Adjuntardocs>
	 */
	private void obtenerTipoDocumento(List<Adjuntardocs> listAdjuntardocs) {
		if (listAdjuntardocs != null) {
			for (Adjuntardocs adjuntardocsAux : listAdjuntardocs) {
				if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					TipoDocumento tipodocumento = new TipoDocumento();
					tipodocumento.setIdTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
					if (tipodocumento != null) {
						adjuntardocsAux.getTipoDocumento().setTdnombre(tipodocumento.getTdnombre());
						adjuntardocsAux.getTipoDocumento().setTdnombree(tipodocumento.getTdnombree());
					}
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					Santipdoc santipdoc = new Santipdoc();
					santipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					santipdoc = this.santipdocDao.find(santipdoc);
					if (santipdoc != null) {
						adjuntardocsAux.getTipoDocumento().setTdnombre(santipdoc.getTdnombre());
						adjuntardocsAux.getTipoDocumento().setTdnombree(santipdoc.getTdnombree());
					}
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
					if (arbtipdoc != null) {
						adjuntardocsAux.getTipoDocumento().setTdnombre(arbtipdoc.getTdnombre());
						adjuntardocsAux.getTipoDocumento().setTdnombree(arbtipdoc.getTdnombree());
					}
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					InspeccionesTipoDocumento inspeccionestipodocumento = new InspeccionesTipoDocumento();
					inspeccionestipodocumento.setIdTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					inspeccionestipodocumento = this.inspeccionesTipoDocumentoDao.find(inspeccionestipodocumento);
					if (inspeccionestipodocumento != null) {
						adjuntardocsAux.getTipoDocumento().setTdnombre(inspeccionestipodocumento.getTdnombre());
						adjuntardocsAux.getTipoDocumento().setTdnombree(inspeccionestipodocumento.getTdnombree());
					}
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
						&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
					if (arbtipdoc != null) {
						adjuntardocsAux.getTipoDocumento().setTdnombre(arbtipdoc.getTdnombre());
						adjuntardocsAux.getTipoDocumento().setTdnombree(arbtipdoc.getTdnombree());
					}
				}
			}
		}
	}

	/**
	 * Tratamiento para comprobar si se ha adjuntado un documento de tipo acuse
	 * en una notificacion comunicacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 */
	public void comprobarTipoDocumentoAcuse(List<DocumentoExpediente> listDocumentoExpediente) {

		if (listDocumentoExpediente != null) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
				documentoHechoAux = this.documentoHechoDao.findDoc(documentoHechoAux);

				if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					TipoDocumento tipodocumento = new TipoDocumento();
					tipodocumento.setIdTipodoc(documentoHechoAux.getQ5idTipodoc());
					tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
					if (tipodocumento != null && tipodocumento.getIdTipodoc() != null
							&& tipodocumento.getIdTipodoc().equals(Y41bConstantes.TIPO_DOC_ACUSE_RECIBO)) {
						throw new Y41bUDAException("error.comun.documentoAcuseNotificacion", true, new Exception());
					}
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					Santipdoc santipdoc = new Santipdoc();
					santipdoc.setTdid(documentoHechoAux.getQ5idTipodoc());

					santipdoc = this.santipdocDao.find(santipdoc);
					if (santipdoc != null && santipdoc.getTdid() != null
							&& santipdoc.getTdid().equals(Y41bConstantes.TIPO_DOC_SAN_ACUSE)) {
						throw new Y41bUDAException("error.comun.documentoAcuseNotificacion", true, new Exception());
					}
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(documentoHechoAux.getQ5idTipodoc());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
					if (arbtipdoc != null && arbtipdoc.getTdid() != null
							&& arbtipdoc.getTdid().equals(Y41bConstantes.TIPO_DOC_ARB_ACUSE)) {
						throw new Y41bUDAException("error.comun.documentoAcuseNotificacion", true, new Exception());

					}
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					InspeccionesTipoDocumento inspeccionestipodocumento = new InspeccionesTipoDocumento();
					inspeccionestipodocumento.setIdTipodoc(documentoHechoAux.getQ5idTipodoc());
					inspeccionestipodocumento = this.inspeccionesTipoDocumentoDao.find(inspeccionestipodocumento);
					if (inspeccionestipodocumento != null && inspeccionestipodocumento.getIdTipodoc() != null
							&& inspeccionestipodocumento.getIdTipodoc().equals(Y41bConstantes.TIPO_DOC_ACUSE_RECIBO)) {
						throw new Y41bUDAException("error.comun.documentoAcuseNotificacion", true, new Exception());
					}
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& (documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(documentoHechoAux.getQ5idTipodoc());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
					if (arbtipdoc != null && arbtipdoc.getTdid() != null
							&& arbtipdoc.getTdid().equals(Y41bConstantes.TIPO_DOC_ARB_ACUSE)) {
						throw new Y41bUDAException("error.comun.documentoAcuseNotificacion", true, new Exception());
					}

				}
			}
		}
	}

	/**
	 * Tratamiento del estado de los documentos
	 * 
	 * @param listAdjuntardocs
	 *            List<Adjuntardocs>
	 */
	private void tratarEstadoDocumentos(List<Adjuntardocs> listAdjuntardocs) {
		if (listAdjuntardocs != null) {
			Parametros parametros = new Parametros();

			parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
			parametros = this.parametrosDao.find(parametros);

			for (Adjuntardocs adjuntardocsAux : listAdjuntardocs) {
				if (adjuntardocsAux.getThfechasollocalizador() != null) {
					if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
							&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
									.equalsIgnoreCase(Y41bConstantes.PDF)) {

						int minutos = 0;
						if (parametros != null && parametros.getValor() != null
								&& Y41bUtils.isNumeric(parametros.getValor())) {
							minutos = Integer.parseInt(parametros.getValor());
						}

						SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

						Date d1 = null;
						Date d2 = null;
						long diffMinutes = 0;
						try {
							d1 = format.parse(format.format(adjuntardocsAux.getThfechasollocalizador()));

							d2 = format.parse(format.format(new Date()));

							long diff = d2.getTime() - d1.getTime();

							diffMinutes = diff / (60 * 1000);
						} catch (ParseException e) {
							diffMinutes = 0;
						}

						if (diffMinutes > minutos) {
							adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
						} else {
							adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
						}
					} else {
						if (adjuntardocsAux.getThestadodocumento() != null && adjuntardocsAux.getThestadodocumento()
								.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
							adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
						} else if (adjuntardocsAux.getThestadodocumento() == null || (!adjuntardocsAux
								.getThestadodocumento().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
								&& !adjuntardocsAux.getThestadodocumento()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
								&& !adjuntardocsAux.getThestadodocumento()
										.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !adjuntardocsAux.getThestadodocumento()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
								&& !adjuntardocsAux.getThestadodocumento()
										.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO))) {
							adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
						}
					}
				}
			}
		}
	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjuntardocs> findAllTipoDocArb(Adjuntardocs adjuntardocs, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("tipoDocumento.tdnombre")) {
				pagination.setSort("tipoDocumentotdnombre");
			}
			if (pagination != null) {
				if (pagination.getSort() != null && pagination.getSort().equals("tipoDocumento.tdnombree")) {
					pagination.setSort("tipoDocumentotdnombre");
				}
			}
		}

		List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, pagination);

		// obtener el numero de expediente del documento
		this.obtenerNumExpedienteDocumento(listAdjuntardocs);

		// obtener el tipo de documento
		this.obtenerTipoDocumento(listAdjuntardocs);

		this.tratarEstadoDocumentos(listAdjuntardocs);

		return listAdjuntardocs;
	}

}
