package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.DocumentoExpediente;

/**
 * AdjuntardocsService  
 * 
 *  
 */

public interface AdjuntardocsService {

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param claveTablaMaestra
	 *            String
	 */
	public void addDocsTableTemporal(String claveTablaMaestra);

	/**
	 * Inserts a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs add(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs update(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs updateAdjuntarDocumentos(Adjuntardocs adjuntardocs);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs find(Adjuntardocs adjuntardocs);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	public Adjuntardocs findDocByPK(Adjuntardocs adjuntardocs) throws Exception;

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	public Adjuntardocs findAdjuntardocsByExpediente(Adjuntardocs adjuntardocs) throws Exception;

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAll(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAllTipoDocInspecciones(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAllTipoDocNuevo(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Counts rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Long
	 */
	Long findAllCount(Adjuntardocs adjuntardocs);

	/**
	 * Finds rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Adjuntardocs> findAllLike(Adjuntardocs adjuntardocs, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Adjuntardocs adjuntardocs, Boolean startsWith);

	/**
	 * Deletes a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return
	 */
	void remove(Adjuntardocs adjuntardocs);

	/**
	 * Deletes multiple rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocsList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Adjuntardocs> adjuntardocsList);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	public Adjuntardocs findAdjuntardocs(Adjuntardocs adjuntardocs) throws Exception;

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * 
	 * @throws Exception
	 *             Exception
	 */
	public Adjuntardocs findAdjuntardocsSinDocumento(Adjuntardocs adjuntardocs) throws Exception;

	/**
	 * Removes a single row in the Adjuntardocs table.
	 */
	public void removeAdjuntardocsAntiguos();

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjuntardocs> findAllTipoDocArb(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Tratamiento para comprobar si se ha adjuntado un documento de tipo acuse
	 * en una notificacion comunicacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 */
	public void comprobarTipoDocumentoAcuse(List<DocumentoExpediente> listDocumentoExpediente);
}
