package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntarDistribuidorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarDistribuidorServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarDistribuidorService")
public class AdjuntarDistribuidorServiceImpl implements
		AdjuntarDistribuidorService {

	@Autowired
	private AdjuntarDistribuidorDao adjuntarDistribuidorDao;
	@Autowired
	private EstablecimientoDao establecimientoDao;

	/**
	 * Inserta los registros en la tabla temporal de distribuidores de la alerta
	 * 
	 * @param alerta
	 *            Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addAlertaDistribuidorTableTemporal(Alerta alerta) {
		this.adjuntarDistribuidorDao.removeAllAlertaDistribuidor(alerta);
		this.adjuntarDistribuidorDao.addAlertaDistribuidor(alerta);
	}

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarDistribuidor add(AdjuntarDistribuidor adjuntarDistribuidor) {
		return this.adjuntarDistribuidorDao.add(adjuntarDistribuidor);
	}

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarDistribuidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarDistribuidor addAlertaDistribuidor(
			AdjuntarDistribuidor adjuntarDistribuidor, String codAlertaAlta) {
		adjuntarDistribuidor.setRdcodigo(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		adjuntarDistribuidor.setRdcoal(codAlertaAlta);
		return this.adjuntarDistribuidorDao.add(adjuntarDistribuidor);
	}

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarDistribuidor update(AdjuntarDistribuidor adjuntarDistribuidor) {
		return this.adjuntarDistribuidorDao.update(adjuntarDistribuidor);
	}

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarDistribuidor updateAlertaFabricanteDistribuidor(
			AdjuntarDistribuidor adjuntarDistribuidor) {

		AdjuntarDistribuidor adjuntarDistribuidorAux = this.adjuntarDistribuidorDao
				.find(adjuntarDistribuidor);

		this.adjuntarDistribuidorDao
				.updateRemoveAllFabricante(adjuntarDistribuidor);

		if (adjuntarDistribuidorAux.getRdfabricante() != null
				&& adjuntarDistribuidorAux.getRdfabricante().equals(
						Y41bConstantes.VALOR_NO)) {
			this.adjuntarDistribuidorDao
					.updateAlertaFabricanteDistribuidor(adjuntarDistribuidor);
		}

		return adjuntarDistribuidor;
	}

	/**
	 * Finds a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor find(AdjuntarDistribuidor adjuntarDistribuidor) {
		AdjuntarDistribuidor adjuntarDistribuidorAux = (AdjuntarDistribuidor) this.adjuntarDistribuidorDao
				.find(adjuntarDistribuidor);

		if (adjuntarDistribuidorAux != null
				&& !Y41bUtils.isFilled(adjuntarDistribuidorAux
						.getRdidinterviniente())) {
			// buscar establecimiento
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(adjuntarDistribuidorAux.getRdcoes());

			establecimiento = this.establecimientoDao.find(establecimiento);

			adjuntarDistribuidorAux.setNif(establecimiento.getEsnif());
			adjuntarDistribuidorAux.setNombre(establecimiento.getEsnombre());
			adjuntarDistribuidorAux.setEsnoco(establecimiento.getEsnoco());
			adjuntarDistribuidorAux.setNombreProvincia(establecimiento
					.getEsnombreProvincia());
			adjuntarDistribuidorAux.setNombreMunicipio(establecimiento
					.getEsnombreMunicipio());
		}

		return adjuntarDistribuidorAux;
	}

	/**
	 * Finds a List of rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarDistribuidor> findAll(
			AdjuntarDistribuidor adjuntarDistribuidor, Pagination pagination) {
		List<AdjuntarDistribuidor> listAdjuntarDistribuidor = (List<AdjuntarDistribuidor>) this.adjuntarDistribuidorDao
				.findAll(adjuntarDistribuidor, pagination);

		for (AdjuntarDistribuidor adjuntarDistribuidorAux : listAdjuntarDistribuidor) {
			if (!Y41bUtils.isFilled(adjuntarDistribuidorAux
					.getRdidinterviniente())) {
				// buscar establecimiento
				Establecimiento establecimiento = new Establecimiento();
				establecimiento
						.setEscodigo(adjuntarDistribuidorAux.getRdcoes());

				establecimiento = this.establecimientoDao.find(establecimiento);

				adjuntarDistribuidorAux.setNif(establecimiento.getEsnif());
				adjuntarDistribuidorAux
						.setNombre(establecimiento.getEsnombre());
				adjuntarDistribuidorAux.setEsnoco(establecimiento.getEsnoco());
				adjuntarDistribuidorAux.setNombreProvincia(establecimiento
						.getEsnombreProvincia());
				adjuntarDistribuidorAux.setNombreMunicipio(establecimiento
						.getEsnombreMunicipio());
			}
		}

		return listAdjuntarDistribuidor;
	}

	/**
	 * Counts rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return Long
	 */
	public Long findAllCount(AdjuntarDistribuidor adjuntarDistribuidor) {
		return this.adjuntarDistribuidorDao.findAllCount(adjuntarDistribuidor);
	}

	/**
	 * Finds rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntarDistribuidor> findAllLike(
			AdjuntarDistribuidor adjuntarDistribuidor, Pagination pagination,
			Boolean startsWith) {
		return (List<AdjuntarDistribuidor>) this.adjuntarDistribuidorDao
				.findAllLike(adjuntarDistribuidor, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjuntarDistribuidor adjuntarDistribuidor,
			Boolean startsWith) {
		return this.adjuntarDistribuidorDao.findAllLikeCount(
				adjuntarDistribuidor, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntarDistribuidor adjuntarDistribuidor) {
		try {
			this.adjuntarDistribuidorDao.remove(adjuntarDistribuidor);
		} catch (Exception e) {
			throw new Y41bUDAException(
					"error.alerta.DataIntegrityViolationExceptionDistDel",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidorList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<AdjuntarDistribuidor> adjuntarDistribuidorList) {
		for (AdjuntarDistribuidor adjuntarDistribuidorAux : adjuntarDistribuidorList) {
			this.adjuntarDistribuidorDao.remove(adjuntarDistribuidorAux);
		}
	}

}
