package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Alerta;

/**
 * AdjuntarDistribuidorService  
 * 
 *  
 */

public interface AdjuntarDistribuidorService {

	/**
	 * Inserta los registros en la tabla temporal de distribuidores de la alerta
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void addAlertaDistribuidorTableTemporal(Alerta alerta);

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	AdjuntarDistribuidor add(AdjuntarDistribuidor adjuntarDistribuidor);

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor addAlertaDistribuidor(
			AdjuntarDistribuidor adjuntarDistribuidor, String codAlertaAlta);

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	AdjuntarDistribuidor update(AdjuntarDistribuidor adjuntarDistribuidor);

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteDistribuidor(
			AdjuntarDistribuidor adjuntarDistribuidor);

	/**
	 * Finds a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	AdjuntarDistribuidor find(AdjuntarDistribuidor adjuntarDistribuidor);

	/**
	 * Finds a List of rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarDistribuidor> findAll(
			AdjuntarDistribuidor adjuntarDistribuidor, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return Long
	 */
	Long findAllCount(AdjuntarDistribuidor adjuntarDistribuidor);

	/**
	 * Finds rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarDistribuidor> findAllLike(
			AdjuntarDistribuidor adjuntarDistribuidor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarDistribuidor adjuntarDistribuidor,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidor
	 *            AdjuntarDistribuidor
	 * @return
	 */
	void remove(AdjuntarDistribuidor adjuntarDistribuidor);

	/**
	 * Deletes multiple rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntarDistribuidorList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjuntarDistribuidor> adjuntarDistribuidorList);

}
