package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntarComusoivrerelDao;
import com.ejie.y41b.dao.ComunicacionSoivreDao;
import com.ejie.y41b.model.AdjuntarComusoivrerel;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarComusoivrerelServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarComusoivrerelService")
public class AdjuntarComusoivrerelServiceImpl implements
		AdjuntarComusoivrerelService {

	@Autowired
	private AdjuntarComusoivrerelDao adjuntarComusoivrerelDao;

	@Autowired
	private ComunicacionSoivreDao comunicacionSoivreDao;

	/**
	 * Inserta los registros en la tabla temporal de comunicaciones soivre
	 * relacionadas
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addComuSoivreRelTableTemporal(
			ComunicacionSoivre comunicacionSoivre) {
		this.adjuntarComusoivrerelDao
				.removeAllComuSoivreRel(comunicacionSoivre);
		this.adjuntarComusoivrerelDao.addComuSoivreRel(comunicacionSoivre);
	}

	/**
	 * Inserts a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarComusoivrerel add(AdjuntarComusoivrerel adjuntarComusoivrerel) {
		if (this.adjuntarComusoivrerelDao.findAllCount(adjuntarComusoivrerel) > 0) {
			throw new Y41bUDAException(
					"error.comunicacionsoivre.duplicateException", true,
					new Exception());

		}

		adjuntarComusoivrerel.setV7codigo(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		return this.adjuntarComusoivrerelDao.add(adjuntarComusoivrerel);
	}

	/**
	 * Updates a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarComusoivrerel update(
			AdjuntarComusoivrerel adjuntarComusoivrerel) {
		return this.adjuntarComusoivrerelDao.update(adjuntarComusoivrerel);
	}

	/**
	 * Finds a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	public AdjuntarComusoivrerel find(
			AdjuntarComusoivrerel adjuntarComusoivrerel) {
		return (AdjuntarComusoivrerel) this.adjuntarComusoivrerelDao
				.find(adjuntarComusoivrerel);
	}

	/**
	 * Finds a List of rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionSoivre> findAll(
			AdjuntarComusoivrerel adjuntarComusoivrerel, Pagination pagination) {
		List<AdjuntarComusoivrerel> listAdjuntarComusoivrerel = (List<AdjuntarComusoivrerel>) this.adjuntarComusoivrerelDao
				.findAll(adjuntarComusoivrerel, pagination);

		List<ComunicacionSoivre> listComunicacionSoivre = new ArrayList<ComunicacionSoivre>();
		ComunicacionSoivre comunicacionSoivre = null;
		for (AdjuntarComusoivrerel adjuntarComusoivrerelAux : listAdjuntarComusoivrerel) {
			comunicacionSoivre = new ComunicacionSoivre();
			comunicacionSoivre.setIdcomunicacionsoivre(adjuntarComusoivrerelAux
					.getIdcomunicacionsoivrerel());
			comunicacionSoivre = this.comunicacionSoivreDao
					.find(comunicacionSoivre);

			listComunicacionSoivre.add(comunicacionSoivre);
		}

		return listComunicacionSoivre;
	}

	/**
	 * Counts rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return Long
	 */
	public Long findAllCount(AdjuntarComusoivrerel adjuntarComusoivrerel) {
		return this.adjuntarComusoivrerelDao
				.findAllCount(adjuntarComusoivrerel);
	}

	/**
	 * Finds rows in the AdjuntarComusoivrerel table using like.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntarComusoivrerel> findAllLike(
			AdjuntarComusoivrerel adjuntarComusoivrerel, Pagination pagination,
			Boolean startsWith) {
		return (List<AdjuntarComusoivrerel>) this.adjuntarComusoivrerelDao
				.findAllLike(adjuntarComusoivrerel, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjuntarComusoivrerel table using like.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjuntarComusoivrerel adjuntarComusoivrerel,
			Boolean startsWith) {
		return this.adjuntarComusoivrerelDao.findAllLikeCount(
				adjuntarComusoivrerel, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntarComusoivrerel adjuntarComusoivrerel) {
		this.adjuntarComusoivrerelDao.remove(adjuntarComusoivrerel);
	}

	/**
	 * Deletes a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeComusoivrerel(AdjuntarComusoivrerel adjuntarComusoivrerel) {
		this.adjuntarComusoivrerelDao
				.removeComusoivrerel(adjuntarComusoivrerel);
	}

	/**
	 * Deletes multiple rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerelList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<AdjuntarComusoivrerel> adjuntarComusoivrerelList) {
		for (AdjuntarComusoivrerel adjuntarComusoivrerelAux : adjuntarComusoivrerelList) {
			this.adjuntarComusoivrerelDao.remove(adjuntarComusoivrerelAux);
		}
	}

}
