package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarComusoivrerel;
import com.ejie.y41b.model.ComunicacionSoivre;

/**
 * AdjuntarComusoivrerelService  
 * 
 *  
 */

public interface AdjuntarComusoivrerelService {

	/**
	 * Inserta los registros en la tabla temporal de comunicaciones soivre
	 * relacionadas
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 */
	public void addComuSoivreRelTableTemporal(
			ComunicacionSoivre comunicacionSoivre);

	/**
	 * Inserts a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	AdjuntarComusoivrerel add(AdjuntarComusoivrerel adjuntarComusoivrerel);

	/**
	 * Updates a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	AdjuntarComusoivrerel update(AdjuntarComusoivrerel adjuntarComusoivrerel);

	/**
	 * Finds a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return AdjuntarComusoivrerel
	 */
	AdjuntarComusoivrerel find(AdjuntarComusoivrerel adjuntarComusoivrerel);

	/**
	 * Finds a List of rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionSoivre> findAll(
			AdjuntarComusoivrerel adjuntarComusoivrerel, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return Long
	 */
	Long findAllCount(AdjuntarComusoivrerel adjuntarComusoivrerel);

	/**
	 * Finds rows in the AdjuntarComusoivrerel table using like.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarComusoivrerel> findAllLike(
			AdjuntarComusoivrerel adjuntarComusoivrerel, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarComusoivrerel table using like.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarComusoivrerel adjuntarComusoivrerel,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return
	 */
	void remove(AdjuntarComusoivrerel adjuntarComusoivrerel);

	/**
	 * Deletes a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return
	 */
	public void removeComusoivrerel(AdjuntarComusoivrerel adjuntarComusoivrerel);

	/**
	 * Deletes multiple rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarComusoivrerelList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjuntarComusoivrerel> adjuntarComusoivrerelList);

}
