package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.AdjuntarCampanhatipoprotDao;
import com.ejie.y41b.dao.ProtocolDao;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarCampanhatipoprot;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarCampanhatipoprotServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarCampanhatipoprotService")
public class AdjuntarCampanhatipoprotServiceImpl implements
		AdjuntarCampanhatipoprotService {

	@Autowired
	private AdjuntarCampanhatipoprotDao adjuntarCampanhatipoprotDao;

	@Autowired()
	private ActaDao actaDao;

	@Autowired
	private ProtocolDao protocolDao;

	/**
	 * Inserta los registros en la tabla temporal de protocolos de la campaña
	 * 
	 * @param campanha
	 *            Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addCampanhatipoprotTableTemporal(Campanha campanha) {
		this.adjuntarCampanhatipoprotDao.removeAllCampanhatipoprot(campanha);
		this.adjuntarCampanhatipoprotDao.addCampanhatipoprot(campanha);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhatipoprot
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhatipoprot addCampanhatipoprot(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			String codCampanhaAlta) {
		try {
			adjuntarCampanhatipoprot.setCmcodigo(codCampanhaAlta);
			return this.adjuntarCampanhatipoprotDao
					.add(adjuntarCampanhatipoprot);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.tipoprot.DuplicateKeyException",
					true, e);
		}
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return AdjuntarCampanhatipoprot
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhatipoprot add(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot) {
		return this.adjuntarCampanhatipoprotDao.add(adjuntarCampanhatipoprot);
	}

	/**
	 * Updates a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return AdjuntarCampanhatipoprot
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhatipoprot update(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot) {
		return this.adjuntarCampanhatipoprotDao
				.update(adjuntarCampanhatipoprot);
	}

	/**
	 * Finds a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return AdjuntarCampanhatipoprot
	 */
	public AdjuntarCampanhatipoprot find(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot) {
		return (AdjuntarCampanhatipoprot) this.adjuntarCampanhatipoprotDao
				.find(adjuntarCampanhatipoprot);
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarCampanhatipoprot> findAll(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Pagination pagination) {
		return (List<AdjuntarCampanhatipoprot>) this.adjuntarCampanhatipoprotDao
				.findAll(adjuntarCampanhatipoprot, pagination);
	}

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return Long
	 */
	public Long findAllCount(AdjuntarCampanhatipoprot adjuntarCampanhatipoprot) {
		return this.adjuntarCampanhatipoprotDao
				.findAllCount(adjuntarCampanhatipoprot);
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAllTipProtocolo(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Pagination pagination) {
		return (List<TipProtocolo>) this.adjuntarCampanhatipoprotDao
				.findAllTipProtocolo(adjuntarCampanhatipoprot, pagination);
	}

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return Long
	 */
	public Long findAllTipProtocoloCount(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot) {
		return this.adjuntarCampanhatipoprotDao
				.findAllTipProtocoloCount(adjuntarCampanhatipoprot);
	}

	/**
	 * Finds rows in the AdjuntarCampanhatipoprot table using like.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntarCampanhatipoprot> findAllLike(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjuntarCampanhatipoprot>) this.adjuntarCampanhatipoprotDao
				.findAllLike(adjuntarCampanhatipoprot, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table using like.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Boolean startsWith) {
		return this.adjuntarCampanhatipoprotDao.findAllLikeCount(
				adjuntarCampanhatipoprot, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntarCampanhatipoprot adjuntarCampanhatipoprot) {
		Acta acta = new Acta();
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcocm(adjuntarCampanhatipoprot.getCmcodigo());
		acta.setActuacion(actuacion);
		acta.setIndIncluirCerrados(Y41bConstantes.VALOR_SI);

		// Buscar las actuaciones de la campaa
		List<BusquedaInspeccion> listBusquedaInspeccion = this.actaDao
				.findAllActaLike(acta, null);

		Protocol protocol = null;
		for (BusquedaInspeccion busquedaInspeccionAux : listBusquedaInspeccion) {
			protocol = new Protocol();
			protocol.setPtcoat(busquedaInspeccionAux.getAtcodigo());
			protocol.setPtcodigo(adjuntarCampanhatipoprot.getTpcodigo());

			// Buscar las preguntas contestadas de ese protocolo
			Long respuestas = this.protocolDao
					.findAllPreguntasContestadasCount(protocol);

			// Si ha contestado a alguna pregunta se lanza error
			if (respuestas > 0) {
				throw new Y41bUDAException(
						"error.campanha.RemoveProtocoloException", true,
						new Exception());
			}
		}

		this.adjuntarCampanhatipoprotDao.remove(adjuntarCampanhatipoprot);
	}

	/**
	 * Deletes multiple rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprotList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<AdjuntarCampanhatipoprot> adjuntarCampanhatipoprotList) {
		for (AdjuntarCampanhatipoprot adjuntarCampanhatipoprotAux : adjuntarCampanhatipoprotList) {
			this.adjuntarCampanhatipoprotDao
					.remove(adjuntarCampanhatipoprotAux);
		}
	}

}
