package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhatipoprot;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.TipProtocolo;

/**
 * AdjuntarCampanhatipoprotService  
 * 
 *  
 */

public interface AdjuntarCampanhatipoprotService {

	/**
	 * Inserta los registros en la tabla temporal de protocolos de la campaña
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhatipoprotTableTemporal(Campanha campanha);

	/**
	 * Inserts a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhatipoprot
	 */
	public AdjuntarCampanhatipoprot addCampanhatipoprot(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			String codCampanhaAlta);

	/**
	 * Inserts a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return AdjuntarCampanhatipoprot
	 */
	AdjuntarCampanhatipoprot add(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot);

	/**
	 * Updates a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return AdjuntarCampanhatipoprot
	 */
	AdjuntarCampanhatipoprot update(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot);

	/**
	 * Finds a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return AdjuntarCampanhatipoprot
	 */
	AdjuntarCampanhatipoprot find(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot);

	/**
	 * Finds a List of rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarCampanhatipoprot> findAll(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Pagination pagination);

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return Long
	 */
	Long findAllCount(AdjuntarCampanhatipoprot adjuntarCampanhatipoprot);

	/**
	 * Finds a List of rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAllTipProtocolo(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Pagination pagination);

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return Long
	 */
	public Long findAllTipProtocoloCount(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot);

	/**
	 * Finds rows in the AdjuntarCampanhatipoprot table using like.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarCampanhatipoprot> findAllLike(
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table using like.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return
	 */
	void remove(AdjuntarCampanhatipoprot adjuntarCampanhatipoprot);

	/**
	 * Deletes multiple rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprotList
	 *            List
	 * @return
	 */
	void removeMultiple(
			List<AdjuntarCampanhatipoprot> adjuntarCampanhatipoprotList);

}
