package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjuntarCampanhaproductoDao;
import com.ejie.y41b.dao.AdjuntarCampanhaprograDao;
import com.ejie.y41b.dao.BandejaCampanhaDao;
import com.ejie.y41b.dao.CampanhaCierreDao;
import com.ejie.y41b.dao.CampanhaComentariosDao;
import com.ejie.y41b.dao.CampanhaProdDao;
import com.ejie.y41b.dao.CampanhaProgramacionDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CampanhaComentarios;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarCampanhaprograServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarCampanhaprograService")
public class AdjuntarCampanhaprograServiceImpl implements AdjuntarCampanhaprograService {

	@Autowired
	private AdjuntarCampanhaprograDao adjuntarCampanhaprograDao;

	@Autowired
	private CampanhaProgramacionDao campanhaProgramacionDao;

	@Autowired
	private BandejaCampanhaDao bandejaCampanhaDao;

	@Autowired
	private ActuacionDao actuacionDao;

	@Autowired
	private InspeccionService inspeccionService;

	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired
	private CampanhaProdDao campanhaProdDao;

	@Autowired
	private AdjuntarCampanhaproductoDao adjuntarCampanhaproductoDao;

	@Autowired
	private CampanhaService campanhaService;

	@Autowired
	private CampanhaComentariosDao campanhaComentariosDao;

	@Autowired
	private CampanhaCierreDao campanhaCierreDao;

	/**
	 * Inserta los registros en la tabla temporal de programacin de la campaña
	 * 
	 * @param campanha
	 *            Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addCampanhaprograTableTemporal(Campanha campanha) {
		this.adjuntarCampanhaprograDao.removeAllCampanhaprogra(campanha);
		this.adjuntarCampanhaprograDao.addCampanhaprogra(campanha);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaprogra add(AdjuntarCampanhaprogra adjuntarCampanhaprogra) {
		return this.adjuntarCampanhaprograDao.add(adjuntarCampanhaprogra);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaproducto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaprogra addCampanhaprogra(AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			String codCampanhaAlta) {
		adjuntarCampanhaprogra.setPgcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		adjuntarCampanhaprogra.setPgcocm(codCampanhaAlta);

		// count por campaa y organismo
		Long numCampanhaOrganismo = this.adjuntarCampanhaprograDao
				.findAllCampanhaOrganismoCount(adjuntarCampanhaprogra);
		if (numCampanhaOrganismo > 0) {
			// si es mayor que 0 lanzar error
			throw new Y41bUDAException("error.campanha.OrganismoException", true, new Exception());
		}

		adjuntarCampanhaprogra = this.adjuntarCampanhaprograDao.add(adjuntarCampanhaprogra);

		return adjuntarCampanhaprogra;
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaproducto
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaprogra addCampanhaprograInspeccionAdicional(AdjuntarCampanhaprogra adjuntarCampanhaprogra)
			throws Exception {
		// Buscar campanha para comprobar si SSTT seleccionados tienen su parte
		// cerrada.
		AdjuntarCampanhaprogra adjuntarCampanhaprograAux = this.adjuntarCampanhaprograDao
				.findConCierres(adjuntarCampanhaprogra);

		// Si SSCC ha cerrado su parte de la campanha, no se podra aniadir
		// ninguna inspeccion adicional.
		if (Y41bConstantes.VALOR_SI.equals(adjuntarCampanhaprograAux.getCampanhaCierre().getTyfinalizadosscc())) {
			throw new Y41bUDAException("error.campanha.inpseccionAcicionalSSCCException", true, new Exception());
		}

		Integer totalNumInspecAdicionalesSol = 0;

		totalNumInspecAdicionalesSol += adjuntarCampanhaprogra.getPgnumTomasMuestrasSol();
		totalNumInspecAdicionalesSol += adjuntarCampanhaprogra.getPgnumControlesEstandarSol();
		totalNumInspecAdicionalesSol += adjuntarCampanhaprogra.getPgnumControlesOtrosSol();

		adjuntarCampanhaprogra.setPgnumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

		// actualizar el numero en la tabla temporal
		this.adjuntarCampanhaprograDao.updateInspeccionAdicional(adjuntarCampanhaprogra);

		// actualizar el numero en la tabla de campaas
		CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
		campanhaprogramacion.setPgcodigo(adjuntarCampanhaprogra.getPgcodigo());
		campanhaprogramacion.setPgnumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

		this.campanhaProgramacionDao.updateInspeccionAdicional(campanhaprogramacion);

		// actualizar el numero en la bandeja
		BandejaCampanha bandejacampanha = new BandejaCampanha();
		bandejacampanha.setCampanhaProgramacion(campanhaprogramacion);
		bandejacampanha.setTznumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

		this.bandejaCampanhaDao.updateInspeccionAdicional(bandejacampanha);

		campanhaprogramacion = this.campanhaProgramacionDao.find(campanhaprogramacion);

		// actualizar el numero en la bandeja de SSCC
		bandejacampanha = new BandejaCampanha();
		Campanha campanha = new Campanha();
		campanha.setCmcodigo(campanhaprogramacion.getCampanha().getCmcodigo());
		bandejacampanha.setCampanha(campanha);
		bandejacampanha.setTznumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

		this.bandejaCampanhaDao.updateInspeccionAdicionalSSCC(bandejacampanha);

		AdjuntarCampanhaproducto adjuntarcampanhaproducto = new AdjuntarCampanhaproducto();
		adjuntarcampanhaproducto.setCpcocm(campanha.getCmcodigo());

		Long totalProds = this.campanhaProdDao.findAllProdCount(adjuntarcampanhaproducto);

		String cpcops = null;
		String cpnops = null;

		if (totalProds == 1) {
			List<AdjuntarCampanhaproducto> listAdjuntarCampanhaproducto = this.adjuntarCampanhaproductoDao
					.findAll(adjuntarcampanhaproducto, null);
			if (listAdjuntarCampanhaproducto != null && listAdjuntarCampanhaproducto.size() > 0) {
				cpcops = listAdjuntarCampanhaproducto.get(0).getCpcops();
				cpnops = listAdjuntarCampanhaproducto.get(0).getCpnops();
			}
		}

		// Generar inspeccion
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		// Generar las inspecciones
		if (adjuntarCampanhaprogra.getPgnumTomasMuestrasSol() > 0) {
			for (int i = 0; i < adjuntarCampanhaprogra.getPgnumTomasMuestrasSol(); i++) {
				InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
				inspeccionDetalle.setAcfere(todayWithZeroTime);
				inspeccionDetalle.setAtcocm(campanhaprogramacion.getCampanha().getCmcodigo());
				inspeccionDetalle.setAtcopg(campanhaprogramacion.getPgcodigo());
				inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
				inspeccionDetalle.setAdcoor(campanhaprogramacion.getPgcoor());
				inspeccionDetalle.setAccoor(campanhaprogramacion.getPgcoor());
				inspeccionDetalle.setAtadicional(Y41bConstantes.VALOR_SI);

				inspeccionDetalle.setAtcops(cpcops);
				inspeccionDetalle.setAtnoprse(cpnops);

				this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
			}
		}

		if (adjuntarCampanhaprogra.getPgnumControlesEstandarSol() > 0) {
			for (int i = 0; i < adjuntarCampanhaprogra.getPgnumControlesEstandarSol(); i++) {
				InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
				inspeccionDetalle.setAcfere(todayWithZeroTime);
				inspeccionDetalle.setAtcocm(campanhaprogramacion.getCampanha().getCmcodigo());
				inspeccionDetalle.setAtcopg(campanhaprogramacion.getPgcodigo());
				inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
				inspeccionDetalle.setAdcoor(campanhaprogramacion.getPgcoor());
				inspeccionDetalle.setAccoor(campanhaprogramacion.getPgcoor());
				inspeccionDetalle.setAtadicional(Y41bConstantes.VALOR_SI);

				inspeccionDetalle.setAtcops(cpcops);
				inspeccionDetalle.setAtnoprse(cpnops);

				this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
			}
		}

		if (adjuntarCampanhaprogra.getPgnumControlesOtrosSol() > 0) {
			for (int i = 0; i < adjuntarCampanhaprogra.getPgnumControlesOtrosSol(); i++) {
				InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
				inspeccionDetalle.setAcfere(todayWithZeroTime);
				inspeccionDetalle.setAtcocm(campanhaprogramacion.getCampanha().getCmcodigo());
				inspeccionDetalle.setAtcopg(campanhaprogramacion.getPgcodigo());
				inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
				inspeccionDetalle.setAdcoor(campanhaprogramacion.getPgcoor());
				inspeccionDetalle.setAccoor(campanhaprogramacion.getPgcoor());
				inspeccionDetalle.setAtadicional(Y41bConstantes.VALOR_SI);

				inspeccionDetalle.setAtcops(cpcops);
				inspeccionDetalle.setAtnoprse(cpnops);

				this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
			}
		}

		return adjuntarCampanhaprogra;
	}

	/**
	 * Updates a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaprogra update(AdjuntarCampanhaprogra adjuntarCampanhaprogra) {
		return this.adjuntarCampanhaprograDao.update(adjuntarCampanhaprogra);
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	public AdjuntarCampanhaprogra find(AdjuntarCampanhaprogra adjuntarCampanhaprogra) {
		return (AdjuntarCampanhaprogra) this.adjuntarCampanhaprograDao.find(adjuntarCampanhaprogra);
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarCampanhaprogra> findAll(AdjuntarCampanhaprogra adjuntarCampanhaprogra, Pagination pagination) {
		List<AdjuntarCampanhaprogra> listAdjuntarCampanhaprogra = this.adjuntarCampanhaprograDao
				.findAll(adjuntarCampanhaprogra, pagination);

		for (AdjuntarCampanhaprogra adjuntarCampanhaprograAux : listAdjuntarCampanhaprogra) {
			// Campos calculados
			Actuacion actuacion = new Actuacion();
			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
			actuacion.setAtcocm(adjuntarCampanhaprograAux.getPgcocm());
			actuacion.setAtcopg(adjuntarCampanhaprograAux.getPgcodigo());
			Long numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			adjuntarCampanhaprograAux.setPgnumTomasMuestrasRealizadas(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
			numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			adjuntarCampanhaprograAux.setPgnumControlesEstandarRealizados(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
			numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			adjuntarCampanhaprograAux.setPgnumControlesOtrosRealizados(numInspeccionesRealizadas.intValue());

			Integer numInspecciones = 0;
			numInspecciones += adjuntarCampanhaprograAux.getPgnumTomasMuestrasSol();
			numInspecciones += adjuntarCampanhaprograAux.getPgnumControlesEstandarSol();
			numInspecciones += adjuntarCampanhaprograAux.getPgnumControlesOtrosSol();

			adjuntarCampanhaprograAux.setPgnumInspeccionesSol(numInspecciones);

			numInspeccionesRealizadas = new Long(0);
			numInspeccionesRealizadas += adjuntarCampanhaprograAux.getPgnumTomasMuestrasRealizadas();
			numInspeccionesRealizadas += adjuntarCampanhaprograAux.getPgnumControlesEstandarRealizados();
			numInspeccionesRealizadas += adjuntarCampanhaprograAux.getPgnumControlesOtrosRealizados();

			adjuntarCampanhaprograAux.setPgnumInspeccionesRealizadas(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(null);
			actuacion.setAtadicional(Y41bConstantes.VALOR_SI);
			Long numInspeccionesAdicionalesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			adjuntarCampanhaprograAux
					.setPgnumInspecAdicionalesRealizadas(numInspeccionesAdicionalesRealizadas.intValue());

			Integer totalInspecciones = 0;
			totalInspecciones += numInspecciones;
			totalInspecciones += adjuntarCampanhaprograAux.getPgnumInspecAdicionalesSol();

			adjuntarCampanhaprograAux.setPgtotalInspeccionesSol(totalInspecciones);

			Integer totalInspeccionesRealizadas = 0;
			totalInspeccionesRealizadas += numInspeccionesRealizadas.intValue();
			totalInspeccionesRealizadas += adjuntarCampanhaprograAux.getPgnumInspecAdicionalesRealizadas();

			adjuntarCampanhaprograAux.setPgtotalInspeccionesRealizadas(totalInspeccionesRealizadas);

			actuacion = new Actuacion();
			actuacion.setAtcocmrelacionada(adjuntarCampanhaprograAux.getPgcocm());
			actuacion.setAtcopgrelacionada(adjuntarCampanhaprograAux.getPgcodigo());
			Long numInspeccionesAsociadasRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			adjuntarCampanhaprograAux.setPgnumInspeccionesAsociadas(numInspeccionesAsociadasRealizadas.intValue());

			// Calcular la fase
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(adjuntarCampanhaprograAux.getPgcocm());

			campanha = this.campanhaService.find(campanha);
			adjuntarCampanhaprograAux.setPgfase(this.campanhaService.obtenerFaseCampnha(campanha));

			// si hay alguno de los comentarios metido poner S
			CampanhaComentarios campanhaComentarios = new CampanhaComentarios();
			campanhaComentarios.setTxcmcodigo(adjuntarCampanhaprograAux.getPgcocm());
			campanhaComentarios = (CampanhaComentarios) this.campanhaComentariosDao.find(campanhaComentarios);

			if (campanhaComentarios != null) {
				if (Y41bUtils.isFilled(campanhaComentarios.getTxcomentarioaraba())
						|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariobizkaia())
						|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariogipuzkoa())
						|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariosscc())) {
					adjuntarCampanhaprograAux.setComentarios(Y41bConstantes.VALOR_SI);
				} else {
					adjuntarCampanhaprograAux.setComentarios(Y41bConstantes.VALOR_NO);
				}
			} else {
				adjuntarCampanhaprograAux.setComentarios(Y41bConstantes.VALOR_NO);
			}

			// obtener numero de programaciones de la campaa
			CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
			campanhaprogramacion.setCampanha(campanha);
			Long numProgramacionesCampanha = this.campanhaProgramacionDao.findAllOrganismoCount(campanhaprogramacion);

			adjuntarCampanhaprograAux.setNumProgramaciones(numProgramacionesCampanha.toString());

			// obtener informe final y revisar quien ha rellenado el check de
			// final
			CampanhaCierre campanhaCierre = new CampanhaCierre();
			campanhaCierre.setTycmcodigo(adjuntarCampanhaprograAux.getPgcocm());
			campanhaCierre = (CampanhaCierre) this.campanhaCierreDao.find(campanhaCierre);

			Long finalizado = new Long(0);

			if (campanhaCierre != null && campanhaCierre.getTyfinalizadoaraba() != null
					&& campanhaCierre.getTyfinalizadoaraba().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			if (campanhaCierre != null && campanhaCierre.getTyfinalizadobizkaia() != null
					&& campanhaCierre.getTyfinalizadobizkaia().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			if (campanhaCierre != null && campanhaCierre.getTyfinalizadogipuzkoa() != null
					&& campanhaCierre.getTyfinalizadogipuzkoa().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			adjuntarCampanhaprograAux.setNumFinalizados(finalizado.toString());

			if (Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA.equals(adjuntarCampanhaprograAux.getPgcoor())) {
				if (campanhaCierre != null && campanhaCierre.getTyfinalizadobizkaia() != null
						&& campanhaCierre.getTyfinalizadobizkaia().equals(Y41bConstantes.VALOR_SI)) {
					adjuntarCampanhaprograAux.setFinalizado(Y41bConstantes.VALOR_SI);
				}
			} else if (Y41bConstantes.CODIGO_ORGANISMO_ARABA.equals(adjuntarCampanhaprograAux.getPgcoor())) {
				if (campanhaCierre != null && campanhaCierre.getTyfinalizadoaraba() != null
						&& campanhaCierre.getTyfinalizadoaraba().equals(Y41bConstantes.VALOR_SI)) {
					adjuntarCampanhaprograAux.setFinalizado(Y41bConstantes.VALOR_SI);
				}
			} else if (Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA.equals(adjuntarCampanhaprograAux.getPgcoor())) {
				if (campanhaCierre != null && campanhaCierre.getTyfinalizadogipuzkoa() != null
						&& campanhaCierre.getTyfinalizadogipuzkoa().equals(Y41bConstantes.VALOR_SI)) {
					adjuntarCampanhaprograAux.setFinalizado(Y41bConstantes.VALOR_SI);
				}
			} else if (Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO
					.equals(adjuntarCampanhaprograAux.getPgcoor())) {
				if (campanhaCierre != null && campanhaCierre.getTyfinalizadosscc() != null
						&& campanhaCierre.getTyfinalizadosscc().equals(Y41bConstantes.VALOR_SI)) {
					adjuntarCampanhaprograAux.setFinalizado(Y41bConstantes.VALOR_SI);
				}
			}
		}

		return listAdjuntarCampanhaprogra;
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	public AdjuntarCampanhaprogra findConCierres(AdjuntarCampanhaprogra adjuntarCampanhaprogra) {
		return (AdjuntarCampanhaprogra) this.adjuntarCampanhaprograDao.findConCierres(adjuntarCampanhaprogra);
	}

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return Long
	 */
	public Long findAllCount(AdjuntarCampanhaprogra adjuntarCampanhaprogra) {
		return this.adjuntarCampanhaprograDao.findAllCount(adjuntarCampanhaprogra);
	}

	/**
	 * Finds rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntarCampanhaprogra> findAllLike(AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjuntarCampanhaprogra>) this.adjuntarCampanhaprograDao.findAllLike(adjuntarCampanhaprogra,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjuntarCampanhaprogra adjuntarCampanhaprogra, Boolean startsWith) {
		return this.adjuntarCampanhaprograDao.findAllLikeCount(adjuntarCampanhaprogra, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntarCampanhaprogra adjuntarCampanhaprogra) {
		// si tiene numero de expediente lanzar error (esta validacin
		// realizarla tambien en el eliminar programacin)
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcopg(adjuntarCampanhaprogra.getPgcodigo());
		Long numInspeccionesIniciada = this.tramiteInspeccionDao
				.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);
		if (numInspeccionesIniciada > 0) {
			throw new Y41bUDAException("error.campanha.InspeccionesAbiertasException", true, new Exception());
		}

		this.adjuntarCampanhaprograDao.remove(adjuntarCampanhaprogra);
	}

	/**
	 * Deletes multiple rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprograList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AdjuntarCampanhaprogra> adjuntarCampanhaprograList) {
		for (AdjuntarCampanhaprogra adjuntarCampanhaprograAux : adjuntarCampanhaprograList) {
			this.adjuntarCampanhaprograDao.remove(adjuntarCampanhaprograAux);
		}
	}

}
