package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.Campanha;

/**
 * AdjuntarCampanhaprograService  
 * 
 *  
 */

public interface AdjuntarCampanhaprograService {

	/**
	 * Inserta los registros en la tabla temporal de programacin de la campaña
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhaprograTableTemporal(Campanha campanha);

	/**
	 * Inserts a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra add(AdjuntarCampanhaprogra adjuntarCampanhaprogra);

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaproducto
	 */
	public AdjuntarCampanhaprogra addCampanhaprogra(
			AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			String codCampanhaAlta);

	/**
	 * Updates a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra update(AdjuntarCampanhaprogra adjuntarCampanhaprogra);

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaproducto
	 * @throws Exception
	 *             Exception
	 */
	public AdjuntarCampanhaprogra addCampanhaprograInspeccionAdicional(
			AdjuntarCampanhaprogra adjuntarCampanhaprogra) throws Exception;

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra find(AdjuntarCampanhaprogra adjuntarCampanhaprogra);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarCampanhaprogra> findAll(
			AdjuntarCampanhaprogra adjuntarCampanhaprogra, Pagination pagination);

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra findConCierres(
			AdjuntarCampanhaprogra adjuntarCampanhaprogra);

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return Long
	 */
	Long findAllCount(AdjuntarCampanhaprogra adjuntarCampanhaprogra);

	/**
	 * Finds rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarCampanhaprogra> findAllLike(
			AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return
	 */
	void remove(AdjuntarCampanhaprogra adjuntarCampanhaprogra);

	/**
	 * Deletes multiple rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarCampanhaprograList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjuntarCampanhaprogra> adjuntarCampanhaprograList);

}
