package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntarCampanhaproductoDao;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarCampanhaproductoServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarCampanhaproductoService")
public class AdjuntarCampanhaproductoServiceImpl implements
		AdjuntarCampanhaproductoService {

	@Autowired
	private AdjuntarCampanhaproductoDao adjuntarCampanhaproductoDao;

	/**
	 * Inserta los registros en la tabla temporal de productos de la campaña
	 * 
	 * @param campanha
	 *            Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addCampanhaproductoTableTemporal(Campanha campanha) {
		this.adjuntarCampanhaproductoDao.removeAllCampanhaproducto(campanha);
		this.adjuntarCampanhaproductoDao.addCampanhaproducto(campanha);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaproducto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaproducto addCampanhaproducto(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			String codCampanhaAlta) {

		AdjuntarCampanhaproducto adjuntarCampanhaproductoAux = new AdjuntarCampanhaproducto();
		adjuntarCampanhaproductoAux.setCpcops(adjuntarCampanhaproducto
				.getCpcops());
		adjuntarCampanhaproductoAux.setCpcocm(codCampanhaAlta);

		if (Y41bUtils.isFilled(adjuntarCampanhaproducto.getCpnops())) {
			adjuntarCampanhaproductoAux.setCpnops(adjuntarCampanhaproducto
					.getCpnops());
		}

		Long numProds = this.adjuntarCampanhaproductoDao
				.findAllProductoCount(adjuntarCampanhaproductoAux);

		if (numProds > 0) {
			throw new Y41bUDAException(
					"error.adjuntarprods.duplicateException", true,
					new Exception());
		}

		adjuntarCampanhaproducto.setCpcodigo(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		adjuntarCampanhaproducto.setCpcocm(codCampanhaAlta);
		return this.adjuntarCampanhaproductoDao.add(adjuntarCampanhaproducto);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return AdjuntarCampanhaproducto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaproducto add(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto) {
		return this.adjuntarCampanhaproductoDao.add(adjuntarCampanhaproducto);
	}

	/**
	 * Updates a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return AdjuntarCampanhaproducto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarCampanhaproducto update(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto) {
		return this.adjuntarCampanhaproductoDao
				.update(adjuntarCampanhaproducto);
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return AdjuntarCampanhaproducto
	 */
	public AdjuntarCampanhaproducto find(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto) {
		return (AdjuntarCampanhaproducto) this.adjuntarCampanhaproductoDao
				.find(adjuntarCampanhaproducto);
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarCampanhaproducto> findAll(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Pagination pagination) {
		return (List<AdjuntarCampanhaproducto>) this.adjuntarCampanhaproductoDao
				.findAll(adjuntarCampanhaproducto, pagination);
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	public Long findAllCount(AdjuntarCampanhaproducto adjuntarCampanhaproducto) {
		return this.adjuntarCampanhaproductoDao
				.findAllCount(adjuntarCampanhaproducto);
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarCampanhaproducto> findAllCampanhaproducto(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Pagination pagination) {
		return (List<AdjuntarCampanhaproducto>) this.adjuntarCampanhaproductoDao
				.findAllCampanhaproducto(adjuntarCampanhaproducto, pagination);
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	public Long findAllCampanhaproductoCount(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto) {
		return this.adjuntarCampanhaproductoDao
				.findAllCampanhaproductoCount(adjuntarCampanhaproducto);
	}

	/**
	 * Finds rows in the AdjuntarCampanhaproducto table using like.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntarCampanhaproducto> findAllLike(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjuntarCampanhaproducto>) this.adjuntarCampanhaproductoDao
				.findAllLike(adjuntarCampanhaproducto, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table using like.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Boolean startsWith) {
		return this.adjuntarCampanhaproductoDao.findAllLikeCount(
				adjuntarCampanhaproducto, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntarCampanhaproducto adjuntarCampanhaproducto) {
		this.adjuntarCampanhaproductoDao.remove(adjuntarCampanhaproducto);
	}

	/**
	 * Deletes multiple rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproductoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<AdjuntarCampanhaproducto> adjuntarCampanhaproductoList) {
		for (AdjuntarCampanhaproducto adjuntarCampanhaproductoAux : adjuntarCampanhaproductoList) {
			this.adjuntarCampanhaproductoDao
					.remove(adjuntarCampanhaproductoAux);
		}
	}

}
