package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.Campanha;

/**
 * AdjuntarCampanhaproductoService  
 * 
 *  
 */

public interface AdjuntarCampanhaproductoService {

	/**
	 * Inserta los registros en la tabla temporal de productos de la campaña
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhaproductoTableTemporal(Campanha campanha);

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaproducto
	 */
	public AdjuntarCampanhaproducto addCampanhaproducto(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			String codCampanhaAlta);

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return AdjuntarCampanhaproducto
	 */
	AdjuntarCampanhaproducto add(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto);

	/**
	 * Updates a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return AdjuntarCampanhaproducto
	 */
	AdjuntarCampanhaproducto update(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto);

	/**
	 * Finds a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return AdjuntarCampanhaproducto
	 */
	AdjuntarCampanhaproducto find(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarCampanhaproducto> findAll(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Pagination pagination);

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	Long findAllCount(AdjuntarCampanhaproducto adjuntarCampanhaproducto);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarCampanhaproducto> findAllCampanhaproducto(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Pagination pagination);

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	public Long findAllCampanhaproductoCount(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto);

	/**
	 * Finds rows in the AdjuntarCampanhaproducto table using like.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarCampanhaproducto> findAllLike(
			AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table using like.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return
	 */
	void remove(AdjuntarCampanhaproducto adjuntarCampanhaproducto);

	/**
	 * Deletes multiple rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarCampanhaproductoList
	 *            List
	 * @return
	 */
	void removeMultiple(
			List<AdjuntarCampanhaproducto> adjuntarCampanhaproductoList);

}
